from jinja2.runtime import Context, missing
from .context import ObjectContext
from .helpers import copy


def new_context(environment, template_name, blocks,
                vrs=None, shared=None, globs=None, locs=None):
    if vrs is None:
        vrs = {}  # pragma: no cover; TODO: try to remove?
    parent = vrs
    if not isinstance(vrs, dict):
        parent = ObjectContext(vrs)
    if not shared:
        parent = copy(parent)
        for key, value in (globs or {}).items():
            if key not in parent:
                # dict.setdefault doesn't work for ObjectContext
                parent[key] = value
    if locs:
        if shared:
            parent = copy(parent)
        for key, value in locs.items():
            if (key[:2] == 'l_' and
                value is not missing):
                parent[key[2:]] = value
    return Context(environment, parent, template_name, blocks)