from sugarbowl import Function
from ..environment import Environment


class render_string(Function):
    """Render a string using context.

    Parameters
    ----------
    string: str
        String to be rendered.
    context: dict/obj
        Rendering context.
    params: dict
        Parameters to pass to jinja2's Environment.

    Returns
    -------
    str
        Rendered string.
    """

    # Public

    def __init__(self, string, *, context=None, **params):
        self.__string = string
        self.__context = context
        self.__params = params

    def __call__(self):
        environment = Environment(**self.__params)
        template = environment.from_string(self.__string)
        result = template.render(self.__context)
        return result
