import unittest
from unittest.mock import Mock, patch
from importlib import import_module
component = import_module('run_render.string.render')


class render_string_Test(unittest.TestCase):

    # Tests

    def test(self):
        result = component.render_string('{{ attr1 }}')
        self.assertEqual(result, '')

    def test_with_context_is_dict(self):
        result = component.render_string(
            '{{ attr1 }}', context={'attr1': 'value1'})
        self.assertEqual(result, 'value1')

    def test_with_context_is_object(self):
        result = component.render_string(
            '{{ attr1 }}', context=Mock(attr1='value1'))
        self.assertEqual(result, 'value1')

    @patch.object(component.Environment, 'from_string')
    def test_with_error_in_rendering(self, from_string):
        from_string.side_effect = Exception()
        self.assertRaises(Exception, component.render_string, '{{ attr1 }}')
