from sugarbowl import Function
from .environment import Environment


class render(Function):
    """Render a string using context.

    Parameters
    ----------
    string: str
        String to be rendered.
    context: dict/object
        Rendering context.
    source: str
        Path to read as string.
    target: str
        Path to write result.
    params: dict
        Parameters to pass to jinja2's Environment.

    Returns
    -------
    str/None
        Rendered string/None if target is passed.
    """

    # Public

    def __init__(self, string=None, *, context=None,
                 source=None, target=None, **params):
        if string is None:
            if source is None:
                raise ValueError('Both string and source can\'t be None')
            with open(source) as file:
                string = file.read()
        self.__string = string
        self.__context = context
        self.__target = target
        self.__params = params

    def __call__(self):
        environment = Environment(**self.__params)
        template = environment.from_string(self.__string)
        result = template.render(self.__context)
        if self.__target is None:
            return result
        with open(self.__target, 'w') as file:
            file.write(result)
