import unittest
from functools import partial
from unittest.mock import patch
from importlib import import_module
component = import_module('run_render.task')


class RenderTaskTest(unittest.TestCase):

    # Actions

    def setUp(self):
        self.args = ('arg1',)
        self.kwargs = {'kwarg1': 'kwarg1'}
        self.ptask = partial(component.RenderTask, meta_build=True)

    # Tests

    @patch.object(component, 'render')
    def test___call___(self, render_file):
        task = self.ptask()
        result = task(*self.args, **self.kwargs)
        self.assertEqual(result, render_file.return_value)
        render_file.assert_called_with(
            *self.args, context=task.meta_module, **self.kwargs)
