import sys
from unittest.mock import patch
from jinja2 import Template, runtime
from jinja2.utils import concat
from .new_context import new_context


class Template(Template):

    # Public
    def render(self, context):
        try:
            with patch.object(runtime, 'new_context', new_context):
                return concat(self.root_render_func(self.new_context(context)))
        except Exception:
            exc_info = sys.exc_info()
        return self.environment.handle_exception(exc_info, True)

    def new_context(self, vrs=None, shared=False, locs=None):
        return new_context(
            self.environment, self.name, self.blocks,
            vrs, shared, self.globals, locs)
