/*! URI.js v1.9.1 http://medialize.github.com/URI.js/ */
/* build contains: URI.js, URITemplate.js, jquery.URI.js */
(function(g,j){"object"===typeof exports?module.exports=j(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains")):"function"===typeof define&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],j):g.URI=j(g.punycode,g.IPv6,g.SecondLevelDomains)})(this,function(g,j,s){function d(a,b){if(!(this instanceof d))return new d(a,b);void 0===a&&(a="undefined"!==typeof location?location.href+"":"");this.href(a);return void 0!==b?this.absoluteTo(b):this}function t(a){return a.replace(/([.*+?^=!:${}()|[\]\/\\])/g,
"\\$1")}function u(a){return"[object Array]"===String(Object.prototype.toString.call(a))}function m(a){return encodeURIComponent(a).replace(/[!'()*]/g,escape).replace(/\*/g,"%2A")}var c=d.prototype,v=Object.prototype.hasOwnProperty;d._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,duplicateQueryParameters:d.duplicateQueryParameters}};d.duplicateQueryParameters=!1;d.protocol_expression=/^[a-z][a-z0-9-+-]*$/i;d.idn_expression=
/[^a-z0-9\.-]/i;d.punycode_expression=/(xn--)/i;d.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;d.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;
d.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))/ig;d.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};d.invalid_hostname_characters=/[^a-zA-Z0-9\.-]/;d.encode=m;d.decode=decodeURIComponent;d.iso8859=function(){d.encode=escape;d.decode=unescape};d.unicode=function(){d.encode=
m;d.decode=decodeURIComponent};d.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+",
"%2C":",","%3B":";","%3D":"="}}}};d.encodeQuery=function(a){return d.encode(a+"").replace(/%20/g,"+")};d.decodeQuery=function(a){return d.decode((a+"").replace(/\+/g,"%20"))};d.recodePath=function(a){a=(a+"").split("/");for(var b=0,e=a.length;b<e;b++)a[b]=d.encodePathSegment(d.decode(a[b]));return a.join("/")};d.decodePath=function(a){a=(a+"").split("/");for(var b=0,e=a.length;b<e;b++)a[b]=d.decodePathSegment(a[b]);return a.join("/")};var p={encode:"encode",decode:"decode"},f,k=function(a,b){return function(e){return d[b](e+
"").replace(d.characters[a][b].expression,function(e){return d.characters[a][b].map[e]})}};for(f in p)d[f+"PathSegment"]=k("pathname",p[f]);d.encodeReserved=k("reserved","encode");d.parse=function(a,b){var e;b||(b={});e=a.indexOf("#");-1<e&&(b.fragment=a.substring(e+1)||null,a=a.substring(0,e));e=a.indexOf("?");-1<e&&(b.query=a.substring(e+1)||null,a=a.substring(0,e));"//"===a.substring(0,2)?(b.protocol="",a=a.substring(2),a=d.parseAuthority(a,b)):(e=a.indexOf(":"),-1<e&&(b.protocol=a.substring(0,
e),b.protocol&&!b.protocol.match(d.protocol_expression)?b.protocol=void 0:"file"===b.protocol?a=a.substring(e+3):"//"===a.substring(e+1,e+3)?(a=a.substring(e+3),a=d.parseAuthority(a,b)):(a=a.substring(e+1),b.urn=!0)));b.path=a;return b};d.parseHost=function(a,b){var e=a.indexOf("/"),h;-1===e&&(e=a.length);"["===a.charAt(0)?(h=a.indexOf("]"),b.hostname=a.substring(1,h)||null,b.port=a.substring(h+2,e)||null):a.indexOf(":")!==a.lastIndexOf(":")?(b.hostname=a.substring(0,e)||null,b.port=null):(h=a.substring(0,
e).split(":"),b.hostname=h[0]||null,b.port=h[1]||null);b.hostname&&"/"!==a.substring(e).charAt(0)&&(e++,a="/"+a);return a.substring(e)||"/"};d.parseAuthority=function(a,b){a=d.parseUserinfo(a,b);return d.parseHost(a,b)};d.parseUserinfo=function(a,b){var e=a.indexOf("@"),h=a.indexOf("/");-1<e&&(-1===h||e<h)?(h=a.substring(0,e).split(":"),b.username=h[0]?d.decode(h[0]):null,h.shift(),b.password=h[0]?d.decode(h.join(":")):null,a=a.substring(e+1)):(b.username=null,b.password=null);return a};d.parseQuery=
function(a){if(!a)return{};a=a.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!a)return{};var b={};a=a.split("&");for(var e=a.length,h,c,f=0;f<e;f++)h=a[f].split("="),c=d.decodeQuery(h.shift()),h=h.length?d.decodeQuery(h.join("=")):null,b[c]?("string"===typeof b[c]&&(b[c]=[b[c]]),b[c].push(h)):b[c]=h;return b};d.build=function(a){var b="";a.protocol&&(b+=a.protocol+":");if(!a.urn&&(b||a.hostname))b+="//";b+=d.buildAuthority(a)||"";"string"===typeof a.path&&("/"!==a.path.charAt(0)&&"string"===typeof a.hostname&&
(b+="/"),b+=a.path);"string"===typeof a.query&&a.query&&(b+="?"+a.query);"string"===typeof a.fragment&&a.fragment&&(b+="#"+a.fragment);return b};d.buildHost=function(a){var b="";if(a.hostname)d.ip6_expression.test(a.hostname)?b=a.port?b+("["+a.hostname+"]:"+a.port):b+a.hostname:(b+=a.hostname,a.port&&(b+=":"+a.port));else return"";return b};d.buildAuthority=function(a){return d.buildUserinfo(a)+d.buildHost(a)};d.buildUserinfo=function(a){var b="";a.username&&(b+=d.encode(a.username),a.password&&(b+=
":"+d.encode(a.password)),b+="@");return b};d.buildQuery=function(a,b){var e="",h,c,f,m;for(c in a)if(v.call(a,c)&&c)if(u(a[c])){h={};f=0;for(m=a[c].length;f<m;f++)void 0!==a[c][f]&&void 0===h[a[c][f]+""]&&(e+="&"+d.buildQueryParameter(c,a[c][f]),!0!==b&&(h[a[c][f]+""]=!0))}else void 0!==a[c]&&(e+="&"+d.buildQueryParameter(c,a[c]));return e.substring(1)};d.buildQueryParameter=function(a,b){return d.encodeQuery(a)+(null!==b?"="+d.encodeQuery(b):"")};d.addQuery=function(a,b,e){if("object"===typeof b)for(var h in b)v.call(b,
h)&&d.addQuery(a,h,b[h]);else if("string"===typeof b)void 0===a[b]?a[b]=e:("string"===typeof a[b]&&(a[b]=[a[b]]),u(e)||(e=[e]),a[b]=a[b].concat(e));else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");};d.removeQuery=function(a,b,e){var h;if(u(b)){e=0;for(h=b.length;e<h;e++)a[b[e]]=void 0}else if("object"===typeof b)for(h in b)v.call(b,h)&&d.removeQuery(a,h,b[h]);else if("string"===typeof b)if(void 0!==e)if(a[b]===e)a[b]=void 0;else{if(u(a[b])){h=a[b];var c={},
f,m;if(u(e)){f=0;for(m=e.length;f<m;f++)c[e[f]]=!0}else c[e]=!0;f=0;for(m=h.length;f<m;f++)void 0!==c[h[f]]&&(h.splice(f,1),m--,f--);a[b]=h}}else a[b]=void 0;else throw new TypeError("URI.addQuery() accepts an object, string as the first parameter");};d.commonPath=function(a,b){var e=Math.min(a.length,b.length),h;for(h=0;h<e;h++)if(a.charAt(h)!==b.charAt(h)){h--;break}if(1>h)return a.charAt(0)===b.charAt(0)&&"/"===a.charAt(0)?"/":"";"/"!==a.charAt(h)&&(h=a.substring(0,h).lastIndexOf("/"));return a.substring(0,
h+1)};d.withinString=function(a,b){return a.replace(d.find_uri_expression,b)};d.ensureValidHostname=function(a){if(a.match(d.invalid_hostname_characters)){if(!g)throw new TypeError("Hostname '"+a+"' contains characters other than [A-Z0-9.-] and Punycode.js is not available");if(g.toASCII(a).match(d.invalid_hostname_characters))throw new TypeError("Hostname '"+a+"' contains characters other than [A-Z0-9.-]");}};c.build=function(a){if(!0===a)this._deferred_build=!0;else if(void 0===a||this._deferred_build)this._string=
d.build(this._parts),this._deferred_build=!1;return this};c.clone=function(){return new d(this)};c.valueOf=c.toString=function(){return this.build(!1)._string};p={protocol:"protocol",username:"username",password:"password",hostname:"hostname",port:"port"};k=function(a){return function(b,e){if(void 0===b)return this._parts[a]||"";this._parts[a]=b;this.build(!e);return this}};for(f in p)c[f]=k(p[f]);p={query:"?",fragment:"#"};k=function(a,b){return function(e,h){if(void 0===e)return this._parts[a]||
"";null!==e&&(e+="",e.charAt(0)===b&&(e=e.substring(1)));this._parts[a]=e;this.build(!h);return this}};for(f in p)c[f]=k(f,p[f]);p={search:["?","query"],hash:["#","fragment"]};k=function(a,b){return function(e,h){var d=this[a](e,h);return"string"===typeof d&&d.length?b+d:d}};for(f in p)c[f]=k(p[f][1],p[f][0]);c.pathname=function(a,b){if(void 0===a||!0===a){var e=this._parts.path||(this._parts.urn?"":"/");return a?d.decodePath(e):e}this._parts.path=a?d.recodePath(a):"/";this.build(!b);return this};
c.path=c.pathname;c.href=function(a,b){var e;if(void 0===a)return this.toString();this._string="";this._parts=d._parts();var h=a instanceof d,c="object"===typeof a&&(a.hostname||a.path);!h&&(c&&void 0!==a.pathname)&&(a=a.toString());if("string"===typeof a)this._parts=d.parse(a,this._parts);else if(h||c)for(e in h=h?a._parts:a,h)v.call(this._parts,e)&&(this._parts[e]=h[e]);else throw new TypeError("invalid input");this.build(!b);return this};c.is=function(a){var b=!1,e=!1,h=!1,c=!1,f=!1,m=!1,k=!1,
l=!this._parts.urn;this._parts.hostname&&(l=!1,e=d.ip4_expression.test(this._parts.hostname),h=d.ip6_expression.test(this._parts.hostname),b=e||h,f=(c=!b)&&s&&s.has(this._parts.hostname),m=c&&d.idn_expression.test(this._parts.hostname),k=c&&d.punycode_expression.test(this._parts.hostname));switch(a.toLowerCase()){case "relative":return l;case "absolute":return!l;case "domain":case "name":return c;case "sld":return f;case "ip":return b;case "ip4":case "ipv4":case "inet4":return e;case "ip6":case "ipv6":case "inet6":return h;
case "idn":return m;case "url":return!this._parts.urn;case "urn":return!!this._parts.urn;case "punycode":return k}return null};var l=c.protocol,n=c.port,q=c.hostname;c.protocol=function(a,b){if(void 0!==a&&a&&(a=a.replace(/:(\/\/)?$/,""),a.match(/[^a-zA-z0-9\.+-]/)))throw new TypeError("Protocol '"+a+"' contains characters other than [A-Z0-9.+-]");return l.call(this,a,b)};c.scheme=c.protocol;c.port=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0!==a&&(0===a&&(a=null),a&&(a+="",
":"===a.charAt(0)&&(a=a.substring(1)),a.match(/[^0-9]/))))throw new TypeError("Port '"+a+"' contains characters other than [0-9]");return n.call(this,a,b)};c.hostname=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0!==a){var e={};d.parseHost(a,e);a=e.hostname}return q.call(this,a,b)};c.host=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?d.buildHost(this._parts):"";d.parseHost(a,this._parts);this.build(!b);return this};c.authority=
function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a)return this._parts.hostname?d.buildAuthority(this._parts):"";d.parseAuthority(a,this._parts);this.build(!b);return this};c.userinfo=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){if(!this._parts.username)return"";var e=d.buildUserinfo(this._parts);return e.substring(0,e.length-1)}"@"!==a[a.length-1]&&(a+="@");d.parseUserinfo(a,this._parts);this.build(!b);return this};c.resource=function(a,b){var e;
if(void 0===a)return this.path()+this.search()+this.hash();e=d.parse(a);this._parts.path=e.path;this._parts.query=e.query;this._parts.fragment=e.fragment;this.build(!b);return this};c.subdomain=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var e=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,e)||""}e=this._parts.hostname.length-this.domain().length;e=this._parts.hostname.substring(0,
e);e=RegExp("^"+t(e));a&&"."!==a.charAt(a.length-1)&&(a+=".");a&&d.ensureValidHostname(a);this._parts.hostname=this._parts.hostname.replace(e,a);this.build(!b);return this};c.domain=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var e=this._parts.hostname.match(/\./g);if(e&&2>e.length)return this._parts.hostname;e=this._parts.hostname.length-this.tld(b).length-1;e=this._parts.hostname.lastIndexOf(".",
e-1)+1;return this._parts.hostname.substring(e)||""}if(!a)throw new TypeError("cannot set domain empty");d.ensureValidHostname(a);!this._parts.hostname||this.is("IP")?this._parts.hostname=a:(e=RegExp(t(this.domain())+"$"),this._parts.hostname=this._parts.hostname.replace(e,a));this.build(!b);return this};c.tld=function(a,b){if(this._parts.urn)return void 0===a?"":this;"boolean"===typeof a&&(b=a,a=void 0);if(void 0===a){if(!this._parts.hostname||this.is("IP"))return"";var e=this._parts.hostname.lastIndexOf("."),
e=this._parts.hostname.substring(e+1);return!0!==b&&s&&s.list[e.toLowerCase()]?s.get(this._parts.hostname)||e:e}if(a)if(a.match(/[^a-zA-Z0-9-]/))if(s&&s.is(a))e=RegExp(t(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(e,a);else throw new TypeError("TLD '"+a+"' contains characters other than [A-Z0-9]");else{if(!this._parts.hostname||this.is("IP"))throw new ReferenceError("cannot set TLD on non-domain host");e=RegExp(t(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(e,
a)}else throw new TypeError("cannot set TLD empty");this.build(!b);return this};c.directory=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path&&!this._parts.hostname)return"";if("/"===this._parts.path)return"/";var e=this._parts.path.length-this.filename().length-1,e=this._parts.path.substring(0,e)||(this._parts.hostname?"/":"");return a?d.decodePath(e):e}e=this._parts.path.length-this.filename().length;e=this._parts.path.substring(0,e);e=RegExp("^"+
t(e));this.is("relative")||(a||(a="/"),"/"!==a.charAt(0)&&(a="/"+a));a&&"/"!==a.charAt(a.length-1)&&(a+="/");a=d.recodePath(a);this._parts.path=this._parts.path.replace(e,a);this.build(!b);return this};c.filename=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path||"/"===this._parts.path)return"";var e=this._parts.path.lastIndexOf("/"),e=this._parts.path.substring(e+1);return a?d.decodePathSegment(e):e}e=!1;"/"===a.charAt(0)&&(a=a.substring(1));a.match(/\.?\//)&&
(e=!0);var h=RegExp(t(this.filename())+"$");a=d.recodePath(a);this._parts.path=this._parts.path.replace(h,a);e?this.normalizePath(b):this.build(!b);return this};c.suffix=function(a,b){if(this._parts.urn)return void 0===a?"":this;if(void 0===a||!0===a){if(!this._parts.path||"/"===this._parts.path)return"";var e=this.filename(),h=e.lastIndexOf(".");if(-1===h)return"";e=e.substring(h+1);e=/^[a-z0-9%]+$/i.test(e)?e:"";return a?d.decodePathSegment(e):e}"."===a.charAt(0)&&(a=a.substring(1));if(e=this.suffix())h=
a?RegExp(t(e)+"$"):RegExp(t("."+e)+"$");else{if(!a)return this;this._parts.path+="."+d.recodePath(a)}h&&(a=d.recodePath(a),this._parts.path=this._parts.path.replace(h,a));this.build(!b);return this};c.segment=function(a,b,e){var d=this._parts.urn?":":"/",c=this.path(),f="/"===c.substring(0,1),c=c.split(d);"number"!==typeof a&&(e=b,b=a,a=void 0);if(void 0!==a&&"number"!==typeof a)throw Error("Bad segment '"+a+"', must be 0-based integer");f&&c.shift();0>a&&(a=Math.max(c.length+a,0));if(void 0===b)return void 0===
a?c:c[a];if(null===a||void 0===c[a])if(u(b))c=b;else{if(b||"string"===typeof b&&b.length)""===c[c.length-1]?c[c.length-1]=b:c.push(b)}else b||"string"===typeof b&&b.length?c[a]=b:c.splice(a,1);f&&c.unshift("");return this.path(c.join(d),e)};var r=c.query;c.query=function(a,b){if(!0===a)return d.parseQuery(this._parts.query);if("function"===typeof a){var e=d.parseQuery(this._parts.query),c=a.call(this,e);this._parts.query=d.buildQuery(c||e,this._parts.duplicateQueryParameters);this.build(!b);return this}return void 0!==
a&&"string"!==typeof a?(this._parts.query=d.buildQuery(a,this._parts.duplicateQueryParameters),this.build(!b),this):r.call(this,a,b)};c.setQuery=function(a,b,e){var c=d.parseQuery(this._parts.query);if("object"===typeof a)for(var f in a)v.call(a,f)&&(c[f]=a[f]);else if("string"===typeof a)c[a]=void 0!==b?b:null;else throw new TypeError("URI.addQuery() accepts an object, string as the name parameter");this._parts.query=d.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(e=b);
this.build(!e);return this};c.addQuery=function(a,b,e){var c=d.parseQuery(this._parts.query);d.addQuery(c,a,void 0===b?null:b);this._parts.query=d.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(e=b);this.build(!e);return this};c.removeQuery=function(a,b,e){var c=d.parseQuery(this._parts.query);d.removeQuery(c,a,b);this._parts.query=d.buildQuery(c,this._parts.duplicateQueryParameters);"string"!==typeof a&&(e=b);this.build(!e);return this};c.setSearch=c.setQuery;c.addSearch=
c.addQuery;c.removeSearch=c.removeQuery;c.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()};c.normalizeProtocol=function(a){"string"===typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!a));return this};c.normalizeHostname=function(a){this._parts.hostname&&
(this.is("IDN")&&g?this._parts.hostname=g.toASCII(this._parts.hostname):this.is("IPv6")&&j&&(this._parts.hostname=j.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!a));return this};c.normalizePort=function(a){"string"===typeof this._parts.protocol&&this._parts.port===d.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!a));return this};c.normalizePath=function(a){if(this._parts.urn||!this._parts.path||"/"===this._parts.path)return this;
var b,e,c=this._parts.path,f,m;"/"!==c.charAt(0)&&("."===c.charAt(0)&&(e=c.substring(0,c.indexOf("/"))),b=!0,c="/"+c);for(c=c.replace(/(\/(\.\/)+)|\/{2,}/g,"/");;){f=c.indexOf("/../");if(-1===f)break;else if(0===f){c=c.substring(3);break}m=c.substring(0,f).lastIndexOf("/");-1===m&&(m=f);c=c.substring(0,m)+c.substring(f+3)}b&&this.is("relative")&&(c=e?e+c:c.substring(1));c=d.recodePath(c);this._parts.path=c;this.build(!a);return this};c.normalizePathname=c.normalizePath;c.normalizeQuery=function(a){"string"===
typeof this._parts.query&&(this._parts.query.length?this.query(d.parseQuery(this._parts.query)):this._parts.query=null,this.build(!a));return this};c.normalizeFragment=function(a){this._parts.fragment||(this._parts.fragment=null,this.build(!a));return this};c.normalizeSearch=c.normalizeQuery;c.normalizeHash=c.normalizeFragment;c.iso8859=function(){var a=d.encode,b=d.decode;d.encode=escape;d.decode=decodeURIComponent;this.normalize();d.encode=a;d.decode=b;return this};c.unicode=function(){var a=d.encode,
b=d.decode;d.encode=m;d.decode=unescape;this.normalize();d.encode=a;d.decode=b;return this};c.readable=function(){var a=this.clone();a.username("").password("").normalize();var b="";a._parts.protocol&&(b+=a._parts.protocol+"://");a._parts.hostname&&(a.is("punycode")&&g?(b+=g.toUnicode(a._parts.hostname),a._parts.port&&(b+=":"+a._parts.port)):b+=a.host());a._parts.hostname&&(a._parts.path&&"/"!==a._parts.path.charAt(0))&&(b+="/");b+=a.path(!0);if(a._parts.query){for(var e="",c=0,f=a._parts.query.split("&"),
m=f.length;c<m;c++){var k=(f[c]||"").split("="),e=e+("&"+d.decodeQuery(k[0]).replace(/&/g,"%26"));void 0!==k[1]&&(e+="="+d.decodeQuery(k[1]).replace(/&/g,"%26"))}b+="?"+e.substring(1)}return b+=a.hash()};c.absoluteTo=function(a){var b=this.clone(),e=["protocol","username","password","hostname","port"],c,f;if(this._parts.urn)throw Error("URNs do not have any generally defined hierachical components");if(this._parts.hostname)return b;a instanceof d||(a=new d(a));c=0;for(f;f=e[c];c++)b._parts[f]=a._parts[f];
e=["query","path"];c=0;for(f;f=e[c];c++)!b._parts[f]&&a._parts[f]&&(b._parts[f]=a._parts[f]);"/"!==b.path().charAt(0)&&(a=a.directory(),b._parts.path=(a?a+"/":"")+b._parts.path,b.normalizePath());b.build();return b};c.relativeTo=function(a){var b=this.clone(),e=["protocol","username","password","hostname","port"],c;if(this._parts.urn)throw Error("URNs do not have any generally defined hierachical components");a instanceof d||(a=new d(a));if("/"!==this.path().charAt(0)||"/"!==a.path().charAt(0))throw Error("Cannot calculate common path from non-relative URLs");
c=d.commonPath(b.path(),a.path());if(!c||"/"===c)return b;for(var f=0,m;m=e[f];f++)b._parts[m]=null;a=a.directory();e=this.directory();if(a===e)return b._parts.path="./"+b.filename(),b.build();a.substring(c.length);e=e.substring(c.length);if(a+"/"===c)return e&&(e+="/"),b._parts.path="./"+e+b.filename(),b.build();e="../";c=RegExp("^"+t(c));for(a=a.replace(c,"/").match(/\//g).length-1;a--;)e+="../";b._parts.path=b._parts.path.replace(c,e);return b.build()};c.equals=function(a){var b=this.clone(),c=
new d(a),f={},m={};a={};var k;b.normalize();c.normalize();if(b.toString()===c.toString())return!0;f=b.query();m=c.query();b.query("");c.query("");if(b.toString()!==c.toString()||f.length!==m.length)return!1;f=d.parseQuery(f);m=d.parseQuery(m);for(k in f)if(v.call(f,k)){if(u(f[k])){if(!u(m[k])||f[k].length!==m[k].length)return!1;f[k].sort();m[k].sort();b=0;for(c=f[k].length;b<c;b++)if(f[k][b]!==m[k][b])return!1}else if(f[k]!==m[k])return!1;a[k]=!0}for(k in m)if(v.call(m,k)&&!a[k])return!1;return!0};
c.duplicateQueryParameters=function(a){this._parts.duplicateQueryParameters=!!a;return this};return d});
(function(g,j){"object"===typeof exports?module.exports=j(require("./URI")):"function"===typeof define&&define.amd?define(["./URI"],j):g.URITemplate=j(g.URI)})(this,function(g){function j(d){if(j._cache[d])return j._cache[d];if(!(this instanceof j))return new j(d);this.expression=d;j._cache[d]=this;return this}function s(d){this.data=d;this.cache={}}var d=Object.prototype.hasOwnProperty,t=j.prototype,u={"":{prefix:"",separator:",",named:!1,empty_name_separator:!1,encode:"encode"},"+":{prefix:"",separator:",",
named:!1,empty_name_separator:!1,encode:"encodeReserved"},"#":{prefix:"#",separator:",",named:!1,empty_name_separator:!1,encode:"encodeReserved"},".":{prefix:".",separator:".",named:!1,empty_name_separator:!1,encode:"encode"},"/":{prefix:"/",separator:"/",named:!1,empty_name_separator:!1,encode:"encode"},";":{prefix:";",separator:";",named:!0,empty_name_separator:!1,encode:"encode"},"?":{prefix:"?",separator:"&",named:!0,empty_name_separator:!0,encode:"encode"},"&":{prefix:"&",separator:"&",named:!0,
empty_name_separator:!0,encode:"encode"}};j._cache={};j.EXPRESSION_PATTERN=/\{([^a-zA-Z0-9%_]?)([^\}]+)(\}|$)/g;j.VARIABLE_PATTERN=/^([^*:]+)((\*)|:(\d+))?$/;j.VARIABLE_NAME_PATTERN=/[^a-zA-Z0-9%_]/;j.expand=function(d,c){var g=u[d.operator],p=g.named?"Named":"Unnamed",f=d.variables,k=[],l,n,q;for(q=0;n=f[q];q++)l=c.get(n.name),l.val.length?k.push(j["expand"+p](l,g,n.explode,n.explode&&g.separator||",",n.maxlength,n.name)):l.type&&k.push("");return k.length?g.prefix+k.join(g.separator):""};j.expandNamed=
function(d,c,j,p,f,k){var l="",n=c.encode;c=c.empty_name_separator;var q=!d[n].length,r=2===d.type?"":g[n](k),a,b,e;b=0;for(e=d.val.length;b<e;b++)f?(a=g[n](d.val[b][1].substring(0,f)),2===d.type&&(r=g[n](d.val[b][0].substring(0,f)))):q?(a=g[n](d.val[b][1]),2===d.type?(r=g[n](d.val[b][0]),d[n].push([r,a])):d[n].push([void 0,a])):(a=d[n][b][1],2===d.type&&(r=d[n][b][0])),l&&(l+=p),j?l+=r+(c||a?"=":"")+a:(b||(l+=g[n](k)+(c||a?"=":"")),2===d.type&&(l+=r+","),l+=a);return l};j.expandUnnamed=function(d,
c,j,p,f){var k="",l=c.encode;c=c.empty_name_separator;var n=!d[l].length,q,r,a,b;a=0;for(b=d.val.length;a<b;a++)f?r=g[l](d.val[a][1].substring(0,f)):n?(r=g[l](d.val[a][1]),d[l].push([2===d.type?g[l](d.val[a][0]):void 0,r])):r=d[l][a][1],k&&(k+=p),2===d.type&&(q=f?g[l](d.val[a][0].substring(0,f)):d[l][a][0],k+=q,k=j?k+(c||r?"=":""):k+","),k+=r;return k};t.expand=function(d){var c="";(!this.parts||!this.parts.length)&&this.parse();d instanceof s||(d=new s(d));for(var g=0,p=this.parts.length;g<p;g++)c+=
"string"===typeof this.parts[g]?this.parts[g]:j.expand(this.parts[g],d);return c};t.parse=function(){var d=this.expression,c=j.EXPRESSION_PATTERN,g=j.VARIABLE_PATTERN,p=j.VARIABLE_NAME_PATTERN,f=[],k=0,l,n,q;for(c.lastIndex=0;;){n=c.exec(d);if(null===n){f.push(d.substring(k));break}else f.push(d.substring(k,n.index)),k=n.index+n[0].length;if(u[n[1]]){if(!n[3])throw Error('Unclosed Expression "'+n[0]+'"');}else throw Error('Unknown Operator "'+n[1]+'" in "'+n[0]+'"');l=n[2].split(",");for(var r=0,
a=l.length;r<a;r++){q=l[r].match(g);if(null===q)throw Error('Invalid Variable "'+l[r]+'" in "'+n[0]+'"');if(q[1].match(p))throw Error('Invalid Variable Name "'+q[1]+'" in "'+n[0]+'"');l[r]={name:q[1],explode:!!q[3],maxlength:q[4]&&parseInt(q[4],10)}}if(!l.length)throw Error('Expression Missing Variable(s) "'+n[0]+'"');f.push({expression:n[0],operator:n[1],variables:l})}f.length||f.push(d);this.parts=f;return this};s.prototype.get=function(g){var c=this.data,j={type:0,val:[],encode:[],encodeReserved:[]},
p;if(void 0!==this.cache[g])return this.cache[g];this.cache[g]=j;c="[object Function]"===String(Object.prototype.toString.call(c))?c(g):"[object Function]"===String(Object.prototype.toString.call(c[g]))?c[g](g):c[g];if(!(void 0===c||null===c))if("[object Array]"===String(Object.prototype.toString.call(c))){p=0;for(g=c.length;p<g;p++)void 0!==c[p]&&null!==c[p]&&j.val.push([void 0,String(c[p])]);j.val.length&&(j.type=3)}else if("[object Object]"===String(Object.prototype.toString.call(c))){for(p in c)d.call(c,
p)&&(void 0!==c[p]&&null!==c[p])&&j.val.push([p,String(c[p])]);j.val.length&&(j.type=2)}else j.type=1,j.val.push([void 0,String(c)]);return j};g.expand=function(d,c){var s=(new j(d)).expand(c);return new g(s)};return j});
(function(g,j){"object"===typeof exports?module.exports=j(require("jquery","./URI")):"function"===typeof define&&define.amd?define(["jquery","./URI"],j):j(g.jQuery,g.URI)})(this,function(g,j){function s(c){return c.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function d(c){var d;g.each(["src","href","action"],function(g,j){return j in c?(d=j,!1):!0});return"input"===c.nodeName.toLowerCase()&&"image"!==c.type?void 0:d}function t(c,k){var l,j,q;if(!d(c)||!k)return!1;l=k.match(p);if(!l||!l[5]&&":"!==
l[2]&&!m[l[2]])return!1;q=g(c).uri();if(l[5])return q.is(l[5]);if(":"===l[2])return j=l[1].toLowerCase()+":",!m[j]?!1:m[j](q,l[4]);j=l[1].toLowerCase();return!u[j]?!1:m[l[2]](q[j](),l[4],j)}var u={},m={"=":function(c,d){return c===d},"^=":function(c,d){return!!(c+"").match(RegExp("^"+s(d),"i"))},"$=":function(c,d){return!!(c+"").match(RegExp(s(d)+"$","i"))},"*=":function(c,d,g){"directory"==g&&(c+="/");return!!(c+"").match(RegExp(s(d),"i"))},"equals:":function(c,d){return c.equals(d)},"is:":function(c,
d){return c.is(d)}};g.each("authority directory domain filename fragment hash host hostname href password path pathname port protocol query resource scheme search subdomain suffix tld username".split(" "),function(c,d){u[d]=!0;g.attrHooks["uri:"+d]={get:function(c){return g(c).uri()[d]()},set:function(c,f){g(c).uri()[d](f);return f}}});var c=function(c,d){return g(c).uri().href(d).toString()};g.each(["src","href","action","uri"],function(d,k){g.attrHooks[k]={set:c}});g.attrHooks.uri.get=function(c){return g(c).uri()};
g.fn.uri=function(c){var g=this.first(),l=g.get(0),n=d(l);if(!n)throw Error('Element "'+l.nodeName+'" does not have either property: href, src, action');if(void 0!==c){var m=g.data("uri");if(m)return m.href(c);c instanceof j||(c=j(c))}else{if(c=g.data("uri"))return c;c=j(g.attr(n))}c._dom_element=l;c._dom_attribute=n;c.normalize();g.data("uri",c);return c};j.prototype.build=function(c){if(this._dom_element)this._string=j.build(this._parts),this._deferred_build=!1,this._dom_element.setAttribute(this._dom_attribute,
this._string),this._dom_element[this._dom_attribute]=this._string;else if(!0===c)this._deferred_build=!0;else if(void 0===c||this._deferred_build)this._string=j.build(this._parts),this._deferred_build=!1;return this};var v,p=/^([a-zA-Z]+)\s*([\^\$*]?=|:)\s*(['"]?)(.+)\3|^\s*([a-zA-Z0-9]+)\s*$/;v=g.expr.createPseudo?g.expr.createPseudo(function(c){return function(d){return t(d,c)}}):function(c,d,g){return t(c,g[3])};g.expr[":"].uri=v;return{}});
