from pilot import PilotComputeService, ComputeDataService, State

NUMBER_JOBS = 4
COORDINATION_URL = redis://localhost

pilot_compute_service = PilotComputeService(COORDINATION_URL)

# create pilot job service and initiate a pilot job
pilot_compute_description = {
                         "service_url": 'fork://localhost',
                         "number_of_processes": 1,
                         "working_directory": os.path.join(os.getcwd(),"work"),
                            }

pilotjob = pilot_compute_service.create_pilot(pilot_compute_description=pilot_compute_description)

compute_data_service = ComputeDataService()
compute_data_service.add_pilot_compute_service(pilot_compute_service)

# start work unit
compute_unit_description = {
        "executable": "/bin/date",
        "arguments": [""],
        "number_of_processes": 1,
        "output": "stdout.txt",
        "error": "stderr.txt",
}

for i in range(NUMBER_JOBS):
     compute_unit = compute_data_service.submit_compute_unit(compute_unit_description)

compute_data_service.wait()

compute_data_service.cancel()
