import re
import gtk

from PyGTKCallback import PyGTKCallback

__all__ = ['Periodic', 'PeriodicButton']

@PyGTKCallback
class Periodic(gtk.Table):
    table_list = "H\tHe\nLiBe\tBCNOFNe\nNaMg\tAlSiPSClAr\nKCa\tScTiVCrMnFeCoNiCuZnGaGeAsSeBrKr\nRbSr\tYZrNbMoTcRuRhPdAgCdInSnSbTeIXe\nCsBa(LaCePrNdPmSmEuGdTbDyHoErTmYbLu)HfTaWReOsIrPtAuHgTlPbBiPoAtRn\nFrRa(AcThPaUNpPuAmCmBkCfEsFmMdNoLr)RfHaSgBhHsMt"
    class LaAc(gtk.Window):
        def __init__(self, parent, elist):
            gtk.Window.__init__(self, gtk.WINDOW_POPUP)
            self.my_parent = parent
            t = gtk.Table(1, len(elist))
            self.add(t)
            icolumn1 = 0;
            for e1 in elist:
                b1 = gtk.Button(label=e1)
                b1.connect('clicked', self.click, e1, self.my_parent.elements[e1])
                t.attach(b1, icolumn1, icolumn1 + 1, 0, 1, gtk.EXPAND | gtk.FILL, gtk.EXPAND | gtk.FILL)
                icolumn1 += 1
            b1 = gtk.Button(label='Cancel')
            b1.connect('clicked', self.popdown)
            t.attach(b1, icolumn1, icolumn1 + 1, 0, 1, gtk.EXPAND | gtk.FILL, gtk.EXPAND | gtk.FILL, 10)
        def popup(self, *args, **kwargs):
            self.set_position(gtk.WIN_POS_MOUSE)
            self.set_modal(True)
            self.show_all()
        def popdown(self, *args, **kwargs):
            self.hide()
        def click(self, widget, element, atnumber):
            self.popdown()
            self.my_parent.select(self, element, atnumber)
    def __init__(self):
        gtk.Table.__init__(self, 7, 18)
        self.elements = dict(zip(re.findall('([A-Z][a-z]*)', self.table_list), range(1, 200)))
        iline = 0
        for line in self.table_list.split('\n'):
            icolumn = 0
            if (line.find('\t') >= 0):
                firstpart, lastpart = line.split('\t')
            else:
                firstpart = line
                lastpart = ""
            for e in re.findall('(?:[A-Z][a-z]*)|(?:\((?:[A-Z][a-z]*)*\))', firstpart):
                if e.startswith('('):
                    elist = re.findall('[A-Z][a-z]*', e)
                    b = gtk.Button(label='%s*' % (elist[0]))
                    w1 = self.LaAc(self, elist)
                    b.connect('clicked', w1.popup)
                else:
                    b = gtk.Button(label=e)
                    b.connect("clicked", self.select, e, self.elements[e])
                self.attach(b, icolumn, icolumn + 1, iline, iline + 1, gtk.EXPAND | gtk.FILL, gtk.EXPAND | gtk.FILL)
                icolumn += 1
            icolumn = 17
            for e in reversed(re.findall('([A-Z][a-z]*)', lastpart)):
                b = gtk.Button(label=e)
                b.connect("clicked", self.select, e, self.elements[e])
                self.attach(b, icolumn, icolumn + 1, iline, iline + 1, gtk.EXPAND | gtk.FILL, gtk.EXPAND | gtk.FILL)
                icolumn -= 1
            iline += 1
    def select(self, widget, element, atnumber):
        return self.emit('select-element', element, atnumber)
@PyGTKCallback
class PeriodicButton(gtk.Button):
    def __init__(self, element='Cu'):
        gtk.Button.__init__(self, element)
        self.my_handlers = []
        self.popupwindow = gtk.Window(gtk.WINDOW_POPUP)
        self.periodic = Periodic()
        self.popupwindow.add(self.periodic)
        self.connect('clicked', self.popup)
        self.periodic.connect('select-element', self.selected)
    def popup(self, widget):
        self.popupwindow.set_position(gtk.WIN_POS_MOUSE)
        self.popupwindow.set_modal(True)
        self.popupwindow.show_all()
    def selected(self, widget, element, atnumber):
        self.popupwindow.hide()
        self.set_element(element)
        self.emit('select-element', element, atnumber)
    def set_element(self, element):
        if element in self.periodic.elements:
            self.set_label(element)
        elif element in self.periodic.elements.values():
            self.set_label([k for k in self.periodic.elements if self.periodic.elements[k] == element][0])
    def get_element_name(self):
        return self.get_label()
    def get_element_number(self):
        return self.periodic.elements[self.get_label()]

AtomicData = [(1, "K", 13.6, 0), (2, "K", 24.6, 0), (3, "K", 54.8, 0),
    (3, "L1", 5.3, 0), (4, "K", 112.1, 0), (4, "L1", 8.0, 0),
    (5, "K", 188.0, 0), (5, "L1", 12.6, 0), (5, "L2", 4.7, 0),
    (5, "L3", 4.7, 0), (6, "K", 283.8, 0), (6, "L1", 18.0, 0),
    (6, "L2", 6.4, 0), (6, "L3", 6.4, 0), (7, "K", 401.6, 0),
    (7, "L1", 24.4, 0), (7, "L2", 9.2, 0), (7, "L3", 9.2, 0),
    (8, "K", 532.0, 0), (8, "L1", 28.5, 0), (8, "L2", 7.1, 0),
    (8, "L3", 7.1, 0), (9, "K", 685.4, 0), (9, "L1", 34.0, 0),
    (9, "L2", 8.6, 0), (9, "L3", 8.6, 0), (10, "K", 870.1, 0.24),
    (10, "L1", 48.5, 0), (10, "L2", 21.7, 0.01), (10, "L3", 21.6, 0.01),
    (11, "K", 1072.1, 0.28), (11, "L1", 63.3, 0.28), (11, "L2", 31.1, 0.02),
    (11, "L3", 31.1, 0.02), (11, "M1", 0.7, 0), (12, "K", 1305.0, 0.33),
    (12, "L1", 89.4, 0.46), (12, "L2", 51.4, 0.03), (12, "L3", 51.4, 0.03),
    (12, "M1", 2.1, 0), (13, "K", 1559.6, 0.37), (13, "L1", 117.7, 0.78),
    (13, "L2", 73.2, 0.04), (13, "L3", 72.7, 0.04), (13, "M1", 0.7, 0),
    (13, "M2", 5.5, 0), (13, "M3", 5.5, 0), (14, "K", 1838.9, 0.43),
    (14, "L1", 148.7, 0.9), (14, "L2", 99.5, 0.05), (14, "L3", 98.9, 0.05),
    (14, "M1", 7.6, 0), (14, "M2", 3.0, 0), (14, "M3", 3.0, 0),
    (15, "K", 2145.5, 0.47), (15, "L1", 189.3, 1.1), (15, "L2", 136.2, 0.07),
    (15, "L3", 135.3, 0.07), (15, "M1", 16.2, 0), (15, "M2", 9.9, 0),
    (15, "M3", 9.9, 0), (16, "K", 2472.0, 0.52), (16, "L1", 229.2, 1.3),
    (16, "L2", 165.4, 0.09), (16, "L3", 164.2, 0.09), (16, "M1", 15.8, 0),
    (16, "M2", 8.0, 0), (16, "M3", 8.0, 0), (17, "K", 2822.4, 0.57),
    (17, "L1", 270.2, 1.5), (17, "L2", 201.6, 0.11), (17, "L3", 200.0, 0.11),
    (17, "M1", 17.5, 0), (17, "M2", 6.8, 0), (17, "M3", 6.8, 0),
    (18, "K", 3206.0, 0.66), (18, "L1", 326.3, 1.8), (18, "L2", 250.7, 0.13),
    (18, "L3", 248.6, 0.13), (18, "M1", 29.2, 0.14), (18, "M2", 15.9, 0),
    (18, "M3", 15.8, 0), (19, "K", 3607.4, 0.71), (19, "L1", 377.1, 2.1),
    (19, "L2", 296.3, 0.18), (19, "L3", 293.6, 0.18), (19, "M1", 33.9, 0.7),
    (19, "M2", 17.8, 0), (19, "M3", 17.8, 0), (20, "K", 4038.1, 0.77),
    (20, "L1", 437.8, 2.5), (20, "L2", 350.0, 0.21), (20, "L3", 346.4, 0.21),
    (20, "M1", 43.7, 1.1), (20, "M2", 25.4, 1.2), (20, "M3", 25.4, 1.2),
    (21, "K", 4492.8, 0.83), (21, "L1", 500.4, 3.3), (21, "L2", 406.7, 0.36),
    (21, "L3", 402.2, 0.23), (21, "M1", 53.8, 1.7), (21, "M2", 32.3, 1.2),
    (21, "M3", 32.3, 1.2), (21, "M4", 6.6, 0), (21, "M5", 6.6, 0),
    (22, "K", 4966.4, 0.89), (22, "L1", 563.7, 3.9), (22, "L2", 461.5, 0.52),
    (22, "L3", 455.5, 0.25), (22, "M1", 60.3, 2.1), (22, "M2", 34.6, 1.2),
    (22, "M3", 34.6, 1.2), (22, "M4", 3.7, 0), (22, "M5", 3.7, 0),
    (23, "K", 5465.1, 0.96), (23, "L1", 628.2, 4.6), (23, "L2", 520.5, 0.78),
    (23, "L3", 512.9, 0.28), (23, "M1", 66.5, 2.2), (23, "M2", 37.8, 1.2),
    (23, "M3", 37.8, 1.2), (23, "M4", 2.2, 0), (23, "M5", 2.2, 0),
    (24, "K", 5989.2, 1.02), (24, "L1", 694.6, 5.2), (24, "L2", 583.7, 0.76),
    (24, "L3", 574.5, 0.32), (24, "M1", 74.1, 2.3), (24, "M2", 42.5, 1.2),
    (24, "M3", 42.5, 1.2), (24, "M4", 2.3, 0), (24, "M5", 2.3, 0),
    (25, "K", 6539.0, 1.11), (25, "L1", 769.0, 6.2), (25, "L2", 651.4, 0.97),
    (25, "L3", 640.3, 0.36), (25, "M1", 83.9, 2.4), (25, "M2", 48.6, 1.2),
    (25, "M3", 48.6, 1.2), (25, "M4", 3.3, 0), (25, "M5", 3.3, 0),
    (26, "K", 7112.0, 1.19), (26, "L1", 846.1, 7.0), (26, "L2", 721.1, 1.14),
    (26, "L3", 708.1, 0.41), (26, "M1", 92.9, 2.4), (26, "M2", 54.0, 1.23),
    (26, "M3", 54.0, 1.23), (26, "M4", 3.6, 0), (26, "M5", 3.6, 0),
    (27, "K", 7708.9, 1.28), (27, "L1", 925.6, 7.2), (27, "L2", 793.6, 1.13),
    (27, "L3", 778.6, 0.47), (27, "M1", 100.7, 2.4), (27, "M2", 59.5, 1.25),
    (27, "M3", 59.5, 1.27), (27, "M4", 2.9, 0), (27, "M5", 2.9, 0),
    (28, "K", 8332.8, 1.39), (28, "L1", 1008.1, 6.4), (28, "L2", 871.9, 0.98),
    (28, "L3", 854.7, 0.53), (28, "M1", 111.8, 2.3), (28, "M2", 68.1, 1.3),
    (28, "M3", 68.1, 1.3), (28, "M4", 3.6, 0), (28, "M5", 3.6, 0),
    (29, "K", 8978.9, 1.49), (29, "L1", 1096.1, 5.5), (29, "L2", 951.0, 1.04),
    (29, "L3", 931.1, 0.61), (29, "M1", 119.8, 2.2), (29, "M2", 73.6, 1.9),
    (29, "M3", 73.6, 1.8), (29, "M4", 1.6, 0), (29, "M5", 1.6, 0),
    (30, "K", 9658.6, 1.62), (30, "L1", 1193.6, 4.8), (30, "L2", 1042.8, 1.06),
    (30, "L3", 1019.7, 0.68), (30, "M1", 135.9, 2.1), (30, "M2", 86.6, 2.1),
    (30, "M3", 86.6, 2.15), (30, "M4", 8.1, 0), (30, "M5", 8.1, 0),
    (31, "K", 10367.1, 1.76), (31, "L1", 1297.7, 4.1), (31, "L2", 1142.3, 0.77),
    (31, "L3", 1115.4, 0.77), (31, "M1", 158.1, 2.0), (31, "M2", 106.8, 2.25),
    (31, "M3", 102.9, 2.3), (31, "M4", 17.4, 0.012), (31, "M5", 17.4, 0),
    (31, "N1", 1.5, 0), (31, "N2", 0.8, 0), (31, "N3", 0.8, 0),
    (32, "K", 11103.1, 1.92), (32, "L1", 1414.3, 3.8), (32, "L2", 1247.8, 0.86),
    (32, "L3", 1216.7, 0.86), (32, "M1", 180.0, 2.1), (32, "M2", 127.9, 2.3),
    (32, "M3", 120.8, 2.3), (32, "M4", 28.7, 0.045), (32, "M5", 28.7, 0.044),
    (32, "N1", 5.0, 0), (32, "N2", 2.3, 0), (32, "N3", 2.3, 0),
    (33, "K", 11866.7, 2.09), (33, "L1", 1526.5, 3.8), (33, "L2", 1358.6, 0.95),
    (33, "L3", 1323.1, 0.94), (33, "M1", 203.5, 2.4), (33, "M2", 146.4, 2.25),
    (33, "M3", 140.5, 2.25), (33, "M4", 41.2, 0.058), (33, "M5", 41.2, 0.06),
    (33, "N1", 8.5, 0), (33, "N2", 2.5, 0), (33, "N3", 2.5, 0),
    (34, "K", 12657.8, 2.28), (34, "L1", 1653.9, 3.8), (34, "L2", 1476.2, 1.05),
    (34, "L3", 1435.8, 1.02), (34, "M1", 231.5, 2.8), (34, "M2", 168.2, 2.2),
    (34, "M3", 161.9, 2.2), (34, "M4", 56.7, 0.065), (34, "M5", 56.7, 0.066),
    (34, "N1", 12.0, 0), (34, "N2", 5.6, 0), (34, "N3", 5.6, 0),
    (35, "K", 13473.7, 2.49), (35, "L1", 1782.0, 3.8), (35, "L2", 1596.0, 1.14),
    (35, "L3", 1549.9, 1.11), (35, "M1", 256.5, 3.2), (35, "M2", 189.3, 2.1),
    (35, "M3", 181.5, 2.15), (35, "M4", 70.1, 0.068), (35, "M5", 69.0, 0.07),
    (35, "N1", 27.3, 0), (35, "N2", 5.2, 0), (35, "N3", 4.6, 0),
    (36, "K", 14325.6, 2.71), (36, "L1", 1921.0, 3.75), (36, "L2", 1727.2, 1.25),
    (36, "L3", 1674.9, 1.19), (36, "M1", 292.1, 3.5), (36, "M2", 221.8, 1.6),
    (36, "M3", 214.5, 1.1), (36, "M4", 95.0, 0.07), (36, "M5", 93.8, 0.072),
    (36, "N1", 27.5, 0.4), (36, "N2", 14.7, 0), (36, "N3", 14.0, 0),
    (37, "K", 15199.7, 2.96), (37, "L1", 2065.1, 3.75), (37, "L2", 1863.9, 1.34),
    (37, "L3", 1804.4, 1.27), (37, "M1", 322.1, 4.0), (37, "M2", 247.4, 1.9),
    (37, "M3", 238.5, 1.95), (37, "M4", 111.8, 0.067), (37, "M5", 110.3, 0.069),
    (37, "N1", 29.3, 1.2), (37, "N2", 14.8, 0), (37, "N3", 14.0, 0),
    (38, "K", 16104.6, 3.23), (38, "L1", 2216.3, 3.75), (38, "L2", 2006.8, 1.43),
    (38, "L3", 1939.6, 1.35), (38, "M1", 357.5, 4.4), (38, "M2", 279.8, 1.9),
    (38, "M3", 269.1, 1.9), (38, "M4", 135.0, 0.061), (38, "M5", 133.1, 0.064),
    (38, "N1", 37.7, 1.6), (38, "N2", 19.9, 0.4), (38, "N3", 19.9, 0),
    (39, "K", 17038.4, 3.51), (39, "L1", 2372.5, 3.75), (39, "L2", 2155.5, 1.53),
    (39, "L3", 2080.0, 1.43), (39, "M1", 393.6, 4.9), (39, "M2", 312.4, 1.95),
    (39, "M3", 300.3, 1.95), (39, "M4", 159.6, 0.062), (39, "M5", 157.4, 0.066),
    (39, "N1", 45.4, 2.0), (39, "N2", 25.6, 0.8), (39, "N3", 25.6, 0.3),
    (39, "N4", 2.4, 0), (39, "N5", 2.4, 0), (40, "K", 17997.6, 3.83),
    (40, "L1", 2531.6, 3.75), (40, "L2", 2306.7, 1.63), (40, "L3", 2222.3, 1.51),
    (40, "M1", 430.3, 5.4), (40, "M2", 344.2, 2.0), (40, "M3", 330.5, 2.0),
    (40, "M4", 182.4, 0.07), (40, "M5", 180.0, 0.074), (40, "N1", 51.3, 2.4),
    (40, "N2", 28.7, 1.2), (40, "N3", 28.7, 0.6), (40, "N4", 3.0, 0),
    (40, "N5", 3.0, 0), (41, "K", 18985.6, 4.16), (41, "L1", 2697.7, 3.8),
    (41, "L2", 2464.7, 1.73), (41, "L3", 2370.5, 1.6), (41, "M1", 468.4, 5.8),
    (41, "M2", 378.4, 2.05), (41, "M3", 363.0, 2.05), (41, "M4", 207.4, 0.092),
    (41, "M5", 204.6, 0.095), (41, "N1", 58.1, 2.8), (41, "N2", 33.9, 1.5),
    (41, "N3", 33.9, 1.0), (41, "N4", 3.2, 0), (41, "N5", 3.2, 0),
    (42, "K", 19999.5, 4.52), (42, "L1", 2865.5, 3.8), (42, "L2", 2625.1, 1.83),
    (42, "L3", 2520.2, 1.69), (42, "M1", 504.6, 6.3), (42, "M2", 409.7, 2.1),
    (42, "M3", 392.3, 2.1), (42, "M4", 230.3, 0.22), (42, "M5", 227.0, 0.12),
    (42, "N1", 61.8, 3.2), (42, "N2", 34.8, 2.2), (42, "N3", 34.8, 1.6),
    (42, "N4", 1.8, 0), (42, "N5", 1.8, 0), (43, "K", 21044.0, 4.91),
    (43, "L1", 3042.5, 3.8), (43, "L2", 2793.2, 1.93), (43, "L3", 2676.9, 1.78),
    (43, "M1", 544.0, 6.7), (43, "M2", 444.9, 2.15), (43, "M3", 425.0, 2.15),
    (43, "M4", 256.4, 0.5), (43, "M5", 252.9, 0.14), (43, "N1", 68.0, 3.5),
    (43, "N2", 38.9, 2.7), (43, "N3", 38.9, 2.2), (43, "N4", 2.0, 0),
    (43, "N5", 2.0, 0), (44, "K", 22117.2, 5.33), (44, "L1", 3224.0, 3.9),
    (44, "L2", 2966.9, 2.03), (44, "L3", 2837.9, 1.87), (44, "M1", 585.0, 7.2),
    (44, "M2", 482.8, 2.2), (44, "M3", 460.6, 2.2), (44, "M4", 283.6, 0.59),
    (44, "M5", 279.4, 0.17), (44, "N1", 74.9, 3.9), (44, "N2", 43.1, 3.2),
    (44, "N3", 43.1, 2.8), (44, "N4", 2.0, 0), (44, "N5", 2.0, 0),
    (45, "K", 23219.9, 5.77), (45, "L1", 3411.9, 4.0), (45, "L2", 3146.1, 2.13),
    (45, "L3", 3003.8, 1.96), (45, "M1", 627.1, 7.6), (45, "M2", 521.0, 2.25),
    (45, "M3", 496.2, 2.25), (45, "M4", 311.7, 0.61), (45, "M5", 307.0, 0.21),
    (45, "N1", 81.0, 4.2), (45, "N2", 47.9, 4.2), (45, "N3", 47.9, 3.8),
    (45, "N4", 2.5, 0), (45, "N5", 2.5, 0), (46, "K", 24350.3, 6.25),
    (46, "L1", 3604.3, 3.9), (46, "L2", 3330.3, 2.23), (46, "L3", 3173.3, 2.05),
    (46, "M1", 669.9, 8.0), (46, "M2", 559.1, 2.35), (46, "M3", 531.5, 2.35),
    (46, "M4", 340.0, 0.26), (46, "M5", 334.7, 0.26), (46, "N1", 86.4, 4.35),
    (46, "N2", 51.1, 6.4), (46, "N3", 51.1, 5.6), (46, "N4", 1.5, 0),
    (46, "N5", 1.5, 0), (47, "K", 25514.0, 6.76), (47, "L1", 3805.8, 3.8),
    (47, "L2", 3523.7, 2.32), (47, "L3", 3351.1, 2.15), (47, "M1", 717.5, 8.4),
    (47, "M2", 602.4, 2.45), (47, "M3", 571.4, 2.55), (47, "M4", 372.8, 0.30),
    (47, "M5", 366.7, 0.31), (47, "N1", 95.2, 4.4), (47, "N2", 62.6, 8.4),
    (47, "N3", 55.9, 8.0), (47, "N4", 3.3, 0), (47, "N5", 3.3, 0),
    (48, "K", 26711.2, 7.32), (48, "L1", 4018.0, 3.5), (48, "L2", 3727.0, 2.42),
    (48, "L3", 3537.5, 2.24), (48, "M1", 770.2, 8.8), (48, "M2", 650.7, 2.55),
    (48, "M3", 616.5, 2.8), (48, "M4", 410.5, 0.34), (48, "M5", 403.7, 0.35),
    (48, "N1", 107.6, 4.4), (48, "N2", 66.9, 10.8), (48, "N3", 66.9, 10.5),
    (48, "N4", 9.3, 0), (48, "N5", 9.3, 0), (48, "O1", 2.2, 0),
    (48, "O2", 2.2, 0), (48, "O3", 2.2, 0), (49, "K", 27939.9, 7.9),
    (49, "L1", 4237.5, 3.0), (49, "L2", 3938.0, 2.53), (49, "L3", 3730.1, 2.34),
    (49, "M1", 825.6, 9.2), (49, "M2", 702.2, 2.7), (49, "M3", 664.3, 3.05),
    (49, "M4", 450.8, 0.38), (49, "M5", 443.1, 0.39), (49, "N1", 121.9, 4.2),
    (49, "N2", 77.4, 13.2), (49, "N3", 77.4, 14.0), (49, "N4", 16.2, 0),
    (49, "N5", 16.2, 0), (49, "O1", 0.1, 0), (49, "O2", 0.8, 0),
    (49, "O3", 0.8, 0), (50, "K", 29200.1, 8.53), (50, "L1", 4464.7, 2.4),
    (50, "L2", 4156.1, 2.64), (50, "L3", 3928.8, 2.43), (50, "M1", 883.8, 9.6),
    (50, "M2", 756.4, 2.85), (50, "M3", 714.4, 3.3), (50, "M4", 493.3, 0.43),
    (50, "M5", 484.8, 0.44), (50, "N1", 136.5, 3.4), (50, "N2", 88.6, 17.0),
    (50, "N3", 88.6, 17.0), (50, "N4", 23.9, 0.08), (50, "N5", 23.9, 0.08),
    (50, "O1", 0.9, 0), (50, "O2", 1.1, 0), (50, "O3", 1.1, 0),
    (51, "K", 30491.2, 9.2), (51, "L1", 4698.3, 2.3), (51, "L2", 4380.4, 2.74),
    (51, "L3", 4132.2, 2.53), (51, "M1", 943.7, 10.0), (51, "M2", 811.9, 3.0),
    (51, "M3", 765.6, 3.6), (51, "M4", 536.9, 0.47), (51, "M5", 527.5, 0.48),
    (51, "N1", 152.0, 2.6), (51, "N2", 98.4, 0), (51, "N3", 98.4, 0),
    (51, "N4", 31.4, 0.14), (51, "N5", 31.4, 0.14), (51, "O1", 6.7, 0),
    (51, "O2", 2.1, 0), (51, "O3", 2.1, 0), (52, "K", 31813.8, 9.91),
    (52, "L1", 4939.2, 2.2), (52, "L2", 4612.0, 2.84), (52, "L3", 4341.4, 2.62),
    (52, "M1", 1006.0, 10.2), (52, "M2", 869.7, 3.2), (52, "M3", 818.7, 3.9),
    (52, "M4", 582.5, 0.52), (52, "M5", 572.1, 0.52), (52, "N1", 168.3, 2.4),
    (52, "N2", 110.2, 0), (52, "N3", 110.2, 0), (52, "N4", 39.8, 0.17),
    (52, "N5", 39.8, 0.2), (52, "O1", 11.6, 0), (52, "O2", 2.3, 0),
    (52, "O3", 2.3, 0), (53, "K", 33169.4, 10.7), (53, "L1", 5188.1, 2.1),
    (53, "L2", 4852.1, 2.95), (53, "L3", 4557.1, 2.72), (53, "M1", 1072.1, 10.4),
    (53, "M2", 930.5, 3.35), (53, "M3", 874.6, 4.3), (53, "M4", 631.3, 0.56),
    (53, "M5", 619.4, 0.56), (53, "N1", 186.4, 2.4), (53, "N2", 122.7, 0),
    (53, "N3", 122.7, 0), (53, "N4", 49.6, 0.11), (53, "N5", 49.6, 0.12),
    (53, "O1", 13.6, 0), (53, "O2", 3.3, 0), (53, "O3", 3.3, 0),
    (54, "K", 34564.4, 11.5), (54, "L1", 5452.8, 2.0), (54, "L2", 5103.7, 3.05),
    (54, "L3", 4782.2, 2.82), (54, "M1", 1148.7, 10.6), (54, "M2", 1002.1, 3.5),
    (54, "M3", 940.6, 4.7), (54, "M4", 689.4, 0.6), (54, "M5", 676.7, 0.6),
    (54, "N1", 213.3, 2.6), (54, "N2", 145.5, 0), (54, "N3", 145.5, 0),
    (54, "N4", 69.5, 0.1), (54, "N5", 67.5, 0.08), (54, "O1", 23.4, 0),
    (54, "O2", 13.4, 0), (54, "O3", 12.1, 0), (55, "K", 35984.6, 12.3),
    (55, "L1", 5714.3, 2.0), (55, "L2", 5359.4, 3.15), (55, "L3", 5011.9, 2.92),
    (55, "M1", 1217.1, 10.8), (55, "M2", 1065.0, 3.7), (55, "M3", 997.6, 5.0),
    (55, "M4", 739.5, 0.63), (55, "M5", 725.5, 0.63), (55, "N1", 230.8, 2.8),
    (55, "N2", 172.3, 0), (55, "N3", 161.6, 0), (55, "N4", 78.8, 0.08),
    (55, "N5", 76.5, 0.08), (55, "O1", 22.7, 0), (55, "O2", 13.1, 0),
    (55, "O3", 11.4, 0), (56, "K", 37440.6, 13.2), (56, "L1", 5988.8, 2.1),
    (56, "L2", 5623.6, 3.25), (56, "L3", 5247.0, 3.02), (56, "M1", 1292.8, 11.1),
    (56, "M2", 1136.7, 3.9), (56, "M3", 1062.2, 5.4), (56, "M4", 796.1, 0.67),
    (56, "M5", 780.7, 0.67), (56, "N1", 253.0, 3.1), (56, "N2", 191.8, 5.0),
    (56, "N3", 179.7, 1.3), (56, "N4", 92.5, 0.08), (56, "N5", 89.9, 0.08),
    (56, "O1", 29.1, 0), (56, "O2", 16.6, 0), (56, "O3", 14.6, 0),
    (57, "K", 38924.6, 14.2), (57, "L1", 6266.3, 2.2), (57, "L2", 5890.6, 3.35),
    (57, "L3", 5482.7, 3.12), (57, "M1", 1361.3, 11.4), (57, "M2", 1204.4, 4.1),
    (57, "M3", 1123.4, 5.8), (57, "M4", 848.5, 0.7), (57, "M5", 831.7, 0.7),
    (57, "N1", 270.4, 3.3), (57, "N2", 205.8, 5.03), (57, "N3", 191.4, 1.45),
    (57, "N4", 98.9, 0.09), (57, "N5", 98.9, 0.1), (57, "O1", 32.3, 0),
    (57, "O2", 14.4, 0), (57, "O3", 14.4, 0), (58, "K", 40443.0, 15.2),
    (58, "L1", 6548.8, 2.5), (58, "L2", 6164.2, 3.41), (58, "L3", 5723.4, 3.19),
    (58, "M1", 1434.6, 11.6), (58, "M2", 1272.8, 4.3), (58, "M3", 1185.4, 6.2),
    (58, "M4", 901.3, 0.72), (58, "M5", 883.3, 0.72), (58, "N1", 289.6, 3.5),
    (58, "N2", 223.3, 5.06), (58, "N3", 207.2, 1.6), (58, "N4", 110.0, 0.61),
    (58, "N5", 110.0, 0.32), (58, "N6", 0.1, 0), (58, "N7", 0.1, 0),
    (58, "O1", 37.8, 0), (58, "O2", 19.8, 0), (58, "O3", 19.8, 0),
    (59, "K", 41990.6, 16.2), (59, "L1", 6834.8, 2.7), (59, "L2", 6440.4, 3.48),
    (59, "L3", 5964.3, 3.27), (59, "M1", 1511.0, 11.8), (59, "M2", 1337.4, 4.5),
    (59, "M3", 1242.2, 6.7), (59, "M4", 951.1, 0.75), (59, "M5", 931.0, 0.75),
    (59, "N1", 304.5, 3.7), (59, "N2", 236.3, 5.08), (59, "N3", 217.6, 1.75),
    (59, "N4", 113.2, 0.78), (59, "N5", 113.2, 0.53), (59, "N6", 2.0, 0),
    (59, "N7", 2.0, 0), (59, "O1", 37.4, 0), (59, "O2", 22.3, 0),
    (59, "O3", 22.3, 0), (60, "K", 43568.9, 17.4), (60, "L1", 7126.0, 2.9),
    (60, "L2", 6721.5, 3.55), (60, "L3", 6207.9, 3.36), (60, "M1", 1575.3, 12.0),
    (60, "M2", 1402.8, 4.7), (60, "M3", 1297.4, 7.3), (60, "M4", 999.9, 0.78),
    (60, "M5", 977.7, 0.78), (60, "N1", 315.2, 4.0), (60, "N2", 243.3, 5.1),
    (60, "N3", 224.6, 1.9), (60, "N4", 117.5, 1.05), (60, "N5", 117.5, 0.8),
    (60, "N6", 1.5, 0), (60, "N7", 1.5, 0), (60, "O1", 37.5, 0),
    (60, "O2", 21.1, 0), (60, "O3", 21.1, 0), (61, "K", 45184.0, 18.5),
    (61, "L1", 7427.9, 3.1), (61, "L2", 7012.8, 3.63), (61, "L3", 6459.3, 3.44),
    (61, "M1", 1650.0, 12.2), (61, "M2", 1471.4, 5.0), (61, "M3", 1356.9, 7.8),
    (61, "M4", 1051.5, 0.82), (61, "M5", 1026.9, 0.82), (61, "N1", 331.0, 4.2),
    (61, "N2", 242.0, 5.13), (61, "N3", 242.0, 2.05), (61, "N4", 120.4, 1.38),
    (61, "N5", 120.4, 1.11), (61, "N6", 4.0, 0), (61, "N7", 4.0, 0),
    (61, "O1", 38.0, 0), (61, "O2", 22.0, 0), (61, "O3", 22.0, 0),
    (62, "K", 46834.2, 19.8), (62, "L1", 7736.8, 3.3), (62, "L2", 7311.8, 3.7),
    (62, "L3", 6716.2, 3.53), (62, "M1", 1722.8, 12.4), (62, "M2", 1540.7, 5.2),
    (62, "M3", 1419.8, 8.1), (62, "M4", 1106.0, 0.86), (62, "M5", 1080.2, 0.86),
    (62, "N1", 345.7, 4.4), (62, "N2", 265.6, 5.16), (62, "N3", 247.4, 2.2),
    (62, "N4", 129.0, 1.78), (62, "N5", 129.0, 1.48), (62, "N6", 5.5, 0),
    (62, "N7", 5.5, 0), (62, "O1", 37.4, 0), (62, "O2", 21.3, 0),
    (62, "O3", 21.3, 0), (63, "K", 48519.0, 21.1), (63, "L1", 8052.0, 3.6),
    (63, "L2", 7617.1, 3.77), (63, "L3", 6976.9, 3.62), (63, "M1", 1800.0, 12.6),
    (63, "M2", 1613.9, 5.4), (63, "M3", 1480.6, 8.2), (63, "M4", 1160.6, 0.9),
    (63, "M5", 1130.9, 0.9), (63, "N1", 360.2, 4.6), (63, "N2", 283.9, 5.2),
    (63, "N3", 256.6, 2.35), (63, "N4", 133.2, 2.2), (63, "N5", 133.2, 1.9),
    (63, "O1", 31.8, 0), (63, "O2", 22.0, 0), (63, "O3", 22.0, 0),
    (64, "K", 50239.1, 22.4), (64, "L1", 8375.6, 3.8), (64, "L2", 7930.3, 3.87),
    (64, "L3", 7242.8, 3.72), (64, "M1", 1880.8, 12.8), (64, "M2", 1688.3, 5.6),
    (64, "M3", 1544.0, 8.3), (64, "M4", 1217.2, 0.95), (64, "M5", 1185.2, 0.95),
    (64, "N1", 375.8, 4.9), (64, "N2", 288.5, 5.23), (64, "N3", 270.9, 2.5),
    (64, "N4", 140.5, 2.45), (64, "N5", 140.5, 2.2), (64, "N6", 0.1, 0),
    (64, "N7", 0.1, 0), (64, "O1", 36.1, 0), (64, "O2", 20.3, 0),
    (64, "O3", 20.3, 0), (65, "K", 51995.7, 23.8), (65, "L1", 8708.0, 4.0),
    (65, "L2", 8251.6, 3.93), (65, "L3", 7514.0, 3.8), (65, "M1", 1967.5, 13.0),
    (65, "M2", 1767.7, 5.8), (65, "M3", 1611.3, 8.2), (65, "M4", 1275.0, 1.01),
    (65, "M5", 1241.2, 1.01), (65, "N1", 397.9, 5.1), (65, "N2", 310.2, 5.26),
    (65, "N3", 285.0, 2.65), (65, "N4", 147.0, 2.7), (65, "N5", 147.0, 2.4),
    (65, "N6", 2.6, 0), (65, "N7", 2.6, 0), (65, "O1", 39.0, 0),
    (65, "O2", 25.4, 0), (65, "O3", 25.4, 0), (66, "K", 53788.5, 25.3),
    (66, "L1", 9045.8, 4.3), (66, "L2", 8580.6, 4.01), (66, "L3", 7790.1, 3.9),
    (66, "M1", 2046.8, 13.2), (66, "M2", 1841.8, 6.0), (66, "M3", 1675.6, 8.0),
    (66, "M4", 1332.5, 1.065), (66, "M5", 1294.9, 1.065), (66, "N1", 416.3, 5.4),
    (66, "N2", 331.8, 5.3), (66, "N3", 292.9, 2.8), (66, "N4", 154.2, 2.95),
    (66, "N5", 154.2, 2.6), (66, "N6", 4.2, 0), (66, "N7", 4.2, 0),
    (66, "O1", 62.9, 0), (66, "O2", 26.3, 0), (66, "O3", 26.3, 0),
    (67, "K", 55617.7, 26.9), (67, "L1", 9394.2, 4.5), (67, "L2", 8917.8, 4.09),
    (67, "L3", 8071.1, 4.0), (67, "M1", 2128.3, 13.4), (67, "M2", 1922.8, 6.3),
    (67, "M3", 1741.2, 7.8), (67, "M4", 1391.5, 1.13), (67, "M5", 1351.4, 1.13),
    (67, "N1", 435.7, 5.6), (67, "N2", 343.5, 5.33), (67, "N3", 306.6, 2.95),
    (67, "N4", 161.0, 3.15), (67, "N5", 161.0, 2.8), (67, "N6", 3.7, 0),
    (67, "N7", 3.7, 0), (67, "O1", 51.2, 0), (67, "O2", 20.3, 0),
    (67, "O3", 20.3, 0), (68, "K", 57485.5, 28.5), (68, "L1", 9751.3, 4.7),
    (68, "L2", 9264.3, 4.18), (68, "L3", 8357.9, 4.1), (68, "M1", 2206.5, 13.6),
    (68, "M2", 2005.8, 6.6), (68, "M3", 1811.8, 7.5), (68, "M4", 1453.3, 1.2),
    (68, "M5", 1409.3, 1.2), (68, "N1", 449.1, 5.8), (68, "N2", 366.2, 5.36),
    (68, "N3", 320.0, 3.15), (68, "N4", 176.7, 3.35), (68, "N5", 167.6, 2.95),
    (68, "N6", 4.3, 0), (68, "N7", 4.3, 0), (68, "O1", 59.8, 0),
    (68, "O2", 29.4, 0), (68, "O3", 29.4, 0), (69, "K", 59389.6, 30.2),
    (69, "L1", 10115.7, 4.9), (69, "L2", 9616.9, 4.26), (69, "L3", 8648.0, 4.2),
    (69, "M1", 2306.8, 13.8), (69, "M2", 2089.8, 6.85), (69, "M3", 1884.5, 7.1),
    (69, "M4", 1514.6, 1.27), (69, "M5", 1467.7, 1.27), (69, "N1", 471.7, 6.1),
    (69, "N2", 385.9, 5.4), (69, "N3", 336.6, 3.3), (69, "N4", 179.6, 3.55),
    (69, "N5", 179.6, 3.1), (69, "N6", 5.3, 0), (69, "N7", 5.3, 0),
    (69, "O1", 53.2, 0), (69, "O2", 32.3, 0), (69, "O3", 32.3, 0),
    (70, "K", 61332.3, 32.0), (70, "L1", 10486.4, 5.2), (70, "L2", 9978.2, 4.36),
    (70, "L3", 8943.6, 4.31), (70, "M1", 2398.1, 13.9), (70, "M2", 2173.0, 7.1),
    (70, "M3", 1949.8, 6.7), (70, "M4", 1576.3, 1.35), (70, "M5", 1527.8, 1.35),
    (70, "N1", 487.2, 6.3), (70, "N2", 396.7, 5.5), (70, "N3", 343.5, 3.5),
    (70, "N4", 198.1, 3.7), (70, "N5", 184.9, 3.2), (70, "N6", 6.3, 0.03),
    (70, "N7", 6.3, 0.03), (70, "O1", 54.1, 0), (70, "O2", 23.4, 0),
    (70, "O3", 23.4, 0), (71, "K", 63313.8, 33.9), (71, "L1", 10870.4, 5.4),
    (71, "L2", 10348.6, 4.46), (71, "L3", 9244.1, 4.43), (71, "M1", 2491.2, 14.1),
    (71, "M2", 2263.5, 7.3), (71, "M3", 2023.6, 6.0), (71, "M4", 1639.4, 1.43),
    (71, "M5", 1588.5, 1.43), (71, "N1", 506.2, 6.6), (71, "N2", 410.1, 5.5),
    (71, "N3", 359.3, 3.65), (71, "N4", 204.8, 3.8), (71, "N5", 195.0, 3.3),
    (71, "N6", 6.9, 0.03), (71, "N7", 6.9, 0.03), (71, "O1", 56.8, 0),
    (71, "O2", 28.0, 0), (71, "O3", 28.0, 0), (71, "O4", 4.6, 0),
    (71, "O5", 4.6, 0), (72, "K", 65350.8, 35.9), (72, "L1", 11270.7, 5.7),
    (72, "L2", 10739.4, 4.57), (72, "L3", 9560.7, 4.55), (72, "M1", 2600.9, 14.2),
    (72, "M2", 2365.4, 7.5), (72, "M3", 2107.6, 5.6), (72, "M4", 1716.4, 1.52),
    (72, "M5", 1661.7, 1.52), (72, "N1", 538.1, 6.8), (72, "N2", 437.0, 5.6),
    (72, "N3", 380.4, 3.85), (72, "N4", 223.8, 3.9), (72, "N5", 213.7, 3.5),
    (72, "N6", 17.1, 0.07), (72, "N7", 17.1, 0.03), (72, "O1", 64.9, 0),
    (72, "O2", 38.1, 0), (72, "O3", 30.6, 0), (72, "O4", 6.6, 0),
    (72, "O5", 6.6, 0), (73, "K", 67416.4, 37.9), (73, "L1", 11681.5, 6.0),
    (73, "L2", 11136.1, 4.69), (73, "L3", 9881.1, 4.68), (73, "M1", 2708.0, 14.3),
    (73, "M2", 2468.7, 7.8), (73, "M3", 2194.0, 5.7), (73, "M4", 1793.2, 1.61),
    (73, "M5", 1735.1, 1.61), (73, "N1", 565.5, 7.0), (73, "N2", 464.8, 5.7),
    (73, "N3", 404.5, 4.0), (73, "N4", 241.3, 4.0), (73, "N5", 229.3, 3.65),
    (73, "N6", 27.5, 0.08), (73, "N7", 25.6, 0.04), (73, "O1", 71.1, 0),
    (73, "O2", 44.9, 0), (73, "O3", 36.4, 0), (73, "O4", 5.7, 0),
    (73, "O5", 5.7, 0), (74, "K", 69525.0, 40.1), (74, "L1", 12099.8, 6.3),
    (74, "L2", 11544.0, 4.82), (74, "L3", 10206.8, 4.81), (74, "M1", 2819.6, 14.5),
    (74, "M2", 2574.9, 8.1), (74, "M3", 2281.0, 6.4), (74, "M4", 1871.6, 1.7),
    (74, "M5", 1809.2, 1.7), (74, "N1", 595.0, 7.3), (74, "N2", 491.6, 5.8),
    (74, "N3", 425.3, 4.2), (74, "N4", 258.8, 4.1), (74, "N5", 245.4, 3.8),
    (74, "N6", 37.9, 0.1), (74, "N7", 35.8, 0.06), (74, "O1", 77.1, 0),
    (74, "O2", 46.8, 0), (74, "O3", 35.6, 0), (74, "O4", 6.1, 0),
    (74, "O5", 6.1, 0), (75, "K", 71676.4, 42.2), (75, "L1", 12526.7, 6.7),
    (75, "L2", 11958.7, 4.95), (75, "L3", 10535.3, 4.95), (75, "M1", 2931.7, 14.6),
    (75, "M2", 2681.6, 8.4), (75, "M3", 2367.3, 6.9), (75, "M4", 1948.9, 1.79),
    (75, "M5", 1882.9, 1.79), (75, "N1", 625.0, 7.5), (75, "N2", 517.9, 5.9),
    (75, "N3", 444.4, 4.4), (75, "N4", 273.7, 4.1), (75, "N5", 260.2, 3.9),
    (75, "N6", 48.1, 0.15), (75, "N7", 45.7, 0.11), (75, "O1", 82.8, 0),
    (75, "O2", 45.6, 0), (75, "O3", 34.6, 0), (75, "O4", 3.5, 0),
    (75, "O5", 3.5, 0), (76, "K", 73870.8, 44.6), (76, "L1", 12968.0, 7.2),
    (76, "L2", 12385.0, 5.09), (76, "L3", 10870.9, 5.09), (76, "M1", 3048.5, 14.7),
    (76, "M2", 2792.2, 8.6), (76, "M3", 2457.2, 7.5), (76, "M4", 2030.8, 1.89),
    (76, "M5", 1960.1, 1.89), (76, "N1", 654.3, 7.7), (76, "N2", 546.5, 6.0),
    (76, "N3", 468.2, 4.6), (76, "N4", 289.4, 4.1), (76, "N5", 272.8, 3.9),
    (76, "N6", 53.8, 0.22), (76, "N7", 51.0, 0.18), (76, "O1", 83.7, 0),
    (76, "O2", 58.0, 0), (76, "O3", 45.4, 0), (77, "K", 76111.0, 47.0),
    (77, "L1", 13418.5, 7.9), (77, "L2", 12824.1, 5.23), (77, "L3", 11215.2, 5.24),
    (77, "M1", 3173.7, 14.8), (77, "M2", 2908.7, 8.9), (77, "M3", 2550.7, 8.0),
    (77, "M4", 2116.1, 1.99), (77, "M5", 2040.4, 1.99), (77, "N1", 690.1, 8.0),
    (77, "N2", 577.1, 6.1), (77, "N3", 494.3, 4.75), (77, "N4", 311.4, 4.1),
    (77, "N5", 294.9, 4.0), (77, "N6", 64.0, 0.31), (77, "N7", 61.0, 0.27),
    (77, "O1", 95.2, 0), (77, "O2", 63.0, 0), (77, "O3", 50.5, 0),
    (77, "O4", 3.8, 0), (77, "O5", 3.8, 0), (78, "K", 78394.8, 49.5),
    (78, "L1", 13880.5, 8.8), (78, "L2", 13272.6, 5.38), (78, "L3", 11563.8, 5.39),
    (78, "M1", 3297.6, 14.9), (78, "M2", 3027.0, 9.2), (78, "M3", 2645.3, 8.3),
    (78, "M4", 2201.5, 2.08), (78, "M5", 2121.1, 2.08), (78, "N1", 724.0, 8.25),
    (78, "N2", 607.6, 6.25), (78, "N3", 519.1, 4.9), (78, "N4", 330.7, 4.1),
    (78, "N5", 313.8, 3.95), (78, "N6", 74.5, 0.35), (78, "N7", 71.1, 0.31),
    (78, "O1", 101.7, 0), (78, "O2", 65.3, 0), (78, "O3", 51.0, 0),
    (78, "O4", 2.1, 0), (78, "O5", 2.1, 0), (79, "K", 80724.9, 52.1),
    (79, "L1", 14352.8, 9.8), (79, "L2", 13733.6, 5.53), (79, "L3", 11918.7, 5.54),
    (79, "M1", 3424.9, 15.0), (79, "M2", 3147.8, 9.5), (79, "M3", 2743.0, 8.5),
    (79, "M4", 2291.1, 2.18), (79, "M5", 2205.7, 2.18), (79, "N1", 758.8, 8.5),
    (79, "N2", 643.7, 6.4), (79, "N3", 545.4, 5.05), (79, "N4", 352.0, 4.1),
    (79, "N5", 333.9, 3.9), (79, "N6", 87.8, 0.37), (79, "N7", 84.1, 0.33),
    (79, "O1", 107.8, 0), (79, "O2", 71.7, 0), (79, "O3", 58.7, 0),
    (79, "O4", 2.5, 0), (79, "O5", 2.5, 0), (80, "K", 83102.3, 54.8),
    (80, "L1", 14839.3, 10.5), (80, "L2", 14208.7, 5.69), (80, "L3", 12283.9, 5.71),
    (80, "M1", 3561.6, 15.1), (80, "M2", 3278.5, 9.8), (80, "M3", 2847.1, 8.6),
    (80, "M4", 2384.9, 2.28), (80, "M5", 2294.9, 2.28), (80, "N1", 803.0, 8.8),
    (80, "N2", 681.0, 6.55), (80, "N3", 576.9, 5.3), (80, "N4", 378.5, 4.0),
    (80, "N5", 359.3, 3.85), (80, "N6", 104.0, 0.33), (80, "N7", 99.9, 0.31),
    (80, "O1", 120.3, 0), (80, "O2", 84.0, 0), (80, "O3", 65.0, 0),
    (80, "O4", 9.8, 0), (80, "O5", 7.8, 0), (81, "K", 85530.4, 57.6),
    (81, "L1", 15346.7, 11.1), (81, "L2", 14697.9, 5.87), (81, "L3", 12657.5, 5.89),
    (81, "M1", 3704.1, 15.1), (81, "M2", 3415.7, 10.1), (81, "M3", 2956.6, 8.7),
    (81, "M4", 2485.1, 2.38), (81, "M5", 2389.3, 2.38), (81, "N1", 845.5, 9.1),
    (81, "N2", 721.3, 6.7), (81, "N3", 609.0, 5.6), (81, "N4", 406.6, 3.9),
    (81, "N5", 386.2, 3.8), (81, "N6", 123.1, 0.29), (81, "N7", 118.8, 0.27),
    (81, "O1", 136.3, 0), (81, "O2", 99.6, 0), (81, "O3", 73.0, 0),
    (81, "O4", 15.3, 0), (81, "O5", 13.1, 0), (82, "K", 88004.5, 60.6),
    (82, "L1", 15860.8, 11.8), (82, "L2", 15200.0, 5.04), (82, "L3", 13035.2, 6.07),
    (82, "M1", 3850.7, 15.2), (82, "M2", 3554.2, 10.4), (82, "M3", 3066.4, 8.7),
    (82, "M4", 2585.6, 2.48), (82, "M5", 2484.0, 2.48), (82, "N1", 893.6, 9.35),
    (82, "N2", 763.9, 6.9), (82, "N3", 644.5, 5.8), (82, "N4", 435.2, 3.8),
    (82, "N5", 412.9, 3.8), (82, "N6", 141.2, 0.26), (82, "N7", 136.3, 0.23),
    (82, "O1", 147.3, 0), (82, "O2", 104.8, 0), (82, "O3", 83.0, 0),
    (82, "O4", 21.8, 0), (82, "O5", 19.2, 0), (82, "P1", 3.1, 0),
    (82, "P2", 0.7, 0), (82, "P3", 0.7, 0), (83, "K", 90525.9, 63.6),
    (83, "L1", 16387.5, 12.3), (83, "L2", 15711.1, 6.22), (83, "L3", 13418.6, 6.27),
    (83, "M1", 3999.1, 15.2), (83, "M2", 3696.3, 10.7), (83, "M3", 3176.9, 8.6),
    (83, "M4", 2687.6, 2.58), (83, "M5", 2579.6, 2.58), (83, "N1", 938.2, 9.6),
    (83, "N2", 805.3, 7.2), (83, "N3", 678.9, 5.95), (83, "N4", 463.6, 3.8),
    (83, "N5", 440.0, 3.8), (83, "N6", 162.4, 0.22), (83, "N7", 157.1, 0.2),
    (83, "O1", 159.3, 0), (83, "O2", 116.8, 0), (83, "O3", 93.0, 0),
    (83, "O4", 26.5, 0), (83, "O5", 24.4, 0), (83, "P1", 8.0, 0),
    (83, "P2", 2.7, 0), (83, "P3", 2.7, 0), (84, "K", 93100.0, 66.8),
    (84, "L1", 16928.0, 12.7), (84, "L2", 16237.0, 6.41), (84, "L3", 13810.0, 6.46),
    (84, "M1", 4152.0, 15.3), (84, "M2", 3844.0, 11.1), (84, "M3", 3293.0, 8.5),
    (84, "M4", 2794.0, 2.68), (84, "M5", 2680.0, 2.68), (84, "N1", 987.0, 9.9),
    (84, "N2", 851.0, 7.35), (84, "N3", 715.0, 6.2), (84, "N4", 495.0, 3.9),
    (84, "N5", 469.0, 3.8), (84, "N6", 184.0, 0.19), (84, "N7", 178.0, 0.18),
    (84, "O1", 176.0, 0), (84, "O2", 132.0, 0), (84, "O3", 102.0, 0),
    (84, "O4", 34.0, 0), (84, "O5", 30.0, 0), (84, "P1", 9.0, 0),
    (84, "P2", 4.0, 0), (84, "P3", 1.0, 0), (85, "K", 95724.0, 70.0),
    (85, "L1", 17482.0, 13.0), (85, "L2", 16776.0, 6.6), (85, "L3", 14207.0, 6.66),
    (85, "M1", 4310.0, 15.3), (85, "M2", 3994.0, 11.4), (85, "M3", 3409.0, 8.4),
    (85, "M4", 2901.0, 2.78), (85, "M5", 2781.0, 2.78), (85, "N1", 1038.0, 10.1),
    (85, "N2", 897.0, 7.6), (85, "N3", 751.0, 6.4), (85, "N4", 527.0, 3.9),
    (85, "N5", 499.0, 3.85), (85, "N6", 206.0, 0.17), (85, "N7", 199.0, 0.16),
    (85, "O1", 192.0, 0), (85, "O2", 144.0, 0), (85, "O3", 113.0, 0),
    (85, "O4", 41.0, 0), (85, "O5", 37.0, 0), (85, "P1", 13.0, 0),
    (85, "P2", 6.0, 0), (85, "P3", 1.0, 0), (86, "K", 98397.0, 73.4),
    (86, "L1", 18048.0, 13.2), (86, "L2", 17328.0, 6.81), (86, "L3", 14610.0, 6.87),
    (86, "M1", 4473.0, 15.3), (86, "M2", 4150.0, 11.7), (86, "M3", 3529.0, 8.3),
    (86, "M4", 3012.0, 2.88), (86, "M5", 2884.0, 2.88), (86, "N1", 1090.0, 10.4),
    (86, "N2", 944.0, 7.8), (86, "N3", 790.0, 6.6), (86, "N4", 558.0, 4.0),
    (86, "N5", 530.0, 3.9), (86, "N6", 229.0, 0.16), (86, "N7", 222.0, 0.16),
    (86, "O1", 208.0, 0), (86, "O2", 158.0, 0), (86, "O3", 123.0, 0),
    (86, "O4", 48.0, 0), (86, "O5", 43.0, 0), (86, "P1", 16.0, 0),
    (86, "P2", 8.0, 0), (86, "P3", 2.0, 0), (87, "K", 101130.0, 76.9),
    (87, "L1", 18634.0, 13.5), (87, "L2", 17899.0, 7.02), (87, "L3", 15025.0, 7.08),
    (87, "M1", 4644.0, 15.4), (87, "M2", 4315.0, 12.1), (87, "M3", 3656.0, 8.2),
    (87, "M4", 3129.0, 2.98), (87, "M5", 2994.0, 2.98), (87, "N1", 1148.0, 10.7),
    (87, "N2", 999.0, 8.1), (87, "N3", 834.0, 6.8), (87, "N4", 597.0, 4.1),
    (87, "N5", 567.0, 3.95), (87, "N6", 258.0, 0.15), (87, "N7", 249.0, 0.15),
    (87, "O1", 229.0, 0), (87, "O2", 178.0, 0), (87, "O3", 138.0, 0),
    (87, "O4", 60.0, 0), (87, "O5", 55.0, 0), (87, "P1", 24.0, 0),
    (87, "P2", 14.0, 0), (87, "P3", 7.0, 0), (87, "P4", 3.8, 0),
    (88, "K", 103915.0, 80.6), (88, "L1", 19232.0, 13.7), (88, "L2", 18484.0, 7.5),
    (88, "L3", 15444.0, 7.29), (88, "M1", 4822.0, 15.4), (88, "M2", 4483.0, 12.5),
    (88, "M3", 3785.0, 8.2), (88, "M4", 3248.0, 3.08), (88, "M5", 3105.0, 3.08),
    (88, "N1", 1208.0, 10.95), (88, "N2", 1055.0, 8.3), (88, "N3", 879.0, 7.0),
    (88, "N4", 636.0, 4.15), (88, "N5", 603.0, 4.0), (88, "N6", 287.0, 0.15),
    (88, "N7", 279.0, 0.16), (88, "O1", 251.0, 0), (88, "O2", 197.0, 0),
    (88, "O3", 153.0, 0), (88, "O4", 72.0, 0), (88, "O5", 66.0, 0),
    (88, "P1", 31.0, 0), (88, "P2", 20.0, 0), (88, "P3", 12.0, 0),
    (88, "P4", 4.7, 0), (89, "K", 106756.0, 84.4), (89, "L1", 19846.0, 14.0),
    (89, "L2", 19081.0, 8.0), (89, "L3", 15870.0, 7.51), (89, "M1", 4999.0, 15.4),
    (89, "M2", 4655.0, 12.9), (89, "M3", 3915.0, 8.0), (89, "M4", 3370.0, 3.18),
    (89, "M5", 3219.0, 3.18), (89, "N1", 1269.0, 11.2), (89, "N2", 1112.0, 8.5),
    (89, "N3", 924.0, 7.25), (89, "N4", 676.0, 4.2), (89, "N5", 640.0, 4.05),
    (89, "N6", 316.0, 0.15), (89, "N7", 307.0, 0.17), (89, "O1", 272.0, 0),
    (89, "O2", 217.0, 0), (89, "O3", 168.0, 0), (89, "O4", 84.0, 0),
    (89, "O5", 76.0, 0), (89, "P1", 37.0, 0), (89, "P2", 24.0, 0),
    (89, "P3", 15.0, 0), (89, "P4", 4.4, 0), (89, "P5", 5.4, 0),
    (90, "K", 109650.0, 88.2), (90, "L1", 20472.0, 14.3), (90, "L2", 19693.0, 8.5),
    (90, "L3", 16300.0, 7.74), (90, "M1", 5182.0, 15.5), (90, "M2", 4831.0, 13.2),
    (90, "M3", 4046.0, 8.0), (90, "M4", 3491.0, 3.28), (90, "M5", 3332.0, 3.28),
    (90, "N1", 1330.0, 11.5), (90, "N2", 1168.0, 8.75), (90, "N3", 967.0, 7.5),
    (90, "N4", 713.0, 4.3), (90, "N5", 677.0, 4.1), (90, "N6", 344.0, 0.15),
    (90, "N7", 335.0, 0.18), (90, "O1", 290.0, 0), (90, "O2", 236.0, 0),
    (90, "O3", 180.0, 0), (90, "O4", 94.0, 0), (90, "O5", 87.0, 0),
    (90, "P1", 41.0, 0), (90, "P2", 24.0, 0), (90, "P3", 17.0, 0),
    (90, "P4", 5.5, 0), (90, "P5", 5.9, 0), (91, "K", 112596.0, 92.1),
    (91, "L1", 21105.0, 14.7), (91, "L2", 20314.0, 9.1), (91, "L3", 16733.0, 7.97),
    (91, "M1", 5361.0, 15.5), (91, "M2", 5001.0, 13.6), (91, "M3", 4174.0, 7.9),
    (91, "M4", 3606.0, 3.39), (91, "M5", 3442.0, 3.39), (91, "N1", 1383.0, 11.6),
    (91, "N2", 1217.0, 9.2), (91, "N3", 1004.0, 7.75), (91, "N4", 743.0, 4.4),
    (91, "N5", 708.0, 4.2), (91, "N6", 366.0, 0.29), (91, "N7", 355.0, 0.25),
    (91, "O1", 305.0, 0), (91, "O2", 245.0, 0), (91, "O3", 188.0, 0),
    (91, "O4", 97.0, 0), (91, "O5", 90.0, 0), (91, "O6", 7.3, 0),
    (91, "P1", 43.0, 0), (91, "P2", 27.0, 0), (91, "P3", 17.0, 0),
    (91, "P4", 4.6, 0), (91, "P5", 5.6, 0), (92, "K", 115602.0, 96.3),
    (92, "L1", 21758.0, 16.0), (92, "L2", 20948.0, 10.0), (92, "L3", 17168.0, 8.2),
    (92, "M1", 5548.0, 15.5), (92, "M2", 5181.0, 14.1), (92, "M3", 4304.0, 7.9),
    (92, "M4", 3726.0, 3.50), (92, "M5", 3550.0, 3.50), (92, "N1", 1441.0, 12.2),
    (92, "N2", 1271.0, 9.6), (92, "N3", 1043.0, 8.0), (92, "N4", 779.0, 4.5),
    (92, "N5", 737.0, 4.25), (92, "N6", 389.0, 0.37), (92, "N7", 379.0, 0.31),
    (92, "O1", 324.0, 0), (92, "O2", 257.0, 0), (92, "O3", 194.0, 0),
    (92, "O4", 104.0, 0), (92, "O5", 95.0, 0), (92, "O6", 8.5, 0),
    (92, "P1", 44.0, 0), (92, "P2", 27.0, 0), (92, "P3", 17.0, 0),
    (92, "P4", 4.6, 0), (92, "P5", 5.7, 0), (93, "K", 118669.0, 0),
    (93, "L1", 22427.0, 0), (93, "L2", 21600.0, 0), (93, "L3", 17610.0, 0),
    (93, "M1", 5739.0, 0), (93, "M2", 5366.0, 0), (93, "M3", 4435.0, 0),
    (93, "M4", 3849.0, 0), (93, "M5", 3664.0, 0), (93, "N1", 1501.0, 0),
    (93, "N2", 1328.0, 0), (93, "N3", 1085.0, 0), (93, "N4", 816.0, 0),
    (93, "N5", 771.0, 0), (93, "N6", 414.0, 0), (93, "N7", 403.0, 0),
    (93, "O1", 338.0, 0), (93, "O2", 274.0, 0), (93, "O3", 206.0, 0),
    (93, "O4", 109.0, 0), (93, "O5", 101.0, 0), (93, "O6", 9.7, 0),
    (93, "P1", 47.0, 0), (93, "P2", 29.0, 0), (93, "P3", 18.0, 0),
    (93, "P4", 4.6, 0), (93, "P5", 5.8, 0), (94, "K", 121791.0, 0),
    (94, "L1", 23104.0, 0), (94, "L2", 22266.0, 0), (94, "L3", 18057.0, 0),
    (94, "M1", 5933.0, 0), (94, "M2", 5547.0, 0), (94, "M3", 4563.0, 0),
    (94, "M4", 3970.0, 0), (94, "M5", 3775.0, 0), (94, "N1", 1559.0, 0),
    (94, "N2", 1380.0, 0), (94, "N3", 1123.0, 0), (94, "N4", 846.0, 0),
    (94, "N5", 798.0, 0), (94, "N6", 436.0, 0), (94, "N7", 424.0, 0),
    (94, "O1", 350.0, 0), (94, "O2", 283.0, 0), (94, "O3", 213.0, 0),
    (94, "O4", 113.0, 0), (94, "O5", 102.0, 0), (94, "O6", 7.0, 0),
    (94, "P1", 46.0, 0), (94, "P2", 29.0, 0), (94, "P3", 16.0, 0),
    (94, "P4", 5.4, 0), (95, "K", 124982.0, 0), (95, "L1", 23808.0, 0),
    (95, "L2", 22952.0, 0), (95, "L3", 18510.0, 0), (95, "M1", 6133.0, 0),
    (95, "M2", 5739.0, 0), (95, "M3", 4698.0, 0), (95, "M4", 4096.0, 0),
    (95, "M5", 3890.0, 0), (95, "N1", 1620.0, 0), (95, "N2", 1438.0, 0),
    (95, "N3", 1165.0, 0), (95, "N4", 880.0, 0), (95, "N5", 829.0, 0),
    (95, "N6", 461.0, 0), (95, "N7", 446.0, 0), (95, "O1", 365.0, 0),
    (95, "O2", 298.0, 0), (95, "O3", 219.0, 0), (95, "O4", 116.0, 0),
    (95, "O5", 106.0, 0), (95, "O6", 7.9, 0), (95, "O7", 6.6, 0),
    (95, "P1", 48.0, 0), (95, "P2", 29.0, 0), (95, "P3", 16.0, 0),
    (95, "P4", 5.5, 0), (96, "K", 128241.0, 0), (96, "L1", 24526.0, 0),
    (96, "L2", 23651.0, 0), (96, "L3", 18970.0, 0), (96, "M1", 6337.0, 0),
    (96, "M2", 5937.0, 0), (96, "M3", 4838.0, 0), (96, "M4", 4224.0, 0),
    (96, "M5", 4009.0, 0), (96, "N1", 1684.0, 0), (96, "N2", 1498.0, 0),
    (96, "N3", 1207.0, 0), (96, "N4", 916.0, 0), (96, "N5", 862.0, 0),
    (96, "N6", 484.0, 0), (96, "N7", 470.0, 0), (96, "O1", 383.0, 0),
    (96, "O2", 313.0, 0), (96, "O3", 229.0, 0), (96, "O4", 124.0, 0),
    (96, "O5", 110.0, 0), (96, "O6", 12.9, 0), (96, "O7", 11.3, 0),
    (96, "P1", 50.0, 0), (96, "P2", 30.0, 0), (96, "P3", 16.0, 0),
    (96, "P4", 4.5, 0), (96, "P5", 6.1, 0), (97, "K", 131556.0, 0),
    (97, "L1", 25256.0, 0), (97, "L2", 24371.0, 0), (97, "L3", 19435.0, 0),
    (97, "M1", 6545.0, 0), (97, "M2", 6138.0, 0), (97, "M3", 4976.0, 0),
    (97, "M4", 4353.0, 0), (97, "M5", 4127.0, 0), (97, "N1", 1748.0, 0),
    (97, "N2", 1558.0, 0), (97, "N3", 1249.0, 0), (97, "N4", 955.0, 0),
    (97, "N5", 898.0, 0), (97, "N6", 511.0, 0), (97, "N7", 495.0, 0),
    (97, "O1", 399.0, 0), (97, "O2", 326.0, 0), (97, "O3", 237.0, 0),
    (97, "O4", 130.0, 0), (97, "O5", 117.0, 0), (97, "O6", 14.0, 0),
    (97, "O7", 12.2, 0), (97, "P1", 52.0, 0), (97, "P2", 32.0, 0),
    (97, "P3", 16.0, 0), (97, "P4", 4.4, 0), (97, "P5", 6.2, 0),
    (98, "K", 134939.0, 0), (98, "L1", 26010.0, 0), (98, "L2", 25108.0, 0),
    (98, "L3", 19907.0, 0), (98, "M1", 6761.0, 0), (98, "M2", 6345.0, 0),
    (98, "M3", 5116.0, 0), (98, "M4", 4484.0, 0), (98, "M5", 4247.0, 0),
    (98, "N1", 1813.0, 0), (98, "N2", 1620.0, 0), (98, "N3", 1292.0, 0),
    (98, "N4", 991.0, 0), (98, "N5", 930.0, 0), (98, "N6", 538.0, 0),
    (98, "N7", 520.0, 0), (98, "O1", 416.0, 0), (98, "O2", 341.0, 0),
    (98, "O3", 245.0, 0), (98, "O4", 137.0, 0), (98, "O5", 122.0, 0),
    (98, "O6", 10.5, 0), (98, "O7", 8.7, 0), (98, "P1", 54.0, 0),
    (98, "P2", 33.0, 0), (98, "P3", 17.0, 0), (98, "P4", 5.7, 0),
    (99, "K", 138396.0, 0), (99, "L1", 26782.0, 0), (99, "L2", 25865.0, 0),
    (99, "L3", 20384.0, 0), (99, "M1", 6981.0, 0), (99, "M2", 6558.0, 0),
    (99, "M3", 5259.0, 0), (99, "M4", 4617.0, 0), (99, "M5", 4368.0, 0),
    (99, "N1", 1883.0, 0), (99, "N2", 1683.0, 0), (99, "N3", 1336.0, 0),
    (99, "N4", 1029.0, 0), (99, "N5", 965.0, 0), (99, "N6", 564.0, 0),
    (99, "N7", 546.0, 0), (99, "O1", 434.0, 0), (99, "O2", 357.0, 0),
    (99, "O3", 255.0, 0), (99, "O4", 142.0, 0), (99, "O5", 127.0, 0),
    (99, "O6", 11.3, 0), (99, "O7", 9.4, 0), (99, "P1", 57.0, 0),
    (99, "P2", 35.0, 0), (99, "P3", 17.0, 0), (99, "P4", 5.8, 0),
    (100, "K", 141926.0, 0), (100, "L1", 27574.0, 0), (100, "L2", 26641.0, 0),
    (100, "L3", 20868.0, 0), (100, "M1", 7208.0, 0), (100, "M2", 6776.0, 0),
    (100, "M3", 5405.0, 0), (100, "M4", 4752.0, 0), (100, "M5", 4491.0, 0),
    (100, "N1", 1952.0, 0), (100, "N2", 1749.0, 0), (100, "N3", 1379.0, 0),
    (100, "N4", 1067.0, 0), (100, "N5", 1000.0, 0), (100, "N6", 591.0, 0),
    (100, "N7", 572.0, 0), (100, "O1", 452.0, 0), (100, "O2", 373.0, 0),
    (100, "O3", 262.0, 0), (100, "O4", 149.0, 0), (100, "O5", 133.0, 0),
    (100, "O6", 17.0, 0), (100, "O7", 14.7, 0), (100, "P1", 59.0, 0),
    (100, "P2", 36.0, 0), (100, "P3", 17.0, 0), (100, "P4", 4.2, 0),
    (100, "P5", 6.5, 0), (101, "K", 146526.0, 0), (101, "L1", 28387.0, 0),
    (101, "L2", 27438.0, 0), (101, "L3", 21356.0, 0), (101, "M1", 7440.0, 0),
    (101, "M2", 7001.0, 0), (101, "M3", 5552.0, 0), (101, "M4", 4889.0, 0),
    (101, "M5", 4615.0, 0), (101, "N1", 2024.0, 0), (101, "N2", 1816.0, 0),
    (101, "N3", 1424.0, 0), (101, "N4", 1105.0, 0), (101, "N5", 1034.0, 0),
    (101, "N6", 618.0, 0), (101, "N7", 597.0, 0), (101, "O1", 471.0, 0),
    (101, "O2", 389.0, 0), (101, "O3", 272.0, 0), (101, "O4", 154.0, 0),
    (101, "O5", 137.0, 0), (101, "O6", 12.9, 0), (101, "O7", 10.5, 0),
    (101, "P1", 61.0, 0), (101, "P2", 37.0, 0), (101, "P3", 17.0, 0),
    (101, "P4", 5.9, 0), (102, "K", 149208.0, 0), (102, "L1", 29221.0, 0),
    (102, "L2", 28255.0, 0), (102, "L3", 21851.0, 0), (102, "M1", 7678.0, 0),
    (102, "M2", 7231.0, 0), (102, "M3", 5702.0, 0), (102, "M4", 5028.0, 0),
    (102, "M5", 4741.0, 0), (102, "N1", 2097.0, 0), (102, "N2", 1885.0, 0),
    (102, "N3", 1469.0, 0), (102, "N4", 1145.0, 0), (102, "N5", 1070.0, 0),
    (102, "N6", 645.0, 0), (102, "N7", 624.0, 0), (102, "O1", 490.0, 0),
    (102, "O2", 406.0, 0), (102, "O3", 280.0, 0), (102, "O4", 161.0, 0),
    (102, "O5", 142.0, 0), (102, "O6", 13.6, 0), (102, "O7", 11.1, 0),
    (102, "P1", 63.0, 0), (102, "P2", 38.0, 0), (102, "P3", 18.0, 0),
    (102, "P4", 6.0, 0), (103, "K", 152970.0, 0), (103, "L1", 30083.0, 0),
    (103, "L2", 29103.0, 0), (103, "L3", 22359.0, 0), (103, "M1", 7930.0, 0),
    (103, "M2", 7474.0, 0), (103, "M3", 5860.0, 0), (103, "M4", 5176.0, 0),
    (103, "M5", 4876.0, 0), (103, "N1", 2180.0, 0), (103, "N2", 1963.0, 0),
    (103, "N3", 1523.0, 0), (103, "N4", 1192.0, 0), (103, "N5", 1112.0, 0),
    (103, "N6", 680.0, 0), (103, "N7", 658.0, 0), (103, "O1", 516.0, 0),
    (103, "O2", 429.0, 0), (103, "O3", 296.0, 0), (103, "O4", 174.0, 0),
    (103, "O5", 154.0, 0), (103, "O6", 19.9, 0), (103, "O7", 17.0, 0),
    (103, "P1", 71.0, 0), (103, "P2", 44.0, 0), (103, "P3", 21.0, 0),
    (103, "P4", 3.9, 0), (103, "P5", 6.9, 0), ]



def get_edge_energy(z, edge):
    return [d[2] for d in AtomicData if d[0] == z and d[1] == edge][0]

def get_atomic_level_width(z, edge):
    return [d[3] for d in AtomicData if d[0] == z and d[1] == edge][0]

if __name__ == '__main__':
    def dummy_handler(widget):
        print widget.get_element_name(), widget.get_element_number()

    wmain = gtk.Window(gtk.WINDOW_TOPLEVEL)
    p = PeriodicButton()
    p.connect('select-element', dummy_handler)
    wmain.add(p)
    wmain.show_all()
    gtk.main()
