#   Licensed under the Apache License, Version 2.0 (the "License"); you may
#   not use this file except in compliance with the License. You may obtain
#   a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#   WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#   License for the specific language governing permissions and limitations
#   under the License.
#
"""Satori Discovery Errors."""


class SatoriException(Exception):

    """Parent class for Satori exceptions.

    Accepts a string error message that that accept a str description.

    """

    def __init__(self, message):
        """Store error message."""
        self.message = message
        super(SatoriException, self).__init__()

    def __str__(self):
        """Display error message."""
        return repr(self.message)


class SatoriInvalidNetloc(SatoriException):
    """Netloc that cannot be parsed by `urlparse`."""
