#! /usr/bin/env python
from setuptools import setup
from setuptools.command.test import test as TestCommand
import sys

def verno(s):
    """
    Update the version number passed in by extending it to the 
    thousands place and adding 1/1000, then returning that result
    and as a side-effect updating setup.py

    Dangerous, self-modifying, and also, helps keep version numbers
    ascending without human intervention.
    """
    
    from decimal import Decimal
    import re
    d = Decimal(s)
    increment = Decimal('0.001')
    d = d.quantize(increment) + increment
    dstr = str(d)
    setup = open('setup.py', 'r').read()
    setup = re.sub('verno\(\w*[\'"]([\d\.]+)[\'"]', 'verno("' + dstr + '"', setup)
    open('setup.py', 'w').write(setup)
    return dstr

def linelist(text):
    """
    Returns each non-blank line in text enclosed in a list.
    """
    return [ l.strip() for l in text.strip().splitlines() if l.split() ]
    
    # The double-mention of l.strip() is yet another fine example of why
    # Python needs en passant aliasing.

class Tox(TestCommand):
    def finalize_options(self):
        TestCommand.finalize_options(self)
        self.test_args = []
        self.test_suite = True
    def run_tests(self):
        #import here, cause outside the eggs aren't loaded
        import tox
        errno = tox.cmdline(self.test_args)
        sys.exit(errno)

setup(
    name='say',
    version=verno("0.407"),
    author='Jonathan Eunice',
    author_email='jonathan.eunice@gmail.com',
    description='Simple printing with templates. E.g.: say("Hello, {whoever}!", indent=1)',
    long_description=open('README.rst').read(),
    url='https://bitbucket.org/jeunice/say',
    py_modules=['say'],
    install_requires=['six','options','otherstuf'],
    tests_require = ['tox', 'pytest'],
    cmdclass = {'test': Tox},
    zip_safe = True,
    keywords='print format template say',
    classifiers=linelist("""
        Development Status :: 3 - Alpha
        Operating System :: OS Independent
        License :: OSI Approved :: BSD License
        Intended Audience :: Developers
        Programming Language :: Python
        Programming Language :: Python :: 2.6
        Programming Language :: Python :: 2.7
        Programming Language :: Python :: 3.2
        Programming Language :: Python :: 3.3
        Topic :: Software Development :: Libraries :: Python Modules
    """)
)
