
import pytest
from say import Show

show = Show(where=False, retvalue=True)

def nospaces(s):
    return s.replace(' ', '')
    
def test_basic(param = 'Yo'):

    a = 1
    b = 3.141
    c = "something else!"
    
    assert show(a) == 'a: 1'
    assert show(a, b) == 'a: 1  b: 3.141'
    assert show(a, b, c) == "a: 1  b: 3.141  c: 'something else!'"
    
    assert show(1 + 1) == '1 + 1: 2'
    assert nospaces(show(1+1)) == nospaces('1 + 1: 2')
        # may have extra spaces in it, based on codegen.to_source() output
        
    assert show(len(c), c) == \
                "len(c): 15  c: 'something else!'"
    
            # anything with paraens in it must be on separate line, given weak parser
            # of show parameters
            
def test_literals():
    assert show(1 + 1) == '1 + 1: 2'
    assert show(1+1) == '1 + 1: 2'
    
    # assert nospaces(show(1+1)) == nospaces('1 + 1: 2')
    
    # NB output may have more or fewer spaces than actual parameter, based on codegen.to_source() 
    # creating its 'idealized' code output

def test_say_params():
    a = 1
    b = 3.141
    c = "something else!"
    
    assert show(a, indent='+1') == '    a: 1'
    assert show(a, b, sep='\n') == 'a: 1\nb: 3.141'

def test_strings():
    assert show('this') == "this"
    x = 44
    assert show("x = {x}") == 'x = 44'
    
def test_show_example():
    
    x = 12
    nums = list(range(4))

    assert show(x) == 'x: 12'
    assert show(nums) == 'nums: [0, 1, 2, 3]'
    assert show(x, nums, len(nums)) == \
        'x: 12  nums: [0, 1, 2, 3]  len(nums): 4'
    assert show(x, nums, len(nums), indent='+1') == \
        '    x: 12  nums: [0, 1, 2, 3]  len(nums): 4'
    assert show(x, nums, len(nums), sep='\n') == \
        'x: 12\nnums: [0, 1, 2, 3]\nlen(nums): 4'
    assert show(x, nums, len(nums), sep='\n', indent=1) == \
        '    x: 12\n    nums: [0, 1, 2, 3]\n    len(nums): 4'

# @pytest.mark.skipif('True')  # under construction
def test_show_items():
    nums = list(range(4))
    assert show.items(nums) == \
        'nums (4 items): [0, 1, 2, 3]'
    
    astring = 'this'
    assert show.items(astring) == \
        "astring (4 chars): 'this'"
    
    #d = {'a': 1, 'b': 2}
    #assert show.items(d) == \
    #   "d (2 items): {'a': 1, 'b': 2}"