# -*- coding:utf-8 -*-

from setuptools import setup, find_packages
import os

version = open(os.path.join("sc", "contentrules", "localrole", "version.txt")).read().strip()

setup(name='sc.contentrules.localrole',
      version=version,
      description="Plone content rule to apply a local role to a content",
      long_description=open(os.path.join("sc", "contentrules", "localrole", "README.txt")).read() + "\n" +
                       open(os.path.join("docs", "HISTORY.txt")).read(),
      # Get more strings from http://www.python.org/pypi?%3Aaction=list_classifiers
      classifiers=[
        "Framework :: Plone",
        "Framework :: Zope2",
        "Framework :: Zope3",
        "Programming Language :: Python",
        "Topic :: Software Development :: Libraries :: Python Modules",
        ],
      keywords='contentrules action plone localrole',
      author='Simples Consultoria',
      author_email='products@simplesconsultoria.com.br',
      url='http://www.simplesconsultoria.com.br',
      license='GPL',
      packages=find_packages(exclude=['ez_setup']),
      namespace_packages=['sc', 'sc.contentrules'],
      include_package_data=True,
      zip_safe=False,
      install_requires=[
        'setuptools',
        'plone.stringinterp',
        ],
      extras_require={
        'test': ['plone.app.testing'],
        },
      entry_points="""
      [z3c.autoinclude.plugin]
      target = plone
      """,
      )
