#!/usr/bin/env python

from setuptools import setup, Extension
import scalpel
import os

doclines = scalpel.__doc__.split("\n")
classifiers = """\
Development Status :: 3 - Alpha
Environment :: X11 Applications :: GTK
Intended Audience :: End Users/Desktop
License :: OSI Approved :: BSD License
Natural Language :: English
Operating System :: POSIX :: Linux
Programming Language :: Python
Topic :: Multimedia :: Sound/Audio :: Editors
"""

c_files = ['scalpel/fast/fast.c', 'scalpel/fx/_svf.c']

for path in c_files:
    if not os.path.exists(path):
        import Cython.Compiler.Main
        Cython.Compiler.Main.compile(path[:-2] + '.pyx')


setup(name = 'scalpel',
      version = scalpel.__version__,
      description = doclines[0],
      author = 'Pierre',
      author_email = 'stackp@online.fr',
      url = 'http://scalpelsound.online.fr',
      license = "BSD License",
      long_description = "\n".join(doclines[2:]),
      classifiers = filter(None, classifiers.split("\n")),
      packages = ['scalpel', 'scalpel.fx'],
      ext_modules = [Extension('scalpel.fast', ['scalpel/fast/fast.c'],
                               libraries=['cairo']),
                     Extension('scalpel.fx._svf', ['scalpel/fx/_svf.c'])],
      scripts = ['scripts/scalpel'],
      requires = ['PyGTK', 'numpy', 'pyalsaaudio (>=0.6)'],
      install_requires = ['pyalsaaudio>=0.6']
      )
