properties = '''
CREATE TABLE IF NOT EXISTS properties (
  -- Property Information
  property_number TEXT,
  curr_owner TEXT,
  wetlands TEXT,
  address TEXT,
  school_district TEXT,
  property_class TEXT,
  site_no TEXT,
  nbhd_cd TEXT,
  acreage FLOAT,
  zoning TEXT,

  -- Assessment Information
    -- Assessed Value
    assessed_land_2014 INTEGER,
    assessed_land_2013_fmv INTEGER,
    assessed_land_2013 INTEGER,
    assessed_total_2014 INTEGER,
    assessed_total_2013_fmv INTEGER,
    assessed_total_2013 INTEGER,

    -- Taxable Value
    taxable_village INTEGER,
    taxable_school INTEGER,
    taxable_county INTEGER,

    -- Special Districts
    taxable_bronx_sewer INTEGER,
    taxable_mamaroneck_sewer INTEGER,
    taxable_hutchinson_sewer INTEGER,
    taxable_county_solid_waste INTEGER,

    -- Excemptions are in a separate table for now.

  -- Building information
  year_built TEXT,
  bldg_style TEXT,
  bathrooms TEXT,
  bedrooms TEXT,
  fireplaces TEXT,
  central_air TEXT,
  living_area TEXT,
  no_stories TEXT,
  half_bathrooms TEXT,
  bath_qual TEXT,
  overall_cond TEXT,
  bsmt_type TEXT,

  -- Structure information
  ap1 BOOLEAN DEFAULT 0,
  ap3 BOOLEAN DEFAULT 0,
  ap4 BOOLEAN DEFAULT 0,
  ap6 BOOLEAN DEFAULT 0,
  ap7 BOOLEAN DEFAULT 0,
  be1 BOOLEAN DEFAULT 0,
  be2 BOOLEAN DEFAULT 0,
  be4 BOOLEAN DEFAULT 0,
  be5 BOOLEAN DEFAULT 0,
  be6 BOOLEAN DEFAULT 0,
  bf1 BOOLEAN DEFAULT 0,
  cc1 BOOLEAN DEFAULT 0,
  cp5 BOOLEAN DEFAULT 0,
  cp6 BOOLEAN DEFAULT 0,
  cp7 BOOLEAN DEFAULT 0,
  el2 BOOLEAN DEFAULT 0,
  fb1 BOOLEAN DEFAULT 0,
  fb4 BOOLEAN DEFAULT 0,
  fb5 BOOLEAN DEFAULT 0,
  fb6 BOOLEAN DEFAULT 0,
  fb8 BOOLEAN DEFAULT 0,
  fc1 BOOLEAN DEFAULT 0,
  fc3 BOOLEAN DEFAULT 0,
  fc4 BOOLEAN DEFAULT 0,
  fc5 BOOLEAN DEFAULT 0,
  fc6 BOOLEAN DEFAULT 0,
  ft1 BOOLEAN DEFAULT 0,
  ft2 BOOLEAN DEFAULT 0,
  gb1 BOOLEAN DEFAULT 0,
  gc2 BOOLEAN DEFAULT 0,
  gc3 BOOLEAN DEFAULT 0,
  gh2 BOOLEAN DEFAULT 0,
  gh3 BOOLEAN DEFAULT 0,
  gh5 BOOLEAN DEFAULT 0,
  gn2 BOOLEAN DEFAULT 0,
  ld1 BOOLEAN DEFAULT 0,
  ld2 BOOLEAN DEFAULT 0,
  lp1 BOOLEAN DEFAULT 0,
  lp3 BOOLEAN DEFAULT 0,
  lp4 BOOLEAN DEFAULT 0,
  lp5 BOOLEAN DEFAULT 0,
  lp6 BOOLEAN DEFAULT 0,
  lp7 BOOLEAN DEFAULT 0,
  lp8 BOOLEAN DEFAULT 0,
  lp9 BOOLEAN DEFAULT 0,
  lr1 BOOLEAN DEFAULT 0,
  lr2 BOOLEAN DEFAULT 0,
  lr3 BOOLEAN DEFAULT 0,
  ls1 BOOLEAN DEFAULT 0,
  ls2 BOOLEAN DEFAULT 0,
  ls3 BOOLEAN DEFAULT 0,
  ls4 BOOLEAN DEFAULT 0,
  ls5 BOOLEAN DEFAULT 0,
  ls7 BOOLEAN DEFAULT 0,
  ls8 BOOLEAN DEFAULT 0,
  lt4 BOOLEAN DEFAULT 0,
  lt5 BOOLEAN DEFAULT 0,
  mh5 BOOLEAN DEFAULT 0,
  ms1 BOOLEAN DEFAULT 0,
  oh1 BOOLEAN DEFAULT 0,
  oh3 BOOLEAN DEFAULT 0,
  rc1 BOOLEAN DEFAULT 0,
  rg1 BOOLEAN DEFAULT 0,
  rg2 BOOLEAN DEFAULT 0,
  rg3 BOOLEAN DEFAULT 0,
  rg4 BOOLEAN DEFAULT 0,
  rg5 BOOLEAN DEFAULT 0,
  rg6 BOOLEAN DEFAULT 0,
  rg7 BOOLEAN DEFAULT 0,
  rn2 BOOLEAN DEFAULT 0,
  rp1 BOOLEAN DEFAULT 0,
  rp2 BOOLEAN DEFAULT 0,
  rp3 BOOLEAN DEFAULT 0,
  rp4 BOOLEAN DEFAULT 0,
  rp5 BOOLEAN DEFAULT 0,
  rp6 BOOLEAN DEFAULT 0,
  rp7 BOOLEAN DEFAULT 0,
  rp8 BOOLEAN DEFAULT 0,
  tc1 BOOLEAN DEFAULT 0,
  tc2 BOOLEAN DEFAULT 0,
  tc5 BOOLEAN DEFAULT 0,
  tc6 BOOLEAN DEFAULT 0,
  tc9 BOOLEAN DEFAULT 0,
  tk1 BOOLEAN DEFAULT 0,
  tk4 BOOLEAN DEFAULT 0,
  tk6 BOOLEAN DEFAULT 0,

  -- Tax information is in a separate table.
  -- Permits is in a separate table.
 
  UNIQUE(property_number)
);
'''
