
"""
this file contains data from running various examples that the tests compare the current package with
"""
import numpy
# define data taken from running the examples from the BVP_SOLVER website

# for test_example 5
# this is the solution of the swave example taken at 100 equaly spaced points

xEval =numpy.array([0.00000000000000      ,
  1.010101010101010E-002 ,
  2.020202020202020E-002 ,
  3.030303030303030E-002 ,
  4.040404040404041E-002 ,
  5.050505050505050E-002 ,
  6.060606060606061E-002 ,
  7.070707070707070E-002 ,
  8.080808080808081E-002 ,
  9.090909090909091E-002 ,
  0.101010101010101      ,
  0.111111111111111      ,
  0.121212121212121      ,
  0.131313131313131      ,
  0.141414141414141      ,
  0.151515151515152      ,
  0.161616161616162      ,
  0.171717171717172      ,
  0.181818181818182      ,
  0.191919191919192      ,
  0.202020202020202      ,
  0.212121212121212      ,
  0.222222222222222      ,
  0.232323232323232      ,
  0.242424242424242      ,
  0.252525252525253      ,
  0.262626262626263      ,
  0.272727272727273      ,
  0.282828282828283      ,
  0.292929292929293      ,
  0.303030303030303      ,
  0.313131313131313      ,
  0.323232323232323      ,
  0.333333333333333      ,
  0.343434343434343      ,
  0.353535353535354      ,
  0.363636363636364      ,
  0.373737373737374      ,
  0.383838383838384      ,
  0.393939393939394      ,
  0.404040404040404      ,
  0.414141414141414      ,
  0.424242424242424      ,
  0.434343434343434      ,
  0.444444444444444      ,
  0.454545454545455      ,
  0.464646464646465      ,
  0.474747474747475      ,
  0.484848484848485      ,
  0.494949494949495      ,
  0.505050505050505      ,
  0.515151515151515      ,
  0.525252525252525      ,
  0.535353535353535      ,
  0.545454545454545      ,
  0.555555555555556      ,
  0.565656565656566      ,
  0.575757575757576      ,
  0.585858585858586      ,
  0.595959595959596      ,
  0.606060606060606      ,
  0.616161616161616      ,
  0.626262626262626      ,
  0.636363636363636      ,
  0.646464646464647      ,
  0.656565656565657      ,
  0.666666666666667      ,
  0.676767676767677      ,
  0.686868686868687      ,
  0.696969696969697      ,
  0.707070707070707      ,
  0.717171717171717      ,
  0.727272727272727      ,
  0.737373737373737      ,
  0.747474747474748      ,
  0.757575757575758      ,
  0.767676767676768      ,
  0.777777777777778      ,
  0.787878787878788      ,
  0.797979797979798      ,
  0.808080808080808      ,
  0.818181818181818      ,
  0.828282828282828      ,
  0.838383838383838      ,
  0.848484848484849      ,
  0.858585858585859      ,
  0.868686868686869      ,
  0.878787878787879      ,
  0.888888888888889      ,
  0.898989898989899      ,
  0.909090909090909      ,
  0.919191919191919      ,
  0.929292929292929      ,
  0.939393939393939      ,
  0.949494949494950      ,
  0.959595959595960      ,
  0.969696969696970      ,
  0.979797979797980      ,
  0.989898989898990      ,
   1.00000000000000     ])

yEval = numpy.transpose(numpy.array([[  0.912900000000000      ,  0.835222672326810      ],
 [  0.921336759156283      ,  0.835238765010523      ],
 [  0.929773126608655      ,  0.835141242695641      ],
 [  0.938207849609067      ,  0.834910403850400      ],
 [  0.946639506674046      ,  0.834532223412058      ],
 [  0.955066556334510      ,  0.833996757735038      ],
 [  0.963487372534205      ,  0.833297048245840      ],
 [  0.971900270787854      ,  0.832428360733722      ],
 [  0.980303527593840      ,  0.831387646459979      ],
 [  0.988695395456203      ,  0.830173160084122      ],
 [  0.997074114786240      ,  0.828784182827147      ],
 [   1.00543792290902      ,  0.827220815743977      ],
 [   1.01378506165558      ,  0.825483830362058      ],
 [   1.02211378367126      ,  0.823574555594415      ],
 [   1.03042235726956      ,  0.821494784373455      ],
 [   1.03870907109815      ,  0.819246712046553      ],
 [   1.04697223766126      ,  0.816832874856782      ],
 [   1.05521019664574      ,  0.814256109147319      ],
 [   1.06342131779550      ,  0.811519515067759      ],
 [   1.07160400325452      ,  0.808626420089313      ],
 [   1.07975668996020      ,  0.805580360120215      ],
 [   1.08787785134750      ,  0.802385044396443      ],
 [   1.09596599926800      ,  0.799044345164542      ],
 [   1.10401968526082      ,  0.795562263932379      ],
 [   1.11203750199510      ,  0.791942922730354      ],
 [   1.12001808416200      ,  0.788190530315268      ],
 [   1.12796010942572      ,  0.784309368853362      ],
 [   1.13586229883848      ,  0.780303753387386      ],
 [   1.14372341717153      ,  0.776178006484971      ],
 [   1.15154227265873      ,  0.771936394249616      ],
 [   1.15931771578669      ,  0.767583051403633      ],
 [   1.16704863820479      ,  0.763121879383724      ],
 [   1.17473396830911      ,  0.758556327597007      ],
 [   1.18237266658995      ,  0.753889141236240      ],
 [   1.18996371535583      ,  0.749121854155489      ],
 [   1.19750610342509      ,  0.744254031592558      ],
 [   1.20499880017726      ,  0.739281994759061      ],
 [   1.21244071308571      ,  0.734196729120913      ],
 [   1.21983061787492      ,  0.728980435407584      ],
 [   1.22716704346299      ,  0.723600830016685      ],
 [   1.23444808178115      ,  0.718001697023489      ],
 [   1.24167107389126      ,  0.712087255115875      ],
 [   1.24883209018951      ,  0.705696219167966      ],
 [   1.25592506984585      ,  0.698558798419288      ],
 [   1.26294039489110      ,  0.690225392586569      ],
 [   1.26986252713099      ,  0.679948422076163      ],
 [   1.27666609277073      ,  0.666486698466251      ],
 [   1.28330939958093      ,  0.647782147725598      ],
 [   1.28972371745014      ,  0.620427151599249      ],
 [   1.29579559496376      ,  0.578790988145813      ],
 [   1.30133779720160      ,  0.513597803034303      ],
 [   1.30604183230894      ,  0.409639597786969      ],
 [   1.30940116155539      ,  0.242171522268146      ],
 [   1.31058898648206      , -2.857386154257512E-002 ],
 [   1.30826903494836      , -0.465205308366202      ],
 [   1.30031674133234      ,  -1.16285304893268      ],
 [   1.28344656739026      ,  -2.25692971260967      ],
 [   1.25281937473031      ,  -3.91577675409319      ],
 [   1.20193627180952      ,  -6.28244813442686      ],
 [   1.12367916831977      ,  -9.28940697439057      ],
 [   1.01427342103735      ,  -12.2577341288211      ],
 [  0.881808481340061      ,  -13.4986106391639      ],
 [  0.753661212854785      ,  -11.2651487332738      ],
 [  0.662204213854799      ,  -6.76299202438183      ],
 [  0.613203070600663      ,  -3.27601325341295      ],
 [  0.589555580592845      ,  -1.65669591641740      ],
 [  0.576300635004965      ,  -1.07176516126314      ],
 [  0.566635678807456      , -0.876637762811722      ],
 [  0.558187470835481      , -0.806658457311449      ],
 [  0.550219731975956      , -0.774037507801978      ],
 [  0.542515128724247      , -0.752409113199021      ],
 [  0.535008133628661      , -0.734320231446904      ],
 [  0.527675455089474      , -0.717732870084999      ],
 [  0.520505383978507      , -0.702075191756569      ],
 [  0.513489638058840      , -0.687156714512165      ],
 [  0.506621251135054      , -0.672886237238074      ],
 [  0.499894005343858      , -0.659201625392884      ],
 [  0.493302244361388      , -0.646052515630750      ],
 [  0.486840782624483      , -0.633395652120549      ],
 [  0.480504843193453      , -0.621193186415257      ],
 [  0.474290008208822      , -0.609411741944849      ],
 [  0.468192177304500      , -0.598021732996464      ],
 [  0.462207532159502      , -0.586996817298998      ],
 [  0.456332506069301      , -0.576313448052642      ],
 [  0.450563757664624      , -0.565950498489898      ],
 [  0.444898148107973      , -0.555888945986833      ],
 [  0.439332721225738      , -0.546111604892700      ],
 [  0.433864686130244      , -0.536602899408531      ],
 [  0.428491401963625      , -0.527348669595038      ],
 [  0.423210364457863      , -0.518336004941757      ],
 [  0.418019194056045      , -0.509553100992354      ],
 [  0.412915625381085      , -0.500989135353150      ],
 [  0.407897497871843      , -0.492634160078081      ],
 [  0.402962747434280      , -0.484479007950620      ],
 [  0.398109398978022      , -0.476515210606327      ],
 [  0.393335559727705      , -0.468734926790693      ],
 [  0.388639413214143      , -0.461130879321163      ],
 [  0.384019213863586      , -0.453696299552678      ],
 [  0.379473282114414      , -0.446424878334191      ],
 [  0.375000000000000      , -0.439310722598872      ]]))

xSol = numpy.array([   0.00000000000000      ,
  1.100335634208356E-002 ,
  2.262291472487897E-002 ,
  3.495119398145768E-002 ,
  4.805755823393220E-002 ,
  6.197909464422609E-002 ,
  7.671080713114965E-002 ,
  9.220261475050895E-002 ,
  0.108369249925636      ,
  0.125104043712312      ,
  0.142306989404985      ,
  0.159903997204620      ,
  0.177854206736695      ,
  0.196150410768008      ,
  0.214822942828523      ,
  0.233960632268771      ,
  0.253796953401810      ,
  0.275452202078203      ,
  0.299391410069007      ,
  0.319714420307507      ,
  0.334597371620216      ,
  0.346910375309560      ,
  0.357449819464559      ,
  0.366754959824991      ,
  0.375093300525790      ,
  0.382655901268460      ,
  0.389576861403941      ,
  0.395955448926753      ,
  0.401877270026111      ,
  0.407404337643207      ,
  0.412585051531817      ,
  0.417466133243039      ,
  0.422074193881779      ,
  0.426453376432033      ,
  0.430627626123301      ,
  0.434614193753623      ,
  0.438420600940903      ,
  0.442082560687107      ,
  0.445607340655907      ,
  0.449011983131700      ,
  0.452311139320941      ,
  0.455515870470028      ,
  0.458632047362489      ,
  0.461664396878025      ,
  0.464623732176986      ,
  0.467520380114340      ,
  0.470360153091872      ,
  0.473143141389397      ,
  0.475873143570174      ,
  0.478561569381885      ,
  0.481213628579060      ,
  0.483832756914831      ,
  0.486421266720274      ,
  0.488981092048285      ,
  0.491515590453622      ,
  0.494029608472061      ,
  0.496525555978692      ,
  0.499005470626103      ,
  0.501468236778135      ,
  0.503918766837039      ,
  0.506359549970908      ,
  0.508792444217381      ,
  0.511219031332462      ,
  0.513640591390724      ,
  0.516058638266307      ,
  0.518474967576014      ,
  0.520891133633835      ,
  0.523308718537007      ,
  0.525729605649677      ,
  0.528156713702640      ,
  0.530591363730371      ,
  0.533032560400763      ,
  0.535480636857452      ,
  0.537936503053969      ,
  0.540402342351316      ,
  0.542880587975196      ,
  0.545373013042307      ,
  0.547881591539264      ,
  0.550408904089385      ,
  0.552960273209118      ,
  0.555541434720794      ,
  0.558156807120028      ,
  0.560812304132705      ,
  0.563514724384702      ,
  0.566272287984965      ,
  0.569096500307244      ,
  0.571994149281918      ,
  0.574893678160154      ,
  0.577562244870104      ,
  0.580066228187644      ,
  0.582438862833867      ,
  0.584717072075112      ,
  0.586914897524289      ,
  0.589049691649958      ,
  0.591136607152804      ,
  0.593187291078691      ,
  0.595211939587733      ,
  0.597219797736443      ,
  0.599220002459082      ,
  0.601236021798608      ,
  0.603181593797502      ,
  0.604931336071510      ,
  0.606512813358445      ,
  0.607951094241229      ,
  0.609267937514103      ,
  0.610472420241250      ,
  0.611556727584061      ,
  0.612543342640713      ,
  0.613414872650132      ,
  0.614156379530366      ,
  0.614765831009619      ,
  0.615243076373487      ,
  0.615818607869942      ,
  0.616547023677556      ,
  0.617360650343388      ,
  0.618253947378103      ,
  0.619211393894224      ,
  0.620224440502167      ,
  0.621298714807991      ,
  0.622452272840511      ,
  0.623685124124056      ,
  0.625002078490156      ,
  0.626436144052277      ,
  0.627962542809264      ,
  0.629360167124464      ,
  0.630625400154492      ,
  0.631820543490555      ,
  0.632981689104104      ,
  0.634120496176820      ,
  0.635247502440498      ,
  0.636371262622583      ,
  0.637499215030948      ,
  0.638639565864191      ,
  0.639802774213952      ,
  0.641000967642479      ,
  0.642238499709654      ,
  0.643512154360899      ,
  0.644834125748701      ,
  0.646240186939281      ,
  0.647781474396376      ,
  0.649429203805697      ,
  0.650916838284012      ,
  0.652264011474522      ,
  0.653517855822376      ,
  0.654721038437623      ,
  0.655886697120193      ,
  0.657023348131643      ,
  0.658135962106530      ,
  0.659228698456853      ,
  0.660305630618430      ,
  0.661369052810569      ,
  0.662420370182231      ,
  0.663460477183997      ,
  0.664492256232244      ,
  0.665516794800557      ,
  0.666534094696304      ,
  0.667545268990834      ,
  0.668551585355737      ,
  0.669553908620455      ,
  0.670553252806239      ,
  0.671550578482224      ,
  0.672546454979785      ,
  0.673541826027341      ,
  0.674537515945202      ,
  0.675534228651355      ,
  0.676532730174369      ,
  0.677533920285493      ,
  0.678538681906846      ,
  0.679547774299333      ,
  0.680562296438235      ,
  0.681588011227534      ,
  0.682621776559393      ,
  0.683664371192879      ,
  0.684717902968108      ,
  0.685783540012586      ,
  0.686862304746292      ,
  0.687956013271590      ,
  0.689067156691817      ,
  0.690197577872536      ,
  0.691351459468297      ,
  0.692528764072961      ,
  0.693734568610106      ,
  0.694975864968838      ,
  0.696253114946013      ,
  0.697568038137907      ,
  0.698924235367711      ,
  0.700324647128080      ,
  0.701773156792874      ,
  0.703283658742081      ,
  0.704858564437505      ,
  0.706501943675315      ,
  0.708229717512524      ,
  0.710051878170522      ,
  0.711981206981739      ,
  0.714027105312941      ,
  0.716200337599792      ,
  0.718522272494717      ,
  0.721020833347344      ,
  0.723743522386077      ,
  0.726761935430227      ,
  0.730079227069595      ,
  0.733769060261726      ,
  0.737932528878917      ,
  0.742656690744089      ,
  0.748020477293239      ,
  0.754058002147698      ,
  0.760692176787729      ,
  0.767780536721710      ,
  0.775189705828421      ,
  0.782826658370081      ,
  0.790655926953988      ,
  0.798667365488400      ,
  0.806856280730674      ,
  0.815231285138888      ,
  0.823793555501467      ,
  0.832540858224178      ,
  0.841474838179032      ,
  0.850598920479261      ,
  0.859916835492246      ,
  0.869431575656443      ,
  0.879145504656619      ,
  0.889061496722461      ,
  0.899182873951422      ,
  0.909513220604156      ,
  0.920055456008617      ,
  0.930811820514578      ,
  0.941785210961969      ,
  0.952978447351692      ,
  0.964394173499655      ,
  0.976034863799672      ,
  0.987902791916224      ,
   1.00000000000000      ])

ySol = numpy.transpose(numpy.array([  [  0.912900000000000      ,  0.835222672326810      ],
 [  0.922090432092020      ,  0.835235013774867      ],
 [  0.931794865501035      ,  0.835098672682569      ],
 [  0.942088301764630      ,  0.834755359400891      ],
 [  0.953025176809137      ,  0.834141356203884      ],
 [  0.964631443907501      ,  0.833188974070262      ],
 [  0.976896187549458      ,  0.831830666070875      ],
 [  0.989769135803261      ,  0.830005036376684      ],
 [   1.00316918996730      ,  0.827662393248424      ],
 [   1.01699639701836      ,  0.824768500444846      ],
 [   1.03115574163698      ,  0.821302818945943      ],
 [   1.04557332465638      ,  0.817253579523141      ],
 [   1.06020230079623      ,  0.812612292179667      ],
 [   1.07502282751517      ,  0.807368861701238      ],
 [   1.09004449395837      ,  0.801505582386575      ],
 [   1.10532186656610      ,  0.794984771472864      ],
 [   1.12102012071805      ,  0.787708895021427      ],
 [   1.13798707287570      ,  0.779202412188282      ],
 [   1.15652168255055      ,  0.769163967506117      ],
 [   1.17206261981653      ,  0.760158038374308      ],
 [   1.18332523789973      ,  0.753298028851461      ],
 [   1.19256479872399      ,  0.747458151350407      ],
 [   1.20041571928586      ,  0.742339923032238      ],
 [   1.20730189669633      ,  0.737724662125763      ],
 [   1.21343576116658      ,  0.733504653446509      ],
 [   1.21896824543677      ,  0.729598732341869      ],
 [   1.22400517955741      ,  0.725947175472503      ],
 [   1.22862475759129      ,  0.722503200849904      ],
 [   1.23289362423130      ,  0.719223242767641      ],
 [   1.23686015868275      ,  0.716073322397812      ],
 [   1.24056207710345      ,  0.713024579024952      ],
 [   1.24403518703457      ,  0.710046731937122      ],
 [   1.24730042924302      ,  0.707119646550875      ],
 [   1.25039071458782      ,  0.704209963808279      ],
 [   1.25332423130245      ,  0.701294659922575      ],
 [   1.25611418344924      ,  0.698353567656672      ],
 [   1.25876678709336      ,  0.695372791536918      ],
 [   1.26130767655633      ,  0.692314243134705      ],
 [   1.26374243808538      ,  0.689159395034135      ],
 [   1.26608326588556      ,  0.685879066073023      ],
 [   1.26834049482834      ,  0.682442482641968      ],
 [   1.27052181410278      ,  0.678818607744812      ],
 [   1.27263123775768      ,  0.674978910236385      ],
 [   1.27467190971617      ,  0.670893820758203      ],
 [   1.27665094148197      ,  0.666521905894140      ],
 [   1.27857491456978      ,  0.661815999322536      ],
 [   1.28044721854098      ,  0.656729603187705      ],
 [   1.28226735422284      ,  0.651222034426053      ],
 [   1.28403716820831      ,  0.645241961974154      ],
 [   1.28576322908719      ,  0.638712971164773      ],
 [   1.28744781688641      ,  0.631561168177087      ],
 [   1.28909185464395      ,  0.623707413704795      ],
 [   1.29069534446111      ,  0.615066173795639      ],
 [   1.29225783875941      ,  0.605543200151669      ],
 [   1.29377950377923      ,  0.595027091676589      ],
 [   1.29526104610658      ,  0.583383929412642      ],
 [   1.29670132602022      ,  0.570471952374585      ],
 [   1.29809859843300      ,  0.556132779914829      ],
 [   1.29944898086062      ,  0.540208893366565      ],
 [   1.30075146716979      ,  0.522483212054227      ],
 [   1.30200307432361      ,  0.502723580395578      ],
 [   1.30319982812662      ,  0.480671114036552      ],
 [   1.30433689314460      ,  0.456034813151447      ],
 [   1.30540848924173      ,  0.428488458253740      ],
 [   1.30640803124277      ,  0.397660011266545      ],
 [   1.30732797834492      ,  0.363123121278679      ],
 [   1.30815945321338      ,  0.324396262228339      ],
 [   1.30889217521361      ,  0.280931276008125      ],
 [   1.30951430292922      ,  0.232097657132330      ],
 [   1.31001223124713      ,  0.177150007582861      ],
 [   1.31036965608013      ,  0.115270102203092      ],
 [   1.31056765320224      ,  4.559568029268677E-002 ],
 [   1.31058508156409      , -3.287612571584040E-002 ],
 [   1.31039787198210      , -0.121295156027454      ],
 [   1.30997821269242      , -0.221015251130638      ],
 [   1.30929368492218      , -0.333596316857481      ],
 [   1.30830678413914      , -0.460789733869814      ],
 [   1.30697397290988      , -0.604600486545071      ],
 [   1.30524428072304      , -0.767351854421650      ],
 [   1.30305560899870      , -0.951907071510003      ],
 [   1.30033315320451      ,  -1.16163744399335      ],
 [   1.29698892646592      ,  -1.40034721924509      ],
 [   1.29291584548469      ,  -1.67257933411595      ],
 [   1.28798355988784      ,  -1.98369983284562      ],
 [   1.28203142745877      ,  -2.34010612643587      ],
 [   1.27485516123175      ,  -2.74968921328586      ],
 [   1.26621789656422      ,  -3.22079284970620      ],
 [   1.25612918344614      ,  -3.74759944241018      ],
 [   1.24542374036578      ,  -4.28422246115700      ],
 [   1.23401667968809      ,  -4.83454226330057      ],
 [   1.22188533295190      ,  -5.39838076624840      ],
 [   1.20893326662360      ,  -5.97819262359425      ],
 [   1.19514785541887      ,  -6.57183540630283      ],
 [   1.18047594120652      ,  -7.17831240511950      ],
 [   1.16485461500651      ,  -7.79617854579230      ],
 [   1.14822747535331      ,  -8.42275949178029      ],
 [   1.13053655280301      ,  -9.05435860313188      ],
 [   1.11172268538822      ,  -9.68605253792826      ],
 [   1.09172153343900      ,  -10.3115705856952      ],
 [   1.07030912460251      ,  -10.9271737263283      ],
 [   1.04849201423765      ,  -11.4948435412652      ],
 [   1.02795616519909      ,  -11.9719277851021      ],
 [   1.00870566769064      ,  -12.3664699247436      ],
 [  0.990683581078963      ,  -12.6875345681945      ],
 [  0.973802986863487      ,  -12.9439963044765      ],
 [  0.958088911394403      ,  -13.1425680209539      ],
 [  0.943756264251976      ,  -13.2884939804885      ],
 [  0.930592287527898      ,  -13.3917705741058      ],
 [  0.918890360750179      ,  -13.4579472658506      ],
 [  0.908896427530859      ,  -13.4947310940938      ],
 [  0.900666441075256      ,  -13.5109771595244      ],
 [  0.894217197715201      ,  -13.5146288537788      ],
 [  0.886440382583023      ,  -13.5081870784918      ],
 [  0.876608910876708      ,  -13.4826658889551      ],
 [  0.865658488177202      ,  -13.4307376213202      ],
 [  0.853696979040187      ,  -13.3447637266011      ],
 [  0.840977663107297      ,  -13.2186032083797      ],
 [  0.827670325632242      ,  -13.0467610955084      ],
 [  0.813771400660915      ,  -12.8219419461796      ],
 [  0.799142536137279      ,  -12.5330599053469      ],
 [  0.783908021273471      ,  -12.1726030056270      ],
 [  0.768160846693185      ,  -11.7330062007733      ],
 [  0.751712367233274      ,  -11.1975048563156      ],
 [  0.735090623581758      ,  -10.5732453760493      ],
 [  0.720735515267956      ,  -9.96386410684358      ],
 [  0.708489831306109      ,  -9.39068274783236      ],
 [  0.697595969231367      ,  -8.83839364947299      ],
 [  0.687646737904020      ,  -8.29852122691471      ],
 [  0.678496731849598      ,  -7.77187042564474      ],
 [  0.670027924916094      ,  -7.25872469665641      ],
 [  0.662152650244320      ,  -6.75965684487266      ],
 [  0.654802934092763      ,  -6.27538205306206      ],
 [  0.647916431233190      ,  -5.80614106628012      ],
 [  0.641429620029782      ,  -5.35138327370088      ],
 [  0.635284697839567      ,  -4.91037754256977      ],
 [  0.629474022556919      ,  -4.48566809078726      ],
 [  0.624021492104511      ,  -4.08203990655413      ],
 [  0.618882305071719      ,  -3.69905996594009      ],
 [  0.613944566352820      ,  -3.33109540762128      ],
 [  0.609092629744847      ,  -2.97243138405384      ],
 [  0.604477477591447      ,  -2.63741119717507      ],
 [  0.600753996654972      ,  -2.37444745512839      ],
 [  0.597698777653274      ,  -2.16573333791652      ],
 [  0.595092956228196      ,  -1.99428331523949      ],
 [  0.592782917697485      ,  -1.84850672385238      ],
 [  0.590702701553189      ,  -1.72313326987625      ],
 [  0.588807065477479      ,  -1.61446562385379      ],
 [  0.587064459392478      ,  -1.51982323744127      ],
 [  0.585449788477562      ,  -1.43705110192715      ],
 [  0.583942072923145      ,  -1.36436189863244      ],
 [  0.582525855489361      ,  -1.30036860895163      ],
 [  0.581188983932826      ,  -1.24393436350640      ],
 [  0.579921564779231      ,  -1.19410067684665      ],
 [  0.578712720372772      ,  -1.14995314669637      ],
 [  0.577554989400109      ,  -1.11078503597509      ],
 [  0.576443002152086      ,  -1.07601663252499      ],
 [  0.575370881588349      ,  -1.04510116829384      ],
 [  0.574333291829895      ,  -1.01755981499541      ],
 [  0.573325908116558      , -0.992986887781404      ],
 [  0.572344745668078      , -0.971024590129366      ],
 [  0.571386299801576      , -0.951361750933211      ],
 [  0.570447796046545      , -0.933732852585582      ],
 [  0.569526405838077      , -0.917897989484154      ],
 [  0.568619682522712      , -0.903648624829697      ],
 [  0.567725517327272      , -0.890802868977011      ],
 [  0.566841941597957      , -0.879199522798457      ],
 [  0.565967043146016      , -0.868695053135442      ],
 [  0.565099080078560      , -0.859163207142993      ],
 [  0.564236550869148      , -0.850493606136034      ],
 [  0.563377781989567      , -0.842585945479853      ],
 [  0.562517314234588      , -0.835320380134286      ],
 [  0.561657288265540      , -0.828653421450309      ],
 [  0.560796585359050      , -0.822517676182646      ],
 [  0.559933068172576      , -0.816846121309439      ],
 [  0.559065449793476      , -0.811584801967549      ],
 [  0.558192619117219      , -0.806686266068195      ],
 [  0.557312877897435      , -0.802104807077155      ],
 [  0.556424047709236      , -0.797797498381986      ],
 [  0.555524527924272      , -0.793728903763980      ],
 [  0.554610916701315      , -0.789859804312933      ],
 [  0.553683207417360      , -0.786168983327634      ],
 [  0.552737401934666      , -0.782621771067608      ],
 [  0.551768091455292      , -0.779182857262428      ],
 [  0.550775035498109      , -0.775838285287646      ],
 [  0.549757033717419      , -0.772571426640126      ],
 [  0.548711467536218      , -0.769362387021539      ],
 [  0.547636277516970      , -0.766194507123063      ],
 [  0.546528729492552      , -0.763050410086361      ],
 [  0.545378538951007      , -0.759893610753583      ],
 [  0.544184295495240      , -0.756714368576383      ],
 [  0.542943381238385      , -0.753500057621555      ],
 [  0.541644353103201      , -0.750216594735175      ],
 [  0.540280423807763      , -0.746843701787178      ],
 [  0.538842892683073      , -0.743357525412188      ],
 [  0.537325770582516      , -0.739741820716518      ],
 [  0.535722241903963      , -0.735979089506578      ],
 [  0.534017939230383      , -0.732035277887326      ],
 [  0.532194126036730      , -0.727868076783276      ],
 [  0.530218458955030      , -0.723406601814753      ],
 [  0.528042274988566      , -0.718546914263117      ],
 [  0.525667373246665      , -0.713300604245161      ],
 [  0.523046015775143      , -0.707571545501588      ],
 [  0.520113306112893      , -0.701231645399274      ],
 [  0.516817274277484      , -0.694187271620332      ],
 [  0.513114850958542      , -0.686369793497366      ],
 [  0.508996898530846      , -0.677786711941601      ],
 [  0.504530942109137      , -0.668604202982246      ],
 [  0.499825607767088      , -0.659063899677322      ],
 [  0.494978564594998      , -0.649373042612103      ],
 [  0.490056572707451      , -0.639667067870161      ],
 [  0.485086482014908      , -0.629996943184205      ],
 [  0.480078011221350      , -0.620378232425885      ],
 [  0.475037110319747      , -0.610818578709665      ],
 [  0.469961503409656      , -0.601309923409326      ],
 [  0.464853596209763      , -0.591853202985853      ],
 [  0.459717777386389      , -0.582452926410645      ],
 [  0.454556081159809      , -0.573109186656833      ],
 [  0.449369551526652      , -0.563820344330008      ],
 [  0.444159141256666      , -0.554584711523296      ],
 [  0.438926292580239      , -0.545401574273583      ],
 [  0.433672842411761      , -0.536270987816110      ],
 [  0.428400390916969      , -0.527192665952851      ],
 [  0.423110354982801      , -0.518166094820334      ],
 [  0.417804080443377      , -0.509190738000084      ],
 [  0.412483314795372      , -0.500266832167140      ],
 [  0.407150181573951      , -0.491395317981418      ],
 [  0.401806503145918      , -0.482576704615157      ],
 [  0.396454174389258      , -0.473811701444245      ],
 [  0.391095202546234      , -0.465101279433723      ],
 [  0.385731693445562      , -0.456446643442510      ],
 [  0.380365855177612      , -0.447849233432690      ],
 [  0.375000000000000      , -0.439310722598872      ]]))

workSol = numpy.array([  0.835222672326810      ,
  6.383233732583265E-003 ,
  0.835235013774868      ,
 -4.668342976958232E-003 ,
  0.835244043605423      ,
  1.253688705491234E-003 ,
  0.835235013774868      ,
 -4.668342976958232E-003 ,
  0.835098672682569      ,
 -1.920146493251520E-002 ,
  0.835187951786099      ,
 -1.163318581887802E-002 ,
  0.835098672682569      ,
 -1.920146493251520E-002 ,
  0.834755359400891      ,
 -3.679652890728152E-002 ,
  0.834954130649507      ,
 -2.777193709886265E-002 ,
  0.834755359400891      ,
 -3.679652890728152E-002 ,
  0.834141356203884      ,
 -5.711945703101131E-002 ,
  0.834481652764720      ,
 -4.679257370596499E-002 ,
  0.834141356203884      ,
 -5.711945703101131E-002 ,
  0.833188974070262      ,
 -7.985199773095723E-002 ,
  0.833704724123704      ,
 -6.837319522209459E-002 ,
  0.833188974070262      ,
 -7.985199773095723E-002 ,
  0.831830666070874      ,
 -0.104641779870275      ,
  0.832555469563454      ,
 -9.218104673672897E-002 ,
  0.831830666070874      ,
 -0.104641779870275      ,
  0.830005036376684      ,
 -0.131079966781337      ,
  0.830969048136958      ,
 -0.117836833404678      ,
  0.830005036376684      ,
 -0.131079966781337      ,
  0.827662393248424      ,
 -0.158714291919987      ,
  0.828889559069157      ,
 -0.144910499491374      ,
  0.827662393248424      ,
 -0.158714291919987      ,
  0.824768500444846      ,
 -0.187077092954997      ,
  0.826274777549952      ,
 -0.172942216228422      ,
  0.824768500444846      ,
 -0.187077092954997      ,
  0.821302818945943      ,
 -0.215739330377281      ,
  0.823097294059621      ,
 -0.201483806703806      ,
  0.821302818945943      ,
 -0.215739330377281      ,
  0.817253579523141      ,
 -0.244345029401159      ,
  0.819341121073147      ,
 -0.230143224543490      ,
  0.817253579523141      ,
 -0.244345029401159      ,
  0.812612292179667      ,
 -0.272619260906767      ,
  0.814996376898889      ,
 -0.258605710089921      ,
  0.812612292179667      ,
 -0.272619260906767      ,
  0.807368861701238      ,
 -0.300360224678592      ,
  0.810054021232102      ,
 -0.286633681782405      ,
  0.807368861701238      ,
 -0.300360224678592      ,
  0.801505582386575      ,
 -0.327433572474301      ,
  0.804500413038244      ,
 -0.314059925124597      ,
  0.801505582386575      ,
 -0.327433572474301      ,
  0.794984771472864      ,
 -0.353786454933941      ,
  0.798308218589766      ,
 -0.340792030285305      ,
  0.794984771472864      ,
 -0.353786454933941      ,
  0.787708895021427      ,
 -0.379533353941275      ,
  0.791410673716757      ,
 -0.366863533960292      ,
  0.787708895021427      ,
 -0.379533353941275      ,
  0.779202412188282      ,
 -0.405766061821070      ,
  0.783526663081428      ,
 -0.392896006110218      ,
  0.779202412188282      ,
 -0.405766061821070      ,
  0.769163967506117      ,
 -0.432511175068884      ,
  0.774263221950797      ,
 -0.419426730622746      ,
  0.769163967506117      ,
 -0.432511175068884      ,
  0.760158038374308      ,
 -0.453542580671681      ,
  0.764714430624137      ,
 -0.443195850642570      ,
  0.760158038374308      ,
 -0.453542580671681      ,
  0.753298028851461      ,
 -0.468256760231117      ,
  0.756755407415133      ,
 -0.460946250675826      ,
  0.753298028851461      ,
 -0.468256760231117      ,
  0.747458151350407      ,
 -0.480337682576818      ,
  0.750396684156111      ,
 -0.474279443133750      ,
  0.747458151350407      ,
 -0.480337682576818      ,
  0.742339923032238      ,
 -0.491006574816547      ,
  0.744913092715567      ,
 -0.485602965675023      ,
  0.742339923032238      ,
 -0.491006574816547      ,
  0.737724662125763      ,
 -0.501131594310376      ,
  0.740044069419944      ,
 -0.495951157187137      ,
  0.737724662125763      ,
 -0.501131594310376      ,
  0.733504653446509      ,
 -0.511285061607787      ,
  0.735625240669839      ,
 -0.506041239886583      ,
  0.733504653446509      ,
 -0.511285061607787      ,
  0.729598732341869      ,
 -0.521963486969466      ,
  0.731561787477635      ,
 -0.516405695558906      ,
  0.729598732341869      ,
 -0.521963486969466      ,
  0.725947175472503      ,
 -0.533617584223088      ,
  0.727783036099999      ,
 -0.527517368140695      ,
  0.725947175472503      ,
 -0.533617584223088      ,
  0.722503200849904      ,
 -0.546678949021558      ,
  0.724235602293520      ,
 -0.539817071508580      ,
  0.722503200849904      ,
 -0.546678949021558      ,
  0.719223242767641      ,
 -0.561599696870231      ,
  0.720874266558701      ,
 -0.553745224834212      ,
  0.719223242767641      ,
 -0.561599696870231      ,
  0.716073322397812      ,
 -0.578831974500990      ,
  0.717660188078184      ,
 -0.569754168542268      ,
  0.716073322397812      ,
 -0.578831974500990      ,
  0.713024579024951      ,
 -0.598838528207308      ,
  0.714561906740213      ,
 -0.588301466250845      ,
  0.713024579024951      ,
 -0.598838528207308      ,
  0.710046731937122      ,
 -0.622136584915070      ,
  0.711549870445849      ,
 -0.609875225254012      ,
  0.710046731937122      ,
 -0.622136584915070      ,
  0.707119646550875      ,
 -0.649208820602239      ,
  0.708598783056957      ,
 -0.634978384272973      ,
  0.707119646550875      ,
 -0.649208820602239      ,
  0.704209963808278      ,
 -0.680710936139007      ,
  0.705682049368908      ,
 -0.664172761132215      ,
  0.704209963808278      ,
 -0.680710936139007      ,
  0.701294659922575      ,
 -0.717276146804124      ,
  0.702771390905343      ,
 -0.698106068572902      ,
  0.701294659922575      ,
 -0.717276146804124      ,
  0.698353567656672      ,
 -0.759550465772247      ,
  0.699845179968572      ,
 -0.737419098115868      ,
  0.698353567656672      ,
 -0.759550465772247      ,
  0.695372791536918      ,
 -0.808108534966991      ,
  0.696886283569743      ,
 -0.782726836919195      ,
  0.695372791536918      ,
 -0.808108534966991      ,
  0.692314243134705      ,
 -0.863976597837037      ,
  0.693869090660477      ,
 -0.834811331377851      ,
  0.692314243134705      ,
 -0.863976597837037      ,
  0.689159395034134      ,
 -0.927941538155231      ,
  0.690765001876962      ,
 -0.894592823069794      ,
  0.689159395034134      ,
 -0.927941538155231      ,
  0.685879066073022      ,
  -1.00105480221914      ,
  0.687550346119125      ,
 -0.962981501275369      ,
  0.685879066073022      ,
  -1.00105480221914      ,
  0.682442482641967      ,
  -1.08450200979097      ,
  0.684195187528911      ,
  -1.04109370198837      ,
  0.682442482641967      ,
  -1.08450200979097      ,
  0.678818607744811      ,
  -1.17957058441856      ,
  0.680668628846190      ,
  -1.13016542905660      ,
  0.678818607744811      ,
  -1.17957058441856      ,
  0.674978910236384      ,
  -1.28755645556384      ,
  0.676940821875144      ,
  -1.23149144829819      ,
  0.674978910236384      ,
  -1.28755645556384      ,
  0.670893820758202      ,
  -1.40983394671488      ,
  0.672982714008674      ,
  -1.34640699446640      ,
  0.670893820758202      ,
  -1.40983394671488      ,
  0.666521905894138      ,
  -1.54820118568050      ,
  0.668759047707981      ,
  -1.47648624064756      ,
  0.666521905894138      ,
  -1.54820118568050      ,
  0.661815999322534      ,
  -1.70475005743316      ,
  0.664225635979143      ,
  -1.62366857552280      ,
  0.661815999322534      ,
  -1.70475005743316      ,
  0.656729603187702      ,
  -1.88165600256990      ,
  0.659335597845439      ,
  -1.79009008415643      ,
  0.656729603187702      ,
  -1.88165600256990      ,
  0.651222034426050      ,
  -2.08095494403896      ,
  0.654045149634604      ,
  -1.97786608530133      ,
  0.651222034426050      ,
  -2.08095494403896      ,
  0.645241961974151      ,
  -2.30510905105504      ,
  0.648308490850224      ,
  -2.18923547095386      ,
  0.645241961974151      ,
  -2.30510905105504      ,
  0.638712971164770      ,
  -2.55761863497984      ,
  0.642062323229851      ,
  -2.42715105956519      ,
  0.638712971164770      ,
  -2.55761863497984      ,
  0.631561168177084      ,
  -2.84201884898041      ,
  0.635231350446329      ,
  -2.69513777311512      ,
  0.631561168177084      ,
  -2.84201884898041      ,
  0.623707413704791      ,
  -3.16214610019260      ,
  0.627739097735275      ,
  -2.99687952036733      ,
  0.623707413704791      ,
  -3.16214610019260      ,
  0.615066173795634      ,
  -3.52217598077617      ,
  0.619503286359730      ,
  -3.33637969353679      ,
  0.615066173795634      ,
  -3.52217598077617      ,
  0.605543200151663      ,
  -3.92671625879482      ,
  0.610434131029883      ,
  -3.71802505690255      ,
  0.605543200151663      ,
  -3.92671625879482      ,
  0.595027091676582      ,
  -4.38117477176688      ,
  0.600429123961175      ,
  -4.14680812121362      ,
  0.595027091676582      ,
  -4.38117477176688      ,
  0.583383929412634      ,
  -4.89201985189643      ,
  0.589366044761618      ,
  -4.62864574457147      ,
  0.583383929412634      ,
  -4.89201985189643      ,
  0.570471952374576      ,
  -5.46615115206313      ,
  0.577107066091996      ,
  -5.17022202997194      ,
  0.570471952374576      ,
  -5.46615115206313      ,
  0.556132779914819      ,
  -6.11127372002075      ,
  0.563502347257904      ,
  -5.77882884989895      ,
  0.556132779914819      ,
  -6.11127372002075      ,
  0.540208893366554      ,
  -6.83509732276017      ,
  0.548393662674295      ,
  -6.46218834472378      ,
  0.540208893366554      ,
  -6.83509732276017      ,
  0.522483212054215      ,
  -7.64807726466883      ,
  0.531595081683501      ,
  -7.22931687184683      ,
  0.522483212054215      ,
  -7.64807726466883      ,
  0.502723580395565      ,
  -8.56141848730981      ,
  0.512882054706351      ,
  -8.09104309757965      ,
  0.502723580395565      ,
  -8.56141848730981      ,
  0.480671114036536      ,
  -9.58758807568706      ,
  0.492009417476984      ,
  -9.05918790301785      ,
  0.480671114036536      ,
  -9.58758807568706      ,
  0.456034813151430      ,
  -10.7405500038810      ,
  0.468702683913875      ,
  -10.1469474103216      ,
  0.456034813151430      ,
  -10.7405500038810      ,
  0.428488458253721      ,
  -12.0358907980738      ,
  0.442653728893707      ,
  -11.3690768989141      ,
  0.428488458253721      ,
  -12.0358907980738      ,
  0.397660011266523      ,
  -13.4912920781057      ,
  0.413514138324859      ,
  -12.7421803079508      ,
  0.397660011266523      ,
  -13.4912920781057      ,
  0.363123121278654      ,
  -15.1268998386708      ,
  0.380885587143968      ,
  -14.2851352517640      ,
  0.363123121278654      ,
  -15.1268998386708      ,
  0.324396262228310      ,
  -16.9653189217896      ,
  0.344314932477068      ,
  -16.0192864343572      ,
  0.324396262228310      ,
  -16.9653189217896      ,
  0.280931276008093      ,
  -19.0320906308676      ,
  0.303288343628473      ,
  -17.9686681536550      ,
  0.280931276008093      ,
  -19.0320906308676      ,
  0.232097657132294      ,
  -21.3563529723739      ,
  0.257217813663821      ,
  -20.1605694058567      ,
  0.232097657132294      ,
  -21.3563529723739      ,
  0.177150007582821      ,
  -23.9722725146889      ,
  0.205417472280940      ,
  -22.6265601442079      ,
  0.177150007582821      ,
  -23.9722725146889      ,
  0.115270102203046      ,
  -26.9168806103973      ,
  0.147106191165667      ,
  -25.4022294163156      ,
  0.115270102203046      ,
  -26.9168806103973      ,
  4.559568029263484E-002 ,
  -30.2284981159812      ,
  8.144342995137079E-002 ,
  -28.5252952543306      ,
  4.559568029263484E-002 ,
  -30.2284981159812      ,
 -3.287612571589898E-002 ,
  -33.9510741171081      ,
  7.498921121692214E-003 ,
  -32.0368197048984      ,
 -3.287612571589898E-002 ,
  -33.9510741171081      ,
 -0.121295156027520      ,
  -38.1341425631165      ,
 -7.580150882242646E-002 ,
  -35.9834887846967      ,
 -0.121295156027520      ,
  -38.1341425631165      ,
 -0.221015251130712      ,
  -42.8350535088823      ,
 -0.169706242211191      ,
  -40.4186462494717      ,
 -0.221015251130712      ,
  -42.8350535088823      ,
 -0.333596316857565      ,
  -48.1184274595745      ,
 -0.275669096697561      ,
  -45.4032203101100      ,
 -0.333596316857565      ,
  -48.1184274595745      ,
 -0.460789733869909      ,
  -54.0546402118016      ,
 -0.395343579680318      ,
  -51.0047216400179      ,
 -0.460789733869909      ,
  -54.0546402118016      ,
 -0.604600486545178      ,
  -60.7216451068368      ,
 -0.530604522067695      ,
  -57.2973095558089      ,
 -0.604600486545178      ,
  -60.7216451068368      ,
 -0.767351854421771      ,
  -68.2064837140229      ,
 -0.683611604665028      ,
  -64.3634806066868      ,
 -0.767351854421771      ,
  -68.2064837140229      ,
 -0.951907071510139      ,
  -76.6133097188560      ,
 -0.856948348432992      ,
  -72.2986873922409      ,
 -0.951907071510139      ,
  -76.6133097188560      ,
  -1.16163744399351      ,
  -86.0587136436241      ,
  -1.05372474361772      ,
  -81.2133864326005      ,
  -1.16163744399351      ,
  -86.0587136436241      ,
  -1.40034721924526      ,
  -96.6641460127987      ,
  -1.27752518723185      ,
  -91.2270015481484      ,
  -1.40034721924526      ,
  -96.6641460127987      ,
  -1.67257933411615      ,
  -108.563736854344      ,
  -1.53251336068923      ,
  -102.467697587101      ,
  -1.67257933411615      ,
  -108.563736854344      ,
  -1.98369983284584      ,
  -121.899221073579      ,
  -1.82363482315296      ,
  -115.074184577680      ,
  -1.98369983284584      ,
  -121.899221073579      ,
  -2.34010612643611      ,
  -136.816116994039      ,
  -2.15676119348858      ,
  -129.191377700286      ,
  -2.34010612643611      ,
  -136.816116994039      ,
  -2.74968921328614      ,
  -153.463390871830      ,
  -2.53902074035888      ,
  -144.968523184424      ,
  -2.74968921328614      ,
  -153.463390871830      ,
  -3.22079284970652      ,
  -171.922721062851      ,
  -2.97855494909618      ,
  -162.525473354932      ,
  -3.22079284970652      ,
  -171.922721062851      ,
  -3.74759944241053      ,
  -191.640268277862      ,
  -3.47704969636379      ,
  -181.639695450686      ,
  -3.74759944241053      ,
  -191.640268277862      ,
  -4.28422246115740      ,
  -210.653556809128      ,
  -4.00956867318131      ,
  -201.062071563875      ,
  -4.28422246115740      ,
  -210.653556809128      ,
  -4.83454226330100      ,
  -228.944080399153      ,
  -4.55365746648689      ,
  -219.767205260763      ,
  -4.83454226330100      ,
  -228.944080399153      ,
  -5.39838076624887      ,
  -246.311032825404      ,
  -5.11131083564671      ,
  -237.649765614581      ,
  -5.39838076624887      ,
  -246.311032825404      ,
  -5.97819262359476      ,
  -262.590026885203      ,
  -5.68365082558367      ,
  -254.529742590279      ,
  -5.97819262359476      ,
  -262.590026885203      ,
  -6.57183540630338      ,
  -277.431644660705      ,
  -6.27093660429233      ,
  -270.151495005036      ,
  -6.57183540630338      ,
  -277.431644660705      ,
  -7.17831240512009      ,
  -290.473906900049      ,
  -6.87159358760999      ,
  -284.160955887709      ,
  -7.17831240512009      ,
  -290.473906900049      ,
  -7.79617854579292      ,
  -301.281516130584      ,
  -7.48442615455002      ,
  -296.161161586131      ,
  -7.79617854579292      ,
  -301.281516130584      ,
  -8.42275949178095      ,
  -309.323105692007      ,
  -8.10740767398041      ,
  -305.669801332304      ,
  -8.42275949178095      ,
  -309.323105692007      ,
  -9.05435860313258      ,
  -313.971805019193      ,
  -8.73738254968654      ,
  -312.108687650758      ,
  -9.05435860313258      ,
  -313.971805019193      ,
  -9.68605253792899      ,
  -314.496260932285      ,
  -9.37007394139594      ,
  -314.799240546207      ,
  -9.68605253792899      ,
  -314.496260932285      ,
  -10.3115705856960      ,
  -310.051643371240      ,
  -9.99992282994196      ,
  -312.953543024887      ,
  -10.3115705856960      ,
  -310.051643371240      ,
  -10.9271737263291      ,
  -299.572594070518      ,
  -10.6220129017688      ,
  -305.627597780215      ,
  -10.9271737263291      ,
  -299.572594070518      ,
  -11.4948435412660      ,
  -282.815274409213      ,
  -11.2150839552863      ,
  -292.065953033799      ,
  -11.4948435412660      ,
  -282.815274409213      ,
  -11.9719277851029      ,
  -261.461224391121      ,
  -11.7380561736892      ,
  -272.920459872249      ,
  -11.9719277851029      ,
  -261.461224391121      ,
  -12.3664699247444      ,
  -236.579465718540      ,
  -12.1741175969486      ,
  -249.705261580603      ,
  -12.3664699247444      ,
  -236.579465718540      ,
  -12.6875345681953      ,
  -209.090479260535      ,
  -12.5319443569336      ,
  -223.424595674792      ,
  -12.6875345681953      ,
  -209.090479260535      ,
  -12.9439963044773      ,
  -179.751187993458      ,
  -12.8205948423783      ,
  -194.921997382832      ,
  -12.9439963044773      ,
  -179.751187993458      ,
  -13.1425680209546      ,
  -149.416590979499      ,
  -13.0478493499832      ,
  -164.998919627504      ,
  -13.1425680209546      ,
  -149.416590979499      ,
  -13.2884939804892      ,
  -119.309084345572      ,
  -13.2196117245365      ,
  -134.688411483023      ,
  -13.2884939804892      ,
  -119.309084345572      ,
  -13.3917705741065      ,
  -89.7055663841135      ,
  -13.3437831868666      ,
  -104.762885343536      ,
  -13.3917705741065      ,
  -89.7055663841135      ,
  -13.4579472658512      ,
  -61.9103240192136      ,
  -13.4278869684588      ,
  -75.9934681577365      ,
  -13.4579472658512      ,
  -61.9103240192136      ,
  -13.4947310940944      ,
  -37.1392070067938      ,
  -13.4786351741848      ,
  -49.6479077418213      ,
  -13.4947310940944      ,
  -37.1392070067938      ,
  -13.5109771595249      ,
  -16.0736410041425      ,
  -13.5044589318548      ,
  -26.6820845718314      ,
  -13.5109771595249      ,
  -16.0736410041425      ,
  -13.5146288537793      ,
  0.826667309288202      ,
  -13.5138112058759      ,
  -7.66566798003444      ,
  -13.5146288537793      ,
  0.826667309288202      ,
  -13.5081870784922      ,
   21.6318457712854      ,
  -13.5129047205726      ,
   11.1744840376774      ,
  -13.5081870784922      ,
   21.6318457712854      ,
  -13.4826658889554      ,
   48.5390849023155      ,
  -13.4978764410141      ,
   35.0121184276945      ,
  -13.4826658889554      ,
   48.5390849023155      ,
  -13.4307376213205      ,
   79.1979453822459      ,
  -13.4598198634418      ,
   63.8005612633697      ,
  -13.4307376213205      ,
   79.1979453822459      ,
  -13.3447637266013      ,
   113.351577730145      ,
  -13.3915643412736      ,
   96.2276367549976      ,
  -13.3447637266013      ,
   113.351577730145      ,
  -13.2186032083799      ,
   150.192729107555      ,
  -13.2860926464951      ,
   131.765462197274      ,
  -13.2186032083799      ,
   150.192729107555      ,
  -13.0467610955084      ,
   188.994086396917      ,
  -13.1375955998673      ,
   169.646840266987      ,
  -13.0467610955084      ,
   188.994086396917      ,
  -12.8219419461795      ,
   229.374505560308      ,
  -12.9397739766897      ,
   209.320902118369      ,
  -12.8219419461795      ,
   229.374505560308      ,
  -12.5330599053467      ,
   271.140600612493      ,
  -12.6835233775674      ,
   250.511675894525      ,
  -12.5330599053467      ,
   271.140600612493      ,
  -12.1726030056266      ,
   313.069706150050      ,
  -12.3592929994342      ,
   292.512363620360      ,
  -12.1726030056266      ,
   313.069706150050      ,
  -11.7330062007728      ,
   353.727985691351      ,
  -11.9594977405447      ,
   333.997658316417      ,
  -11.7330062007728      ,
   353.727985691351      ,
  -11.1975048563148      ,
   391.955295488598      ,
  -11.4721080871079      ,
   373.701420907412      ,
  -11.1975048563148      ,
   391.955295488598      ,
  -10.5732453760485      ,
   424.509259439440      ,
  -10.8915864074453      ,
   409.346900407350      ,
  -10.5732453760485      ,
   424.509259439440      ,
  -9.96386410684257      ,
   446.173693175391      ,
  -10.2723395838661      ,
   436.347579836272      ,
  -9.96386410684257      ,
   446.173693175391      ,
  -9.39068274783125      ,
   458.752146241467      ,
  -9.67926276162264      ,
   453.305050900376      ,
  -9.39068274783125      ,
   458.752146241467      ,
  -8.83839364947179      ,
   464.485841106685      ,
  -9.11539477205267      ,
   462.357274496004      ,
  -8.83839364947179      ,
   464.485841106685      ,
  -8.29852122691346      ,
   464.526409957329      ,
  -8.56846332648550      ,
   465.169055862637      ,
  -8.29852122691346      ,
   464.526409957329      ,
  -7.77187042564345      ,
   459.605838383510      ,
  -8.03449537856469      ,
   462.654412142138      ,
  -7.77187042564345      ,
   459.605838383510      ,
  -7.25872469665509      ,
   450.342397400642      ,
  -7.51399256664790      ,
   455.489263625943      ,
  -7.25872469665509      ,
   450.342397400642      ,
  -6.75965684487133      ,
   437.278240071432      ,
  -7.00735564828583      ,
   444.252789285075      ,
  -6.75965684487133      ,
   437.278240071432      ,
  -6.27538205306074      ,
   420.908144892173      ,
  -6.51521136293071      ,
   429.463011193787      ,
  -6.27538205306074      ,
   420.908144892173      ,
  -5.80614106627883      ,
   401.671432639499      ,
  -6.03801948456401      ,
   411.587504326374      ,
  -5.80614106627883      ,
   401.671432639499      ,
  -5.35138327369963      ,
   379.929199144484      ,
  -5.57560082654625      ,
   391.026761194129      ,
  -5.35138327369963      ,
   379.929199144484      ,
  -4.91037754256856      ,
   355.982171986717      ,
  -5.12729376181245      ,
   368.110476972065      ,
  -4.91037754256856      ,
   355.982171986717      ,
  -4.48566809078611      ,
   330.292564905421      ,
  -4.69404885260781      ,
   343.217311688735      ,
  -4.48566809078611      ,
   330.292564905421      ,
  -4.08203990655305      ,
   303.513177915155      ,
  -4.27959053731988      ,
   316.906838029305      ,
  -4.08203990655305      ,
   303.513177915155      ,
  -3.69905996593908      ,
   275.987566173383      ,
  -3.88600142735177      ,
   289.680293938610      ,
  -3.69905996593908      ,
   275.987566173383      ,
  -3.33109540762036      ,
   247.607722386596      ,
  -3.51008971216181      ,
   261.649412016679      ,
  -3.33109540762036      ,
   247.607722386596      ,
  -2.97243138405301      ,
   218.123653781389      ,
  -3.14608296769602      ,
   232.623415953128      ,
  -2.97243138405301      ,
   218.123653781389      ,
  -2.63741119717434      ,
   188.956280044382      ,
  -2.79891379817629      ,
   203.213515335969      ,
  -2.63741119717434      ,
   188.956280044382      ,
  -2.37444745512774      ,
   164.957274248527      ,
  -2.50146660759264      ,
   176.671161816767      ,
  -2.37444745512774      ,
   164.957274248527      ,
  -2.16573333791595      ,
   145.214297775266      ,
  -2.26676574544614      ,
   154.848293237266      ,
  -2.16573333791595      ,
   145.214297775266      ,
  -1.99428331523899      ,
   128.534266954845      ,
  -2.07739405628169      ,
   136.672077083423      ,
  -1.99428331523899      ,
   128.534266954845      ,
  -1.84850672385192      ,
   114.023391324997      ,
  -1.91921261538422      ,
   121.099320938245      ,
  -1.84850672385192      ,
   114.023391324997      ,
  -1.72313326987585      ,
   101.302024362458      ,
  -1.78396640038213      ,
   107.502477135367      ,
  -1.72313326987585      ,
   101.302024362458      ,
  -1.61446562385344      ,
   90.0958974078555      ,
  -1.66720726492247      ,
   95.5555465988275      ,
  -1.61446562385344      ,
   90.0958974078555      ,
  -1.51982323744095      ,
   80.2013882265225      ,
  -1.56576833449847      ,
   85.0203186219883      ,
  -1.51982323744095      ,
   80.2013882265225      ,
  -1.43705110192687      ,
   71.4469258554073      ,
  -1.47724137977635      ,
   75.7092934000634      ,
  -1.43705110192687      ,
   71.4469258554073      ,
  -1.36436189863219      ,
   63.6834934758339      ,
  -1.39966141402781      ,
   67.4622171087750      ,
  -1.36436189863219      ,
   63.6834934758339      ,
  -1.30036860895141      ,
   56.7930781928462      ,
  -1.33144932622618      ,
   60.1459796566571      ,
  -1.30036860895141      ,
   56.7930781928462      ,
  -1.24393436350620      ,
   50.6761883932756      ,
  -1.27134763716545      ,
   53.6520112458798      ,
  -1.24393436350620      ,
   50.6761883932756      ,
  -1.19410067684647      ,
   45.2464135459816      ,
  -1.21831157682175      ,
   47.8874648750592      ,
  -1.19410067684647      ,
   45.2464135459816      ,
  -1.14995314669621      ,
   40.4173551539527      ,
  -1.17140409661238      ,
   42.7657208835187      ,
  -1.14995314669621      ,
   40.4173551539527      ,
  -1.11078503597495      ,
   36.1216677329602      ,
  -1.12981895415555      ,
   38.2102461151823      ,
  -1.11078503597495      ,
   36.1216677329602      ,
  -1.07601663252487      ,
   32.3032470578316      ,
  -1.09291527438057      ,
   34.1594849754767      ,
  -1.07601663252487      ,
   32.3032470578316      ,
  -1.04510116829373      ,
   28.9075497974596      ,
  -1.06012969518659      ,
   30.5580357727798      ,
  -1.04510116829373      ,
   28.9075497974596      ,
  -1.01755981499531      ,
   25.8859267681049      ,
  -1.03095040305665      ,
   27.3543568088854      ,
  -1.01755981499531      ,
   25.8859267681049      ,
 -0.992986887781320      ,
   23.1965874477849      ,
  -1.00493640296738      ,
   24.5033266343931      ,
 -0.992986887781320      ,
   23.1965874477849      ,
 -0.971024590129292      ,
   20.8021220112064      ,
 -0.981706627066292      ,
   21.9653880718221      ,
 -0.971024590129292      ,
   20.8021220112064      ,
 -0.951361750933145      ,
   18.6695864809752      ,
 -0.960927316476312      ,
   19.7054203846348      ,
 -0.951361750933145      ,
   18.6695864809752      ,
 -0.933732852585525      ,
   16.7705498347041      ,
 -0.942310901013831      ,
   17.6928041356469      ,
 -0.933732852585525      ,
   16.7705498347041      ,
 -0.917897989484103      ,
   15.0790421218090      ,
 -0.925604961309297      ,
   15.9003562173991      ,
 -0.917897989484103      ,
   15.0790421218090      ,
 -0.903648624829652      ,
   13.5722731933867      ,
 -0.910585772828055      ,
   14.3037408313641      ,
 -0.903648624829652      ,
   13.5722731933867      ,
 -0.890802868976972      ,
   12.2301825709612      ,
 -0.897058537056289      ,
   12.8815704085996      ,
 -0.890802868976972      ,
   12.2301825709612      ,
 -0.879199522798422      ,
   11.0348511196878      ,
 -0.884852003353372      ,
   11.6148810064315      ,
 -0.879199522798422      ,
   11.0348511196878      ,
 -0.868695053135411      ,
   9.97022169746830      ,
 -0.873814050910725      ,
   10.4867063516426      ,
 -0.868695053135411      ,
   9.97022169746830      ,
 -0.859163207142966      ,
   9.02207966083776      ,
 -0.863810048047939      ,
   9.48193572454773      ,
 -0.859163207142966      ,
   9.02207966083776      ,
 -0.850493606136011      ,
   8.17790919225422      ,
 -0.854721925889762      ,
   8.58722858216551      ,
 -0.850493606136011      ,
   8.17790919225422      ,
 -0.842585945479832      ,
   7.42632371140733      ,
 -0.846444463294222      ,
   7.79064423126497      ,
 -0.842585945479832      ,
   7.42632371140733      ,
 -0.835320380134268      ,
   6.75438580685840      ,
 -0.838867010726277      ,
   7.07994778392378      ,
 -0.835320380134268      ,
   6.75438580685840      ,
 -0.828653421450294      ,
   6.15649668668463      ,
 -0.831909641161689      ,
   6.44607836925055      ,
 -0.828653421450294      ,
   6.15649668668463      ,
 -0.822517676182632      ,
   5.62487536370679      ,
 -0.825516265624165      ,
   5.88226611360521      ,
 -0.822517676182632      ,
   5.62487536370679      ,
 -0.816846121309428      ,
   5.15198644548135      ,
 -0.819619623308342      ,
   5.38084455997452      ,
 -0.816846121309428      ,
   5.15198644548135      ,
 -0.811584801967539      ,
   4.73163109692133      ,
 -0.814159468359575      ,
   4.93497461769504      ,
 -0.811584801967539      ,
   4.73163109692133      ,
 -0.806686266068186      ,
   4.35832258642549      ,
 -0.809085195010873      ,
   4.53882420317662      ,
 -0.806686266068186      ,
   4.35832258642549      ,
 -0.802104807077148      ,
   4.02690988700681      ,
 -0.804350227960824      ,
   4.18707390491372      ,
 -0.802104807077148      ,
   4.02690988700681      ,
 -0.797797498381979      ,
   3.73268647148052      ,
 -0.799910287178033      ,
   3.87479856789001      ,
 -0.797797498381979      ,
   3.73268647148052      ,
 -0.793728903763974      ,
   3.47169506685745      ,
 -0.795726322296505      ,
   3.59768166515541      ,
 -0.793728903763974      ,
   3.47169506685745      ,
 -0.789859804312929      ,
   3.23997835016987      ,
 -0.791760932331599      ,
   3.35175643897007      ,
 -0.789859804312929      ,
   3.23997835016987      ,
 -0.786168983327630      ,
   3.03487321612216      ,
 -0.787984209917935      ,
   3.13375022291343      ,
 -0.786168983327630      ,
   3.03487321612216      ,
 -0.782621771067605      ,
   2.85311875412980      ,
 -0.784367982153253      ,
   2.94067273982437      ,
 -0.782621771067605      ,
   2.85311875412980      ,
 -0.779182857262425      ,
   2.69175192537211      ,
 -0.780877276157895      ,
   2.76941419956742      ,
 -0.779182857262425      ,
   2.69175192537211      ,
 -0.775838285287643      ,
   2.54903314338265      ,
 -0.777487785329904      ,
   2.61766284561167      ,
 -0.775838285287643      ,
   2.54903314338265      ,
 -0.772571426640124      ,
   2.42313757983639      ,
 -0.774184163089351      ,
   2.48362972218175      ,
 -0.772571426640124      ,
   2.42313757983639      ,
 -0.769362387021537      ,
   2.31221028039649      ,
 -0.770948101918804      ,
   2.36546937630448      ,
 -0.769362387021537      ,
   2.31221028039649      ,
 -0.766194507123061      ,
   2.21463060669493      ,
 -0.767761365606971      ,
   2.26144883486246      ,
 -0.766194507123061      ,
   2.21463060669493      ,
 -0.763050410086360      ,
   2.12886034169279      ,
 -0.764606928722485      ,
   2.16998786892991      ,
 -0.763050410086360      ,
   2.12886034169279      ,
 -0.759893610753583      ,
   2.05304849422259      ,
 -0.761457696177049      ,
   2.08937409104820      ,
 -0.759893610753583      ,
   2.05304849422259      ,
 -0.756714368576382      ,
   1.98620369493796      ,
 -0.758290830383095      ,
   2.01821795142636      ,
 -0.756714368576382      ,
   1.98620369493796      ,
 -0.753500057621555      ,
   1.92728787703993      ,
 -0.755095110469980      ,
   1.95550038549886      ,
 -0.753500057621555      ,
   1.92728787703993      ,
 -0.750216594735174      ,
   1.87498961516898      ,
 -0.751847031232291      ,
   1.90003191717642      ,
 -0.750216594735174      ,
   1.87498961516898      ,
 -0.746843701787178      ,
   1.82839563237725      ,
 -0.748519535545883      ,
   1.85071425086546      ,
 -0.746843701787178      ,
   1.82839563237725      ,
 -0.743357525412187      ,
   1.78662677987924      ,
 -0.745090540368366      ,
   1.80665048846561      ,
 -0.743357525412187      ,
   1.78662677987924      ,
 -0.739741820716518      ,
   1.74896119681090      ,
 -0.741540040570160      ,
   1.76704462926410      ,
 -0.739741820716518      ,
   1.74896119681090      ,
 -0.735979089506578      ,
   1.71469688689590      ,
 -0.737851147073474      ,
   1.73118329004367      ,
 -0.735979089506578      ,
   1.71469688689590      ,
 -0.732035277887326      ,
   1.68304777270446      ,
 -0.733997997799122      ,
   1.69831719451043      ,
 -0.732035277887326      ,
   1.68304777270446      ,
 -0.727868076783276      ,
   1.65326953820142      ,
 -0.729942376993927      ,
   1.66768149571055      ,
 -0.727868076783276      ,
   1.65326953820142      ,
 -0.723406601814754      ,
   1.62453943701042      ,
 -0.725627561407565      ,
   1.63849001753494      ,
 -0.723406601814754      ,
   1.62453943701042      ,
 -0.718546914263118      ,
   1.59597840372192      ,
 -0.720965981914507      ,
   1.60989168531013      ,
 -0.718546914263118      ,
   1.59597840372192      ,
 -0.713300604245161      ,
   1.56745267816089      ,
 -0.715911930735276      ,
   1.58139823908348      ,
 -0.713300604245161      ,
   1.56745267816089      ,
 -0.707571545501588      ,
   1.53824481809453      ,
 -0.710422603356932      ,
   1.55256657698693      ,
 -0.707571545501588      ,
   1.53824481809453      ,
 -0.701231645399274      ,
   1.50759538580116      ,
 -0.704385644456745      ,
   1.52265711859079      ,
 -0.701231645399274      ,
   1.50759538580116      ,
 -0.694187271620332      ,
   1.47502136324024      ,
 -0.697690222890406      ,
   1.49105170258478      ,
 -0.694187271620332      ,
   1.47502136324024      ,
 -0.686369793497366      ,
   1.44023989651543      ,
 -0.690255212513427      ,
   1.45736735228680      ,
 -0.686369793497366      ,
   1.44023989651543      ,
 -0.677786711941601      ,
   1.40337716658855      ,
 -0.682050432763466      ,
   1.42152957822543      ,
 -0.677786711941601      ,
   1.40337716658855      ,
 -0.668604202982245      ,
   1.36525780778330      ,
 -0.673163846151488      ,
   1.38402468334305      ,
 -0.668604202982245      ,
   1.36525780778330      ,
 -0.659063899677322      ,
   1.32696129315011      ,
 -0.663800118894792      ,
   1.34581208404992      ,
 -0.659063899677322      ,
   1.32696129315011      ,
 -0.649373042612103      ,
   1.28933800034568      ,
 -0.654183626477370      ,
   1.30785712722262      ,
 -0.649373042612103      ,
   1.28933800034568      ,
 -0.639667067870162      ,
   1.25288178014142      ,
 -0.644485253438189      ,
   1.27082879020867      ,
 -0.639667067870162      ,
   1.25288178014142      ,
 -0.629996943184205      ,
   1.21772513350353      ,
 -0.634797599173553      ,
   1.23503564250769      ,
 -0.629996943184205      ,
   1.21772513350353      ,
 -0.620378232425885      ,
   1.18385855753072      ,
 -0.625153672806073      ,
   1.20053733978915      ,
 -0.620378232425885      ,
   1.18385855753072      ,
 -0.610818578709665      ,
   1.15124249988480      ,
 -0.615565019301325      ,
   1.16730899407192      ,
 -0.610818578709665      ,
   1.15124249988480      ,
 -0.601309923409326      ,
   1.11978615069271      ,
 -0.606031320176602      ,
   1.13528468131214      ,
 -0.601309923409326      ,
   1.11978615069271      ,
 -0.591853202985853      ,
   1.08943319310167      ,
 -0.596549076918939      ,
   1.10439134795210      ,
 -0.591853202985853      ,
   1.08943319310167      ,
 -0.582452926410645      ,
   1.06014052655538      ,
 -0.587121035720519      ,
   1.07457946159212      ,
 -0.582452926410645      ,
   1.06014052655538      ,
 -0.573109186656833      ,
   1.03185284599167      ,
 -0.577749466337348      ,
   1.04579962837699      ,
 -0.573109186656833      ,
   1.03185284599167      ,
 -0.563820344330008      ,
   1.00451237141023      ,
 -0.568433583400894      ,
   1.01799525972908      ,
 -0.563820344330008      ,
   1.00451237141023      ,
 -0.554584711523296      ,
  0.978064205883255      ,
 -0.559171722706823      ,
  0.991110048085955      ,
 -0.554584711523296      ,
  0.978064205883255      ,
 -0.545401574273583      ,
  0.952459026129184      ,
 -0.549962689569412      ,
  0.965091950249618      ,
 -0.545401574273583      ,
  0.952459026129184      ,
 -0.536270987816110      ,
  0.927652059275759      ,
 -0.540806159405506      ,
  0.939893969476989      ,
 -0.536270987816110      ,
  0.927652059275759      ,
 -0.527192665952851      ,
  0.903599831091507      ,
 -0.531702014171500      ,
  0.915471990170288      ,
 -0.527192665952851      ,
  0.903599831091507      ,
 -0.518166094820334      ,
  0.880260499313524      ,
 -0.522649852113943      ,
  0.891783367286699      ,
 -0.518166094820334      ,
  0.880260499313524      ,
 -0.509190738000084      ,
  0.857594356980613      ,
 -0.513649147771762      ,
  0.868787346413725      ,
 -0.509190738000084      ,
  0.857594356980613      ,
 -0.500266832167140      ,
  0.835565698634419      ,
 -0.504699756170871      ,
  0.846446264585195      ,
 -0.500266832167140      ,
  0.835565698634419      ,
 -0.491395317981418      ,
  0.814142372262536      ,
 -0.495802270435856      ,
  0.824726229658688      ,
 -0.491395317981418      ,
  0.814142372262536      ,
 -0.482576704615157      ,
  0.793292892411481      ,
 -0.486957412612908      ,
  0.803595424506581      ,
 -0.482576704615157      ,
  0.793292892411481      ,
 -0.473811701444245      ,
  0.772987950436062      ,
 -0.478165793277775      ,
  0.783023472348279      ,
 -0.473811701444245      ,
  0.772987950436062      ,
 -0.465101279433723      ,
  0.753200456404191      ,
 -0.469428254362357      ,
  0.762982194668887      ,
 -0.465101279433723      ,
  0.753200456404191      ,
 -0.456446643442510      ,
  0.733905375458844      ,
 -0.460745885430417      ,
  0.743445547966448      ,
 -0.456446643442510      ,
  0.733905375458844      ,
 -0.447849233432690      ,
  0.715079641232469      ,
 -0.452120010630032      ,
  0.724389499606524      ,
 -0.447849233432690      ,
  0.715079641232469      ,
 -0.439310722598872      ,
  0.696702068487790      ,
 -0.443552188350585      ,
  0.705791940897398      ,
  0.835242061918225      ,
  2.347782771228186E-003 ,
  0.835200629366426      ,
 -1.018813873354829E-002 ,
  0.834987287817144      ,
 -2.601844642655033E-002 ,
  0.834541651908484      ,
 -4.476440435420626E-002 ,
  0.833798329845744      ,
 -6.610240711048167E-002 ,
  0.832689443344754      ,
 -8.970303835839277E-002 ,
  0.831149551312351      ,
 -0.115192614550969      ,
  0.829121596528525      ,
 -0.142145413772502      ,
  0.826561818516290      ,
 -0.170103151046041      ,
  0.823441438449576      ,
 -0.198613788468519      ,
  0.819743585040557      ,
 -0.227277963330574      ,
  0.815458038967865      ,
 -0.255772792301071      ,
  0.810575910781467      ,
 -0.283853357663317      ,
  0.805084310741727      ,
 -0.311345673167837      ,
  0.798957889482792      ,
 -0.338149141779401      ,
  0.792135836999455      ,
 -0.364280480615916      ,
  0.784374641662461      ,
 -0.390262882629638      ,
  0.775264085844545      ,
 -0.416741587426193      ,
  0.765612996319093      ,
 -0.441087869737306      ,
  0.757440335599367      ,
 -0.459474770471369      ,
  0.750979921139084      ,
 -0.473074044454901      ,
  0.745424330000340      ,
 -0.484541017528032      ,
  0.740505089322368      ,
 -0.494945808996464      ,
  0.736046773638823      ,
 -0.505035285521886      ,
  0.731951922908004      ,
 -0.515349590907156      ,
  0.728147728000629      ,
 -0.526366172261022      ,
  0.724579515588663      ,
 -0.538527763894142      ,
  0.721201745896018      ,
 -0.552272805857309      ,
  0.717974622242052      ,
 -0.568053616548576      ,
  0.714866174343933      ,
 -0.586326689937874      ,
  0.711846990913187      ,
 -0.607574780693608      ,
  0.708890765460290      ,
 -0.632304124692674      ,
  0.705972217573832      ,
 -0.661059611505763      ,
  0.703062039587246      ,
 -0.694491027878550      ,
  0.700138319716705      ,
 -0.733237823664452      ,
  0.697183302712846      ,
 -0.777921893572264      ,
  0.694173778288253      ,
 -0.829281025236110      ,
  0.691079205272510      ,
 -0.888258716025322      ,
  0.687876969153722      ,
 -0.955739130984927      ,
  0.684537291485907      ,
  -1.03282528487008      ,
  0.681029301129663      ,
  -1.12074301629082      ,
  0.677322902488464      ,
  -1.22078608553799      ,
  0.673389146979482      ,
  -1.33428187788576      ,
  0.669193952105803      ,
  -1.46276274820710      ,
  0.664693699108702      ,
  -1.60813896055907      ,
  0.659841442713408      ,
  -1.77253811722312      ,
  0.654592826980812      ,
  -1.95808902854829      ,
  0.648903106724583      ,
  -2.16698842853810      ,
  0.642711465620192      ,
  -2.40208662825642      ,
  0.635942362259476      ,
  -2.66690471052531      ,
  0.628519844840180      ,
  -2.96509652746067      ,
  0.620362271763926      ,
  -3.30063165541556      ,
  0.611380724654455      ,
  -3.67785384937159      ,
  0.601474396815963      ,
  -4.10167629636901      ,
  0.590523299927071      ,
  -4.57791075464144      ,
  0.578390390859527      ,
  -5.11319815968265      ,
  0.564927480924959      ,
  -5.71475029383070      ,
  0.549976271616605      ,
  -6.39028811878962      ,
  0.533356726446618      ,
  -7.14855642977066      ,
  0.514845801120426      ,
  -8.00030894689099      ,
  0.494200988960186      ,
  -8.95724097584947      ,
  0.471150995681592      ,
  -10.0323997767451      ,
  0.445391197227372      ,
  -11.2403792174455      ,
  0.416577730141288      ,
  -12.5975750231130      ,
  0.384317662605277      ,
  -14.1226199264712      ,
  0.348163334875060      ,
  -15.8366140358131      ,
  0.307607535555377      ,
  -17.7632996374352      ,
  0.262070434670850      ,
  -19.9296082034154      ,
  0.210877559490579      ,
  -22.3666103728603      ,
  0.153255037037395      ,
  -25.1096089334777      ,
  8.836674824741528E-002 ,
  -28.1961908099713      ,
  1.529638666285613E-002 ,
  -31.6668582082911      ,
 -6.701561714414044E-002 ,
  -35.5677407666750      ,
 -0.159797395203742      ,
  -39.9514045379814      ,
 -0.264482288050253      ,
  -44.8780525753869      ,
 -0.382704740950885      ,
  -50.4146185929926      ,
 -0.516314361908711      ,
  -56.6345032493772      ,
 -0.667439185124699      ,
  -63.6192927672538      ,
 -0.838609150858486      ,
  -71.4627326952328      ,
  -1.03288373543291      ,
  -80.2740288104702      ,
  -1.25380414604244      ,
  -90.1720965088701      ,
  -1.50546057304474      ,
  -101.283809253422      ,
  -1.79271656611003      ,
  -113.747072006199      ,
  -2.12134090946112      ,
  -127.706349036252      ,
  -2.49831298379738      ,
  -143.310427700434      ,
  -2.93172756780857      ,
  -160.685656355539      ,
  -3.42466805191068      ,
  -179.672534378916      ,
  -3.95616730737241      ,
  -199.162808462142      ,
  -4.49885701519891      ,
  -217.937842906832      ,
  -5.05513132631346      ,
  -235.910371306854      ,
  -5.62584929980020      ,
  -252.896597886131      ,
  -6.21172552982513      ,
  -268.659369567311      ,
  -6.81107087895837      ,
  -282.845792050380      ,
  -7.42273338415528      ,
  -295.066165017713      ,
  -8.04480791775885      ,
  -304.847755439538      ,
  -8.67423981579659      ,
  -311.621902666660      ,
  -9.30687349766895      ,
  -314.720476532940      ,
  -9.93728307617138      ,
  -313.366934496661      ,
  -10.5602943491847      ,
  -306.638858255266      ,
  -11.1580996705211      ,
  -293.703380955323      ,
  -11.6901171315491      ,
  -275.022429567724      ,
  -12.1344319715449      ,
  -252.164848989889      ,
  -12.4996130707690      ,
  -226.149401681036      ,
  -12.7947343739758      ,
  -197.835847740062      ,
  -13.0277934941517      ,
  -168.016060762845      ,
  -13.2048446029230      ,
  -137.686582771398      ,
  -13.3333014226632      ,
  -107.713529861755      ,
  -13.4211430033022      ,
  -78.7660476148150      ,
  -13.4748620296455      ,
  -52.1204550618881      ,
  -13.5027686575432      ,
  -28.7858478737286      ,
  -13.5134050642970      ,
  -9.35413619914260      ,
  -13.5134880191777      ,
   9.09591723252035      ,
  -13.5003288520102      ,
   32.3237896028110      ,
  -13.4648861966220      ,
   60.7365590380900      ,
  -13.4000078369665      ,
   92.8129410819360      ,
  -13.2985321261493      ,
   128.079983989667      ,
  -13.1545850053856      ,
   165.762505267058      ,
  -12.9620436894677      ,
   205.274833684908      ,
  -12.7121800642317      ,
   246.321696139750      ,
  -12.3950962925979      ,
   288.299373749691      ,
  -12.0032149310119      ,
   329.903660880825      ,
  -11.5254235746148      ,
   369.839775764301      ,
  -10.9538183473126      ,
   406.043095575573      ,
  -10.3331713140429      ,
   434.139434236240      ,
  -9.73653541990379      ,
   452.013502734054      ,
  -9.17061765419866      ,
   461.755167321205      ,
  -8.62247496548749      ,
   465.139853604876      ,
  -8.08720991488961      ,
   463.124731806679      ,
  -7.56537791764710      ,
   456.397107953864      ,
  -7.05735174974973      ,
   445.543836901680      ,
  -6.56374451396752      ,
   431.087709157984      ,
  -6.08506413025374      ,
   413.501841470504      ,
  -5.62121148844128      ,
   393.194558200242      ,
  -5.17154373582113      ,
   370.501648483458      ,
  -4.73668192218446      ,
   345.785675544283      ,
  -4.32012405586558      ,
   319.587023835621      ,
  -3.92447839724997      ,
   292.437826668559      ,
  -3.54707901742313      ,
   264.495291105409      ,
  -3.18216463802738      ,
   235.583266620735      ,
  -2.83263890363879      ,
   206.144510798944      ,
  -2.52792789402155      ,
   179.082823647571      ,
  -2.28775990500620      ,
   156.832060023988      ,
  -2.09463551627538      ,
   138.347989339912      ,
  -1.93387065929314      ,
   122.557337733714      ,
  -1.79657191286132      ,
   108.780738676482      ,
  -1.67813250041899      ,
   96.6815999644294      ,
  -1.57528304817664      ,
   86.0146086597087      ,
  -1.48556240842274      ,
   76.5890501432952      ,
  -1.40696858849571      ,
   68.2424096307705      ,
  -1.33788215116311      ,
   60.8384592688709      ,
  -1.27702043608893      ,
   54.2667687580829      ,
  -1.22332072570405      ,
   48.4331779671828      ,
  -1.17584157771943      ,
   43.2510726587260      ,
  -1.13375582768736      ,
   38.6420015342631      ,
  -1.09640981267769      ,
   34.5432783263693      ,
  -1.06323687727795      ,
   30.8993475572105      ,
  -1.03371837715664      ,
   27.6580758083024      ,
  -1.00740595703063      ,
   24.7736520000024      ,
 -0.983913735086916      ,
   22.2060791306879      ,
 -0.962903263279107      ,
   19.9197877086240      ,
 -0.944082378027310      ,
   17.8837044569204      ,
 -0.927196087556343      ,
   16.0703994145528      ,
 -0.912017512351089      ,
   14.4552171413914      ,
 -0.898349174064163      ,
   13.0164956880180      ,
 -0.886017742171453      ,
   11.7350559927523      ,
 -0.874869320194619      ,
   10.5937447490832      ,
 -0.864767538886355      ,
   9.57726604989619      ,
 -0.855592732999146      ,
   8.67210855951572      ,
 -0.847238669418114      ,
   7.86621824703402      ,
 -0.839596671757255      ,
   7.14751774731616      ,
 -0.832579117686746      ,
   6.50620518454638      ,
 -0.826132330564890      ,
   5.93573162148730      ,
 -0.820189014054619      ,
   5.42840628812561      ,
 -0.814687606977662      ,
   4.97725545271179      ,
 -0.809576849769116      ,
   4.57637543300697      ,
 -0.804809992230152      ,
   4.22041324027214      ,
 -0.800342474900491      ,
   3.90439912176753      ,
 -0.796134493799397      ,
   3.62394108683569      ,
 -0.792149028484250      ,
   3.37507267511284      ,
 -0.788354360900436      ,
   3.15439053419308      ,
 -0.784723670951137      ,
   2.95896508660624      ,
 -0.781222049054531      ,
   2.78565665480189      ,
 -0.777823042397353      ,
   2.63202983203525      ,
 -0.774511573341815      ,
   2.49630440561323      ,
 -0.771269662403233      ,
   2.37663810751238      ,
 -0.768078748501386      ,
   2.27127437164323      ,
 -0.764921878152382      ,
   2.17862474560612      ,
 -0.761773872293265      ,
   2.09700865406943      ,
 -0.758609210005925      ,
   2.02494959445363      ,
 -0.755416960177333      ,
   1.96143330981243      ,
 -0.752175768123570      ,
   1.90529809088719      ,
 -0.748857192301211      ,
   1.85540539845623      ,
 -0.745439507795681      ,
   1.81085493954932      ,
 -0.741901947279895      ,
   1.77083485977443      ,
 -0.738227747608193      ,
   1.73462983715896      ,
 -0.734392705149345      ,
   1.70149914481683      ,
 -0.730359430967182      ,
   1.67067374389591      ,
 -0.726074063908936      ,
   1.64137536087834      ,
 -0.721452346243700      ,
   1.61275855035108      ,
 -0.716437001195176      ,
   1.58426010285312      ,
 -0.710996014774685      ,
   1.55549572256934      ,
 -0.705020237469189      ,
   1.52573007057040      ,
 -0.698395390891164      ,
   1.49431727540493      ,
 -0.691037847938267      ,
   1.46085431364475      ,
 -0.682909799823279      ,
   1.42522560012388      ,
 -0.674083299339462      ,
   1.38784714522021      ,
 -0.664755439049115      ,
   1.34965258675804      ,
 -0.655154036616134      ,
   1.31163019574808      ,
 -0.645457174288577      ,
   1.27448476044995      ,
 -0.635765920799008      ,
   1.23856117843555      ,
 -0.626116835235240      ,
   1.20393338446148      ,
 -0.616522256830592      ,
   1.17057951311321      ,
 -0.606983441397333      ,
   1.13843879389688      ,
 -0.597495988593276      ,
   1.10743470640257      ,
 -0.588062286483544      ,
   1.07751639050080      ,
 -0.578685047584224      ,
   1.04863567957326      ,
 -0.569363660216880      ,
   1.02073623416318      ,
 -0.560096465049715      ,
  0.993761457298559      ,
 -0.550882169769126      ,
  0.967658746038488      ,
 -0.541720372692480      ,
  0.942380646770932      ,
 -0.532610990014611      ,
  0.917882913741557      ,
 -0.523553642812594      ,
  0.894122738228269      ,
 -0.514547807892353      ,
  0.871059151556951      ,
 -0.505593262785446      ,
  0.848654089061217      ,
 -0.496690530048744      ,
  0.826873301940895      ,
 -0.487840374983854      ,
  0.805684906341029      ,
 -0.479043388095706      ,
  0.785058307061430      ,
 -0.470300385089314      ,
  0.764965102960099      ,
 -0.461612432075055      ,
  0.745379044338371      ,
 -0.452980829623307      ,
  0.726275901055213      ,
 -0.444407112729926      ,
  0.707633375678311      ,
   0.00000000000000      ,
  1.100335634208356E-002 ,
  2.262291472487897E-002 ,
  3.495119398145768E-002 ,
  4.805755823393220E-002 ,
  6.197909464422609E-002 ,
  7.671080713114965E-002 ,
  9.220261475050895E-002 ,
  0.108369249925636      ,
  0.125104043712312      ,
  0.142306989404985      ,
  0.159903997204620      ,
  0.177854206736695      ,
  0.196150410768008      ,
  0.214822942828523      ,
  0.233960632268771      ,
  0.253796953401810      ,
  0.275452202078203      ,
  0.299391410069007      ,
  0.319714420307507      ,
  0.334597371620216      ,
  0.346910375309560      ,
  0.357449819464559      ,
  0.366754959824991      ,
  0.375093300525790      ,
  0.382655901268460      ,
  0.389576861403941      ,
  0.395955448926753      ,
  0.401877270026111      ,
  0.407404337643207      ,
  0.412585051531817      ,
  0.417466133243039      ,
  0.422074193881779      ,
  0.426453376432033      ,
  0.430627626123301      ,
  0.434614193753623      ,
  0.438420600940903      ,
  0.442082560687107      ,
  0.445607340655907      ,
  0.449011983131700      ,
  0.452311139320941      ,
  0.455515870470028      ,
  0.458632047362489      ,
  0.461664396878025      ,
  0.464623732176986      ,
  0.467520380114340      ,
  0.470360153091872      ,
  0.473143141389397      ,
  0.475873143570174      ,
  0.478561569381885      ,
  0.481213628579060      ,
  0.483832756914831      ,
  0.486421266720274      ,
  0.488981092048285      ,
  0.491515590453622      ,
  0.494029608472061      ,
  0.496525555978692      ,
  0.499005470626103      ,
  0.501468236778135      ,
  0.503918766837039      ,
  0.506359549970908      ,
  0.508792444217381      ,
  0.511219031332462      ,
  0.513640591390724      ,
  0.516058638266307      ,
  0.518474967576014      ,
  0.520891133633835      ,
  0.523308718537007      ,
  0.525729605649677      ,
  0.528156713702640      ,
  0.530591363730371      ,
  0.533032560400763      ,
  0.535480636857452      ,
  0.537936503053969      ,
  0.540402342351316      ,
  0.542880587975196      ,
  0.545373013042307      ,
  0.547881591539264      ,
  0.550408904089385      ,
  0.552960273209118      ,
  0.555541434720794      ,
  0.558156807120028      ,
  0.560812304132705      ,
  0.563514724384702      ,
  0.566272287984965      ,
  0.569096500307244      ,
  0.571994149281918      ,
  0.574893678160154      ,
  0.577562244870104      ,
  0.580066228187644      ,
  0.582438862833867      ,
  0.584717072075112      ,
  0.586914897524289      ,
  0.589049691649958      ,
  0.591136607152804      ,
  0.593187291078691      ,
  0.595211939587733      ,
  0.597219797736443      ,
  0.599220002459082      ,
  0.601236021798608      ,
  0.603181593797502      ,
  0.604931336071510      ,
  0.606512813358445      ,
  0.607951094241229      ,
  0.609267937514103      ,
  0.610472420241250      ,
  0.611556727584061      ,
  0.612543342640713      ,
  0.613414872650132      ,
  0.614156379530366      ,
  0.614765831009619      ,
  0.615243076373487      ,
  0.615818607869942      ,
  0.616547023677556      ,
  0.617360650343388      ,
  0.618253947378103      ,
  0.619211393894224      ,
  0.620224440502167      ,
  0.621298714807991      ,
  0.622452272840511      ,
  0.623685124124056      ,
  0.625002078490156      ,
  0.626436144052277      ,
  0.627962542809264      ,
  0.629360167124464      ,
  0.630625400154492      ,
  0.631820543490555      ,
  0.632981689104104      ,
  0.634120496176820      ,
  0.635247502440498      ,
  0.636371262622583      ,
  0.637499215030948      ,
  0.638639565864191      ,
  0.639802774213952      ,
  0.641000967642479      ,
  0.642238499709654      ,
  0.643512154360899      ,
  0.644834125748701      ,
  0.646240186939281      ,
  0.647781474396376      ,
  0.649429203805697      ,
  0.650916838284012      ,
  0.652264011474522      ,
  0.653517855822376      ,
  0.654721038437623      ,
  0.655886697120193      ,
  0.657023348131643      ,
  0.658135962106530      ,
  0.659228698456853      ,
  0.660305630618430      ,
  0.661369052810569      ,
  0.662420370182231      ,
  0.663460477183997      ,
  0.664492256232244      ,
  0.665516794800557      ,
  0.666534094696304      ,
  0.667545268990834      ,
  0.668551585355737      ,
  0.669553908620455      ,
  0.670553252806239      ,
  0.671550578482224      ,
  0.672546454979785      ,
  0.673541826027341      ,
  0.674537515945202      ,
  0.675534228651355      ,
  0.676532730174369      ,
  0.677533920285493      ,
  0.678538681906846      ,
  0.679547774299333      ,
  0.680562296438235      ,
  0.681588011227534      ,
  0.682621776559393      ,
  0.683664371192879      ,
  0.684717902968108      ,
  0.685783540012586      ,
  0.686862304746292      ,
  0.687956013271590      ,
  0.689067156691817      ,
  0.690197577872536      ,
  0.691351459468297      ,
  0.692528764072961      ,
  0.693734568610106      ,
  0.694975864968838      ,
  0.696253114946013      ,
  0.697568038137907      ,
  0.698924235367711      ,
  0.700324647128080      ,
  0.701773156792874      ,
  0.703283658742081      ,
  0.704858564437505      ,
  0.706501943675315      ,
  0.708229717512524      ,
  0.710051878170522      ,
  0.711981206981739      ,
  0.714027105312941      ,
  0.716200337599792      ,
  0.718522272494717      ,
  0.721020833347344      ,
  0.723743522386077      ,
  0.726761935430227      ,
  0.730079227069595      ,
  0.733769060261726      ,
  0.737932528878917      ,
  0.742656690744089      ,
  0.748020477293239      ,
  0.754058002147698      ,
  0.760692176787729      ,
  0.767780536721710      ,
  0.775189705828421      ,
  0.782826658370081      ,
  0.790655926953988      ,
  0.798667365488400      ,
  0.806856280730674      ,
  0.815231285138888      ,
  0.823793555501467      ,
  0.832540858224178      ,
  0.841474838179032      ,
  0.850598920479261      ,
  0.859916835492246      ,
  0.869431575656443      ,
  0.879145504656619      ,
  0.889061496722461      ,
  0.899182873951422      ,
  0.909513220604156      ,
  0.920055456008617      ,
  0.930811820514578      ,
  0.941785210961969      ,
  0.952978447351692      ,
  0.964394173499655      ,
  0.976034863799672      ,
  0.987902791916224      ,
   1.00000000000000      ,
  0.912900000000000      ,
  0.835222672326810      ,
  0.922090432092020      ,
  0.835235013774867      ,
  0.931794865501035      ,
  0.835098672682569      ,
  0.942088301764630      ,
  0.834755359400891      ,
  0.953025176809137      ,
  0.834141356203884      ,
  0.964631443907501      ,
  0.833188974070262      ,
  0.976896187549458      ,
  0.831830666070875      ,
  0.989769135803261      ,
  0.830005036376684      ,
   1.00316918996730      ,
  0.827662393248424      ,
   1.01699639701836      ,
  0.824768500444846      ,
   1.03115574163698      ,
  0.821302818945943      ,
   1.04557332465638      ,
  0.817253579523141      ,
   1.06020230079623      ,
  0.812612292179667      ,
   1.07502282751517      ,
  0.807368861701238      ,
   1.09004449395837      ,
  0.801505582386575      ,
   1.10532186656610      ,
  0.794984771472864      ,
   1.12102012071805      ,
  0.787708895021427      ,
   1.13798707287570      ,
  0.779202412188282      ,
   1.15652168255055      ,
  0.769163967506117      ,
   1.17206261981653      ,
  0.760158038374308      ,
   1.18332523789973      ,
  0.753298028851461      ,
   1.19256479872399      ,
  0.747458151350407      ,
   1.20041571928586      ,
  0.742339923032238      ,
   1.20730189669633      ,
  0.737724662125763      ,
   1.21343576116658      ,
  0.733504653446509      ,
   1.21896824543677      ,
  0.729598732341869      ,
   1.22400517955741      ,
  0.725947175472503      ,
   1.22862475759129      ,
  0.722503200849904      ,
   1.23289362423130      ,
  0.719223242767641      ,
   1.23686015868275      ,
  0.716073322397812      ,
   1.24056207710345      ,
  0.713024579024952      ,
   1.24403518703457      ,
  0.710046731937122      ,
   1.24730042924302      ,
  0.707119646550875      ,
   1.25039071458782      ,
  0.704209963808279      ,
   1.25332423130245      ,
  0.701294659922575      ,
   1.25611418344924      ,
  0.698353567656672      ,
   1.25876678709336      ,
  0.695372791536918      ,
   1.26130767655633      ,
  0.692314243134705      ,
   1.26374243808538      ,
  0.689159395034135      ,
   1.26608326588556      ,
  0.685879066073023      ,
   1.26834049482834      ,
  0.682442482641968      ,
   1.27052181410278      ,
  0.678818607744812      ,
   1.27263123775768      ,
  0.674978910236385      ,
   1.27467190971617      ,
  0.670893820758203      ,
   1.27665094148197      ,
  0.666521905894140      ,
   1.27857491456978      ,
  0.661815999322536      ,
   1.28044721854098      ,
  0.656729603187705      ,
   1.28226735422284      ,
  0.651222034426053      ,
   1.28403716820831      ,
  0.645241961974154      ,
   1.28576322908719      ,
  0.638712971164773      ,
   1.28744781688641      ,
  0.631561168177087      ,
   1.28909185464395      ,
  0.623707413704795      ,
   1.29069534446111      ,
  0.615066173795639      ,
   1.29225783875941      ,
  0.605543200151669      ,
   1.29377950377923      ,
  0.595027091676589      ,
   1.29526104610658      ,
  0.583383929412642      ,
   1.29670132602022      ,
  0.570471952374585      ,
   1.29809859843300      ,
  0.556132779914829      ,
   1.29944898086062      ,
  0.540208893366565      ,
   1.30075146716979      ,
  0.522483212054227      ,
   1.30200307432361      ,
  0.502723580395578      ,
   1.30319982812662      ,
  0.480671114036552      ,
   1.30433689314460      ,
  0.456034813151447      ,
   1.30540848924173      ,
  0.428488458253740      ,
   1.30640803124277      ,
  0.397660011266545      ,
   1.30732797834492      ,
  0.363123121278679      ,
   1.30815945321338      ,
  0.324396262228339      ,
   1.30889217521361      ,
  0.280931276008125      ,
   1.30951430292922      ,
  0.232097657132330      ,
   1.31001223124713      ,
  0.177150007582861      ,
   1.31036965608013      ,
  0.115270102203092      ,
   1.31056765320224      ,
  4.559568029268677E-002 ,
   1.31058508156409      ,
 -3.287612571584040E-002 ,
   1.31039787198210      ,
 -0.121295156027454      ,
   1.30997821269242      ,
 -0.221015251130638      ,
   1.30929368492218      ,
 -0.333596316857481      ,
   1.30830678413914      ,
 -0.460789733869814      ,
   1.30697397290988      ,
 -0.604600486545071      ,
   1.30524428072304      ,
 -0.767351854421650      ,
   1.30305560899870      ,
 -0.951907071510003      ,
   1.30033315320451      ,
  -1.16163744399335      ,
   1.29698892646592      ,
  -1.40034721924509      ,
   1.29291584548469      ,
  -1.67257933411595      ,
   1.28798355988784      ,
  -1.98369983284562      ,
   1.28203142745877      ,
  -2.34010612643587      ,
   1.27485516123175      ,
  -2.74968921328586      ,
   1.26621789656422      ,
  -3.22079284970620      ,
   1.25612918344614      ,
  -3.74759944241018      ,
   1.24542374036578      ,
  -4.28422246115700      ,
   1.23401667968809      ,
  -4.83454226330057      ,
   1.22188533295190      ,
  -5.39838076624840      ,
   1.20893326662360      ,
  -5.97819262359425      ,
   1.19514785541887      ,
  -6.57183540630283      ,
   1.18047594120652      ,
  -7.17831240511950      ,
   1.16485461500651      ,
  -7.79617854579230      ,
   1.14822747535331      ,
  -8.42275949178029      ,
   1.13053655280301      ,
  -9.05435860313188      ,
   1.11172268538822      ,
  -9.68605253792826      ,
   1.09172153343900      ,
  -10.3115705856952      ,
   1.07030912460251      ,
  -10.9271737263283      ,
   1.04849201423765      ,
  -11.4948435412652      ,
   1.02795616519909      ,
  -11.9719277851021      ,
   1.00870566769064      ,
  -12.3664699247436      ,
  0.990683581078963      ,
  -12.6875345681945      ,
  0.973802986863487      ,
  -12.9439963044765      ,
  0.958088911394403      ,
  -13.1425680209539      ,
  0.943756264251976      ,
  -13.2884939804885      ,
  0.930592287527898      ,
  -13.3917705741058      ,
  0.918890360750179      ,
  -13.4579472658506      ,
  0.908896427530859      ,
  -13.4947310940938      ,
  0.900666441075256      ,
  -13.5109771595244      ,
  0.894217197715201      ,
  -13.5146288537788      ,
  0.886440382583023      ,
  -13.5081870784918      ,
  0.876608910876708      ,
  -13.4826658889551      ,
  0.865658488177202      ,
  -13.4307376213202      ,
  0.853696979040187      ,
  -13.3447637266011      ,
  0.840977663107297      ,
  -13.2186032083797      ,
  0.827670325632242      ,
  -13.0467610955084      ,
  0.813771400660915      ,
  -12.8219419461796      ,
  0.799142536137279      ,
  -12.5330599053469      ,
  0.783908021273471      ,
  -12.1726030056270      ,
  0.768160846693185      ,
  -11.7330062007733      ,
  0.751712367233274      ,
  -11.1975048563156      ,
  0.735090623581758      ,
  -10.5732453760493      ,
  0.720735515267956      ,
  -9.96386410684358      ,
  0.708489831306109      ,
  -9.39068274783236      ,
  0.697595969231367      ,
  -8.83839364947299      ,
  0.687646737904020      ,
  -8.29852122691471      ,
  0.678496731849598      ,
  -7.77187042564474      ,
  0.670027924916094      ,
  -7.25872469665641      ,
  0.662152650244320      ,
  -6.75965684487266      ,
  0.654802934092763      ,
  -6.27538205306206      ,
  0.647916431233190      ,
  -5.80614106628012      ,
  0.641429620029782      ,
  -5.35138327370088      ,
  0.635284697839567      ,
  -4.91037754256977      ,
  0.629474022556919      ,
  -4.48566809078726      ,
  0.624021492104511      ,
  -4.08203990655413      ,
  0.618882305071719      ,
  -3.69905996594009      ,
  0.613944566352820      ,
  -3.33109540762128      ,
  0.609092629744847      ,
  -2.97243138405384      ,
  0.604477477591447      ,
  -2.63741119717507      ,
  0.600753996654972      ,
  -2.37444745512839      ,
  0.597698777653274      ,
  -2.16573333791652      ,
  0.595092956228196      ,
  -1.99428331523949      ,
  0.592782917697485      ,
  -1.84850672385238      ,
  0.590702701553189      ,
  -1.72313326987625      ,
  0.588807065477479      ,
  -1.61446562385379      ,
  0.587064459392478      ,
  -1.51982323744127      ,
  0.585449788477562      ,
  -1.43705110192715      ,
  0.583942072923145      ,
  -1.36436189863244      ,
  0.582525855489361      ,
  -1.30036860895163      ,
  0.581188983932826      ,
  -1.24393436350640      ,
  0.579921564779231      ,
  -1.19410067684665      ,
  0.578712720372772      ,
  -1.14995314669637      ,
  0.577554989400109      ,
  -1.11078503597509      ,
  0.576443002152086      ,
  -1.07601663252499      ,
  0.575370881588349      ,
  -1.04510116829384      ,
  0.574333291829895      ,
  -1.01755981499541      ,
  0.573325908116558      ,
 -0.992986887781404      ,
  0.572344745668078      ,
 -0.971024590129366      ,
  0.571386299801576      ,
 -0.951361750933211      ,
  0.570447796046545      ,
 -0.933732852585582      ,
  0.569526405838077      ,
 -0.917897989484154      ,
  0.568619682522712      ,
 -0.903648624829697      ,
  0.567725517327272      ,
 -0.890802868977011      ,
  0.566841941597957      ,
 -0.879199522798457      ,
  0.565967043146016      ,
 -0.868695053135442      ,
  0.565099080078560      ,
 -0.859163207142993      ,
  0.564236550869148      ,
 -0.850493606136034      ,
  0.563377781989567      ,
 -0.842585945479853      ,
  0.562517314234588      ,
 -0.835320380134286      ,
  0.561657288265540      ,
 -0.828653421450309      ,
  0.560796585359050      ,
 -0.822517676182646      ,
  0.559933068172576      ,
 -0.816846121309439      ,
  0.559065449793476      ,
 -0.811584801967549      ,
  0.558192619117219      ,
 -0.806686266068195      ,
  0.557312877897435      ,
 -0.802104807077155      ,
  0.556424047709236      ,
 -0.797797498381986      ,
  0.555524527924272      ,
 -0.793728903763980      ,
  0.554610916701315      ,
 -0.789859804312933      ,
  0.553683207417360      ,
 -0.786168983327634      ,
  0.552737401934666      ,
 -0.782621771067608      ,
  0.551768091455292      ,
 -0.779182857262428      ,
  0.550775035498109      ,
 -0.775838285287646      ,
  0.549757033717419      ,
 -0.772571426640126      ,
  0.548711467536218      ,
 -0.769362387021539      ,
  0.547636277516970      ,
 -0.766194507123063      ,
  0.546528729492552      ,
 -0.763050410086361      ,
  0.545378538951007      ,
 -0.759893610753583      ,
  0.544184295495240      ,
 -0.756714368576383      ,
  0.542943381238385      ,
 -0.753500057621555      ,
  0.541644353103201      ,
 -0.750216594735175      ,
  0.540280423807763      ,
 -0.746843701787178      ,
  0.538842892683073      ,
 -0.743357525412188      ,
  0.537325770582516      ,
 -0.739741820716518      ,
  0.535722241903963      ,
 -0.735979089506578      ,
  0.534017939230383      ,
 -0.732035277887326      ,
  0.532194126036730      ,
 -0.727868076783276      ,
  0.530218458955030      ,
 -0.723406601814753      ,
  0.528042274988566      ,
 -0.718546914263117      ,
  0.525667373246665      ,
 -0.713300604245161      ,
  0.523046015775143      ,
 -0.707571545501588      ,
  0.520113306112893      ,
 -0.701231645399274      ,
  0.516817274277484      ,
 -0.694187271620332      ,
  0.513114850958542      ,
 -0.686369793497366      ,
  0.508996898530846      ,
 -0.677786711941601      ,
  0.504530942109137      ,
 -0.668604202982246      ,
  0.499825607767088      ,
 -0.659063899677322      ,
  0.494978564594998      ,
 -0.649373042612103      ,
  0.490056572707451      ,
 -0.639667067870161      ,
  0.485086482014908      ,
 -0.629996943184205      ,
  0.480078011221350      ,
 -0.620378232425885      ,
  0.475037110319747      ,
 -0.610818578709665      ,
  0.469961503409656      ,
 -0.601309923409326      ,
  0.464853596209763      ,
 -0.591853202985853      ,
  0.459717777386389      ,
 -0.582452926410645      ,
  0.454556081159809      ,
 -0.573109186656833      ,
  0.449369551526652      ,
 -0.563820344330008      ,
  0.444159141256666      ,
 -0.554584711523296      ,
  0.438926292580239      ,
 -0.545401574273583      ,
  0.433672842411761      ,
 -0.536270987816110      ,
  0.428400390916969      ,
 -0.527192665952851      ,
  0.423110354982801      ,
 -0.518166094820334      ,
  0.417804080443377      ,
 -0.509190738000084      ,
  0.412483314795372      ,
 -0.500266832167140      ,
  0.407150181573951      ,
 -0.491395317981418      ,
  0.401806503145918      ,
 -0.482576704615157      ,
  0.396454174389258      ,
 -0.473811701444245      ,
  0.391095202546234      ,
 -0.465101279433723      ,
  0.385731693445562      ,
 -0.456446643442510      ,
  0.380365855177612      ,
 -0.447849233432690      ,
  0.375000000000000      ,
 -0.439310722598872      ])

iworkSol = numpy.array([           3 ,
           4 ,
           4 ])


