#!/bin/bash

PACKAGENAME=sciproc

# begin version control
# -->> for argument, choose between major, minor, sub

IFS_OLD=$IFS
IFS=.
VERSION=(`cat VERSION`)

MAJ=${VERSION[0]}
MIN=${VERSION[1]}
SUB=${VERSION[2]}

if [[ "$1" == "major" ]]
then
    MAJ=$((${VERSION[0]} + 1))
    MIN=0
    SUB=0
fi

if [[ "$1" == "minor" ]]
then
    MIN=$((${VERSION[1]} + 1))
    SUB=0
fi

if [[ "$1" == "sub" ]]
then
    SUB=$((${VERSION[2]} + 1))
fi

IFS=$IFS_OLD

cat > VERSION << end_input
$MAJ.$MIN.$SUB
end_input

#end version control

VERSION=`cat VERSION`
LASTBUILD=`cat LASTBUILD`

# begin version STAMP in CHANGES.txt
if [[ "$VERSION" != "$LASTBUILD" ]]
then
    if [[ "$1" != "''" ]]
    then
       REVISION=": $1 revision - "`date`
       echo -e "\n\n\nVERSION $VERSION$REVISION\n" |cat - CHANGES.txt > /tmp/out && mv /tmp/out CHANGES.txt
    fi
    #then 
    #    REVISION=": custom revision"
    #fi
fi
# end automatic versioning

find ./deb_dist/* -type d -exec rm -r {} \;

# generate setup.py file for package build
cat > setup.py << end_input
# generated by ./ubuntubuild.sh
from distutils.core import setup

setup(
    name='${PACKAGENAME}',
    version='${VERSION}',
    author='H. Wouters',
    author_email='hendrikwout@gmail.com',
    packages=['sciproc'],
    url='http://www.nowebsite.com',
    license='LICENSE.txt',
    description='Process scientific multidimensional data.',
    long_description=open('README.txt').read(),
)

end_input


python setup.py sdist
python setup.py --command-packages=stdeb.command bdist_deb
sudo dpkg -r 'python-'$PACKAGENAME
sudo dpkg -i 'deb_dist/python-'$PACKAGENAME'_'$VERSION'-1_all.deb'


python setup.py sdist upload


cat > LASTBUILD << end_input
$VERSION
end_input
