from contextlib import contextmanager


def stack(manager=None):
    if manager is None:
        manager = yield
    with manager as context:
        next_manager = yield context
        if next_manager is not None:
            yield from stack(next_manager)


@contextmanager
def scope_stack():
    self = stack()
    next(self)
    try:
        yield self
    finally:
        self.send(None)
