from contextlib import contextmanager


def stack(manager=None):
    if manager is None:
        manager = yield
    if manager is None:
        return
    with manager as context:
        next_manager = yield context
        yield from stack(next_manager)


@contextmanager
def scope_stack():
    self = stack()
    next(self)
    yield self
    self.send(None)
    self.close()
