from contextlib import contextmanager


def wrap(manager):
    with manager as value:
        yield value


class ScopeStack():
    def __init__(self):
        self.stack = []

    def add(self, context):
        ctx = wrap(context)
        value = next(ctx)
        self.stack.append(ctx)
        return value

    def unroll(self):
        while self.stack:
            self.stack.pop().close()


@contextmanager
def scope():
    stack = ScopeStack()
    try:
        yield stack
    finally:
        stack.unroll()
