#!/usr/bin/env python
# Setup script

"""Description:
Setup script for scripter
Copyright (c) 2010 Benjamin Schiller <benjamin.schiller@ucsf.edu>
All rights reserved.
"""

import os, sys
from distutils.core import setup
try: import py2exe
except ImportError: pass
try: import py2app
except ImportError: pass

def main():
	if not float(sys.version[:3])>=2.7:
		sys.stderr.write("CRITICAL: Python version must greater than or equal to 2.7! python 2.7.2 is recommended!\n")
		sys.exit(1)
	setup(name='scripter',
	      version='2.9.1',
	      description="""Intended for automation of tasks on multicore computers
rewrote scripter to use logging, argparse
breaks compatibility with scripter < 2.1.0""",
	      author='Benjamin Schiller',
	      author_email='benjamin.schiller@ucsf.edu',
	      requires = ['decorator'],
	      packages = ['scripter'],
	      package_dir = {'scripter': 'src' + os.sep},
  	      classifiers = [
				'Development Status :: 3 - Alpha',
				'License :: OSI Approved :: Artistic License',
				'Intended Audience :: Developers',
				'Intended Audience :: Science/Research',
				'Operating System :: MacOS :: MacOS X',
				'Operating System :: Microsoft :: Windows',
				'Operating System :: POSIX',
				'Programming Language :: Python :: 2.7',
				]
	      )
	
if __name__ == '__main__':
	main()
