import os
import logging
import json
import subprocess
import shlex
from docopt import docopt
from helpers import *

try:
    appName, Version = learn_from_metadatarb()
except:
    raise IOError("Couldn't find a metadata.rb in local file or couldn't find version and application name in metadata.rb")


APP_PARAMS = {
        "vpc":            "vpc-b61f7ddb",
        "subnet":         "subnet-e344118e",
        "region":         "us-east-1",
        "sami":           "ami-723ebe1a",
        "appname":        appName,
        "instance_type":  "c3.large",
        "version":        Version,
        }

try:
    logging.warning("Attempting to get the latest ign-base ami image... this may take a while depending on your network connection!")
    latest_base = get_latest_ign_base_ami()
    logging.warning("Excellent, we've found the new base and it is {0}".format(latest_base))
    APP_PARAMS["sami"] = latest_base
except:
    logging.warning("Failed to get latest ign-base, using {0} default instead".format(APP_PARAMS["sami"]))


def packerize(app_params=APP_PARAMS):
    logging.warning("SCRIPTNADO: attempting this to create AMI with this configuration")
    logging.warning(pretty_print_(json.dumps(APP_PARAMS)))
    logging.warning("SCRIPTNADO: removing old packer.json")
    subprocess.call(shlex.split("rm -rf packer.json"))
    logging.warning("SCRIPTNADO: writing a new packer.json file with the aforementioned configuration")
    write_packer_json_to_file(app_params)
    logging.warning("SCRIPTNADO: removing old vendor directory")
    subprocess.call(shlex.split("rm -rf vendor"))
    logging.warning("SCRIPTNADO: creating new vendor directory for chef-solo to use")
    subprocess.call(shlex.split("berks vendor vendor/cookbooks"))
    logging.warning("SCRIPTNADO: executing packer build process")
    subprocess.call(shlex.split("packer build -machine-readable -var 'packer_build_version={0}' packer.json".format(app_params["version"])))
    logging.warning("SCRIPTNADO: removing left-over packer.json")
    subprocess.call(shlex.split("rm -rf packer.json"))
    logging.warning("SCRIPTNADO: removing the vendor file since it is no longer needed")
    subprocess.call(shlex.split("rm -rf vendor"))
    logging.warning("SCRIPTNADO: The program has finished successfully")


def test_packerize():
    logging.warning("Attemting a test run of packerize with a modified configuration")
    APP_PARAMS["sami"] = get_latest_ign_base_ami()
    logging.warning(APP_PARAMS)
    packerize(APP_PARAMS)


def priliminary_checks_pass():
    required_localdirectory_files = [
            "metadata.rb",
            "Berksfile",
    #        "packer.json",
                                    ]

    for fil in required_localdirectory_files:
        try:
            with open(fil, "r") as f:
                pass
        except:
            raise IOError("Couldn't find {fi} in the local directory, you need it".format(fi=fil))

    return True


def create_ami(params=APP_PARAMS):
    logging.warning("you have entered the create_ami function")
    if priliminary_checks_pass():
        logging.warning("checks passed")
        packerize(params)


if __name__ == '__main__':
    logging.warning("This is a library that shouldn't be executed as an independent script")
