import json
import boto.ec2
import logging

def file_exists(fn):
    try:
        f = open(fn)
        return True
    except IOError:
        return False


def is_valid_json(j):
    try:
        json.loads(j)
        return True
    except:
        return False


def load_config(config_path):
    with open(config_path, "r") as f:
        fo = f.read()
        try:
            return dict(json.loads(fo))
        except:
            logging.warning("load_config function failed to load json")
            raise IOError("load_config function failed to load json")


def write_packer_json_to_file(json_params):
    fn = "packer.json"
    with open(fn,'w') as f:
        f.write(generate_packer_json(
        vpc=json_params["vpc"],
        subnet=json_params["subnet"],
        region=json_params["region"],
        sami=json_params["sami"],
        appname=json_params["appname"],
        instance_type=json_params["instance_type"],
        ))


def pretty_print_json(json_string):
    return json.dumps(json.loads(json_string), sort_keys=True, indent=4, separators=(',', ':'))


def find_ver_metadata(f):
    NAME = "Just another name"
    VERSION = "JUST another version"
    for line in f.readlines():
        if "version" in line:
            VERSION = line.strip().split()[1].strip("\'")
        if "name" in line:
            if "name" in line.split()[0]:
                NAME = line.split()[1].strip("\'")
        else:
            pass
    return NAME, VERSION


def learn_from_metadatarb():
    if file_exists("metadata.rb"):
        with open("metadata.rb") as f:
            NAME,VERSION = find_ver_metadata(f)
            return NAME, VERSION
    else:
        raise IOError("couldn't find metadata.rb in local folder")


def get_version_from_metadata():
    with open("metadata.rb", "r") as f:
        for i in f.readlines():
            if "version" in i:
                VERSION = i.strip().split()[1].strip("\'")
                return VERSION


def get_latest_ign_base_ami(APP="ign-base", REGION="us-east-1", SMAX=4):
    conn = boto.ec2.connect_to_region(REGION)
    lens = []
    images = conn.get_all_images()
    passes = 0
    blist = []
    clist = []
    lookup_dict = {}
    res_dict = {}
    for image in images:
        try:
            if APP in image.name:
                slicy = image.name.split()[1].replace(".","")
                if len(slicy) < SMAX:
                    while len(slicy) < SMAX:
                        slicy = str(slicy)
                        slicy += "0"
                lookup_dict.update({str(slicy):image.name})
                res_dict.update({image.name:image.id})
                blist.append(slicy)
        except:
            passes += 1
    return res_dict[lookup_dict[max(blist)]]


def generate_packer_json(region, sami, instance_type, appname, vpc, subnet):
    PACKERJSONSTR="""
{{
  "variables": {{
      "aws_access_key": "",
      "aws_secret_key": "",
      "packer_build_version": ""
  }},
  "builders": [{{
      "type": "amazon-ebs",
      "region": "{REGION}",
      "access_key": "{{{{user `aws_access_key`}}}}",
      "secret_key": "{{{{user `aws_secret_key`}}}}",
      "source_ami": "{SAMI}",
      "instance_type": "{INSTANCE_TYPE}",
      "ssh_username": "root",
      "ssh_timeout": "5m",
      "ami_name": "{APPNAME} {{{{user `packer_build_version`}}}}",
      "ami_description": "Packer-generated CentOS 6.5 basebox",
      "vpc_id": "{VPC}",
      "subnet_id": "{SUBNET}",
      "run_tags": {{
          "product": "ign",
          "app": "base",
          "env": "build",
          "role": "builder",
          "type": "other",
          "tier": "ign-base-builder"
       }},
       "tags": {{
          "product": "ign"
       }}
  }}
  ],
  "provisioners": [
      {{
        "type": "chef-solo",
        "cookbook_paths": ["vendor/cookbooks"],
        "run_list": ["recipe[{APPNAME}]"]
      }},
      {{
            "type": "shell",
            "inline": "rm -f /root/.ssh/authorized_keys",
            "only": ["amazon-ebs"]
          }}
  ]
}}""".format(
        VPC=vpc,
        SUBNET=subnet,
        REGION=region,
        SAMI=sami,
        APPNAME=appname,
        INSTANCE_TYPE=instance_type,)
    if is_valid_json(PACKERJSONSTR):
        return pretty_print_json(PACKERJSONSTR.strip())
    else:
        print PACKERJSONSTR
        raise ValueError("Not valid JSON")
