import json
from helpers import *

class Configuration(object):
    def __init__(self, default):
        self.default = default
        self.current = default

    def loadFromFile(self, fn):
        with open(fn) as f:
            return json.loads(fn.read())

    def getCurrentConfiguration(self):
        return self.current
try:
    appName, Version = learn_from_metadatarb()
except:
    raise IOError("Couldn't find a metadata.rb in local file or couldn't find version and application name in metadata.rb")

Config = Configuration({
        "vpc":            "vpc-b61f7ddb",
        "subnet":         "subnet-e344118e",
        "region":         "us-east-1",
        "sami":           "ami-acfb71c4",
        "appname":        appName,
        "instance_type":  "c3.large",
        "version":        Version,
        "debug":          False,
        "dynamic base":   False,
    })
