# -*- coding: utf-8 -*-
'''
Created on 11/lug/2011

@author: simone cittadini
'''
import operator

NON_FIELD_ERRORS = '__all__'
class IncoerenzaNelleMaschere(Exception):
    """Un errore durante un tentativo di modifica delle maschere dei prefissi"""
    def __init__(self, message, code=None, params=None):
        from django.utils.encoding import force_unicode
        """
        Posso passarle per essere stampata una stringa, 
        lista di oggetti o dizionario.
        """
        if isinstance(message, dict):
            self.message_dict = message
            # Riduce ogni lista di messaggi in una singola lista
            message = reduce(operator.add, message.values())
            
        if isinstance(message, list):
            self.messages = [force_unicode(msg) for msg in message]
        else:
            self.code = code
            self.params = params
            message = force_unicode(message)
            self.messages = [message]
            
    def __str__(self):
        if hasattr(self, 'message_dict'):
            return repr(self.message_dict)
        return repr(self.messages)
    
    def __repr__(self):
        if hasattr(self, 'message_dict'):
            return 'IncoerenzaNelleMaschere(%s)' % repr(self.message_dict)
        return 'IncoerenzaNelleMaschere(%s)' % repr(self.messages)

    def update_error_dict(self, error_dict):
        if hasattr(self, 'message_dict'):
            if error_dict:
                for k, v in self.message_dict.items():
                    error_dict.setdefault(k, []).extend(v)
            else:
                error_dict = self.message_dict
        else:
            error_dict[NON_FIELD_ERRORS] = self.messages
        return error_dict