# -*- coding: utf-8 -*-
'''
Created on 14/giu/2011

@author: simone cittadini
'''


from django.core.management import setup_environ
import settings
from sctel.linee.models import Ingresso, Rivendita, Rotta

setup_environ(settings)

from prefissi.models import Maschera, Prefisso, NomeDistretto


def create_fixture_prefissi(print_diagram=False):
	maschera_base = Maschera.objects.create(nome='maschera base', base=True)
	maschera_esterna = Maschera.objects.create(nome='maschera esterna')
	# Creo i prefissi per italia fisso.
	nd = NomeDistretto.objects.create(nome='Italia Fisso',
									maschera=maschera_base)
	for pre in ('01','02','03','04','05','06','07','08','09'):
		p = Prefisso.objects.create(pre='39%s' % pre)
		nd.prefissi.add(p)
		
	# Creo i prefissi per italia mobile.
	nd = NomeDistretto.objects.create(nome='ItaliaMobile',
									maschera=maschera_base)
	for pre in ('328', '333', '392'):
		p = Prefisso.objects.create(pre='39%s' % pre)
		nd.prefissi.add(p)	
	
	# Creo i prefissi per afghanistan.
	nd = NomeDistretto.objects.create(nome='Afghanistan',
									maschera=maschera_base)
	p = Prefisso.objects.create(pre='93')
	nd.prefissi.add(p)	
	
	# Creo i prefissi per afghanistan mobile.
	nd = NomeDistretto.objects.create(nome='Afghanistan Mobile',
									maschera=maschera_base)
	for pre in ('70','71','72','73','74','75','76'):
		p = Prefisso.objects.create(pre='93%s' % pre)
		nd.prefissi.add(p)
		
	if print_diagram:
		print "====== fixture prefissi ======="
		print "maschera"
		print "-nome distretto"
		print "--prefisso"
		print "================================"
		for maschera in Maschera.objects.all():
			print maschera
			for nome_distretto in NomeDistretto.objects.filter(maschera__exact=maschera):
				print "-%s" % nome_distretto.nome
				for prefisso in nome_distretto.prefissi.all():
					print "--%s" % prefisso.pre

def create_fixture_linee(print_diagram=False):
	if print_diagram:
		print "====== fixture linee ======"
		print "ingressi:"
		print "ingresso -> distretto -> rivendita"
		print "rivendite:"
		print "rivendita -> distretto -> terminazione, backup"
		print "==========================="
		for ingresso in Ingresso.objects.all():
			print "ingressi:"
			for rotta in Rotta.objects.filter(linea_in__exact=ingresso):
				print "%s -> %s -> %s" % (rotta.linea_in, rotta.nome_distretto,
										rotta.linea_out)
		for rivendita in Rivendita.objects.all():
			print "rivendite:"
			for rotta in Rotta.objects.filter(linea_in__exact=rivendita):
				print "%s -> %s -> %s, %s" % (rotta.linea_in, rotta.nome_distretto,
											rotta.linea_out, rotta.backup)
				

if __name__ == '__main__':

	create_fixture_prefissi(True)
	create_fixture_linee(True)
