# -*- coding: utf-8 -*-
'''
Created on 18/set/2011

@author: simone cittadini
'''
from django.test import TestCase

from sctel.prefissi.models import Maschera, NomeDistretto, Prefisso
from sctel.linee.models import Terminazione

class TestRight(TestCase):
    """
    Nessun errore di input o di stato.
    """
    
    def setUp(self):
        self.maschera = Maschera.objects.create(nome='base', base=True)
        self.distretto = NomeDistretto.objects.create(nome='italia',
                                                      tipo=1,
                                                      maschera=self.maschera)
        self.prefisso = Prefisso.objects.create(pre='02')
        self.distretto.prefissi.add(self.prefisso)
    
    def tearDown(self):
        pass
    

    def test_crea_linea_terminazione(self):
        """
        get_terminazione e get_dial_string implemetati, gli altri metodi eccezione appropriata
        """
        t = Terminazione.objects.create(nome='linea_terminazione')
        self.assertEqual(t,
                         t.get_terminazione(self.distretto))


#    def test_crea_linea_rivendita(self):
"""
get_terminazione e get_backup implementati, gli altri metodi eccezione appropriata
"""
#        linea = crea_linea_master('linea_master', self.linea_terminazione_a)
#        self.assertEqual(linea.tipo, 'MASTER')
#        self.assertEqual(linea.creatore, self.supermaster)
#        for distretto in NomeDistretto.objects.filter(locale=True):
#            try:
#                Rotta.objects.get(distretto=distretto, 
#                                  ingresso=linea, 
#                                  uscita_uno=self.linea_terminazione_a)
#            except:
#                self.fail('la rotta dovrebbe esistere')

        
#    def test_crea_linea_ingresso(self):
"""
get_terminazione deve essere implementato, gli altri metodi lanciare eccezione appropriata
"""
#        linea = crea_linea_resell('linea_resell', self.master, '10000', \
#                                   self.linea_master_a)
#        self.assertEqual(linea.tipo, 'RESELL')
#        self.assertEqual(linea.creatore, self.master)
#        self.assertEqual(linea.codice_selezione, '10000')
#        for prefisso in Prefisso.objects.filter(locale=True):
#            try:
#                Rotta.objects.get(prefisso=prefisso,
#                                  ingresso=linea,
#                                  uscita_uno=self.linea_master_a)
#            except:
#                self.fail('la rotta dovrebbe esistere')


# def test_rotta_rivendita(self):
"""
se in è rivendita out e backup devono essere terminazione
il distretto deve essere della maschera base
get_terminazione torna una linea terminazione, come get_backup
"""
                
    #def test_rotta_ingresso(self):
"""
se in è ingresso out deve essere rivendita, backup none.
il distretto deve essere della maschera base, altro lancia eccezione appropriata
get_terminazione torna una linea di tipo terminazione
get_backup torna una linea di tipo terminazione
per far prima si può chiamare get_dial_string direttamente sulla rotta ingresso
"""
   #     pass
        
class TestException(TestCase):


    def setUp(self):
        pass
        
    def tearDown(self):
        pass
    
    
# def test_rotta_terminazione
# non posso avere terminazione in

#    def test_salva_direttamente_tipo_inesistente(self):
#        linea = Linea(nome="inesistente",
#                      tipo="INESISTENTE")
#        self.assertRaises(ExceptionTipoLineaInesistente,
#                          linea.save)

#    def test_rivendita_crea_non_utente(self):
#        self.assertRaises(ExceptionCreatoreNonUtente,
#                          crea_linea_resell,
#                          'linea_venidta',
#                          self.master.get_specifico(),
#                          '10000',
#                          self.linea_master_a)
        
#    def test_resell_crea_non_master(self):
#        self.assertRaises(ExceptionCreatoreNonUtenteMaster,
#                          crea_linea_resell,
#                          'linea_resell',
#                          self.supermaster,
#                          '10000',
#                          self.linea_master_a)

        
#    def testLinea_resell_crea_non_termina_giusta(self):
#        self.assertRaises(ExceptionResellNonEsceSuMaster,
#                          crea_linea_resell,
#                          'linea vendit',
#                          self.supermaster,
#                          '10000',
#                          self.linea_terminazione_a)
        
#    def test_rotta_terminazione_null(self):
#        # per sicurezza le uscite a null le riscriviamo con la linea offline
#        rotta = Rotta.objects.get(ingresso=self.linea_resell_a, 
#                                  prefisso=Prefisso.objects.get(pre='003902'))
#        rotta.uscita_due = None
#        rotta.save()
#        self.assertEqual(Linea.objects.get(nome='-master OFF-'),
#                         rotta.uscita_due)

        
class TestPrefissi(TestCase):
    
    def setUp(self):
        pass
    
    def tearDown(self):
        pass

        
#    def test_update_prefissi_prefisso_esistente_distretto_nuovo(self):
#        update_prefissi('003902', 'Italia MI')
#        prefisso = Prefisso.objects.get(pre='003902')
#        # il vecchio distretto esiste ancora
#        distretto_vecchio = Distretto.objects.get(nome='Italia')
#        self.assertEqual('Italia Mi',
#                         prefisso.distretto.nome)
#        # si è creata una nuova rottadistretto
#        linee = Linea.objects.exclude(tipo__exact='TERMINAZIONE').exclude(nome__contains="OFF-").values_list('id', flat=True)
#        # per tutte le linee
#        for l in Linea.objects.exclude(tipo__exact='TERMINAZIONE').exclude(nome__contains="OFF-"):
#            self.assertEqual(1,
#                             RottaDistretto.objects.filter(distretto__nome__exact=prefisso.distretto.nome,
#                                                           ingresso__exact=l).count())

        

        
#    def test_update_prefissi_prefisso_nuovo_distretto_nuovo(self):
#        update_prefissi('0039011', 'Italia specifico')
#        prefisso = Prefisso.objects.get(pre='0039011')
#        self.assertEqual('Italia Specifico',
#                         prefisso.distretto.nome)
#        for linea in Linea.objects.filter(tipo__in=['MASTER', 'RESELL', 'CUSTOMER']).exclude(nome__contains='OFF-'):
#            self.assertEqual(1,
#                         Rotta.objects.filter(prefisso__exact=prefisso,
#                                              ingresso__exact=linea).count())        
