# -*- coding: utf-8 -*-
'''
Created on 14/giu/2011

@author: simone cittadini
'''
from django.test import TestCase

from sctel.core.exceptions import IncoerenzaNelleMaschere
from sctel.prefissi.models import NomeDistretto, Maschera, Prefisso
from sctel.create_testbase import create_fixture_prefissi


class TestRight(TestCase):
    """
    Nessun errore di input o di stato.
    """


    def test_get_maschera_base(self):
		# Può esistere una maschera base dei prefissi,
		# ma non è considerata errore la sua assenza.
		m = Maschera.objects.create(nome='base', base=True)
		self.assertEqual(m, Maschera.get_maschera_base())
		m.delete()
		self.assertEqual(None, Maschera.get_maschera_base())
		mnb = Maschera.objects.create(nome="maschera due")
		self.assertFalse(mnb.base)

    def test_get_prefisso(self):
		# Ad una destinazione si associa sempre 
		# il più lungo prefisso corrispondente.
		p_base = Prefisso.objects.create(pre='39')
		p_spec = Prefisso.objects.create(pre='3902')
		self.assertEqual(p_spec, Prefisso.get_prefisso('3902123456'))

    def test_save_nome_distretto(self):
		# I nomi dei distretti vengono normalizzati in fase di salvataggio.
		ugly_names = ('italia mobile', 'ITALIA MOBILE', ' italia mobile',
                      'italia mobile ')
		m = Maschera.objects.create(nome='m')
		for ugly_name in ugly_names:
			nd = NomeDistretto.objects.create(nome='%s' % ugly_name,
                                              maschera=m, tipo=2)
			self.assertEqual('Italia Mobile',
                             nd.nome)
			nd.delete()

    def test_get_distretto_base(self):
		# Un prefisso può non appartenere alla maschera base
        m = Maschera.objects.create(nome='maschera carrier')
        mb = Maschera.objects.create(nome='base', base=True)
        p = Prefisso.objects.create(pre='39')
        d = NomeDistretto.objects.create(nome='Italy', maschera=m, tipo=1)
        db = NomeDistretto.objects.create(nome='Italia Fisso', maschera=mb,
                                          tipo=1)

        d.prefissi.add(p)
        d.save()
        self.assertEqual(None,
                         p.get_distretto_base())
        db.prefissi.add(p)
        db.save()
        self.assertEqual(db,
                         p.get_distretto_base())

	def test_prefisso_duplicato_in_maschera(self):
		# Aggiungere ad un NomeDistretto un prefisso già esistente
		# sotto altro nome ne aggiorna la posizione
		m = Maschera.objects.create(nome='base', base=True)
		prefisso = Prefisso.objects.get(pre='3901')
		self.assertEqual(9,
						NomeDistretto.objects.get(nome='Italia Fisso').\
						prefissi.all().count())
		nd = NomeDistretto.objects.create(nome="Italia Special",
										maschera=m)
		nd.prefissi.add(prefisso)
		self.assertEqual(1,
						nd.prefissi.all().count())
		self.assertEqual(8,
						NomeDistretto.objects.get(nome='Italia Fisso').\
						prefissi.all().count())
		
	def test_get_distretto_base(self):
		# si può risalire al NomeDistretto della machera base direttamente
		# dal prefisso, se contenuto in maschera
		create_fixture_prefissi()
		m = Maschera.objects.get(nome="maschera base")
		prefisso = Prefisso.objects.get(pre="3901")
		self.assertEqual(NomeDistretto.objects.get(nome="Italia Fisso",
												maschera=m),
						prefisso.get_distretto_base())
		prefisso = Prefisso.objects.create(pre="0099")
		self.assertEqual(None,
						prefisso.get_distretto_base())


class TestException(TestCase):

	
	def test_save_maschera_base(self):
		# Può esistere una e una sola maschera base,
		# inserirne una seconda è considerato errore.
		m = Maschera.objects.create(nome='base', base=True)
		m_dup = Maschera(nome='altra base', base=True)
		self.assertRaises(IncoerenzaNelleMaschere, m_dup.save)

	def testPrefissoVuoto(self):
		prefisso = Prefisso(pre='')
		self.assertRaises(IncoerenzaNelleMaschere,
						prefisso.save)
		
	def testPrefissoNullo(self):
		prefisso = Prefisso(pre=None)
		self.assertRaises(IncoerenzaNelleMaschere,
						prefisso.save)
		
	def testPrefissoCorto(self):
		prefisso = Prefisso(pre='0')
		self.assertRaises(IncoerenzaNelleMaschere,
						prefisso.save)
