# Copyright (C) 2011-2012 CRS4.
#
# This file is part of Seal.
#
# Seal is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# Seal is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Seal.  If not, see <http://www.gnu.org/licenses/>.

"""
This implements a I{short read alignment} application.
It will map read pairs and it will align them to a reference genome.

The default implementation uses bwa as alignment engine
"""

from pydoop.pipes import runTask, Factory
from mapper import mapper
from reducer import reducer


def run_task():
  return runTask(Factory(mapper, reducer))
