! ***********************************************************************
! dataspec_p5.f90 - (march, 6th 2008)
! ***********************************************************************

! **********************************************************************
! these modules contain the spectral broadness of prospect 
! (nl obs_wavelengths with 1 nm spectral resolution)
! and the spectral coefficients:
! [1] = refractive index of leaf material
! [2] = specific absorption coefficient of chlorophyll (a+b) (cm2.microg-1)
! [3] = specific absorption coefficient of carotenoids (cm2.microg-1)
! [4] = specific absorption coefficient of water (cm-1)
! [5] = specific absorption coefficient of dry matter (cm2.g-1)
! féret et al. (2008), prospect-4 and 5: advances in the leaf optical
! properties model separating photosynthetic pigments, remote sensing of
! environment
! **********************************************************************

module spectrum_width_p5

	implicit none

integer,parameter :: nlmax=2101
integer nl
end module 

module dataspec_p5

	use spectrum_width_p5
	implicit none

integer lambdafull(nlmax)
double precision nrefracfull(nlmax)
double precision acabfull(nlmax)
double precision acarfull(nlmax)
double precision acwfull(nlmax)
double precision acmfull(nlmax)
double precision phis1full(nlmax)
double precision phis2full(nlmax)
double precision phis3full(nlmax)
double precision phis4full(nlmax)

integer,allocatable :: lambda(:)
double precision,allocatable ::  nrefrac(:)
double precision,allocatable ::  acab(:)
double precision,allocatable ::  acar(:)
double precision,allocatable ::  acw(:)
double precision,allocatable ::  acm(:)
double precision,allocatable ::  phis1(:)
double precision,allocatable ::  phis2(:)
double precision,allocatable ::  phis3(:)
double precision,allocatable ::  phis4(:)

integer itmp

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!							wavelength								!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


		data (lambdafull(itmp),itmp=1,100)/&
	400.,401.,402.,403.,404.,405.,406.,407.,408.,409.,&
	410.,411.,412.,413.,414.,415.,416.,417.,418.,419.,&
	420.,421.,422.,423.,424.,425.,426.,427.,428.,429.,&
	430.,431.,432.,433.,434.,435.,436.,437.,438.,439.,&
	440.,441.,442.,443.,444.,445.,446.,447.,448.,449.,&
	450.,451.,452.,453.,454.,455.,456.,457.,458.,459.,&
	460.,461.,462.,463.,464.,465.,466.,467.,468.,469.,&
	470.,471.,472.,473.,474.,475.,476.,477.,478.,479.,&
	480.,481.,482.,483.,484.,485.,486.,487.,488.,489.,&
	490.,491.,492.,493.,494.,495.,496.,497.,498.,499/

		data (lambdafull(itmp),itmp=101,200)/&
	500.,501.,502.,503.,504.,505.,506.,507.,508.,509.,&
	510.,511.,512.,513.,514.,515.,516.,517.,518.,519.,&
	520.,521.,522.,523.,524.,525.,526.,527.,528.,529.,&
	530.,531.,532.,533.,534.,535.,536.,537.,538.,539.,&
	540.,541.,542.,543.,544.,545.,546.,547.,548.,549.,&
	550.,551.,552.,553.,554.,555.,556.,557.,558.,559.,&
	560.,561.,562.,563.,564.,565.,566.,567.,568.,569.,&
	570.,571.,572.,573.,574.,575.,576.,577.,578.,579.,&
	580.,581.,582.,583.,584.,585.,586.,587.,588.,589.,&
	590.,591.,592.,593.,594.,595.,596.,597.,598.,599/

		data (lambdafull(itmp),itmp=201,300)/&
	600.,601.,602.,603.,604.,605.,606.,607.,608.,609.,&
	610.,611.,612.,613.,614.,615.,616.,617.,618.,619.,&
	620.,621.,622.,623.,624.,625.,626.,627.,628.,629.,&
	630.,631.,632.,633.,634.,635.,636.,637.,638.,639.,&
	640.,641.,642.,643.,644.,645.,646.,647.,648.,649.,&
	650.,651.,652.,653.,654.,655.,656.,657.,658.,659.,&
	660.,661.,662.,663.,664.,665.,666.,667.,668.,669.,&
	670.,671.,672.,673.,674.,675.,676.,677.,678.,679.,&
	680.,681.,682.,683.,684.,685.,686.,687.,688.,689.,&
	690.,691.,692.,693.,694.,695.,696.,697.,698.,699/

		data (lambdafull(itmp),itmp=301,400)/&
	700.,701.,702.,703.,704.,705.,706.,707.,708.,709.,&
	710.,711.,712.,713.,714.,715.,716.,717.,718.,719.,&
	720.,721.,722.,723.,724.,725.,726.,727.,728.,729.,&
	730.,731.,732.,733.,734.,735.,736.,737.,738.,739.,&
	740.,741.,742.,743.,744.,745.,746.,747.,748.,749.,&
	750.,751.,752.,753.,754.,755.,756.,757.,758.,759.,&
	760.,761.,762.,763.,764.,765.,766.,767.,768.,769.,&
	770.,771.,772.,773.,774.,775.,776.,777.,778.,779.,&
	780.,781.,782.,783.,784.,785.,786.,787.,788.,789.,&
	790.,791.,792.,793.,794.,795.,796.,797.,798.,799/

		data (lambdafull(itmp),itmp=401,500)/&
	800.,801.,802.,803.,804.,805.,806.,807.,808.,809.,&
	810.,811.,812.,813.,814.,815.,816.,817.,818.,819.,&
	820.,821.,822.,823.,824.,825.,826.,827.,828.,829.,&
	830.,831.,832.,833.,834.,835.,836.,837.,838.,839.,&
	840.,841.,842.,843.,844.,845.,846.,847.,848.,849.,&
	850.,851.,852.,853.,854.,855.,856.,857.,858.,859.,&
	860.,861.,862.,863.,864.,865.,866.,867.,868.,869.,&
	870.,871.,872.,873.,874.,875.,876.,877.,878.,879.,&
	880.,881.,882.,883.,884.,885.,886.,887.,888.,889.,&
	890.,891.,892.,893.,894.,895.,896.,897.,898.,899/

		data (lambdafull(itmp),itmp=501,600)/&
	900.,901.,902.,903.,904.,905.,906.,907.,908.,909.,&
	910.,911.,912.,913.,914.,915.,916.,917.,918.,919.,&
	920.,921.,922.,923.,924.,925.,926.,927.,928.,929.,&
	930.,931.,932.,933.,934.,935.,936.,937.,938.,939.,&
	940.,941.,942.,943.,944.,945.,946.,947.,948.,949.,&
	950.,951.,952.,953.,954.,955.,956.,957.,958.,959.,&
	960.,961.,962.,963.,964.,965.,966.,967.,968.,969.,&
	970.,971.,972.,973.,974.,975.,976.,977.,978.,979.,&
	980.,981.,982.,983.,984.,985.,986.,987.,988.,989.,&
	990.,991.,992.,993.,994.,995.,996.,997.,998.,999/

		data (lambdafull(itmp),itmp=601,700)/&
	1000.,1001.,1002.,1003.,1004.,1005.,1006.,1007.,1008.,1009.,&
	1010.,1011.,1012.,1013.,1014.,1015.,1016.,1017.,1018.,1019.,&
	1020.,1021.,1022.,1023.,1024.,1025.,1026.,1027.,1028.,1029.,&
	1030.,1031.,1032.,1033.,1034.,1035.,1036.,1037.,1038.,1039.,&
	1040.,1041.,1042.,1043.,1044.,1045.,1046.,1047.,1048.,1049.,&
	1050.,1051.,1052.,1053.,1054.,1055.,1056.,1057.,1058.,1059.,&
	1060.,1061.,1062.,1063.,1064.,1065.,1066.,1067.,1068.,1069.,&
	1070.,1071.,1072.,1073.,1074.,1075.,1076.,1077.,1078.,1079.,&
	1080.,1081.,1082.,1083.,1084.,1085.,1086.,1087.,1088.,1089.,&
	1090.,1091.,1092.,1093.,1094.,1095.,1096.,1097.,1098.,1099/

		data (lambdafull(itmp),itmp=701,800)/&
	1100.,1101.,1102.,1103.,1104.,1105.,1106.,1107.,1108.,1109.,&
	1110.,1111.,1112.,1113.,1114.,1115.,1116.,1117.,1118.,1119.,&
	1120.,1121.,1122.,1123.,1124.,1125.,1126.,1127.,1128.,1129.,&
	1130.,1131.,1132.,1133.,1134.,1135.,1136.,1137.,1138.,1139.,&
	1140.,1141.,1142.,1143.,1144.,1145.,1146.,1147.,1148.,1149.,&
	1150.,1151.,1152.,1153.,1154.,1155.,1156.,1157.,1158.,1159.,&
	1160.,1161.,1162.,1163.,1164.,1165.,1166.,1167.,1168.,1169.,&
	1170.,1171.,1172.,1173.,1174.,1175.,1176.,1177.,1178.,1179.,&
	1180.,1181.,1182.,1183.,1184.,1185.,1186.,1187.,1188.,1189.,&
	1190.,1191.,1192.,1193.,1194.,1195.,1196.,1197.,1198.,1199/

		data (lambdafull(itmp),itmp=801,900)/&
	1200.,1201.,1202.,1203.,1204.,1205.,1206.,1207.,1208.,1209.,&
	1210.,1211.,1212.,1213.,1214.,1215.,1216.,1217.,1218.,1219.,&
	1220.,1221.,1222.,1223.,1224.,1225.,1226.,1227.,1228.,1229.,&
	1230.,1231.,1232.,1233.,1234.,1235.,1236.,1237.,1238.,1239.,&
	1240.,1241.,1242.,1243.,1244.,1245.,1246.,1247.,1248.,1249.,&
	1250.,1251.,1252.,1253.,1254.,1255.,1256.,1257.,1258.,1259.,&
	1260.,1261.,1262.,1263.,1264.,1265.,1266.,1267.,1268.,1269.,&
	1270.,1271.,1272.,1273.,1274.,1275.,1276.,1277.,1278.,1279.,&
	1280.,1281.,1282.,1283.,1284.,1285.,1286.,1287.,1288.,1289.,&
	1290.,1291.,1292.,1293.,1294.,1295.,1296.,1297.,1298.,1299/

		data (lambdafull(itmp),itmp=901,1000)/&
	1300.,1301.,1302.,1303.,1304.,1305.,1306.,1307.,1308.,1309.,&
	1310.,1311.,1312.,1313.,1314.,1315.,1316.,1317.,1318.,1319.,&
	1320.,1321.,1322.,1323.,1324.,1325.,1326.,1327.,1328.,1329.,&
	1330.,1331.,1332.,1333.,1334.,1335.,1336.,1337.,1338.,1339.,&
	1340.,1341.,1342.,1343.,1344.,1345.,1346.,1347.,1348.,1349.,&
	1350.,1351.,1352.,1353.,1354.,1355.,1356.,1357.,1358.,1359.,&
	1360.,1361.,1362.,1363.,1364.,1365.,1366.,1367.,1368.,1369.,&
	1370.,1371.,1372.,1373.,1374.,1375.,1376.,1377.,1378.,1379.,&
	1380.,1381.,1382.,1383.,1384.,1385.,1386.,1387.,1388.,1389.,&
	1390.,1391.,1392.,1393.,1394.,1395.,1396.,1397.,1398.,1399/

		data (lambdafull(itmp),itmp=1001,1100)/&
	1400.,1401.,1402.,1403.,1404.,1405.,1406.,1407.,1408.,1409.,&
	1410.,1411.,1412.,1413.,1414.,1415.,1416.,1417.,1418.,1419.,&
	1420.,1421.,1422.,1423.,1424.,1425.,1426.,1427.,1428.,1429.,&
	1430.,1431.,1432.,1433.,1434.,1435.,1436.,1437.,1438.,1439.,&
	1440.,1441.,1442.,1443.,1444.,1445.,1446.,1447.,1448.,1449.,&
	1450.,1451.,1452.,1453.,1454.,1455.,1456.,1457.,1458.,1459.,&
	1460.,1461.,1462.,1463.,1464.,1465.,1466.,1467.,1468.,1469.,&
	1470.,1471.,1472.,1473.,1474.,1475.,1476.,1477.,1478.,1479.,&
	1480.,1481.,1482.,1483.,1484.,1485.,1486.,1487.,1488.,1489.,&
	1490.,1491.,1492.,1493.,1494.,1495.,1496.,1497.,1498.,1499/

		data (lambdafull(itmp),itmp=1101,1200)/&
	1500.,1501.,1502.,1503.,1504.,1505.,1506.,1507.,1508.,1509.,&
	1510.,1511.,1512.,1513.,1514.,1515.,1516.,1517.,1518.,1519.,&
	1520.,1521.,1522.,1523.,1524.,1525.,1526.,1527.,1528.,1529.,&
	1530.,1531.,1532.,1533.,1534.,1535.,1536.,1537.,1538.,1539.,&
	1540.,1541.,1542.,1543.,1544.,1545.,1546.,1547.,1548.,1549.,&
	1550.,1551.,1552.,1553.,1554.,1555.,1556.,1557.,1558.,1559.,&
	1560.,1561.,1562.,1563.,1564.,1565.,1566.,1567.,1568.,1569.,&
	1570.,1571.,1572.,1573.,1574.,1575.,1576.,1577.,1578.,1579.,&
	1580.,1581.,1582.,1583.,1584.,1585.,1586.,1587.,1588.,1589.,&
	1590.,1591.,1592.,1593.,1594.,1595.,1596.,1597.,1598.,1599/

		data (lambdafull(itmp),itmp=1201,1300)/&
	1600.,1601.,1602.,1603.,1604.,1605.,1606.,1607.,1608.,1609.,&
	1610.,1611.,1612.,1613.,1614.,1615.,1616.,1617.,1618.,1619.,&
	1620.,1621.,1622.,1623.,1624.,1625.,1626.,1627.,1628.,1629.,&
	1630.,1631.,1632.,1633.,1634.,1635.,1636.,1637.,1638.,1639.,&
	1640.,1641.,1642.,1643.,1644.,1645.,1646.,1647.,1648.,1649.,&
	1650.,1651.,1652.,1653.,1654.,1655.,1656.,1657.,1658.,1659.,&
	1660.,1661.,1662.,1663.,1664.,1665.,1666.,1667.,1668.,1669.,&
	1670.,1671.,1672.,1673.,1674.,1675.,1676.,1677.,1678.,1679.,&
	1680.,1681.,1682.,1683.,1684.,1685.,1686.,1687.,1688.,1689.,&
	1690.,1691.,1692.,1693.,1694.,1695.,1696.,1697.,1698.,1699/

		data (lambdafull(itmp),itmp=1301,1400)/&
	1700.,1701.,1702.,1703.,1704.,1705.,1706.,1707.,1708.,1709.,&
	1710.,1711.,1712.,1713.,1714.,1715.,1716.,1717.,1718.,1719.,&
	1720.,1721.,1722.,1723.,1724.,1725.,1726.,1727.,1728.,1729.,&
	1730.,1731.,1732.,1733.,1734.,1735.,1736.,1737.,1738.,1739.,&
	1740.,1741.,1742.,1743.,1744.,1745.,1746.,1747.,1748.,1749.,&
	1750.,1751.,1752.,1753.,1754.,1755.,1756.,1757.,1758.,1759.,&
	1760.,1761.,1762.,1763.,1764.,1765.,1766.,1767.,1768.,1769.,&
	1770.,1771.,1772.,1773.,1774.,1775.,1776.,1777.,1778.,1779.,&
	1780.,1781.,1782.,1783.,1784.,1785.,1786.,1787.,1788.,1789.,&
	1790.,1791.,1792.,1793.,1794.,1795.,1796.,1797.,1798.,1799/

		data (lambdafull(itmp),itmp=1401,1500)/&
	1800.,1801.,1802.,1803.,1804.,1805.,1806.,1807.,1808.,1809.,&
	1810.,1811.,1812.,1813.,1814.,1815.,1816.,1817.,1818.,1819.,&
	1820.,1821.,1822.,1823.,1824.,1825.,1826.,1827.,1828.,1829.,&
	1830.,1831.,1832.,1833.,1834.,1835.,1836.,1837.,1838.,1839.,&
	1840.,1841.,1842.,1843.,1844.,1845.,1846.,1847.,1848.,1849.,&
	1850.,1851.,1852.,1853.,1854.,1855.,1856.,1857.,1858.,1859.,&
	1860.,1861.,1862.,1863.,1864.,1865.,1866.,1867.,1868.,1869.,&
	1870.,1871.,1872.,1873.,1874.,1875.,1876.,1877.,1878.,1879.,&
	1880.,1881.,1882.,1883.,1884.,1885.,1886.,1887.,1888.,1889.,&
	1890.,1891.,1892.,1893.,1894.,1895.,1896.,1897.,1898.,1899/

		data (lambdafull(itmp),itmp=1501,1600)/&
	1900.,1901.,1902.,1903.,1904.,1905.,1906.,1907.,1908.,1909.,&
	1910.,1911.,1912.,1913.,1914.,1915.,1916.,1917.,1918.,1919.,&
	1920.,1921.,1922.,1923.,1924.,1925.,1926.,1927.,1928.,1929.,&
	1930.,1931.,1932.,1933.,1934.,1935.,1936.,1937.,1938.,1939.,&
	1940.,1941.,1942.,1943.,1944.,1945.,1946.,1947.,1948.,1949.,&
	1950.,1951.,1952.,1953.,1954.,1955.,1956.,1957.,1958.,1959.,&
	1960.,1961.,1962.,1963.,1964.,1965.,1966.,1967.,1968.,1969.,&
	1970.,1971.,1972.,1973.,1974.,1975.,1976.,1977.,1978.,1979.,&
	1980.,1981.,1982.,1983.,1984.,1985.,1986.,1987.,1988.,1989.,&
	1990.,1991.,1992.,1993.,1994.,1995.,1996.,1997.,1998.,1999/

		data (lambdafull(itmp),itmp=1601,1700)/&
	2000.,2001.,2002.,2003.,2004.,2005.,2006.,2007.,2008.,2009.,&
	2010.,2011.,2012.,2013.,2014.,2015.,2016.,2017.,2018.,2019.,&
	2020.,2021.,2022.,2023.,2024.,2025.,2026.,2027.,2028.,2029.,&
	2030.,2031.,2032.,2033.,2034.,2035.,2036.,2037.,2038.,2039.,&
	2040.,2041.,2042.,2043.,2044.,2045.,2046.,2047.,2048.,2049.,&
	2050.,2051.,2052.,2053.,2054.,2055.,2056.,2057.,2058.,2059.,&
	2060.,2061.,2062.,2063.,2064.,2065.,2066.,2067.,2068.,2069.,&
	2070.,2071.,2072.,2073.,2074.,2075.,2076.,2077.,2078.,2079.,&
	2080.,2081.,2082.,2083.,2084.,2085.,2086.,2087.,2088.,2089.,&
	2090.,2091.,2092.,2093.,2094.,2095.,2096.,2097.,2098.,2099/

		data (lambdafull(itmp),itmp=1701,1800)/&
	2100.,2101.,2102.,2103.,2104.,2105.,2106.,2107.,2108.,2109.,&
	2110.,2111.,2112.,2113.,2114.,2115.,2116.,2117.,2118.,2119.,&
	2120.,2121.,2122.,2123.,2124.,2125.,2126.,2127.,2128.,2129.,&
	2130.,2131.,2132.,2133.,2134.,2135.,2136.,2137.,2138.,2139.,&
	2140.,2141.,2142.,2143.,2144.,2145.,2146.,2147.,2148.,2149.,&
	2150.,2151.,2152.,2153.,2154.,2155.,2156.,2157.,2158.,2159.,&
	2160.,2161.,2162.,2163.,2164.,2165.,2166.,2167.,2168.,2169.,&
	2170.,2171.,2172.,2173.,2174.,2175.,2176.,2177.,2178.,2179.,&
	2180.,2181.,2182.,2183.,2184.,2185.,2186.,2187.,2188.,2189.,&
	2190.,2191.,2192.,2193.,2194.,2195.,2196.,2197.,2198.,2199/

		data (lambdafull(itmp),itmp=1801,1900)/&
	2200.,2201.,2202.,2203.,2204.,2205.,2206.,2207.,2208.,2209.,&
	2210.,2211.,2212.,2213.,2214.,2215.,2216.,2217.,2218.,2219.,&
	2220.,2221.,2222.,2223.,2224.,2225.,2226.,2227.,2228.,2229.,&
	2230.,2231.,2232.,2233.,2234.,2235.,2236.,2237.,2238.,2239.,&
	2240.,2241.,2242.,2243.,2244.,2245.,2246.,2247.,2248.,2249.,&
	2250.,2251.,2252.,2253.,2254.,2255.,2256.,2257.,2258.,2259.,&
	2260.,2261.,2262.,2263.,2264.,2265.,2266.,2267.,2268.,2269.,&
	2270.,2271.,2272.,2273.,2274.,2275.,2276.,2277.,2278.,2279.,&
	2280.,2281.,2282.,2283.,2284.,2285.,2286.,2287.,2288.,2289.,&
	2290.,2291.,2292.,2293.,2294.,2295.,2296.,2297.,2298.,2299/

		data (lambdafull(itmp),itmp=1901,2000)/&
	2300.,2301.,2302.,2303.,2304.,2305.,2306.,2307.,2308.,2309.,&
	2310.,2311.,2312.,2313.,2314.,2315.,2316.,2317.,2318.,2319.,&
	2320.,2321.,2322.,2323.,2324.,2325.,2326.,2327.,2328.,2329.,&
	2330.,2331.,2332.,2333.,2334.,2335.,2336.,2337.,2338.,2339.,&
	2340.,2341.,2342.,2343.,2344.,2345.,2346.,2347.,2348.,2349.,&
	2350.,2351.,2352.,2353.,2354.,2355.,2356.,2357.,2358.,2359.,&
	2360.,2361.,2362.,2363.,2364.,2365.,2366.,2367.,2368.,2369.,&
	2370.,2371.,2372.,2373.,2374.,2375.,2376.,2377.,2378.,2379.,&
	2380.,2381.,2382.,2383.,2384.,2385.,2386.,2387.,2388.,2389.,&
	2390.,2391.,2392.,2393.,2394.,2395.,2396.,2397.,2398.,2399/

		data (lambdafull(itmp),itmp=2001,2101)/&
	2400.,2401.,2402.,2403.,2404.,2405.,2406.,2407.,2408.,2409.,&
	2410.,2411.,2412.,2413.,2414.,2415.,2416.,2417.,2418.,2419.,&
	2420.,2421.,2422.,2423.,2424.,2425.,2426.,2427.,2428.,2429.,&
	2430.,2431.,2432.,2433.,2434.,2435.,2436.,2437.,2438.,2439.,&
	2440.,2441.,2442.,2443.,2444.,2445.,2446.,2447.,2448.,2449.,&
	2450.,2451.,2452.,2453.,2454.,2455.,2456.,2457.,2458.,2459.,&
	2460.,2461.,2462.,2463.,2464.,2465.,2466.,2467.,2468.,2469.,&
	2470.,2471.,2472.,2473.,2474.,2475.,2476.,2477.,2478.,2479.,&
	2480.,2481.,2482.,2483.,2484.,2485.,2486.,2487.,2488.,2489.,&
	2490.,2491.,2492.,2493.,2494.,2495.,2496.,2497.,2498.,2499.,&
	2500./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!						refractive index							!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		data (nrefracfull(itmp),itmp=1,100)/&
	1.4955,1.4958,1.496,1.4964,1.4971,1.4978,1.4986,1.4995,1.5006,1.5016,&
	1.5024,1.5031,1.5041,1.5052,1.5065,1.5076,1.5088,1.5099,1.511,1.5122,&
	1.5134,1.5144,1.5156,1.5168,1.5181,1.5195,1.5206,1.5212,1.5219,1.5228,&
	1.5235,1.5241,1.5249,1.5256,1.5262,1.5268,1.5272,1.5276,1.5279,1.5282,&
	1.5286,1.529,1.5292,1.5294,1.5294,1.5295,1.5293,1.5291,1.5289,1.5286,&
	1.5282,1.5278,1.5273,1.5268,1.5262,1.5256,1.5249,1.5243,1.5237,1.5231,&
	1.5224,1.5217,1.521,1.5203,1.5196,1.519,1.5184,1.5178,1.5173,1.517,&
	1.5166,1.5163,1.516,1.5157,1.5153,1.515,1.5148,1.5145,1.5142,1.5139,&
	1.5135,1.5131,1.5126,1.5119,1.5112,1.5103,1.5092,1.5081,1.5067,1.5052,&
	1.5034,1.5015,1.4994,1.4972,1.4947,1.4922,1.4895,1.4866,1.4837,1.4807/

		data (nrefracfull(itmp),itmp=101,200)/&
	1.4776,1.4745,1.4713,1.4681,1.4649,1.4618,1.4588,1.4559,1.4532,1.4505,&
	1.4481,1.4458,1.4436,1.4417,1.44,1.4385,1.4372,1.436,1.4351,1.4343,&
	1.4337,1.4332,1.4328,1.4325,1.4323,1.4322,1.4322,1.4321,1.4321,1.4321,&
	1.4321,1.432,1.432,1.4319,1.4318,1.4317,1.4315,1.4314,1.4311,1.4309,&
	1.4307,1.4304,1.4302,1.4299,1.4297,1.4295,1.4292,1.429,1.4287,1.4285,&
	1.4282,1.4279,1.4276,1.4273,1.4269,1.4265,1.4261,1.4256,1.4251,1.4245,&
	1.424,1.4234,1.4228,1.4222,1.4215,1.4209,1.4203,1.4197,1.419,1.4184,&
	1.4178,1.4172,1.4166,1.4161,1.4156,1.4151,1.4146,1.4142,1.4138,1.4134,&
	1.413,1.4127,1.4124,1.4121,1.4118,1.4116,1.4113,1.4111,1.4109,1.4106,&
	1.4104,1.4102,1.41,1.4099,1.4097,1.4095,1.4093,1.4091,1.4089,1.4088/
	
		data (nrefracfull(itmp),itmp=201,300)/&
	1.4086,1.4084,1.4082,1.4081,1.4079,1.4078,1.4077,1.4076,1.4076,1.4075,&
	1.4075,1.4075,1.4075,1.4076,1.4077,1.4078,1.4079,1.4080,1.4081,1.4082,&
	1.4082,1.4083,1.4083,1.4083,1.4083,1.4083,1.4082,1.4081,1.4079,1.4078,&
	1.4077,1.4076,1.4076,1.4077,1.4078,1.4080,1.4083,1.4088,1.4093,1.4100,&
	1.4108,1.4118,1.4129,1.4140,1.4153,1.4166,1.4180,1.4193,1.4206,1.4218,&
	1.4229,1.4240,1.4251,1.4261,1.4272,1.4285,1.4299,1.4315,1.4335,1.4357,&
	1.4383,1.4411,1.4442,1.4475,1.4509,1.4544,1.4580,1.4615,1.4649,1.4682,&
	1.4714,1.4744,1.4774,1.4802,1.4830,1.4857,1.4884,1.4909,1.4932,1.4951,&
	1.4963,1.4967,1.4958,1.4936,1.4899,1.4847,1.4780,1.4703,1.4618,1.4530,&
	1.4445,1.4366,1.4297,1.4238,1.4190,1.4154,1.4129,1.4113,1.4104,1.4102/

		data (nrefracfull(itmp),itmp=301,400)/&
	1.4106,1.4113,1.4124,1.4137,1.4152,1.4169,1.4186,1.4204,1.4223,1.4242,&
	1.4261,1.4281,1.4301,1.4321,1.4341,1.4362,1.4382,1.4402,1.4422,1.4442,&
	1.4462,1.4481,1.4500,1.4518,1.4536,1.4554,1.4571,1.4587,1.4603,1.4618,&
	1.4633,1.4646,1.4659,1.4672,1.4683,1.4694,1.4704,1.4713,1.4722,1.4729,&
	1.4736,1.4742,1.4748,1.4752,1.4756,1.4759,1.4762,1.4764,1.4765,1.4766,&
	1.4766,1.4766,1.4766,1.4765,1.4764,1.4763,1.4762,1.4760,1.4758,1.4756,&
	1.4754,1.4753,1.4751,1.4749,1.4747,1.4745,1.4743,1.4741,1.4739,1.4737,&
	1.4735,1.4733,1.4731,1.4729,1.4727,1.4725,1.4723,1.4721,1.4719,1.4717,&
	1.4716,1.4714,1.4712,1.4711,1.4709,1.4707,1.4706,1.4704,1.4702,1.4700,&
	1.4699,1.4697,1.4695,1.4693,1.4691,1.4690,1.4688,1.4686,1.4684,1.4682/

		data (nrefracfull(itmp),itmp=401,500)/&
	1.4681,1.4679,1.4677,1.4676,1.4674,1.4672,1.4670,1.4668,1.4667,1.4665,&
	1.4664,1.4662,1.4661,1.4659,1.4657,1.4656,1.4654,1.4652,1.4651,1.4649,&
	1.4648,1.4646,1.4645,1.4643,1.4641,1.4640,1.4638,1.4636,1.4635,1.4633,&
	1.4631,1.4630,1.4628,1.4627,1.4626,1.4625,1.4623,1.4622,1.4620,1.4619,&
	1.4617,1.4616,1.4615,1.4613,1.4612,1.4610,1.4608,1.4607,1.4606,1.4604,&
	1.4603,1.4601,1.4600,1.4599,1.4597,1.4596,1.4595,1.4594,1.4593,1.4591,&
	1.4589,1.4588,1.4586,1.4584,1.4583,1.4582,1.4582,1.4581,1.4580,1.4579,&
	1.4578,1.4576,1.4574,1.4573,1.4571,1.4569,1.4568,1.4566,1.4565,1.4563,&
	1.4562,1.4561,1.4559,1.4558,1.4556,1.4555,1.4553,1.4551,1.4550,1.4548,&
	1.4547,1.4545,1.4544,1.4543,1.4541,1.4539,1.4538,1.4536,1.4535,1.4534/

		data (nrefracfull(itmp),itmp=501,600)/&
	1.4532,1.4531,1.4529,1.4528,1.4527,1.4525,1.4524,1.4522,1.4521,1.4519,&
	1.4518,1.4516,1.4515,1.4514,1.4512,1.4511,1.4510,1.4508,1.4506,1.4505,&
	1.4503,1.4502,1.4500,1.4499,1.4497,1.4495,1.4494,1.4492,1.4491,1.4489,&
	1.4488,1.4487,1.4485,1.4483,1.4481,1.4479,1.4478,1.4477,1.4476,1.4474,&
	1.4472,1.4469,1.4467,1.4465,1.4464,1.4462,1.4461,1.4461,1.4461,1.4460,&
	1.4457,1.4455,1.4453,1.4452,1.4450,1.4449,1.4448,1.4447,1.4445,1.4445,&
	1.4445,1.4442,1.4440,1.4438,1.4437,1.4436,1.4436,1.4435,1.4434,1.4435,&
	1.4435,1.4434,1.4432,1.4430,1.4428,1.4427,1.4426,1.4425,1.4423,1.4422,&
	1.4420,1.4418,1.4417,1.4415,1.4415,1.4414,1.4415,1.4415,1.4416,1.4416,&
	1.4415,1.4414,1.4413,1.4411,1.4409,1.4407,1.4405,1.4403,1.4401,1.4400/

		data (nrefracfull(itmp),itmp=601,700)/&
	1.4399,1.4397,1.4395,1.4394,1.4393,1.4392,1.4392,1.4392,1.4391,1.4390,&
	1.4389,1.4387,1.4386,1.4385,1.4384,1.4384,1.4383,1.4382,1.4380,1.4378,&
	1.4376,1.4374,1.4372,1.4371,1.4370,1.4369,1.4368,1.4367,1.4365,1.4365,&
	1.4364,1.4364,1.4363,1.4363,1.4363,1.4363,1.4363,1.4363,1.4361,1.4361,&
	1.4359,1.4358,1.4356,1.4354,1.4353,1.4352,1.4351,1.4350,1.4349,1.4349,&
	1.4348,1.4347,1.4345,1.4344,1.4342,1.4342,1.4342,1.4341,1.4340,1.4339,&
	1.4338,1.4337,1.4336,1.4334,1.4334,1.4334,1.4334,1.4334,1.4333,1.4332,&
	1.4331,1.4329,1.4328,1.4327,1.4325,1.4324,1.4322,1.4321,1.4320,1.4318,&
	1.4317,1.4316,1.4315,1.4314,1.4314,1.4313,1.4312,1.4310,1.4309,1.4307,&
	1.4306,1.4304,1.4303,1.4303,1.4302,1.4301,1.4300,1.4297,1.4295,1.4294/

		data (nrefracfull(itmp),itmp=701,800)/&
	1.4293,1.4292,1.4291,1.4290,1.4290,1.4288,1.4286,1.4285,1.4283,1.4283,&
	1.4284,1.4284,1.4284,1.4284,1.4283,1.4283,1.4282,1.4280,1.4278,1.4276,&
	1.4275,1.4274,1.4272,1.4270,1.4268,1.4268,1.4267,1.4266,1.4266,1.4264,&
	1.4263,1.4262,1.4261,1.4259,1.4258,1.4257,1.4256,1.4256,1.4255,1.4254,&
	1.4252,1.4250,1.4249,1.4248,1.4247,1.4244,1.4241,1.4239,1.4237,1.4235,&
	1.4234,1.4233,1.4232,1.4230,1.4228,1.4226,1.4224,1.4224,1.4223,1.4223,&
	1.4223,1.4222,1.4222,1.4221,1.4221,1.4219,1.4218,1.4216,1.4216,1.4215,&
	1.4215,1.4213,1.4210,1.4208,1.4207,1.4206,1.4207,1.4207,1.4206,1.4206,&
	1.4205,1.4203,1.4201,1.4199,1.4198,1.4199,1.4201,1.4204,1.4205,1.4205,&
	1.4203,1.4200,1.4196,1.4192,1.4189,1.4187,1.4187,1.4188,1.4188,1.4187/

		data (nrefracfull(itmp),itmp=801,900)/&
	1.4186,1.4185,1.4183,1.4181,1.4180,1.4178,1.4178,1.4177,1.4176,1.4175,&
	1.4173,1.4173,1.4172,1.4172,1.4170,1.4168,1.4167,1.4165,1.4164,1.4163,&
	1.4161,1.4158,1.4156,1.4155,1.4154,1.4153,1.4151,1.4151,1.4151,1.4150,&
	1.4148,1.4147,1.4146,1.4145,1.4145,1.4143,1.4142,1.4139,1.4136,1.4134,&
	1.4133,1.4130,1.4129,1.4128,1.4128,1.4128,1.4126,1.4124,1.4123,1.4122,&
	1.4122,1.4121,1.4121,1.4120,1.4118,1.4116,1.4115,1.4114,1.4112,1.4112,&
	1.4111,1.4111,1.4110,1.4108,1.4106,1.4104,1.4103,1.4102,1.4102,1.4103,&
	1.4103,1.4101,1.4099,1.4097,1.4095,1.4093,1.4092,1.4091,1.4091,1.4091,&
	1.4090,1.4088,1.4086,1.4083,1.4081,1.4080,1.4079,1.4078,1.4077,1.4078,&
	1.4078,1.4078,1.4077,1.4076,1.4075,1.4073,1.4070,1.4068,1.4066,1.4064/

		data (nrefracfull(itmp),itmp=901,1000)/&
	1.4064,1.4062,1.4061,1.4059,1.4057,1.4056,1.4055,1.4055,1.4055,1.4056,&
	1.4057,1.4058,1.4058,1.4057,1.4055,1.4053,1.4051,1.4050,1.4049,1.4048,&
	1.4046,1.4045,1.4044,1.4044,1.4044,1.4045,1.4045,1.4044,1.4042,1.4040,&
	1.4040,1.4041,1.4042,1.4040,1.4037,1.4034,1.4032,1.4031,1.4030,1.4031,&
	1.4033,1.4034,1.4033,1.4032,1.4028,1.4023,1.4018,1.4013,1.4011,1.4010,&
	1.4008,1.4007,1.4004,1.4002,1.4000,1.4003,1.4004,1.4009,1.4012,1.4015,&
	1.4016,1.4015,1.4010,1.4002,1.3996,1.3992,1.3989,1.3992,1.3995,1.3997,&
	1.4000,1.4000,1.4000,1.4003,1.4002,1.3999,1.4002,1.4005,1.4008,1.4009,&
	1.4019,1.4015,1.4010,1.4001,1.4001,1.3988,1.3978,1.3971,1.3960,1.3968,&
	1.3958,1.3955,1.3952,1.3954,1.3945,1.3960,1.3961,1.3950,1.3946,1.3942/

		data (nrefracfull(itmp),itmp=1001,1100)/&
	1.3938,1.3936,1.3927,1.3926,1.3930,1.3943,1.3944,1.3944,1.3944,1.3937,&
	1.3933,1.3934,1.3934,1.3935,1.3934,1.3931,1.3928,1.3926,1.3920,1.3918,&
	1.3915,1.3910,1.3905,1.3898,1.3892,1.3880,1.3872,1.3865,1.3858,1.3852,&
	1.3844,1.3838,1.3829,1.3823,1.3810,1.3801,1.3794,1.3785,1.3776,1.3771,&
	1.3765,1.3758,1.3751,1.3743,1.3733,1.3725,1.3717,1.3711,1.3707,1.3703,&
	1.3700,1.3700,1.3697,1.3692,1.3685,1.3680,1.3675,1.3670,1.3667,1.3662,&
	1.3657,1.3659,1.3658,1.3656,1.3656,1.3654,1.3650,1.3653,1.3651,1.3649,&
	1.3651,1.3646,1.3642,1.3644,1.3640,1.3645,1.3643,1.3644,1.3647,1.3646,&
	1.3649,1.3644,1.3641,1.3635,1.3636,1.3633,1.3631,1.3635,1.3635,1.3643,&
	1.3642,1.3646,1.3643,1.3642,1.3637,1.3640,1.3638,1.3640,1.3640,1.3640/

		data (nrefracfull(itmp),itmp=1101,1200)/&
	1.3646,1.3645,1.3650,1.3650,1.3652,1.3657,1.3656,1.3660,1.3657,1.3662,&
	1.3665,1.3667,1.3671,1.3666,1.3669,1.3673,1.3673,1.3680,1.3686,1.3686,&
	1.3689,1.3693,1.3690,1.3694,1.3698,1.3695,1.3697,1.3698,1.3696,1.3698,&
	1.3700,1.3706,1.3705,1.3709,1.3712,1.3717,1.3718,1.3721,1.3721,1.3724,&
	1.3723,1.3721,1.3723,1.3724,1.3726,1.3723,1.3723,1.3727,1.3729,1.3730,&
	1.3730,1.3731,1.3731,1.3734,1.3735,1.3736,1.3737,1.3738,1.3736,1.3735,&
	1.3735,1.3735,1.3736,1.3738,1.3738,1.3739,1.3736,1.3737,1.3735,1.3735,&
	1.3735,1.3734,1.3734,1.3734,1.3735,1.3732,1.3733,1.3732,1.3732,1.3735,&
	1.3736,1.3739,1.3742,1.3741,1.3738,1.3737,1.3737,1.3736,1.3735,1.3737,&
	1.3738,1.3741,1.3743,1.3744,1.3745,1.3743,1.3740,1.3741,1.3741,1.3741/

		data (nrefracfull(itmp),itmp=1201,1300)/&
	1.3742,1.3742,1.3741,1.3743,1.3743,1.3743,1.3742,1.3741,1.3740,1.3741,&
	1.3738,1.3736,1.3734,1.3733,1.3731,1.3730,1.3730,1.3731,1.3731,1.3733,&
	1.3731,1.3730,1.3729,1.3728,1.3727,1.3726,1.3725,1.3726,1.3725,1.3726,&
	1.3726,1.3724,1.3720,1.3719,1.3716,1.3715,1.3712,1.3713,1.3711,1.3711,&
	1.3708,1.3708,1.3707,1.3708,1.3708,1.3710,1.3712,1.3715,1.3715,1.3716,&
	1.3715,1.3714,1.3712,1.3713,1.3710,1.3708,1.3704,1.3704,1.3700,1.3698,&
	1.3695,1.3694,1.3692,1.3690,1.3687,1.3687,1.3684,1.3685,1.3684,1.3684,&
	1.3683,1.3687,1.3682,1.3679,1.3674,1.3670,1.3665,1.3665,1.3664,1.3663,&
	1.3660,1.3659,1.3656,1.3655,1.3654,1.3655,1.3654,1.3654,1.3652,1.3651,&
	1.3648,1.3648,1.3647,1.3648,1.3647,1.3647,1.3646,1.3647,1.3646,1.3644/

		data (nrefracfull(itmp),itmp=1301,1400)/&
	1.3640,1.3638,1.3635,1.3634,1.3632,1.3631,1.3628,1.3629,1.3627,1.3629,&
	1.3629,1.3627,1.3625,1.3625,1.3623,1.3622,1.3620,1.3620,1.3619,1.3619,&
	1.3616,1.3615,1.3612,1.3612,1.3612,1.3613,1.3613,1.3617,1.3617,1.3618,&
	1.3618,1.3618,1.3615,1.3616,1.3615,1.3616,1.3618,1.3617,1.3616,1.3616,&
	1.3613,1.3612,1.3612,1.3616,1.3616,1.3617,1.3618,1.3621,1.3623,1.3625,&
	1.3626,1.3626,1.3625,1.3628,1.3633,1.3638,1.3638,1.3636,1.3635,1.3633,&
	1.3630,1.3629,1.3632,1.3636,1.3641,1.3646,1.3651,1.3654,1.3649,1.3640,&
	1.3630,1.3621,1.3615,1.3608,1.3608,1.3611,1.3617,1.3628,1.3638,1.3645,&
	1.3649,1.3646,1.3638,1.3625,1.3613,1.3601,1.3595,1.3593,1.3599,1.3607,&
	1.3614,1.3623,1.3627,1.3627,1.3624,1.3622,1.3619,1.3616,1.3616,1.3617/

		data (nrefracfull(itmp),itmp=1401,1500)/&
	1.3619,1.3621,1.3623,1.3626,1.3630,1.3635,1.3637,1.3639,1.3636,1.3632,&
	1.3629,1.3625,1.3624,1.3625,1.3628,1.3634,1.3638,1.3645,1.3650,1.3652,&
	1.3652,1.3650,1.3645,1.3642,1.3639,1.3638,1.3636,1.3634,1.3632,1.3632,&
	1.3631,1.3630,1.3624,1.3624,1.3624,1.3623,1.3626,1.3629,1.3629,1.3631,&
	1.3628,1.3622,1.3615,1.3607,1.3602,1.3598,1.3597,1.3599,1.3597,1.3597,&
	1.3596,1.3600,1.3593,1.3597,1.3602,1.3613,1.3625,1.3634,1.3638,1.3645,&
	1.3643,1.3648,1.3629,1.3632,1.3635,1.3645,1.3648,1.3662,1.3668,1.3684,&
	1.3653,1.3658,1.3664,1.3663,1.3672,1.3668,1.3680,1.3626,1.3620,1.3624,&
	1.3628,1.3617,1.3628,1.3562,1.3557,1.3558,1.3559,1.3555,1.3508,1.3504,&
	1.3512,1.3521,1.3525,1.3493,1.3504,1.3525,1.3546,1.3578,1.3556,1.3583/

		data (nrefracfull(itmp),itmp=1501,1600)/&
	1.3601,1.3610,1.3595,1.3599,1.3606,1.3612,1.3598,1.3601,1.3601,1.3606,&
	1.3599,1.3600,1.3603,1.3608,1.3606,1.3614,1.3615,1.3614,1.3606,1.3600,&
	1.3591,1.3577,1.3566,1.3554,1.3539,1.3530,1.3519,1.3510,1.3500,1.3493,&
	1.3486,1.3479,1.3468,1.3456,1.3445,1.3432,1.3421,1.3413,1.3402,1.3390,&
	1.3380,1.3363,1.3343,1.3328,1.3310,1.3296,1.3289,1.3282,1.3272,1.3273,&
	1.3261,1.3259,1.3244,1.3231,1.3226,1.3217,1.3203,1.3200,1.3185,1.3177,&
	1.3164,1.3147,1.3149,1.3138,1.3144,1.3139,1.3135,1.3140,1.3137,1.3141,&
	1.3133,1.3145,1.3135,1.3119,1.3122,1.3108,1.3104,1.3090,1.3095,1.3087,&
	1.3094,1.3089,1.3080,1.3089,1.3078,1.3080,1.3068,1.3070,1.3061,1.3067,&
	1.3065,1.3070,1.3065,1.3069,1.3061,1.3060,1.3047,1.3048,1.3035,1.3038/

		data (nrefracfull(itmp),itmp=1601,1700)/&
	1.3027,1.3018,1.3020,1.3025,1.3015,1.3019,1.3012,1.3015,1.3010,1.3018,&
	1.3013,1.3017,1.3009,1.3014,1.3006,1.3009,1.3003,1.3008,1.3002,1.3008,&
	1.3006,1.3013,1.3018,1.3009,1.3013,1.3010,1.3018,1.3014,1.3020,1.3026,&
	1.3019,1.3015,1.3004,1.3001,1.2989,1.2988,1.2990,1.2985,1.2993,1.2988,&
	1.2990,1.2990,1.2981,1.2983,1.2980,1.2989,1.2999,1.3000,1.3010,1.3010,&
	1.3017,1.3019,1.3012,1.3008,1.3008,1.3002,1.3008,1.3003,1.3006,1.3007,&
	1.3009,1.3010,1.3011,1.3013,1.3014,1.3015,1.3016,1.3017,1.3018,1.3019,&
	1.3020,1.3021,1.3022,1.3023,1.3024,1.3025,1.3025,1.3026,1.3027,1.3027,&
	1.3028,1.3029,1.3029,1.3030,1.3030,1.3030,1.3031,1.3031,1.3032,1.3032,&
	1.3032,1.3032,1.3032,1.3033,1.3033,1.3033,1.3033,1.3033,1.3033,1.3033/

		data (nrefracfull(itmp),itmp=1701,1800)/&
	1.3033,1.3033,1.3032,1.3032,1.3032,1.3032,1.3032,1.3031,1.3031,1.3031,&
	1.3030,1.3030,1.3030,1.3029,1.3029,1.3028,1.3028,1.3027,1.3027,1.3026,&
	1.3025,1.3025,1.3024,1.3023,1.3023,1.3022,1.3021,1.3021,1.3020,1.3019,&
	1.3018,1.3017,1.3016,1.3016,1.3015,1.3014,1.3013,1.3012,1.3011,1.3010,&
	1.3009,1.3008,1.3007,1.3005,1.3004,1.3003,1.3002,1.3001,1.2999,1.2998,&
	1.2997,1.2996,1.2995,1.2993,1.2992,1.2991,1.2990,1.2989,1.2987,1.2986,&
	1.2985,1.2984,1.2983,1.2981,1.2980,1.2979,1.2978,1.2977,1.2975,1.2974,&
	1.2973,1.2972,1.2970,1.2969,1.2967,1.2966,1.2965,1.2964,1.2962,1.2961,&
	1.2960,1.2959,1.2958,1.2957,1.2956,1.2955,1.2954,1.2953,1.2951,1.2950,&
	1.2949,1.2948,1.2947,1.2945,1.2944,1.2943,1.2942,1.2941,1.2939,1.2938/

		data (nrefracfull(itmp),itmp=1801,1900)/&
	1.2937,1.2936,1.2935,1.2933,1.2932,1.2931,1.2930,1.2928,1.2927,1.2925,&
	1.2924,1.2923,1.2922,1.2920,1.2919,1.2918,1.2917,1.2916,1.2914,1.2913,&
	1.2912,1.2911,1.2910,1.2908,1.2907,1.2906,1.2905,1.2904,1.2902,1.2901,&
	1.2900,1.2899,1.2898,1.2896,1.2895,1.2894,1.2893,1.2892,1.2890,1.2889,&
	1.2888,1.2887,1.2886,1.2884,1.2883,1.2882,1.2881,1.2880,1.2878,1.2877,&
	1.2876,1.2875,1.2874,1.2873,1.2872,1.2871,1.2870,1.2869,1.2867,1.2866,&
	1.2865,1.2864,1.2863,1.2862,1.2861,1.2860,1.2859,1.2858,1.2856,1.2855,&
	1.2854,1.2853,1.2852,1.2850,1.2849,1.2848,1.2847,1.2846,1.2845,1.2844,&
	1.2843,1.2842,1.2841,1.2840,1.2839,1.2838,1.2837,1.2836,1.2834,1.2833,&
	1.2832,1.2831,1.2830,1.2829,1.2828,1.2827,1.2826,1.2825,1.2824,1.2823/

		data (nrefracfull(itmp),itmp=1901,2000)/&
	1.2822,1.2821,1.2820,1.2818,1.2817,1.2816,1.2815,1.2814,1.2813,1.2812,&
	1.2811,1.2810,1.2809,1.2808,1.2807,1.2806,1.2805,1.2804,1.2803,1.2802,&
	1.2801,1.2800,1.2799,1.2799,1.2798,1.2797,1.2796,1.2795,1.2795,1.2794,&
	1.2793,1.2792,1.2791,1.2791,1.2790,1.2789,1.2788,1.2788,1.2787,1.2787,&
	1.2786,1.2785,1.2785,1.2784,1.2784,1.2783,1.2782,1.2781,1.2780,1.2779,&
	1.2778,1.2777,1.2776,1.2776,1.2775,1.2774,1.2773,1.2772,1.2771,1.2770,&
	1.2769,1.2768,1.2767,1.2766,1.2765,1.2764,1.2763,1.2762,1.2761,1.2760,&
	1.2759,1.2758,1.2757,1.2757,1.2756,1.2755,1.2754,1.2753,1.2753,1.2752,&
	1.2751,1.2750,1.2749,1.2749,1.2748,1.2747,1.2746,1.2745,1.2745,1.2744,&
	1.2743,1.2742,1.2742,1.2741,1.2741,1.2740,1.2739,1.2739,1.2738,1.2738/

		data (nrefracfull(itmp),itmp=2001,2101)/&
	1.2737,1.2736,1.2736,1.2735,1.2735,1.2734,1.2733,1.2733,1.2732,1.2732,&
	1.2731,1.2730,1.2730,1.2729,1.2729,1.2728,1.2727,1.2727,1.2726,1.2726,&
	1.2725,1.2725,1.2724,1.2724,1.2723,1.2723,1.2722,1.2722,1.2721,1.2721,&
	1.2720,1.2720,1.2719,1.2719,1.2718,1.2718,1.2717,1.2717,1.2716,1.2716,&
	1.2715,1.2715,1.2714,1.2714,1.2713,1.2713,1.2713,1.2713,1.2712,1.2712,&
	1.2712,1.2712,1.2711,1.2711,1.2710,1.2710,1.2710,1.2710,1.2709,1.2709,&
	1.2709,1.2709,1.2709,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,&
	1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2708,1.2709,1.2709,1.2710,&
	1.2710,1.2711,1.2712,1.2712,1.2713,1.2714,1.2715,1.2716,1.2717,1.2718,&
	1.2719,1.2720,1.2722,1.2723,1.2725,1.2726,1.2728,1.2730,1.2732,1.2734,&
	1.2736/


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of chlorophyll					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		data (acabfull(itmp),itmp=1,100)/&
	2.676e-02,3.113e-02,3.561e-02,3.972e-02,4.321e-02,4.606e-02,4.815e-02,5.007e-02,5.189e-02,5.346e-02,&
	5.526e-02,5.721e-02,5.891e-02,6.004e-02,6.100e-02,6.189e-02,6.259e-02,6.318e-02,6.367e-02,6.416e-02,&
	6.475e-02,6.555e-02,6.628e-02,6.690e-02,6.718e-02,6.747e-02,6.795e-02,6.855e-02,6.897e-02,6.931e-02,&
	6.979e-02,7.037e-02,7.082e-02,7.114e-02,7.141e-02,7.160e-02,7.174e-02,7.177e-02,7.171e-02,7.156e-02,&
	7.120e-02,7.048e-02,6.963e-02,6.883e-02,6.789e-02,6.685e-02,6.583e-02,6.480e-02,6.358e-02,6.225e-02,&
	6.090e-02,5.956e-02,5.813e-02,5.677e-02,5.553e-02,5.439e-02,5.330e-02,5.224e-02,5.135e-02,5.056e-02,&
	4.990e-02,4.934e-02,4.891e-02,4.852e-02,4.812e-02,4.767e-02,4.729e-02,4.698e-02,4.673e-02,4.647e-02,&
	4.622e-02,4.606e-02,4.589e-02,4.570e-02,4.552e-02,4.535e-02,4.519e-02,4.492e-02,4.466e-02,4.442e-02,&
	4.413e-02,4.373e-02,4.325e-02,4.275e-02,4.216e-02,4.149e-02,4.073e-02,3.989e-02,3.895e-02,3.791e-02,&
	3.683e-02,3.571e-02,3.455e-02,3.335e-02,3.215e-02,3.094e-02,2.972e-02,2.850e-02,2.730e-02,2.615e-02/

		data (acabfull(itmp),itmp=101,200)/&
	2.502e-02,2.395e-02,2.294e-02,2.199e-02,2.109e-02,2.025e-02,1.946e-02,1.873e-02,1.804e-02,1.740e-02,&
	1.680e-02,1.622e-02,1.567e-02,1.515e-02,1.466e-02,1.418e-02,1.373e-02,1.331e-02,1.291e-02,1.254e-02,&
	1.220e-02,1.189e-02,1.161e-02,1.136e-02,1.114e-02,1.096e-02,1.080e-02,1.067e-02,1.057e-02,1.050e-02,&
	1.044e-02,1.041e-02,1.040e-02,1.041e-02,1.043e-02,1.046e-02,1.050e-02,1.055e-02,1.061e-02,1.067e-02,&
	1.073e-02,1.080e-02,1.087e-02,1.094e-02,1.100e-02,1.107e-02,1.113e-02,1.118e-02,1.124e-02,1.130e-02,&
	1.136e-02,1.143e-02,1.150e-02,1.159e-02,1.170e-02,1.182e-02,1.196e-02,1.212e-02,1.230e-02,1.249e-02,&
	1.271e-02,1.294e-02,1.318e-02,1.344e-02,1.371e-02,1.400e-02,1.431e-02,1.464e-02,1.499e-02,1.535e-02,&
	1.572e-02,1.611e-02,1.649e-02,1.688e-02,1.726e-02,1.763e-02,1.799e-02,1.833e-02,1.866e-02,1.898e-02,&
	1.929e-02,1.958e-02,1.986e-02,2.013e-02,2.038e-02,2.063e-02,2.086e-02,2.107e-02,2.128e-02,2.147e-02,&
	2.164e-02,2.180e-02,2.194e-02,2.208e-02,2.219e-02,2.230e-02,2.240e-02,2.250e-02,2.259e-02,2.269e-02/

		data (acabfull(itmp),itmp=201,300)/&
	2.279e-02,2.291e-02,2.304e-02,2.319e-02,2.337e-02,2.356e-02,2.378e-02,2.403e-02,2.430e-02,2.459e-02,&
	2.489e-02,2.520e-02,2.552e-02,2.586e-02,2.620e-02,2.654e-02,2.687e-02,2.719e-02,2.750e-02,2.778e-02,&
	2.803e-02,2.826e-02,2.845e-02,2.862e-02,2.877e-02,2.888e-02,2.898e-02,2.905e-02,2.910e-02,2.916e-02,&
	2.921e-02,2.928e-02,2.938e-02,2.951e-02,2.969e-02,2.993e-02,3.022e-02,3.059e-02,3.103e-02,3.152e-02,&
	3.208e-02,3.269e-02,3.335e-02,3.405e-02,3.478e-02,3.552e-02,3.626e-02,3.698e-02,3.767e-02,3.831e-02,&
	3.890e-02,3.943e-02,3.993e-02,4.043e-02,4.095e-02,4.152e-02,4.217e-02,4.293e-02,4.380e-02,4.479e-02,&
	4.588e-02,4.709e-02,4.837e-02,4.970e-02,5.106e-02,5.239e-02,5.368e-02,5.488e-02,5.595e-02,5.688e-02,&
	5.765e-02,5.826e-02,5.871e-02,5.900e-02,5.914e-02,5.914e-02,5.899e-02,5.868e-02,5.819e-02,5.748e-02,&
	5.650e-02,5.522e-02,5.361e-02,5.168e-02,4.941e-02,4.689e-02,4.416e-02,4.128e-02,3.834e-02,3.541e-02,&
	3.254e-02,2.978e-02,2.717e-02,2.473e-02,2.247e-02,2.039e-02,1.850e-02,1.678e-02,1.523e-02,1.384e-02/

		data (acabfull(itmp),itmp=301,400)/&
	1.259e-02,1.147e-02,1.048e-02,9.594e-03,8.804e-03,8.099e-03,7.465e-03,6.892e-03,6.371e-03,5.897e-03,&
	5.461e-03,5.061e-03,4.691e-03,4.348e-03,4.029e-03,3.733e-03,3.456e-03,3.199e-03,2.960e-03,2.736e-03,&
	2.528e-03,2.334e-03,2.153e-03,1.985e-03,1.829e-03,1.683e-03,1.549e-03,1.424e-03,1.309e-03,1.202e-03,&
	1.103e-03,1.012e-03,9.268e-04,8.485e-04,7.767e-04,7.109e-04,6.505e-04,5.948e-04,5.437e-04,4.967e-04,&
	4.539e-04,4.150e-04,3.794e-04,3.471e-04,3.177e-04,2.909e-04,2.666e-04,2.450e-04,2.255e-04,2.079e-04,&
	1.924e-04,1.788e-04,1.667e-04,1.556e-04,1.456e-04,1.365e-04,1.282e-04,1.209e-04,1.142e-04,1.083e-04,&
	1.036e-04,9.885e-05,9.424e-05,8.971e-05,8.527e-05,8.092e-05,7.667e-05,7.252e-05,6.846e-05,6.451e-05,&
	6.065e-05,5.690e-05,5.325e-05,4.971e-05,4.628e-05,4.295e-05,3.974e-05,3.664e-05,3.365e-05,3.078e-05,&
	2.802e-05,2.539e-05,2.287e-05,2.048e-05,1.821e-05,1.606e-05,1.404e-05,1.215e-05,1.040e-05,8.767e-06,&
	7.272e-06,5.912e-06,4.688e-06,3.602e-06,2.656e-06,1.851e-06,1.189e-06,6.710e-07,2.990e-07,7.500e-08/

		data (acabfull(itmp),itmp=401,2101)/1701*0./

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of carotenoids					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

              data (acarfull(itmp),itmp=1,2101)/&
          0.52718, 0.52618, 0.52518, 0.52418, 0.52318, 0.52218, 0.52118,&
          0.52019, 0.51919, 0.51819, 0.51719, 0.51619, 0.51519, 0.51419,&
          0.51319, 0.51219, 0.51119, 0.51019, 0.50919, 0.50819, 0.50719,&
          0.50619, 0.50519, 0.50419, 0.50319, 0.50219, 0.50119, 0.50019,&
          0.49919, 0.49819, 0.49719, 0.49599, 0.49480, 0.49360, 0.49241,&
          0.49121, 0.49002, 0.48883, 0.48763, 0.48644, 0.48524, 0.48405,&
          0.48285, 0.48166, 0.48046, 0.47927, 0.47807, 0.47688, 0.47568,&
          0.47449, 0.47329, 0.47204, 0.47079, 0.46954, 0.46828, 0.46703,&
          0.46578, 0.46453, 0.46328, 0.46203, 0.46077, 0.45974, 0.45870,&
          0.45767, 0.45664, 0.45560, 0.45457, 0.45353, 0.45250, 0.45146,&
          0.45043, 0.44939, 0.44836, 0.44733, 0.44629, 0.44526, 0.44422,&
          0.44319, 0.44216, 0.44112, 0.44009, 0.43880, 0.43752, 0.43623,&
          0.43495, 0.43367, 0.43238, 0.43110, 0.42982, 0.42853, 0.42725,&
          0.42597, 0.42468, 0.42340, 0.42276, 0.42212, 0.42083, 0.41955,&
          0.41826, 0.41698, 0.41570, 0.41441, 0.41354, 0.41266, 0.41179,&
          0.41091, 0.41004, 0.40917, 0.40829, 0.40742, 0.40654, 0.40567,&
          0.40472, 0.40377, 0.40282, 0.40092, 0.39998, 0.39903, 0.39808,&
          0.39713, 0.39618, 0.39523, 0.39429, 0.39334, 0.39239, 0.39144,&
          0.39049, 0.38954, 0.38860, 0.38765, 0.38670, 0.38456, 0.38243,&
          0.38029, 0.37816, 0.37603, 0.37389, 0.37176, 0.36962, 0.36749,&
          0.36535, 0.36393, 0.36251, 0.36108, 0.35966, 0.35824, 0.35682,&
          0.35539, 0.35397, 0.35255, 0.35113, 0.35002, 0.34892, 0.34782,&
          0.34673, 0.34562, 0.34452, 0.34342, 0.34232, 0.34122, 0.34012,&
          0.33834, 0.33655, 0.33477, 0.33298, 0.33120, 0.32941, 0.32763,&
          0.32584, 0.32406, 0.32227, 0.32125, 0.32023, 0.31819, 0.31615,&
          0.31411, 0.31207, 0.31003, 0.30799, 0.30595, 0.30391, 0.30187,&
          0.29989, 0.29792, 0.29595, 0.29397, 0.29200, 0.29002, 0.28805,&
          0.28608, 0.28410, 0.28213, 0.28027, 0.27842, 0.27656, 0.27470,&
          0.27285, 0.27099, 0.26913, 0.26727, 0.26542, 0.26356, 0.26183,&
          0.26010, 0.25837, 0.25664, 0.25491, 0.25318, 0.24972, 0.24799,&
          0.24626, 0.24466, 0.24305, 0.24145, 0.23984, 0.23824, 0.23663,&
          0.23503, 0.23342, 0.23181, 0.23021, 0.22875, 0.22729, 0.22584,&
          0.22438, 0.22292, 0.22146, 0.22001, 0.21855, 0.21709, 0.21563,&
          0.21427, 0.21290, 0.21154, 0.21017, 0.20880, 0.20744, 0.20607,&
          0.20470, 0.20333, 0.20197, 0.20067, 0.19937, 0.19807, 0.19677,&
          0.19547, 0.19417, 0.19288, 0.19158, 0.19028, 0.18898, 0.18776,&
          0.18653, 0.18531, 0.18409, 0.18286, 0.18164, 0.18042, 0.17920,&
          0.17797, 0.17675, 0.17548, 0.17421, 0.17294, 0.17167, 0.17040,&
          0.16913, 0.16786, 0.16659, 0.16532, 0.16406, 0.16269, 0.16133,&
          0.15997, 0.15860, 0.15724, 0.15588, 0.15452, 0.15316, 0.15179,&
          0.15043, 0.14909, 0.14775, 0.14642, 0.14508, 0.14374, 0.14240,&
          0.14106, 0.13972, 0.13839, 0.13705, 0.13580, 0.13454, 0.13329,&
          0.13204, 0.13079, 0.12954, 0.12829, 0.12704, 0.12578, 0.12453,&
          0.12341, 0.12229, 0.12116, 0.12004, 0.11892, 0.11780, 0.11667,&
          0.11555, 0.11443, 0.11331, 0.11221, 0.11112, 0.11002, 0.10893,&
          0.10784, 0.10674, 0.10565, 0.10455, 0.10346, 0.10236, 0.10135,&
          0.10033, 0.09931, 0.09829, 0.09727, 0.09625, 0.09524, 0.09422,&
          0.09320, 0.09218, 0.09120, 0.09022, 0.08924, 0.08826, 0.08729,&
          0.08631, 0.08533, 0.08435, 0.08337, 0.08239, 0.08155, 0.08070,&
          0.07985, 0.07901, 0.07816, 0.07731, 0.07647, 0.07562, 0.07477,&
          0.07393, 0.07319, 0.07245, 0.07171, 0.07097, 0.07023, 0.06949,&
          0.06875, 0.06801, 0.06727, 0.06653, 0.06586, 0.06519, 0.06452,&
          0.06385, 0.06318, 0.06251, 0.06184, 0.06117, 0.06050, 0.05983,&
          0.05913, 0.05843, 0.05773, 0.05704, 0.05634, 0.05564, 0.05494,&
          0.05424, 0.05354, 0.05284, 0.05226, 0.05167, 0.05109, 0.05050,&
          0.04992, 0.04933, 0.04874, 0.04816, 0.04757, 0.04699, 0.04646,&
          0.04594, 0.04542, 0.04490, 0.04437, 0.04385, 0.04333, 0.04281,&
          0.04228, 0.04176, 0.04128, 0.04081, 0.04033, 0.03985, 0.03937,&
          0.03889, 0.03841, 0.03793, 0.03746, 0.03698, 0.03657, 0.03615,&
          0.03574, 0.03533, 0.03492, 0.03451, 0.03409, 0.03368, 0.03327,&
          0.03286, 0.03249, 0.03212, 0.03175, 0.03139, 0.03102, 0.03065,&
          0.03028, 0.02991, 0.02954, 0.02917, 0.02885, 0.02852, 0.02819,&
          0.02786, 0.02753, 0.02720, 0.02687, 0.02655, 0.02622, 0.02589,&
          0.02559, 0.02529, 0.02499, 0.02469, 0.02440, 0.02410, 0.02380,&
          0.02350, 0.02320, 0.02290, 0.02264, 0.02238, 0.02212, 0.02185,&
          0.02159, 0.02133, 0.02107, 0.02081, 0.02055, 0.02029, 0.02006,&
          0.01983, 0.01961, 0.01938, 0.01915, 0.01893, 0.01870, 0.01847,&
          0.01825, 0.01802, 0.01782, 0.01762, 0.01742, 0.01723, 0.01703,&
          0.01683, 0.01663, 0.01643, 0.01623, 0.01604, 0.01586, 0.01568,&
          0.01551, 0.01533, 0.01516, 0.01498, 0.01481, 0.01463, 0.01446,&
          0.01428, 0.01414, 0.01400, 0.01385, 0.01371, 0.01357, 0.01342,&
          0.01328, 0.01314, 0.01300, 0.01286, 0.01274, 0.01262, 0.01250,&
          0.01239, 0.01227, 0.01215, 0.01203, 0.01192, 0.01180, 0.01168,&
          0.01158, 0.01148, 0.01137, 0.01127, 0.01116, 0.01106, 0.01096,&
          0.01086, 0.01075, 0.01065, 0.01052, 0.01039, 0.01027, 0.01014,&
          0.01001, 0.00988, 0.00976, 0.00963, 0.00950, 0.00937, 0.00927,&
          0.00916, 0.00905, 0.00894, 0.00883, 0.00872, 0.00861, 0.00850,&
          0.00839, 0.00829, 0.00819, 0.00810, 0.00801, 0.00792, 0.00783,&
          0.00773, 0.00764, 0.00755, 0.00746, 0.00737, 0.00729, 0.00721,&
          0.00713, 0.00705, 0.00696, 0.00688, 0.00681, 0.00673, 0.00664,&
          0.00656, 0.00649, 0.00641, 0.00634, 0.00626, 0.00618, 0.00611,&
          0.00603, 0.00595, 0.00588, 0.00580, 0.00572, 0.00564, 0.00556,&
          0.00548, 0.00541, 0.00533, 0.00525, 0.00517, 0.00509, 0.00501,&
          0.00493, 0.00485, 0.00476, 0.00468, 0.00460, 0.00451, 0.00443,&
          0.00435, 0.00427, 0.00419, 0.00410, 0.00401, 0.00393, 0.00384,&
          0.00376, 0.00367, 0.00358, 0.00350, 0.00341, 0.00332, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000 /		

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!					specific absorption of water					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	    data (acwfull(itmp),itmp=1,100)/&
	5.800e-05,5.852e-05,5.900e-05,5.989e-05,6.100e-05,6.203e-05,6.300e-05,6.399e-05,6.500e-05,6.603e-05,&
	6.700e-05,6.790e-05,6.900e-05,7.050e-05,7.200e-05,7.312e-05,7.400e-05,7.490e-05,7.600e-05,7.740e-05,&
	7.900e-05,8.063e-05,8.200e-05,8.297e-05,8.400e-05,8.551e-05,8.700e-05,8.800e-05,8.900e-05,9.050e-05,&
	9.200e-05,9.300e-05,9.400e-05,9.550e-05,9.700e-05,9.801e-05,9.900e-05,1.005e-04,1.020e-04,1.031e-04,&
	1.040e-04,1.050e-04,1.060e-04,1.070e-04,1.080e-04,1.090e-04,1.100e-04,1.110e-04,1.120e-04,1.130e-04,&
	1.140e-04,1.150e-04,1.160e-04,1.170e-04,1.180e-04,1.190e-04,1.200e-04,1.210e-04,1.220e-04,1.230e-04,&
	1.240e-04,1.250e-04,1.260e-04,1.270e-04,1.280e-04,1.289e-04,1.300e-04,1.315e-04,1.330e-04,1.340e-04,&
	1.350e-04,1.364e-04,1.380e-04,1.396e-04,1.410e-04,1.424e-04,1.440e-04,1.459e-04,1.480e-04,1.499e-04,&
	1.520e-04,1.544e-04,1.570e-04,1.596e-04,1.620e-04,1.643e-04,1.670e-04,1.704e-04,1.740e-04,1.775e-04,&
	1.810e-04,1.849e-04,1.890e-04,1.934e-04,1.980e-04,2.031e-04,2.090e-04,2.158e-04,2.230e-04,2.303e-04/

      data (acwfull(itmp),itmp=101,200)/&
	2.380e-04,2.463e-04,2.550e-04,2.640e-04,2.730e-04,2.819e-04,2.910e-04,3.004e-04,3.100e-04,3.194e-04,&
	3.290e-04,3.390e-04,3.490e-04,3.588e-04,3.680e-04,3.767e-04,3.860e-04,3.962e-04,4.040e-04,4.069e-04,&
	4.090e-04,4.138e-04,4.160e-04,4.112e-04,4.090e-04,4.176e-04,4.270e-04,4.268e-04,4.230e-04,4.237e-04,&
	4.290e-04,4.371e-04,4.450e-04,4.506e-04,4.560e-04,4.631e-04,4.700e-04,4.748e-04,4.800e-04,4.879e-04,&
	4.950e-04,4.983e-04,5.030e-04,5.141e-04,5.270e-04,5.363e-04,5.440e-04,5.532e-04,5.640e-04,5.759e-04,&
	5.880e-04,5.998e-04,6.110e-04,6.215e-04,6.310e-04,6.391e-04,6.460e-04,6.520e-04,6.580e-04,6.647e-04,&
	6.720e-04,6.793e-04,6.860e-04,6.920e-04,6.990e-04,7.084e-04,7.180e-04,7.257e-04,7.340e-04,7.455e-04,&
	7.590e-04,7.729e-04,7.870e-04,8.020e-04,8.190e-04,8.386e-04,8.580e-04,8.754e-04,8.960e-04,9.238e-04,&
	9.520e-04,9.745e-04,1.000e-03,1.037e-03,1.079e-03,1.119e-03,1.159e-03,1.204e-03,1.253e-03,1.304e-03,&
	1.356e-03,1.408e-03,1.459e-03,1.510e-03,1.567e-03,1.635e-03,1.700e-03,1.758e-03,1.860e-03,2.042e-03/

      data (acwfull(itmp),itmp=201,300)/&
	2.224e-03,2.323e-03,2.366e-03,2.400e-03,2.448e-03,2.519e-03,2.587e-03,2.629e-03,2.653e-03,2.674e-03,&
	2.691e-03,2.704e-03,2.715e-03,2.727e-03,2.740e-03,2.753e-03,2.764e-03,2.775e-03,2.785e-03,2.797e-03,&
	2.810e-03,2.824e-03,2.839e-03,2.854e-03,2.868e-03,2.881e-03,2.893e-03,2.907e-03,2.922e-03,2.938e-03,&
	2.955e-03,2.972e-03,2.988e-03,3.000e-03,3.011e-03,3.023e-03,3.038e-03,3.057e-03,3.076e-03,3.094e-03,&
	3.111e-03,3.127e-03,3.144e-03,3.162e-03,3.181e-03,3.202e-03,3.223e-03,3.242e-03,3.263e-03,3.289e-03,&
	3.315e-03,3.338e-03,3.362e-03,3.390e-03,3.423e-03,3.461e-03,3.508e-03,3.567e-03,3.636e-03,3.712e-03,&
	3.791e-03,3.866e-03,3.931e-03,3.981e-03,4.019e-03,4.049e-03,4.072e-03,4.087e-03,4.098e-03,4.109e-03,&
	4.122e-03,4.137e-03,4.150e-03,4.160e-03,4.173e-03,4.196e-03,4.223e-03,4.248e-03,4.270e-03,4.293e-03,&
	4.318e-03,4.347e-03,4.381e-03,4.418e-03,4.458e-03,4.500e-03,4.545e-03,4.594e-03,4.646e-03,4.701e-03,&
	4.760e-03,4.827e-03,4.903e-03,4.986e-03,5.071e-03,5.154e-03,5.244e-03,5.351e-03,5.470e-03,5.594e-03/

      data (acwfull(itmp),itmp=301,400)/&
	5.722e-03,5.855e-03,5.995e-03,6.146e-03,6.303e-03,6.463e-03,6.628e-03,6.804e-03,6.993e-03,7.197e-03,&
	7.415e-03,7.647e-03,7.893e-03,8.157e-03,8.445e-03,8.763e-03,9.109e-03,9.479e-03,9.871e-03,1.029e-02,&
	1.072e-02,1.119e-02,1.168e-02,1.218e-02,1.268e-02,1.319e-02,1.372e-02,1.428e-02,1.487e-02,1.551e-02,&
	1.621e-02,1.699e-02,1.787e-02,1.886e-02,1.992e-02,2.101e-02,2.207e-02,2.306e-02,2.394e-02,2.469e-02,&
	2.532e-02,2.583e-02,2.623e-02,2.652e-02,2.672e-02,2.689e-02,2.702e-02,2.713e-02,2.722e-02,2.728e-02,&
	2.733e-02,2.738e-02,2.741e-02,2.745e-02,2.748e-02,2.751e-02,2.754e-02,2.758e-02,2.763e-02,2.767e-02,&
	2.771e-02,2.773e-02,2.773e-02,2.774e-02,2.774e-02,2.773e-02,2.770e-02,2.766e-02,2.761e-02,2.757e-02,&
	2.754e-02,2.752e-02,2.748e-02,2.741e-02,2.731e-02,2.720e-02,2.710e-02,2.701e-02,2.690e-02,2.675e-02,&
	2.659e-02,2.645e-02,2.633e-02,2.624e-02,2.613e-02,2.593e-02,2.558e-02,2.523e-02,2.513e-02,2.501e-02,&
	2.466e-02,2.447e-02,2.412e-02,2.389e-02,2.374e-02,2.355e-02,2.337e-02,2.318e-02,2.304e-02,2.281e-02/

      data (acwfull(itmp),itmp=401,500)/&
	2.246e-02,2.243e-02,2.238e-02,2.222e-02,2.204e-02,2.201e-02,2.204e-02,2.196e-02,2.177e-02,2.190e-02,&
	2.188e-02,2.188e-02,2.198e-02,2.210e-02,2.223e-02,2.233e-02,2.248e-02,2.276e-02,2.304e-02,2.311e-02,&
	2.329e-02,2.388e-02,2.446e-02,2.475e-02,2.516e-02,2.620e-02,2.769e-02,2.830e-02,2.914e-02,3.108e-02,&
	3.214e-02,3.297e-02,3.459e-02,3.606e-02,3.662e-02,3.702e-02,3.788e-02,3.829e-02,3.854e-02,3.909e-02,&
	3.949e-02,3.972e-02,4.000e-02,4.040e-02,4.057e-02,4.075e-02,4.115e-02,4.127e-02,4.149e-02,4.204e-02,&
	4.199e-02,4.223e-02,4.254e-02,4.272e-02,4.280e-02,4.306e-02,4.360e-02,4.369e-02,4.379e-02,4.433e-02,&
	4.454e-02,4.466e-02,4.505e-02,4.527e-02,4.552e-02,4.605e-02,4.658e-02,4.691e-02,4.705e-02,4.713e-02,&
	4.752e-02,4.833e-02,4.867e-02,4.894e-02,4.960e-02,5.006e-02,5.050e-02,5.115e-02,5.153e-02,5.204e-02,&
	5.298e-02,5.346e-02,5.386e-02,5.465e-02,5.528e-02,5.566e-02,5.596e-02,5.653e-02,5.745e-02,5.789e-02,&
	5.831e-02,5.924e-02,5.982e-02,6.009e-02,6.035e-02,6.094e-02,6.185e-02,6.226e-02,6.269e-02,6.360e-02/

      data (acwfull(itmp),itmp=501,600)/&
	6.407e-02,6.458e-02,6.562e-02,6.636e-02,6.672e-02,6.699e-02,6.769e-02,6.900e-02,6.989e-02,7.037e-02,&
	7.085e-02,7.187e-02,7.358e-02,7.486e-02,7.562e-02,7.630e-02,7.792e-02,8.085e-02,8.292e-02,8.410e-02,&
	8.528e-02,8.801e-02,9.268e-02,9.584e-02,9.819e-02,1.012e-01,1.042e-01,1.066e-01,1.113e-01,1.194e-01,&
	1.246e-01,1.281e-01,1.327e-01,1.374e-01,1.410e-01,1.465e-01,1.557e-01,1.635e-01,1.688e-01,1.732e-01,&
	1.818e-01,1.963e-01,2.050e-01,2.106e-01,2.187e-01,2.287e-01,2.386e-01,2.468e-01,2.542e-01,2.701e-01,&
	2.976e-01,3.153e-01,3.274e-01,3.438e-01,3.622e-01,3.785e-01,3.930e-01,4.068e-01,4.184e-01,4.273e-01,&
	4.385e-01,4.538e-01,4.611e-01,4.633e-01,4.663e-01,4.701e-01,4.733e-01,4.756e-01,4.772e-01,4.785e-01,&
	4.800e-01,4.814e-01,4.827e-01,4.843e-01,4.864e-01,4.870e-01,4.867e-01,4.864e-01,4.857e-01,4.841e-01,&
	4.821e-01,4.804e-01,4.786e-01,4.764e-01,4.738e-01,4.710e-01,4.677e-01,4.641e-01,4.604e-01,4.570e-01,&
	4.532e-01,4.482e-01,4.434e-01,4.397e-01,4.362e-01,4.316e-01,4.265e-01,4.215e-01,4.168e-01,4.121e-01/

      data (acwfull(itmp),itmp=601,700)/&
	4.072e-01,4.017e-01,3.963e-01,3.915e-01,3.868e-01,3.816e-01,3.760e-01,3.701e-01,3.640e-01,3.581e-01,&
	3.521e-01,3.461e-01,3.402e-01,3.349e-01,3.297e-01,3.243e-01,3.191e-01,3.141e-01,3.086e-01,3.022e-01,&
	2.957e-01,2.897e-01,2.840e-01,2.782e-01,2.724e-01,2.672e-01,2.621e-01,2.566e-01,2.506e-01,2.444e-01,&
	2.391e-01,2.357e-01,2.331e-01,2.299e-01,2.251e-01,2.198e-01,2.151e-01,2.109e-01,2.064e-01,2.020e-01,&
	1.981e-01,1.944e-01,1.904e-01,1.868e-01,1.841e-01,1.818e-01,1.790e-01,1.752e-01,1.715e-01,1.687e-01,&
	1.664e-01,1.639e-01,1.613e-01,1.586e-01,1.562e-01,1.545e-01,1.532e-01,1.522e-01,1.510e-01,1.495e-01,&
	1.475e-01,1.457e-01,1.447e-01,1.442e-01,1.438e-01,1.433e-01,1.426e-01,1.418e-01,1.412e-01,1.410e-01,&
	1.409e-01,1.408e-01,1.406e-01,1.405e-01,1.408e-01,1.414e-01,1.426e-01,1.435e-01,1.438e-01,1.439e-01,&
	1.443e-01,1.456e-01,1.475e-01,1.498e-01,1.519e-01,1.534e-01,1.547e-01,1.561e-01,1.580e-01,1.604e-01,&
	1.632e-01,1.659e-01,1.677e-01,1.693e-01,1.712e-01,1.739e-01,1.777e-01,1.824e-01,1.866e-01,1.890e-01/

      data (acwfull(itmp),itmp=701,800)/&
	1.906e-01,1.929e-01,1.967e-01,2.005e-01,2.031e-01,2.051e-01,2.079e-01,2.123e-01,2.166e-01,2.196e-01,&
	2.219e-01,2.251e-01,2.298e-01,2.337e-01,2.346e-01,2.342e-01,2.353e-01,2.397e-01,2.450e-01,2.491e-01,&
	2.528e-01,2.578e-01,2.650e-01,2.719e-01,2.765e-01,2.811e-01,2.891e-01,3.023e-01,3.164e-01,3.271e-01,&
	3.378e-01,3.533e-01,3.770e-01,4.037e-01,4.281e-01,4.502e-01,4.712e-01,4.932e-01,5.202e-01,5.572e-01,&
	6.052e-01,6.520e-01,6.863e-01,7.159e-01,7.535e-01,8.064e-01,8.597e-01,8.981e-01,9.253e-01,9.493e-01,&
	9.769e-01,1.008e+00,1.041e+00,1.073e+00,1.100e+00,1.119e+00,1.131e+00,1.140e+00,1.150e+00,1.160e+00,&
	1.170e+00,1.181e+00,1.190e+00,1.194e+00,1.196e+00,1.197e+00,1.200e+00,1.203e+00,1.205e+00,1.206e+00,&
	1.207e+00,1.213e+00,1.223e+00,1.232e+00,1.234e+00,1.232e+00,1.229e+00,1.230e+00,1.233e+00,1.236e+00,&
	1.239e+00,1.241e+00,1.244e+00,1.248e+00,1.252e+00,1.256e+00,1.258e+00,1.260e+00,1.262e+00,1.265e+00,&
	1.267e+00,1.270e+00,1.272e+00,1.275e+00,1.277e+00,1.280e+00,1.282e+00,1.283e+00,1.283e+00,1.279e+00/

      data (acwfull(itmp),itmp=801,900)/&
	1.272e+00,1.266e+00,1.267e+00,1.271e+00,1.273e+00,1.271e+00,1.265e+00,1.260e+00,1.258e+00,1.258e+00,&
	1.257e+00,1.252e+00,1.247e+00,1.243e+00,1.243e+00,1.243e+00,1.240e+00,1.233e+00,1.224e+00,1.216e+00,&
	1.214e+00,1.214e+00,1.213e+00,1.210e+00,1.205e+00,1.200e+00,1.199e+00,1.198e+00,1.197e+00,1.194e+00,&
	1.189e+00,1.184e+00,1.180e+00,1.176e+00,1.171e+00,1.166e+00,1.161e+00,1.158e+00,1.157e+00,1.157e+00,&
	1.155e+00,1.152e+00,1.148e+00,1.142e+00,1.138e+00,1.133e+00,1.130e+00,1.126e+00,1.123e+00,1.120e+00,&
	1.116e+00,1.111e+00,1.107e+00,1.103e+00,1.101e+00,1.101e+00,1.101e+00,1.101e+00,1.100e+00,1.098e+00,&
	1.094e+00,1.089e+00,1.085e+00,1.084e+00,1.083e+00,1.083e+00,1.082e+00,1.081e+00,1.080e+00,1.079e+00,&
	1.080e+00,1.083e+00,1.087e+00,1.093e+00,1.099e+00,1.104e+00,1.107e+00,1.109e+00,1.111e+00,1.115e+00,&
	1.121e+00,1.129e+00,1.137e+00,1.147e+00,1.156e+00,1.164e+00,1.170e+00,1.175e+00,1.181e+00,1.188e+00,&
	1.196e+00,1.206e+00,1.216e+00,1.227e+00,1.239e+00,1.252e+00,1.267e+00,1.283e+00,1.297e+00,1.310e+00/

      data (acwfull(itmp),itmp=901,1000)/&
	1.323e+00,1.336e+00,1.351e+00,1.370e+00,1.392e+00,1.416e+00,1.440e+00,1.465e+00,1.489e+00,1.511e+00,&
	1.532e+00,1.555e+00,1.580e+00,1.610e+00,1.642e+00,1.672e+00,1.701e+00,1.728e+00,1.758e+00,1.791e+00,&
	1.831e+00,1.872e+00,1.911e+00,1.943e+00,1.974e+00,2.007e+00,2.047e+00,2.098e+00,2.153e+00,2.203e+00,&
	2.243e+00,2.277e+00,2.312e+00,2.357e+00,2.415e+00,2.479e+00,2.540e+00,2.590e+00,2.631e+00,2.666e+00,&
	2.701e+00,2.738e+00,2.780e+00,2.829e+00,2.889e+00,2.960e+00,3.033e+00,3.097e+00,3.146e+00,3.181e+00,&
	3.226e+00,3.267e+00,3.319e+00,3.363e+00,3.412e+00,3.449e+00,3.504e+00,3.544e+00,3.600e+00,3.648e+00,&
	3.701e+00,3.752e+00,3.802e+00,3.871e+00,3.927e+00,3.985e+00,4.064e+00,4.125e+00,4.216e+00,4.302e+00,&
	4.389e+00,4.504e+00,4.630e+00,4.737e+00,4.904e+00,5.092e+00,5.260e+00,5.479e+00,5.720e+00,6.006e+00,&
	6.242e+00,6.580e+00,6.927e+00,7.313e+00,7.633e+00,8.089e+00,8.545e+00,9.030e+00,9.591e+00,1.002e+01,&
	1.063e+01,1.122e+01,1.184e+01,1.245e+01,1.316e+01,1.369e+01,1.434e+01,1.509e+01,1.578e+01,1.646e+01/

      data (acwfull(itmp),itmp=1001,1100)/&
	1.714e+01,1.781e+01,1.854e+01,1.919e+01,1.980e+01,2.029e+01,2.089e+01,2.146e+01,2.202e+01,2.260e+01,&
	2.313e+01,2.360e+01,2.407e+01,2.450e+01,2.493e+01,2.533e+01,2.571e+01,2.606e+01,2.641e+01,2.673e+01,&
	2.701e+01,2.729e+01,2.756e+01,2.782e+01,2.806e+01,2.835e+01,2.856e+01,2.875e+01,2.892e+01,2.908e+01,&
	2.926e+01,2.940e+01,2.956e+01,2.966e+01,2.982e+01,2.993e+01,3.003e+01,3.014e+01,3.023e+01,3.029e+01,&
	3.036e+01,3.042e+01,3.046e+01,3.049e+01,3.052e+01,3.053e+01,3.055e+01,3.056e+01,3.056e+01,3.055e+01,&
	3.054e+01,3.051e+01,3.049e+01,3.045e+01,3.041e+01,3.035e+01,3.029e+01,3.023e+01,3.014e+01,3.006e+01,&
	2.998e+01,2.983e+01,2.971e+01,2.957e+01,2.936e+01,2.917e+01,2.899e+01,2.872e+01,2.851e+01,2.829e+01,&
	2.800e+01,2.777e+01,2.754e+01,2.722e+01,2.699e+01,2.664e+01,2.638e+01,2.611e+01,2.581e+01,2.555e+01,&
	2.522e+01,2.497e+01,2.468e+01,2.443e+01,2.413e+01,2.388e+01,2.364e+01,2.332e+01,2.307e+01,2.274e+01,&
	2.250e+01,2.218e+01,2.193e+01,2.163e+01,2.139e+01,2.107e+01,2.082e+01,2.052e+01,2.025e+01,2.001e+01/

      data (acwfull(itmp),itmp=1101,1200)/&
	1.972e+01,1.951e+01,1.924e+01,1.900e+01,1.874e+01,1.847e+01,1.827e+01,1.802e+01,1.784e+01,1.758e+01,&
	1.734e+01,1.712e+01,1.688e+01,1.671e+01,1.647e+01,1.623e+01,1.606e+01,1.583e+01,1.562e+01,1.545e+01,&
	1.525e+01,1.504e+01,1.489e+01,1.468e+01,1.447e+01,1.432e+01,1.413e+01,1.395e+01,1.381e+01,1.364e+01,&
	1.348e+01,1.329e+01,1.316e+01,1.298e+01,1.282e+01,1.265e+01,1.254e+01,1.238e+01,1.223e+01,1.206e+01,&
	1.193e+01,1.181e+01,1.166e+01,1.152e+01,1.137e+01,1.126e+01,1.114e+01,1.100e+01,1.088e+01,1.075e+01,&
	1.064e+01,1.054e+01,1.044e+01,1.032e+01,1.022e+01,1.011e+01,1.001e+01,9.912e+00,9.839e+00,9.754e+00,&
	9.660e+00,9.563e+00,9.477e+00,9.383e+00,9.305e+00,9.202e+00,9.133e+00,9.047e+00,8.977e+00,8.898e+00,&
	8.820e+00,8.742e+00,8.665e+00,8.588e+00,8.509e+00,8.448e+00,8.364e+00,8.295e+00,8.234e+00,8.157e+00,&
	8.104e+00,8.036e+00,7.959e+00,7.890e+00,7.834e+00,7.773e+00,7.712e+00,7.654e+00,7.609e+00,7.548e+00,&
	7.495e+00,7.432e+00,7.374e+00,7.315e+00,7.252e+00,7.203e+00,7.164e+00,7.124e+00,7.084e+00,7.041e+00/

      data (acwfull(itmp),itmp=1201,1300)/&
	6.987e+00,6.943e+00,6.910e+00,6.865e+00,6.828e+00,6.776e+00,6.742e+00,6.714e+00,6.695e+00,6.654e+00,&
	6.630e+00,6.599e+00,6.567e+00,6.526e+00,6.501e+00,6.474e+00,6.449e+00,6.420e+00,6.401e+00,6.363e+00,&
	6.345e+00,6.309e+00,6.282e+00,6.250e+00,6.214e+00,6.186e+00,6.163e+00,6.130e+00,6.121e+00,6.091e+00,&
	6.076e+00,6.053e+00,6.048e+00,6.016e+00,6.005e+00,5.982e+00,5.973e+00,5.947e+00,5.940e+00,5.919e+00,&
	5.911e+00,5.887e+00,5.875e+00,5.846e+00,5.826e+00,5.798e+00,5.787e+00,5.751e+00,5.746e+00,5.718e+00,&
	5.705e+00,5.685e+00,5.684e+00,5.657e+00,5.658e+00,5.644e+00,5.648e+00,5.626e+00,5.626e+00,5.619e+00,&
	5.618e+00,5.603e+00,5.614e+00,5.597e+00,5.603e+00,5.582e+00,5.584e+00,5.564e+00,5.563e+00,5.547e+00,&
	5.545e+00,5.536e+00,5.542e+00,5.529e+00,5.532e+00,5.525e+00,5.533e+00,5.528e+00,5.529e+00,5.516e+00,&
	5.524e+00,5.516e+00,5.526e+00,5.520e+00,5.520e+00,5.516e+00,5.522e+00,5.511e+00,5.527e+00,5.511e+00,&
	5.519e+00,5.515e+00,5.520e+00,5.510e+00,5.518e+00,5.523e+00,5.538e+00,5.535e+00,5.544e+00,5.557e+00/

      data (acwfull(itmp),itmp=1301,1400)/&
	5.571e+00,5.583e+00,5.606e+00,5.607e+00,5.629e+00,5.636e+00,5.664e+00,5.670e+00,5.693e+00,5.702e+00,&
	5.733e+00,5.752e+00,5.766e+00,5.776e+00,5.797e+00,5.811e+00,5.829e+00,5.842e+00,5.877e+00,5.891e+00,&
	5.930e+00,5.945e+00,5.972e+00,5.999e+00,6.025e+00,6.051e+00,6.087e+00,6.096e+00,6.136e+00,6.166e+00,&
	6.198e+00,6.219e+00,6.256e+00,6.284e+00,6.335e+00,6.369e+00,6.392e+00,6.445e+00,6.493e+00,6.517e+00,&
	6.571e+00,6.617e+00,6.658e+00,6.689e+00,6.748e+00,6.796e+00,6.842e+00,6.897e+00,6.955e+00,7.003e+00,&
	7.054e+00,7.111e+00,7.179e+00,7.235e+00,7.274e+00,7.339e+00,7.414e+00,7.481e+00,7.536e+00,7.594e+00,&
	7.669e+00,7.734e+00,7.776e+00,7.833e+00,7.893e+00,7.952e+00,8.000e+00,8.045e+00,8.103e+00,8.155e+00,&
	8.205e+00,8.241e+00,8.264e+00,8.321e+00,8.352e+00,8.394e+00,8.430e+00,8.448e+00,8.477e+00,8.512e+00,&
	8.535e+00,8.562e+00,8.593e+00,8.618e+00,8.640e+00,8.670e+00,8.689e+00,8.720e+00,8.738e+00,8.755e+00,&
	8.777e+00,8.778e+00,8.778e+00,8.794e+00,8.805e+00,8.807e+00,8.809e+00,8.811e+00,8.799e+00,8.795e+00/

      data (acwfull(itmp),itmp=1401,1500)/&
	8.789e+00,8.779e+00,8.767e+00,8.754e+00,8.750e+00,8.738e+00,8.739e+00,8.735e+00,8.744e+00,8.753e+00,&
	8.755e+00,8.780e+00,8.787e+00,8.790e+00,8.798e+00,8.794e+00,8.811e+00,8.820e+00,8.836e+00,8.845e+00,&
	8.854e+00,8.858e+00,8.868e+00,8.869e+00,8.884e+00,8.888e+00,8.900e+00,8.922e+00,8.951e+00,8.973e+00,&
	9.010e+00,9.034e+00,9.110e+00,9.146e+00,9.195e+00,9.259e+00,9.315e+00,9.380e+00,9.457e+00,9.535e+00,&
	9.633e+00,9.723e+00,9.824e+00,9.935e+00,1.005e+01,1.018e+01,1.031e+01,1.042e+01,1.059e+01,1.075e+01,&
	1.094e+01,1.110e+01,1.139e+01,1.160e+01,1.184e+01,1.208e+01,1.235e+01,1.266e+01,1.301e+01,1.334e+01,&
	1.375e+01,1.412e+01,1.478e+01,1.529e+01,1.586e+01,1.641e+01,1.709e+01,1.774e+01,1.853e+01,1.925e+01,&
	2.051e+01,2.148e+01,2.250e+01,2.367e+01,2.483e+01,2.622e+01,2.751e+01,2.972e+01,3.144e+01,3.317e+01,&
	3.504e+01,3.725e+01,3.927e+01,4.269e+01,4.530e+01,4.789e+01,5.060e+01,5.360e+01,5.761e+01,6.088e+01,&
	6.401e+01,6.720e+01,7.059e+01,7.497e+01,7.841e+01,8.157e+01,8.469e+01,8.752e+01,9.189e+01,9.456e+01/

      data (acwfull(itmp),itmp=1501,1600)/&
	9.722e+01,9.995e+01,1.033e+02,1.057e+02,1.078e+02,1.097e+02,1.123e+02,1.140e+02,1.157e+02,1.171e+02,&
	1.190e+02,1.203e+02,1.215e+02,1.226e+02,1.240e+02,1.248e+02,1.257e+02,1.265e+02,1.275e+02,1.281e+02,&
	1.286e+02,1.292e+02,1.296e+02,1.299e+02,1.303e+02,1.304e+02,1.306e+02,1.306e+02,1.306e+02,1.305e+02,&
	1.304e+02,1.301e+02,1.299e+02,1.296e+02,1.291e+02,1.287e+02,1.282e+02,1.275e+02,1.270e+02,1.264e+02,&
	1.256e+02,1.249e+02,1.242e+02,1.232e+02,1.224e+02,1.216e+02,1.206e+02,1.197e+02,1.190e+02,1.178e+02,&
	1.170e+02,1.157e+02,1.149e+02,1.140e+02,1.128e+02,1.118e+02,1.110e+02,1.097e+02,1.088e+02,1.076e+02,&
	1.066e+02,1.058e+02,1.044e+02,1.036e+02,1.023e+02,1.014e+02,1.005e+02,9.928e+01,9.831e+01,9.711e+01,&
	9.631e+01,9.488e+01,9.412e+01,9.341e+01,9.206e+01,9.121e+01,9.009e+01,8.929e+01,8.804e+01,8.725e+01,&
	8.611e+01,8.532e+01,8.460e+01,8.336e+01,8.262e+01,8.151e+01,8.076e+01,7.973e+01,7.904e+01,7.800e+01,&
	7.723e+01,7.628e+01,7.557e+01,7.463e+01,7.392e+01,7.298e+01,7.234e+01,7.141e+01,7.082e+01,6.986e+01/

      data (acwfull(itmp),itmp=1601,1700)/&
	6.924e+01,6.865e+01,6.779e+01,6.688e+01,6.634e+01,6.548e+01,6.490e+01,6.412e+01,6.358e+01,6.281e+01,&
	6.232e+01,6.156e+01,6.105e+01,6.029e+01,5.980e+01,5.907e+01,5.857e+01,5.788e+01,5.746e+01,5.680e+01,&
	5.632e+01,5.566e+01,5.503e+01,5.463e+01,5.398e+01,5.356e+01,5.294e+01,5.256e+01,5.197e+01,5.138e+01,&
	5.098e+01,5.047e+01,5.006e+01,4.951e+01,4.915e+01,4.860e+01,4.806e+01,4.773e+01,4.718e+01,4.685e+01,&
	4.635e+01,4.584e+01,4.553e+01,4.503e+01,4.473e+01,4.426e+01,4.379e+01,4.348e+01,4.302e+01,4.273e+01,&
	4.228e+01,4.186e+01,4.155e+01,4.115e+01,4.072e+01,4.046e+01,4.002e+01,3.975e+01,3.934e+01,3.894e+01,&
	3.868e+01,3.827e+01,3.790e+01,3.762e+01,3.726e+01,3.687e+01,3.664e+01,3.628e+01,3.592e+01,3.568e+01,&
	3.536e+01,3.499e+01,3.479e+01,3.447e+01,3.413e+01,3.392e+01,3.363e+01,3.329e+01,3.309e+01,3.280e+01,&
	3.251e+01,3.231e+01,3.200e+01,3.172e+01,3.154e+01,3.127e+01,3.097e+01,3.071e+01,3.052e+01,3.025e+01,&
	2.999e+01,2.980e+01,2.958e+01,2.929e+01,2.906e+01,2.888e+01,2.865e+01,2.840e+01,2.822e+01,2.799e+01/

      data (acwfull(itmp),itmp=1701,1800)/&
	2.776e+01,2.751e+01,2.737e+01,2.713e+01,2.692e+01,2.671e+01,2.657e+01,2.637e+01,2.617e+01,2.597e+01,&
	2.584e+01,2.565e+01,2.547e+01,2.528e+01,2.518e+01,2.501e+01,2.485e+01,2.466e+01,2.455e+01,2.438e+01,&
	2.420e+01,2.401e+01,2.386e+01,2.374e+01,2.358e+01,2.342e+01,2.328e+01,2.318e+01,2.304e+01,2.289e+01,&
	2.275e+01,2.262e+01,2.252e+01,2.239e+01,2.227e+01,2.214e+01,2.202e+01,2.194e+01,2.183e+01,2.172e+01,&
	2.162e+01,2.150e+01,2.140e+01,2.133e+01,2.123e+01,2.112e+01,2.102e+01,2.091e+01,2.085e+01,2.077e+01,&
	2.067e+01,2.058e+01,2.049e+01,2.040e+01,2.033e+01,2.027e+01,2.018e+01,2.010e+01,2.002e+01,1.995e+01,&
	1.987e+01,1.983e+01,1.976e+01,1.969e+01,1.963e+01,1.958e+01,1.952e+01,1.946e+01,1.942e+01,1.938e+01,&
	1.933e+01,1.928e+01,1.923e+01,1.918e+01,1.913e+01,1.909e+01,1.904e+01,1.900e+01,1.896e+01,1.889e+01,&
	1.884e+01,1.880e+01,1.874e+01,1.870e+01,1.866e+01,1.860e+01,1.856e+01,1.852e+01,1.849e+01,1.845e+01,&
	1.843e+01,1.839e+01,1.837e+01,1.837e+01,1.838e+01,1.837e+01,1.836e+01,1.835e+01,1.835e+01,1.835e+01/

      data (acwfull(itmp),itmp=1801,1900)/&
	1.834e+01,1.833e+01,1.833e+01,1.833e+01,1.834e+01,1.833e+01,1.834e+01,1.834e+01,1.832e+01,1.831e+01,&
	1.829e+01,1.828e+01,1.828e+01,1.829e+01,1.829e+01,1.830e+01,1.832e+01,1.835e+01,1.836e+01,1.837e+01,&
	1.837e+01,1.838e+01,1.837e+01,1.840e+01,1.842e+01,1.843e+01,1.846e+01,1.849e+01,1.851e+01,1.854e+01,&
	1.857e+01,1.858e+01,1.860e+01,1.864e+01,1.865e+01,1.867e+01,1.870e+01,1.875e+01,1.879e+01,1.883e+01,&
	1.888e+01,1.893e+01,1.897e+01,1.903e+01,1.908e+01,1.913e+01,1.919e+01,1.924e+01,1.929e+01,1.934e+01,&
	1.940e+01,1.946e+01,1.951e+01,1.961e+01,1.966e+01,1.973e+01,1.980e+01,1.985e+01,1.991e+01,1.997e+01,&
	2.004e+01,2.013e+01,2.020e+01,2.027e+01,2.038e+01,2.046e+01,2.054e+01,2.062e+01,2.071e+01,2.079e+01,&
	2.087e+01,2.094e+01,2.103e+01,2.111e+01,2.126e+01,2.135e+01,2.145e+01,2.153e+01,2.164e+01,2.174e+01,&
	2.183e+01,2.192e+01,2.202e+01,2.212e+01,2.223e+01,2.234e+01,2.245e+01,2.264e+01,2.276e+01,2.287e+01,&
	2.301e+01,2.313e+01,2.327e+01,2.338e+01,2.351e+01,2.363e+01,2.377e+01,2.385e+01,2.409e+01,2.418e+01/

      data (acwfull(itmp),itmp=1901,2000)/&
	2.433e+01,2.444e+01,2.459e+01,2.470e+01,2.485e+01,2.495e+01,2.523e+01,2.534e+01,2.549e+01,2.564e+01,&
	2.579e+01,2.592e+01,2.611e+01,2.623e+01,2.653e+01,2.664e+01,2.681e+01,2.695e+01,2.712e+01,2.727e+01,&
	2.744e+01,2.756e+01,2.789e+01,2.802e+01,2.819e+01,2.838e+01,2.855e+01,2.869e+01,2.903e+01,2.916e+01,&
	2.934e+01,2.951e+01,2.969e+01,2.988e+01,3.002e+01,3.038e+01,3.054e+01,3.073e+01,3.092e+01,3.107e+01,&
	3.145e+01,3.160e+01,3.180e+01,3.199e+01,3.219e+01,3.238e+01,3.272e+01,3.290e+01,3.311e+01,3.331e+01,&
	3.348e+01,3.388e+01,3.404e+01,3.426e+01,3.447e+01,3.468e+01,3.486e+01,3.528e+01,3.547e+01,3.570e+01,&
	3.592e+01,3.610e+01,3.656e+01,3.675e+01,3.697e+01,3.716e+01,3.761e+01,3.777e+01,3.801e+01,3.827e+01,&
	3.848e+01,3.892e+01,3.913e+01,3.938e+01,3.957e+01,4.007e+01,4.024e+01,4.050e+01,4.078e+01,4.096e+01,&
	4.147e+01,4.167e+01,4.196e+01,4.220e+01,4.268e+01,4.293e+01,4.319e+01,4.342e+01,4.388e+01,4.413e+01,&
	4.439e+01,4.464e+01,4.513e+01,4.538e+01,4.565e+01,4.590e+01,4.638e+01,4.663e+01,4.690e+01,4.714e+01/

		data (acwfull(itmp),itmp=2001,2101)/&
	4.764e+01,4.787e+01,4.817e+01,4.836e+01,4.894e+01,4.917e+01,4.940e+01,4.997e+01,5.021e+01,5.050e+01,&
	5.078e+01,5.131e+01,5.159e+01,5.191e+01,5.246e+01,5.275e+01,5.310e+01,5.339e+01,5.401e+01,5.429e+01,&
	5.462e+01,5.523e+01,5.555e+01,5.588e+01,5.618e+01,5.686e+01,5.713e+01,5.746e+01,5.808e+01,5.841e+01,&
	5.878e+01,5.946e+01,5.976e+01,6.009e+01,6.039e+01,6.107e+01,6.146e+01,6.180e+01,6.250e+01,6.286e+01,&
	6.316e+01,6.392e+01,6.427e+01,6.462e+01,6.539e+01,6.574e+01,6.609e+01,6.685e+01,6.725e+01,6.759e+01,&
	6.842e+01,6.881e+01,6.918e+01,7.009e+01,7.046e+01,7.084e+01,7.174e+01,7.212e+01,7.249e+01,7.340e+01,&
	7.381e+01,7.423e+01,7.514e+01,7.554e+01,7.591e+01,7.675e+01,7.718e+01,7.801e+01,7.839e+01,7.880e+01,&
	7.970e+01,8.005e+01,8.046e+01,8.136e+01,8.173e+01,8.215e+01,8.295e+01,8.338e+01,8.423e+01,8.474e+01,&
	8.510e+01,8.584e+01,8.617e+01,8.637e+01,8.708e+01,8.762e+01,8.884e+01,8.904e+01,8.945e+01,9.055e+01,&
	9.089e+01,9.134e+01,9.204e+01,9.244e+01,9.308e+01,9.333e+01,9.358e+01,9.416e+01,9.448e+01,9.499e+01,&
	9.530e+01/


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!				specific absorption of dry matter					!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

		data (acmfull(itmp),itmp=1,100)/&
	1.097e+02,1.037e+02,9.798e+01,9.244e+01,8.713e+01,8.231e+01,7.806e+01,7.404e+01,7.013e+01,6.654e+01,&
	6.300e+01,5.954e+01,5.616e+01,5.301e+01,5.001e+01,4.723e+01,4.463e+01,4.220e+01,3.996e+01,3.780e+01,&
	3.567e+01,3.362e+01,3.170e+01,2.993e+01,2.832e+01,2.679e+01,2.535e+01,2.402e+01,2.276e+01,2.150e+01,&
	2.024e+01,1.901e+01,1.785e+01,1.676e+01,1.575e+01,1.481e+01,1.392e+01,1.312e+01,1.233e+01,1.161e+01,&
	1.096e+01,1.041e+01,9.924e+00,9.410e+00,8.947e+00,8.508e+00,8.087e+00,7.640e+00,7.269e+00,6.939e+00,&
	6.660e+00,6.422e+00,6.222e+00,6.010e+00,5.782e+00,5.573e+00,5.370e+00,5.173e+00,4.946e+00,4.761e+00,&
	4.575e+00,4.419e+00,4.259e+00,4.117e+00,4.006e+00,3.945e+00,3.853e+00,3.784e+00,3.671e+00,3.554e+00,&
	3.462e+00,3.364e+00,3.282e+00,3.184e+00,3.102e+00,3.051e+00,2.983e+00,2.947e+00,2.913e+00,2.869e+00,&
	2.803e+00,2.777e+00,2.751e+00,2.726e+00,2.702e+00,2.679e+00,2.656e+00,2.634e+00,2.613e+00,2.593e+00,&
	2.573e+00,2.554e+00,2.536e+00,2.519e+00,2.502e+00,2.486e+00,2.471e+00,2.457e+00,2.443e+00,2.430e+00/

		data (acmfull(itmp),itmp=101,200)/&
	2.417e+00,2.405e+00,2.394e+00,2.384e+00,2.374e+00,2.365e+00,2.356e+00,2.348e+00,2.341e+00,2.334e+00,&
	2.328e+00,2.323e+00,2.318e+00,2.314e+00,2.310e+00,2.307e+00,2.304e+00,2.303e+00,2.301e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=201,300)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=301,400)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=401,500)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/
		
		data (acmfull(itmp),itmp=501,600)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=601,700)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=701,800)/&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,&
	2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00,2.300e+00/

		data (acmfull(itmp),itmp=801,900)/&
	2.300e+00,2.300e+00,2.301e+00,2.301e+00,2.302e+00,2.303e+00,2.305e+00,2.306e+00,2.308e+00,2.310e+00,&
	2.312e+00,2.315e+00,2.318e+00,2.320e+00,2.323e+00,2.327e+00,2.330e+00,2.334e+00,2.338e+00,2.342e+00,&
	2.346e+00,2.350e+00,2.354e+00,2.359e+00,2.364e+00,2.369e+00,2.374e+00,2.379e+00,2.384e+00,2.389e+00,&
	2.395e+00,2.400e+00,2.406e+00,2.412e+00,2.418e+00,2.424e+00,2.430e+00,2.436e+00,2.442e+00,2.448e+00,&
	2.454e+00,2.461e+00,2.467e+00,2.473e+00,2.480e+00,2.486e+00,2.493e+00,2.499e+00,2.506e+00,2.512e+00,&
	2.519e+00,2.525e+00,2.532e+00,2.538e+00,2.545e+00,2.551e+00,2.558e+00,2.564e+00,2.570e+00,2.577e+00,&
	2.583e+00,2.589e+00,2.595e+00,2.601e+00,2.607e+00,2.613e+00,2.619e+00,2.625e+00,2.631e+00,2.636e+00,&
	2.642e+00,2.647e+00,2.652e+00,2.657e+00,2.662e+00,2.667e+00,2.672e+00,2.677e+00,2.681e+00,2.685e+00,&
	2.689e+00,2.693e+00,2.697e+00,2.701e+00,2.704e+00,2.708e+00,2.711e+00,2.714e+00,2.716e+00,2.719e+00,&
	2.721e+00,2.723e+00,2.725e+00,2.726e+00,2.728e+00,2.729e+00,2.730e+00,2.730e+00,2.731e+00,2.731e+00/

		data (acmfull(itmp),itmp=901,1000)/&
	2.721e+00,2.736e+00,2.728e+00,2.719e+00,2.712e+00,2.698e+00,2.702e+00,2.691e+00,2.688e+00,2.686e+00,&
	2.682e+00,2.676e+00,2.675e+00,2.677e+00,2.670e+00,2.671e+00,2.668e+00,2.670e+00,2.674e+00,2.674e+00,&
	2.683e+00,2.674e+00,2.675e+00,2.682e+00,2.683e+00,2.665e+00,2.661e+00,2.668e+00,2.670e+00,2.674e+00,&
	2.664e+00,2.661e+00,2.665e+00,2.668e+00,2.681e+00,2.686e+00,2.684e+00,2.697e+00,2.712e+00,2.720e+00,&
	2.717e+00,2.726e+00,2.744e+00,2.743e+00,2.751e+00,2.763e+00,2.778e+00,2.793e+00,2.818e+00,2.835e+00,&
	2.865e+00,2.879e+00,2.899e+00,2.918e+00,2.936e+00,2.953e+00,2.966e+00,2.977e+00,2.981e+00,2.942e+00,&
	2.888e+00,2.864e+00,2.877e+00,2.886e+00,2.888e+00,2.891e+00,2.899e+00,2.887e+00,2.884e+00,2.900e+00,&
	2.929e+00,2.969e+00,3.014e+00,3.053e+00,3.075e+00,3.111e+00,3.128e+00,3.130e+00,3.103e+00,3.051e+00,&
	2.980e+00,2.941e+00,2.920e+00,2.931e+00,2.950e+00,2.979e+00,3.025e+00,3.048e+00,3.066e+00,3.087e+00,&
	3.099e+00,3.090e+00,3.088e+00,3.081e+00,3.086e+00,3.071e+00,3.065e+00,3.069e+00,3.067e+00,3.085e+00/

		data (acmfull(itmp),itmp=1001,1100)/&
	3.094e+00,3.110e+00,3.136e+00,3.149e+00,3.158e+00,3.191e+00,3.230e+00,3.266e+00,3.298e+00,3.356e+00,&
	3.419e+00,3.476e+00,3.534e+00,3.584e+00,3.632e+00,3.708e+00,3.775e+00,3.847e+00,3.931e+00,3.987e+00,&
	4.071e+00,4.156e+00,4.242e+00,4.320e+00,4.395e+00,4.480e+00,4.561e+00,4.638e+00,4.708e+00,4.782e+00,&
	4.846e+00,4.906e+00,4.974e+00,5.026e+00,5.071e+00,5.131e+00,5.179e+00,5.220e+00,5.271e+00,5.322e+00,&
	5.358e+00,5.403e+00,5.441e+00,5.460e+00,5.481e+00,5.500e+00,5.523e+00,5.548e+00,5.560e+00,5.575e+00,&
	5.582e+00,5.597e+00,5.611e+00,5.639e+00,5.653e+00,5.675e+00,5.682e+00,5.685e+00,5.680e+00,5.689e+00,&
	5.711e+00,5.723e+00,5.715e+00,5.716e+00,5.732e+00,5.741e+00,5.743e+00,5.752e+00,5.745e+00,5.744e+00,&
	5.757e+00,5.766e+00,5.781e+00,5.787e+00,5.798e+00,5.810e+00,5.808e+00,5.815e+00,5.825e+00,5.824e+00,&
	5.827e+00,5.854e+00,5.878e+00,5.900e+00,5.908e+00,5.922e+00,5.940e+00,5.962e+00,5.963e+00,5.966e+00,&
	5.982e+00,5.990e+00,5.994e+00,6.016e+00,6.014e+00,6.025e+00,6.008e+00,6.022e+00,6.021e+00,6.027e+00/

		data (acmfull(itmp),itmp=1101,1200)/&
	6.027e+00,6.035e+00,6.025e+00,6.009e+00,5.990e+00,5.987e+00,5.984e+00,5.971e+00,5.971e+00,5.973e+00,&
	5.951e+00,5.952e+00,5.939e+00,5.933e+00,5.931e+00,5.925e+00,5.909e+00,5.897e+00,5.884e+00,5.881e+00,&
	5.876e+00,5.856e+00,5.843e+00,5.830e+00,5.818e+00,5.807e+00,5.799e+00,5.792e+00,5.776e+00,5.783e+00,&
	5.776e+00,5.767e+00,5.762e+00,5.769e+00,5.756e+00,5.762e+00,5.737e+00,5.740e+00,5.757e+00,5.756e+00,&
	5.751e+00,5.754e+00,5.751e+00,5.750e+00,5.744e+00,5.744e+00,5.754e+00,5.744e+00,5.735e+00,5.740e+00,&
	5.732e+00,5.728e+00,5.731e+00,5.724e+00,5.724e+00,5.715e+00,5.697e+00,5.693e+00,5.703e+00,5.700e+00,&
	5.713e+00,5.728e+00,5.731e+00,5.735e+00,5.743e+00,5.754e+00,5.753e+00,5.744e+00,5.746e+00,5.746e+00,&
	5.746e+00,5.750e+00,5.749e+00,5.743e+00,5.740e+00,5.747e+00,5.739e+00,5.755e+00,5.749e+00,5.753e+00,&
	5.745e+00,5.732e+00,5.735e+00,5.724e+00,5.725e+00,5.712e+00,5.702e+00,5.700e+00,5.700e+00,5.686e+00,&
	5.685e+00,5.672e+00,5.659e+00,5.627e+00,5.613e+00,5.590e+00,5.591e+00,5.563e+00,5.552e+00,5.525e+00/

		data (acmfull(itmp),itmp=1201,1300)/&
	5.517e+00,5.506e+00,5.494e+00,5.459e+00,5.450e+00,5.438e+00,5.428e+00,5.407e+00,5.391e+00,5.382e+00,&
	5.376e+00,5.358e+00,5.347e+00,5.333e+00,5.319e+00,5.301e+00,5.292e+00,5.284e+00,5.274e+00,5.258e+00,&
	5.253e+00,5.249e+00,5.233e+00,5.222e+00,5.211e+00,5.204e+00,5.210e+00,5.200e+00,5.193e+00,5.186e+00,&
	5.177e+00,5.175e+00,5.178e+00,5.173e+00,5.152e+00,5.135e+00,5.139e+00,5.128e+00,5.121e+00,5.114e+00,&
	5.126e+00,5.107e+00,5.104e+00,5.100e+00,5.109e+00,5.114e+00,5.112e+00,5.128e+00,5.137e+00,5.131e+00,&
	5.152e+00,5.175e+00,5.194e+00,5.200e+00,5.244e+00,5.257e+00,5.273e+00,5.289e+00,5.335e+00,5.366e+00,&
	5.389e+00,5.427e+00,5.453e+00,5.490e+00,5.522e+00,5.562e+00,5.605e+00,5.652e+00,5.698e+00,5.744e+00,&
	5.743e+00,5.642e+00,5.689e+00,5.722e+00,5.755e+00,5.798e+00,5.848e+00,5.875e+00,5.918e+00,5.971e+00,&
	6.022e+00,6.061e+00,6.116e+00,6.173e+00,6.214e+00,6.266e+00,6.319e+00,6.382e+00,6.426e+00,6.486e+00,&
	6.542e+00,6.579e+00,6.616e+00,6.666e+00,6.728e+00,6.771e+00,6.807e+00,6.858e+00,6.908e+00,6.959e+00/

		data (acmfull(itmp),itmp=1301,1400)/&
	7.006e+00,7.052e+00,7.093e+00,7.136e+00,7.164e+00,7.199e+00,7.232e+00,7.266e+00,7.315e+00,7.340e+00,&
	7.361e+00,7.399e+00,7.440e+00,7.473e+00,7.505e+00,7.525e+00,7.557e+00,7.579e+00,7.604e+00,7.633e+00,&
	7.653e+00,7.674e+00,7.691e+00,7.699e+00,7.708e+00,7.721e+00,7.730e+00,7.729e+00,7.712e+00,7.702e+00,&
	7.695e+00,7.670e+00,7.644e+00,7.618e+00,7.585e+00,7.555e+00,7.517e+00,7.479e+00,7.451e+00,7.435e+00,&
	7.408e+00,7.379e+00,7.363e+00,7.347e+00,7.332e+00,7.332e+00,7.332e+00,7.304e+00,7.295e+00,7.296e+00,&
	7.291e+00,7.292e+00,7.292e+00,7.281e+00,7.283e+00,7.264e+00,7.250e+00,7.240e+00,7.228e+00,7.210e+00,&
	7.186e+00,7.164e+00,7.143e+00,7.114e+00,7.101e+00,7.069e+00,7.038e+00,7.003e+00,6.974e+00,6.928e+00,&
	6.889e+00,6.839e+00,6.793e+00,6.764e+00,6.729e+00,6.694e+00,6.662e+00,6.613e+00,6.572e+00,6.546e+00,&
	6.522e+00,6.507e+00,6.482e+00,6.484e+00,6.479e+00,6.494e+00,6.496e+00,6.491e+00,6.461e+00,6.440e+00,&
	6.430e+00,6.413e+00,6.421e+00,6.399e+00,6.379e+00,6.365e+00,6.372e+00,6.346e+00,6.321e+00,6.310e+00/

		data (acmfull(itmp),itmp=1401,1500)/&
	6.314e+00,6.282e+00,6.277e+00,6.270e+00,6.258e+00,6.242e+00,6.234e+00,6.221e+00,6.231e+00,6.221e+00,&
	6.205e+00,6.193e+00,6.192e+00,6.179e+00,6.159e+00,6.143e+00,6.143e+00,6.120e+00,6.098e+00,6.087e+00,&
	6.063e+00,6.056e+00,6.053e+00,6.040e+00,6.044e+00,6.007e+00,5.996e+00,5.994e+00,5.997e+00,5.975e+00,&
	5.954e+00,5.946e+00,5.927e+00,5.914e+00,5.890e+00,5.873e+00,5.832e+00,5.794e+00,5.768e+00,5.728e+00,&
	5.681e+00,5.680e+00,5.655e+00,5.648e+00,5.620e+00,5.594e+00,5.567e+00,5.557e+00,5.552e+00,5.553e+00,&
	5.539e+00,5.524e+00,5.507e+00,5.505e+00,5.487e+00,5.474e+00,5.462e+00,5.450e+00,5.448e+00,5.441e+00,&
	5.440e+00,5.442e+00,5.450e+00,5.466e+00,5.461e+00,5.452e+00,5.445e+00,5.412e+00,5.379e+00,5.280e+00,&
	5.228e+00,5.199e+00,5.171e+00,5.139e+00,5.124e+00,5.112e+00,5.129e+00,5.145e+00,5.173e+00,5.176e+00,&
	5.185e+00,5.183e+00,5.200e+00,5.202e+00,5.204e+00,5.224e+00,5.244e+00,5.297e+00,5.318e+00,5.376e+00,&
	5.441e+00,5.491e+00,5.561e+00,5.629e+00,5.687e+00,5.757e+00,5.830e+00,5.911e+00,5.998e+00,6.090e+00/

		data (acmfull(itmp),itmp=1501,1600)/&
	6.193e+00,6.330e+00,6.449e+00,6.581e+00,6.710e+00,6.838e+00,6.970e+00,7.107e+00,7.238e+00,7.388e+00,&
	7.506e+00,7.635e+00,7.767e+00,7.874e+00,7.977e+00,8.071e+00,8.150e+00,8.220e+00,8.292e+00,8.350e+00,&
	8.449e+00,8.521e+00,8.583e+00,8.666e+00,8.723e+00,8.759e+00,8.821e+00,8.864e+00,8.909e+00,8.941e+00,&
	8.949e+00,8.955e+00,8.983e+00,9.022e+00,9.043e+00,9.044e+00,9.028e+00,9.034e+00,9.052e+00,9.048e+00,&
	9.041e+00,9.037e+00,9.036e+00,9.035e+00,9.021e+00,9.016e+00,9.008e+00,8.970e+00,8.974e+00,8.953e+00,&
	8.957e+00,8.937e+00,8.923e+00,8.912e+00,8.895e+00,8.891e+00,8.880e+00,8.867e+00,8.855e+00,8.852e+00,&
	8.861e+00,8.864e+00,8.876e+00,8.869e+00,8.873e+00,8.855e+00,8.828e+00,8.839e+00,8.855e+00,8.856e+00,&
	8.833e+00,8.842e+00,8.844e+00,8.830e+00,8.808e+00,8.818e+00,8.807e+00,8.797e+00,8.794e+00,8.791e+00,&
	8.795e+00,8.772e+00,8.754e+00,8.759e+00,8.760e+00,8.746e+00,8.762e+00,8.778e+00,8.790e+00,8.795e+00,&
	8.811e+00,8.848e+00,8.874e+00,8.885e+00,8.913e+00,8.944e+00,8.981e+00,8.988e+00,9.001e+00,9.034e+00/

		data (acmfull(itmp),itmp=1601,1700)/&
	9.076e+00,9.111e+00,9.141e+00,9.171e+00,9.214e+00,9.255e+00,9.304e+00,9.356e+00,9.406e+00,9.448e+00,&
	9.516e+00,9.578e+00,9.638e+00,9.692e+00,9.763e+00,9.845e+00,9.953e+00,1.004e+01,1.015e+01,1.027e+01,&
	1.039e+01,1.052e+01,1.063e+01,1.077e+01,1.091e+01,1.103e+01,1.119e+01,1.135e+01,1.150e+01,1.166e+01,&
	1.181e+01,1.201e+01,1.217e+01,1.235e+01,1.251e+01,1.269e+01,1.287e+01,1.307e+01,1.325e+01,1.346e+01,&
	1.364e+01,1.384e+01,1.404e+01,1.423e+01,1.441e+01,1.461e+01,1.481e+01,1.499e+01,1.518e+01,1.534e+01,&
	1.554e+01,1.571e+01,1.591e+01,1.607e+01,1.622e+01,1.637e+01,1.653e+01,1.667e+01,1.678e+01,1.690e+01,&
	1.698e+01,1.709e+01,1.718e+01,1.725e+01,1.734e+01,1.739e+01,1.748e+01,1.755e+01,1.761e+01,1.767e+01,&
	1.771e+01,1.777e+01,1.783e+01,1.787e+01,1.794e+01,1.795e+01,1.799e+01,1.805e+01,1.809e+01,1.813e+01,&
	1.820e+01,1.827e+01,1.830e+01,1.835e+01,1.841e+01,1.846e+01,1.852e+01,1.856e+01,1.861e+01,1.866e+01,&
	1.871e+01,1.876e+01,1.881e+01,1.885e+01,1.890e+01,1.896e+01,1.903e+01,1.907e+01,1.911e+01,1.916e+01/

		data (acmfull(itmp),itmp=1701,1800)/&
	1.921e+01,1.927e+01,1.929e+01,1.932e+01,1.935e+01,1.936e+01,1.940e+01,1.943e+01,1.947e+01,1.951e+01,&
	1.953e+01,1.956e+01,1.960e+01,1.961e+01,1.962e+01,1.966e+01,1.966e+01,1.969e+01,1.970e+01,1.972e+01,&
	1.974e+01,1.974e+01,1.976e+01,1.978e+01,1.979e+01,1.982e+01,1.982e+01,1.983e+01,1.986e+01,1.988e+01,&
	1.989e+01,1.989e+01,1.993e+01,1.993e+01,1.997e+01,2.001e+01,2.001e+01,2.004e+01,2.007e+01,2.011e+01,&
	2.014e+01,2.015e+01,2.017e+01,2.019e+01,2.022e+01,2.023e+01,2.023e+01,2.026e+01,2.027e+01,2.029e+01,&
	2.028e+01,2.027e+01,2.029e+01,2.029e+01,2.031e+01,2.029e+01,2.026e+01,2.030e+01,2.031e+01,2.030e+01,&
	2.030e+01,2.031e+01,2.029e+01,2.029e+01,2.026e+01,2.025e+01,2.023e+01,2.020e+01,2.016e+01,2.015e+01,&
	2.012e+01,2.009e+01,2.007e+01,2.003e+01,1.998e+01,1.996e+01,1.991e+01,1.986e+01,1.980e+01,1.975e+01,&
	1.969e+01,1.964e+01,1.959e+01,1.953e+01,1.947e+01,1.941e+01,1.936e+01,1.931e+01,1.922e+01,1.918e+01,&
	1.912e+01,1.906e+01,1.899e+01,1.890e+01,1.885e+01,1.881e+01,1.875e+01,1.867e+01,1.861e+01,1.858e+01/

		data (acmfull(itmp),itmp=1801,1900)/&
	1.852e+01,1.846e+01,1.840e+01,1.834e+01,1.829e+01,1.824e+01,1.819e+01,1.813e+01,1.807e+01,1.803e+01,&
	1.798e+01,1.792e+01,1.788e+01,1.782e+01,1.780e+01,1.775e+01,1.773e+01,1.768e+01,1.768e+01,1.766e+01,&
	1.763e+01,1.762e+01,1.763e+01,1.764e+01,1.764e+01,1.766e+01,1.770e+01,1.774e+01,1.779e+01,1.786e+01,&
	1.795e+01,1.803e+01,1.814e+01,1.825e+01,1.836e+01,1.851e+01,1.866e+01,1.881e+01,1.895e+01,1.913e+01,&
	1.932e+01,1.951e+01,1.972e+01,1.994e+01,2.017e+01,2.040e+01,2.065e+01,2.089e+01,2.114e+01,2.140e+01,&
	2.163e+01,2.186e+01,2.210e+01,2.237e+01,2.262e+01,2.290e+01,2.313e+01,2.339e+01,2.361e+01,2.387e+01,&
	2.410e+01,2.435e+01,2.455e+01,2.479e+01,2.499e+01,2.521e+01,2.541e+01,2.562e+01,2.583e+01,2.605e+01,&
	2.626e+01,2.643e+01,2.657e+01,2.674e+01,2.689e+01,2.701e+01,2.718e+01,2.732e+01,2.742e+01,2.754e+01,&
	2.763e+01,2.777e+01,2.794e+01,2.804e+01,2.821e+01,2.836e+01,2.850e+01,2.863e+01,2.878e+01,2.896e+01,&
	2.913e+01,2.922e+01,2.937e+01,2.947e+01,2.960e+01,2.970e+01,2.982e+01,2.997e+01,3.007e+01,3.018e+01/

		data (acmfull(itmp),itmp=1901,2000)/&
	3.028e+01,3.040e+01,3.053e+01,3.060e+01,3.066e+01,3.070e+01,3.076e+01,3.078e+01,3.075e+01,3.074e+01,&
	3.072e+01,3.065e+01,3.058e+01,3.051e+01,3.045e+01,3.034e+01,3.029e+01,3.023e+01,3.015e+01,3.004e+01,&
	3.000e+01,2.998e+01,2.991e+01,2.986e+01,2.984e+01,2.981e+01,2.976e+01,2.973e+01,2.976e+01,2.977e+01,&
	2.979e+01,2.981e+01,2.985e+01,2.989e+01,2.999e+01,3.000e+01,3.005e+01,3.007e+01,3.011e+01,3.017e+01,&
	3.022e+01,3.023e+01,3.029e+01,3.028e+01,3.029e+01,3.027e+01,3.027e+01,3.024e+01,3.019e+01,3.010e+01,&
	3.010e+01,3.003e+01,2.993e+01,2.983e+01,2.984e+01,2.975e+01,2.966e+01,2.958e+01,2.948e+01,2.930e+01,&
	2.926e+01,2.920e+01,2.913e+01,2.902e+01,2.890e+01,2.882e+01,2.873e+01,2.873e+01,2.870e+01,2.865e+01,&
	2.858e+01,2.854e+01,2.851e+01,2.846e+01,2.838e+01,2.834e+01,2.823e+01,2.820e+01,2.817e+01,2.809e+01,&
	2.803e+01,2.803e+01,2.801e+01,2.794e+01,2.791e+01,2.790e+01,2.784e+01,2.779e+01,2.781e+01,2.782e+01,&
	2.781e+01,2.781e+01,2.783e+01,2.785e+01,2.785e+01,2.782e+01,2.782e+01,2.780e+01,2.780e+01,2.778e+01/

		data (acmfull(itmp),itmp=2001,2101)/&
	2.783e+01,2.784e+01,2.788e+01,2.791e+01,2.799e+01,2.804e+01,2.812e+01,2.811e+01,2.819e+01,2.819e+01,&
	2.817e+01,2.817e+01,2.831e+01,2.837e+01,2.848e+01,2.853e+01,2.859e+01,2.870e+01,2.874e+01,2.887e+01,&
	2.898e+01,2.910e+01,2.923e+01,2.934e+01,2.944e+01,2.959e+01,2.973e+01,2.987e+01,3.002e+01,3.016e+01,&
	3.035e+01,3.043e+01,3.064e+01,3.084e+01,3.098e+01,3.122e+01,3.132e+01,3.152e+01,3.165e+01,3.184e+01,&
	3.204e+01,3.221e+01,3.233e+01,3.255e+01,3.282e+01,3.315e+01,3.339e+01,3.360e+01,3.384e+01,3.410e+01,&
	3.426e+01,3.452e+01,3.473e+01,3.497e+01,3.519e+01,3.539e+01,3.561e+01,3.579e+01,3.604e+01,3.618e+01,&
	3.636e+01,3.660e+01,3.675e+01,3.682e+01,3.699e+01,3.711e+01,3.735e+01,3.758e+01,3.792e+01,3.796e+01,&
	3.812e+01,3.822e+01,3.833e+01,3.856e+01,3.874e+01,3.877e+01,3.884e+01,3.883e+01,3.879e+01,3.886e+01,&
	3.900e+01,3.900e+01,3.906e+01,3.905e+01,3.916e+01,3.928e+01,3.948e+01,3.943e+01,3.951e+01,3.964e+01,&
	3.953e+01,3.960e+01,3.958e+01,3.954e+01,3.940e+01,3.936e+01,3.917e+01,3.926e+01,3.893e+01,3.921e+01,&
	3.871e+01/

              data (phis1full(itmp),itmp=1,2101)/&
          0.03181, 0.03076, 0.03060, 0.03099, 0.03083, 0.03105, 0.03124,&
          0.03100, 0.03088, 0.03055, 0.02996, 0.03065, 0.03106, 0.03127,&
          0.03182, 0.03168, 0.03128, 0.03144, 0.03163, 0.03173, 0.03156,&
          0.03195, 0.03211, 0.03205, 0.03228, 0.03225, 0.03215, 0.03274,&
          0.03289, 0.03296, 0.03326, 0.03318, 0.03314, 0.03324, 0.03350,&
          0.03360, 0.03352, 0.03345, 0.03357, 0.03381, 0.03393, 0.03400,&
          0.03400, 0.03395, 0.03391, 0.03400, 0.03421, 0.03430, 0.03442,&
          0.03455, 0.03450, 0.03458, 0.03464, 0.03480, 0.03475, 0.03480,&
          0.03511, 0.03512, 0.03525, 0.03552, 0.03514, 0.03513, 0.03534,&
          0.03539, 0.03546, 0.03555, 0.03573, 0.03592, 0.03609, 0.03618,&
          0.03609, 0.03605, 0.03606, 0.03616, 0.03623, 0.03627, 0.03629,&
          0.03635, 0.03644, 0.03655, 0.03669, 0.03678, 0.03675, 0.03683,&
          0.03693, 0.03701, 0.03717, 0.03734, 0.03747, 0.03747, 0.03760,&
          0.03772, 0.03776, 0.03782, 0.03795, 0.03811, 0.03822, 0.03830,&
          0.03839, 0.03851, 0.03862, 0.03870, 0.03879, 0.03887, 0.03899,&
          0.03918, 0.03926, 0.03932, 0.03938, 0.03955, 0.03958, 0.03955,&
          0.03978, 0.03993, 0.04005, 0.04012, 0.04022, 0.04038, 0.04059,&
          0.04068, 0.04081, 0.04098, 0.04102, 0.04111, 0.04125, 0.04142,&
          0.04156, 0.04165, 0.04167, 0.04182, 0.04198, 0.04215, 0.04226,&
          0.04245, 0.04268, 0.04281, 0.04289, 0.04302, 0.04304, 0.04331,&
          0.04357, 0.04358, 0.04375, 0.04395, 0.04406, 0.04422, 0.04437,&
          0.04450, 0.04464, 0.04480, 0.04495, 0.04509, 0.04523, 0.04538,&
          0.04555, 0.04567, 0.04579, 0.04602, 0.04614, 0.04631, 0.04650,&
          0.04664, 0.04679, 0.04694, 0.04712, 0.04727, 0.04743, 0.04756,&
          0.04778, 0.04795, 0.04802, 0.04822, 0.04842, 0.04853, 0.04871,&
          0.04886, 0.04901, 0.04916, 0.04930, 0.04949, 0.04963, 0.04975,&
          0.04989, 0.05000, 0.05015, 0.05029, 0.05045, 0.05059, 0.05071,&
          0.05081, 0.05093, 0.05110, 0.05124, 0.05131, 0.05149, 0.05161,&
          0.05172, 0.05186, 0.05201, 0.05210, 0.05231, 0.05243, 0.05249,&
          0.05261, 0.05277, 0.05294, 0.05305, 0.05313, 0.05324, 0.05344,&
          0.05359, 0.05372, 0.05379, 0.05396, 0.05414, 0.05431, 0.05438,&
          0.05446, 0.05457, 0.05477, 0.05480, 0.05488, 0.05503, 0.05516,&
          0.05528, 0.05541, 0.05561, 0.05576, 0.05587, 0.05605, 0.05618,&
          0.05630, 0.05644, 0.05664, 0.05683, 0.05701, 0.05714, 0.05724,&
          0.05736, 0.05754, 0.05770, 0.05784, 0.05798, 0.05814, 0.05832,&
          0.05848, 0.05865, 0.05879, 0.05895, 0.05913, 0.05928, 0.05947,&
          0.05967, 0.05979, 0.05996, 0.06021, 0.06040, 0.06057, 0.06075,&
          0.06094, 0.06111, 0.06130, 0.06147, 0.06165, 0.06187, 0.06204,&
          0.06225, 0.06244, 0.06260, 0.06280, 0.06301, 0.06320, 0.06337,&
          0.06356, 0.06378, 0.06399, 0.06419, 0.06443, 0.06468, 0.06485,&
          0.06505, 0.06524, 0.06546, 0.06566, 0.06588, 0.06615, 0.06636,&
          0.06657, 0.06681, 0.06700, 0.06720, 0.06740, 0.06767, 0.06792,&
          0.06813, 0.06837, 0.06860, 0.06881, 0.06910, 0.06931, 0.06950,&
          0.06977, 0.07004, 0.07027, 0.07046, 0.07074, 0.07096, 0.07115,&
          0.07140, 0.07165, 0.07191, 0.07215, 0.07241, 0.07265, 0.07290,&
          0.07315, 0.07339, 0.07359, 0.07384, 0.07408, 0.07433, 0.07461,&
          0.07484, 0.07507, 0.07532, 0.07563, 0.07590, 0.07611, 0.07637,&
          0.07666, 0.07691, 0.07712, 0.07739, 0.07765, 0.07789, 0.07815,&
          0.07842, 0.07866, 0.07893, 0.07922, 0.07945, 0.07975, 0.08002,&
          0.08027, 0.08055, 0.08081, 0.08109, 0.08136, 0.08163, 0.08190,&
          0.08219, 0.08247, 0.08272, 0.08296, 0.08326, 0.08353, 0.08378,&
          0.08408, 0.08438, 0.08467, 0.08491, 0.08520, 0.08549, 0.08578,&
          0.08602, 0.08627, 0.08658, 0.08689, 0.08718, 0.08746, 0.08773,&
          0.08802, 0.08831, 0.08859, 0.08884, 0.08918, 0.08949, 0.08977,&
          0.09005, 0.09033, 0.09061, 0.09091, 0.09118, 0.09145, 0.09172,&
          0.09207, 0.09234, 0.09267, 0.09292, 0.09323, 0.09351, 0.09377,&
          0.09408, 0.09440, 0.09469, 0.09500, 0.09528, 0.09553, 0.09586,&
          0.09614, 0.09645, 0.09676, 0.09704, 0.09735, 0.09766, 0.09793,&
          0.09822, 0.09852, 0.09882, 0.09912, 0.09940, 0.09967, 0.10001,&
          0.10031, 0.10063, 0.10089, 0.10118, 0.10150, 0.10178, 0.10207,&
          0.10239, 0.10267, 0.10297, 0.10327, 0.10357, 0.10386, 0.10418,&
          0.10445, 0.10474, 0.10504, 0.10531, 0.10561, 0.10594, 0.10620,&
          0.10652, 0.10683, 0.10708, 0.10737, 0.10769, 0.10795, 0.10826,&
          0.10858, 0.10887, 0.10918, 0.10949, 0.10981, 0.11008, 0.11036,&
          0.11068, 0.11101, 0.11128, 0.11157, 0.11188, 0.11215, 0.11245,&
          0.11273, 0.11299, 0.11332, 0.11365, 0.11397, 0.11423, 0.11453,&
          0.11486, 0.11511, 0.11540, 0.11568, 0.11600, 0.11630, 0.11661,&
          0.11694, 0.11724, 0.11752, 0.11783, 0.11814, 0.11846, 0.11873,&
          0.11901, 0.11932, 0.11964, 0.11996, 0.12023, 0.12050, 0.12080,&
          0.12107, 0.12143, 0.12173, 0.12199, 0.12238, 0.12270, 0.12302,&
          0.12330, 0.12360, 0.12387, 0.12416, 0.12445, 0.12474, 0.12504,&
          0.12539, 0.12574, 0.12607, 0.12638, 0.12670, 0.12696, 0.12723,&
          0.12754, 0.12788, 0.12823, 0.12857, 0.12888, 0.12916, 0.12942,&
          0.12968, 0.13006, 0.13036, 0.13067, 0.13099, 0.13130, 0.13161,&
          0.13187, 0.13223, 0.13261, 0.13294, 0.13323, 0.13354, 0.13389,&
          0.13420, 0.13450, 0.13488, 0.13524, 0.13552, 0.13575, 0.13604,&
          0.13638, 0.13670, 0.13704, 0.13734, 0.13765, 0.13791, 0.13831,&
          0.13868, 0.13897, 0.13921, 0.13951, 0.13984, 0.14016, 0.14040,&
          0.14069, 0.14104, 0.14124, 0.14156, 0.14194, 0.14227, 0.14255,&
          0.14284, 0.14309, 0.14336, 0.14362, 0.14394, 0.14441, 0.14451,&
          0.14476, 0.14507, 0.14534, 0.14572, 0.14603, 0.14621, 0.14664,&
          0.14693, 0.14720, 0.14756, 0.14785, 0.14816, 0.14849, 0.14878,&
          0.14919, 0.14954, 0.14982, 0.15015, 0.15038, 0.15069, 0.15114,&
          0.15132, 0.15160, 0.15196, 0.15237, 0.15265, 0.15297, 0.15337,&
          0.15374, 0.15391, 0.15418, 0.15466, 0.15487, 0.15520, 0.15557,&
          0.15597, 0.15610, 0.15646, 0.15692, 0.15696, 0.15729, 0.15422,&
          0.15451, 0.15486, 0.15517, 0.15547, 0.15574, 0.15606, 0.15635,&
          0.15661, 0.15686, 0.15715, 0.15750, 0.15784, 0.15817, 0.15850,&
          0.15880, 0.15910, 0.15943, 0.15971, 0.15996, 0.16025, 0.16058,&
          0.16091, 0.16123, 0.16147, 0.16167, 0.16195, 0.16228, 0.16259,&
          0.16289, 0.16318, 0.16347, 0.16376, 0.16403, 0.16431, 0.16460,&
          0.16490, 0.16523, 0.16547, 0.16571, 0.16595, 0.16621, 0.16649,&
          0.16674, 0.16704, 0.16736, 0.16764, 0.16788, 0.16812, 0.16838,&
          0.16865, 0.16892, 0.16920, 0.16941, 0.16968, 0.16996, 0.17020,&
          0.17046, 0.17072, 0.17099, 0.17123, 0.17148, 0.17177, 0.17207,&
          0.17232, 0.17259, 0.17287, 0.17314, 0.17339, 0.17366, 0.17395,&
          0.17423, 0.17446, 0.17473, 0.17502, 0.17530, 0.17557, 0.17589,&
          0.17620, 0.17646, 0.17674, 0.17706, 0.17736, 0.17761, 0.17787,&
          0.17813, 0.17842, 0.17872, 0.17905, 0.17933, 0.17957, 0.17984,&
          0.18010, 0.18038, 0.18066, 0.18097, 0.18121, 0.18147, 0.18175,&
          0.18200, 0.18227, 0.18252, 0.18275, 0.18298, 0.18326, 0.18354,&
          0.18379, 0.18404, 0.18425, 0.18451, 0.18472, 0.18497, 0.18522,&
          0.18546, 0.18567, 0.18590, 0.18612, 0.18636, 0.18656, 0.18678,&
          0.18700, 0.18719, 0.18738, 0.18756, 0.18775, 0.18793, 0.18813,&
          0.18827, 0.18843, 0.18859, 0.18873, 0.18886, 0.18899, 0.18912,&
          0.18927, 0.18939, 0.18946, 0.18952, 0.18964, 0.18973, 0.18981,&
          0.18992, 0.19001, 0.19012, 0.19019, 0.19024, 0.19031, 0.19040,&
          0.19050, 0.19060, 0.19070, 0.19082, 0.19098, 0.19111, 0.19127,&
          0.19142, 0.19154, 0.19170, 0.19188, 0.19205, 0.19224, 0.19242,&
          0.19259, 0.19277, 0.19297, 0.19313, 0.19335, 0.19357, 0.19375,&
          0.19394, 0.19411, 0.19430, 0.19448, 0.19468, 0.19493, 0.19514,&
          0.19536, 0.19555, 0.19575, 0.19591, 0.19610, 0.19631, 0.19654,&
          0.19672, 0.19692, 0.19709, 0.19727, 0.19744, 0.19761, 0.19781,&
          0.19801, 0.19822, 0.19842, 0.19863, 0.19884, 0.19905, 0.19925,&
          0.19944, 0.19963, 0.19982, 0.20005, 0.20026, 0.20046, 0.20065,&
          0.20085, 0.20106, 0.20126, 0.20150, 0.20173, 0.20195, 0.20216,&
          0.20239, 0.20258, 0.20278, 0.20300, 0.20322, 0.20343, 0.20365,&
          0.20385, 0.20408, 0.20428, 0.20448, 0.20468, 0.20489, 0.20511,&
          0.20531, 0.20551, 0.20568, 0.20591, 0.20612, 0.20633, 0.20656,&
          0.20675, 0.20695, 0.20718, 0.20737, 0.20759, 0.20777, 0.20797,&
          0.20815, 0.20832, 0.20855, 0.20875, 0.20895, 0.20916, 0.20937,&
          0.20952, 0.20969, 0.20989, 0.21012, 0.21035, 0.21059, 0.21080,&
          0.21099, 0.21114, 0.21132, 0.21149, 0.21166, 0.21183, 0.21203,&
          0.21222, 0.21240, 0.21258, 0.21275, 0.21290, 0.21307, 0.21324,&
          0.21343, 0.21361, 0.21377, 0.21389, 0.21403, 0.21416, 0.21430,&
          0.21448, 0.21465, 0.21480, 0.21494, 0.21509, 0.21524, 0.21534,&
          0.21541, 0.21554, 0.21570, 0.21581, 0.21590, 0.21600, 0.21611,&
          0.21620, 0.21628, 0.21634, 0.21642, 0.21649, 0.21659, 0.21669,&
          0.21675, 0.21684, 0.21694, 0.21705, 0.21712, 0.21719, 0.21728,&
          0.21736, 0.21744, 0.21752, 0.21757, 0.21761, 0.21769, 0.21776,&
          0.21784, 0.21786, 0.21792, 0.21801, 0.21803, 0.21805, 0.21808,&
          0.21813, 0.21817, 0.21821, 0.21823, 0.21818, 0.21817, 0.21814,&
          0.21816, 0.21814, 0.21812, 0.21806, 0.21797, 0.21790, 0.21785,&
          0.21777, 0.21766, 0.21757, 0.21742, 0.21730, 0.21718, 0.21704,&
          0.21691, 0.21677, 0.21663, 0.21648, 0.21629, 0.21613, 0.21600,&
          0.21585, 0.21566, 0.21547, 0.21528, 0.21508, 0.21490, 0.21467,&
          0.21449, 0.21433, 0.21412, 0.21390, 0.21365, 0.21339, 0.21316,&
          0.21294, 0.21274, 0.21253, 0.21232, 0.21205, 0.21178, 0.21149,&
          0.21121, 0.21092, 0.21060, 0.21022, 0.20981, 0.20934, 0.20888,&
          0.20825, 0.20764, 0.20692, 0.20621, 0.20529, 0.20438, 0.20330,&
          0.20219, 0.20097, 0.19967, 0.19825, 0.19678, 0.19519, 0.19356,&
          0.19183, 0.19001, 0.18814, 0.18624, 0.18427, 0.18222, 0.18015,&
          0.17801, 0.17589, 0.17374, 0.17156, 0.16946, 0.16734, 0.16526,&
          0.16316, 0.16119, 0.15924, 0.15739, 0.15552, 0.15385, 0.15214,&
          0.15055, 0.14901, 0.14761, 0.14628, 0.14507, 0.14387, 0.14284,&
          0.14189, 0.14103, 0.14026, 0.13958, 0.13896, 0.13840, 0.13789,&
          0.13744, 0.13702, 0.13662, 0.13628, 0.13593, 0.13563, 0.13536,&
          0.13511, 0.13486, 0.13465, 0.13444, 0.13425, 0.13406, 0.13391,&
          0.13377, 0.13366, 0.13354, 0.13347, 0.13341, 0.13334, 0.13328,&
          0.13326, 0.13323, 0.13321, 0.13315, 0.13318, 0.13324, 0.13328,&
          0.13333, 0.13339, 0.13349, 0.13358, 0.13369, 0.13378, 0.13390,&
          0.13404, 0.13422, 0.13439, 0.13455, 0.13476, 0.13502, 0.13527,&
          0.13553, 0.13584, 0.13619, 0.13657, 0.13698, 0.13739, 0.13784,&
          0.13831, 0.13880, 0.13931, 0.13982, 0.14037, 0.14094, 0.14152,&
          0.14213, 0.14275, 0.14335, 0.14395, 0.14459, 0.14523, 0.14587,&
          0.14651, 0.14720, 0.14791, 0.14855, 0.14922, 0.14990, 0.15059,&
          0.15129, 0.15197, 0.15265, 0.15333, 0.15402, 0.15473, 0.15541,&
          0.15612, 0.15683, 0.15756, 0.15827, 0.15897, 0.15968, 0.16040,&
          0.16109, 0.16181, 0.16251, 0.16318, 0.16385, 0.16453, 0.16521,&
          0.16592, 0.16662, 0.16733, 0.16803, 0.16867, 0.16931, 0.16996,&
          0.17060, 0.17129, 0.17193, 0.17259, 0.17325, 0.17384, 0.17446,&
          0.17509, 0.17569, 0.17630, 0.17690, 0.17751, 0.17809, 0.17870,&
          0.17932, 0.17991, 0.18050, 0.18108, 0.18162, 0.18221, 0.18281,&
          0.18337, 0.18391, 0.18446, 0.18499, 0.18553, 0.18607, 0.18662,&
          0.18720, 0.18770, 0.18821, 0.18870, 0.18920, 0.18971, 0.19023,&
          0.19073, 0.19122, 0.19172, 0.19218, 0.19266, 0.19314, 0.19359,&
          0.19402, 0.19451, 0.19497, 0.19540, 0.19583, 0.19623, 0.19668,&
          0.19713, 0.19755, 0.19795, 0.19834, 0.19874, 0.19910, 0.19947,&
          0.19988, 0.20027, 0.20064, 0.20100, 0.20135, 0.20171, 0.20207,&
          0.20243, 0.20279, 0.20311, 0.20344, 0.20378, 0.20412, 0.20447,&
          0.20479, 0.20509, 0.20543, 0.20577, 0.20608, 0.20638, 0.20667,&
          0.20697, 0.20728, 0.20756, 0.20781, 0.20805, 0.20833, 0.20860,&
          0.20884, 0.20912, 0.20942, 0.20970, 0.20995, 0.21021, 0.21046,&
          0.21069, 0.21092, 0.21114, 0.21138, 0.21163, 0.21188, 0.21209,&
          0.21232, 0.21259, 0.21284, 0.21307, 0.21323, 0.21341, 0.21361,&
          0.21382, 0.21401, 0.21423, 0.21443, 0.21465, 0.21485, 0.21506,&
          0.21518, 0.21533, 0.21553, 0.21573, 0.21592, 0.21608, 0.21623,&
          0.21637, 0.21653, 0.21670, 0.21688, 0.21703, 0.21720, 0.21738,&
          0.21751, 0.21764, 0.21772, 0.21778, 0.21791, 0.21805, 0.21819,&
          0.21830, 0.21844, 0.21855, 0.21862, 0.21871, 0.21885, 0.21897,&
          0.21909, 0.21921, 0.21928, 0.21938, 0.21946, 0.21953, 0.21960,&
          0.21965, 0.21974, 0.21982, 0.21988, 0.21991, 0.22001, 0.22008,&
          0.22014, 0.22021, 0.22028, 0.22033, 0.22038, 0.22043, 0.22049,&
          0.22054, 0.22056, 0.22061, 0.22067, 0.22072, 0.22076, 0.22078,&
          0.22078, 0.22079, 0.22086, 0.22089, 0.22087, 0.22088, 0.22090,&
          0.22091, 0.22089, 0.22088, 0.22089, 0.22089, 0.22088, 0.22087,&
          0.22085, 0.22083, 0.22076, 0.22073, 0.22071, 0.22065, 0.22054,&
          0.22044, 0.22041, 0.22033, 0.22023, 0.22015, 0.22006, 0.22000,&
          0.21992, 0.21980, 0.21966, 0.21949, 0.21930, 0.21918, 0.21905,&
          0.21890, 0.21877, 0.21861, 0.21842, 0.21823, 0.21807, 0.21789,&
          0.21772, 0.21754, 0.21734, 0.21714, 0.21694, 0.21673, 0.21654,&
          0.21632, 0.21612, 0.21588, 0.21564, 0.21543, 0.21521, 0.21492,&
          0.21464, 0.21443, 0.21423, 0.21395, 0.21368, 0.21340, 0.21310,&
          0.21282, 0.21254, 0.21225, 0.21199, 0.21172, 0.21146, 0.21114,&
          0.21083, 0.21050, 0.21020, 0.20991, 0.20966, 0.20944, 0.20918,&
          0.20889, 0.20862, 0.20836, 0.20811, 0.20783, 0.20758, 0.20738,&
          0.20715, 0.20695, 0.20675, 0.20656, 0.20635, 0.20610, 0.20597,&
          0.20589, 0.20575, 0.20560, 0.20546, 0.20533, 0.20525, 0.20521,&
          0.20512, 0.20504, 0.20497, 0.20491, 0.20490, 0.20489, 0.20490,&
          0.20489, 0.20490, 0.20490, 0.20494, 0.20496, 0.20496, 0.20494,&
          0.20502, 0.20513, 0.20518, 0.20524, 0.20536, 0.20546, 0.20554,&
          0.20556, 0.20559, 0.20564, 0.20570, 0.20571, 0.20572, 0.20572,&
          0.20575, 0.20576, 0.20582, 0.20583, 0.20581, 0.20579, 0.20580,&
          0.20575, 0.20573, 0.20569, 0.20559, 0.20545, 0.20539, 0.20535,&
          0.20524, 0.20509, 0.20497, 0.20487, 0.20473, 0.20453, 0.20429,&
          0.20403, 0.20381, 0.20353, 0.20324, 0.20297, 0.20259, 0.20221,&
          0.20176, 0.20130, 0.20087, 0.20046, 0.19987, 0.19921, 0.19853,&
          0.19779, 0.19702, 0.19617, 0.19535, 0.19436, 0.19334, 0.19220,&
          0.19102, 0.18972, 0.18833, 0.18688, 0.18530, 0.18371, 0.18184,&
          0.17994, 0.17787, 0.17576, 0.17349, 0.17106, 0.16853, 0.16589,&
          0.16320, 0.16026, 0.15726, 0.15421, 0.15110, 0.14777, 0.14441,&
          0.14101, 0.13755, 0.13411, 0.13054, 0.12698, 0.12335, 0.11972,&
          0.11602, 0.11233, 0.10872, 0.10520, 0.10171, 0.09824, 0.09492,&
          0.09177, 0.08862, 0.08566, 0.08277, 0.08008, 0.07749, 0.07514,&
          0.07290, 0.07079, 0.06888, 0.06708, 0.06548, 0.06391, 0.06257,&
          0.06126, 0.06017, 0.05911, 0.05819, 0.05736, 0.05661, 0.05594,&
          0.05528, 0.05477, 0.05426, 0.05384, 0.05344, 0.05310, 0.05275,&
          0.05246, 0.05223, 0.05203, 0.05184, 0.05165, 0.05155, 0.05147,&
          0.05142, 0.05134, 0.05130, 0.05128, 0.05131, 0.05137, 0.05139,&
          0.05141, 0.05144, 0.05157, 0.05170, 0.05186, 0.05203, 0.05216,&
          0.05233, 0.05253, 0.05276, 0.05300, 0.05327, 0.05351, 0.05378,&
          0.05407, 0.05442, 0.05477, 0.05507, 0.05539, 0.05576, 0.05613,&
          0.05650, 0.05687, 0.05723, 0.05764, 0.05807, 0.05849, 0.05889,&
          0.05930, 0.05969, 0.06018, 0.06070, 0.06113, 0.06155, 0.06200,&
          0.06251, 0.06302, 0.06344, 0.06390, 0.06443, 0.06496, 0.06545,&
          0.06596, 0.06647, 0.06701, 0.06752, 0.06804, 0.06858, 0.06918,&
          0.06977, 0.07033, 0.07088, 0.07145, 0.07203, 0.07262, 0.07318,&
          0.07377, 0.07439, 0.07499, 0.07558, 0.07617, 0.07680, 0.07743,&
          0.07804, 0.07864, 0.07928, 0.07993, 0.08052, 0.08114, 0.08178,&
          0.08243, 0.08304, 0.08369, 0.08432, 0.08497, 0.08561, 0.08625,&
          0.08687, 0.08751, 0.08812, 0.08873, 0.08931, 0.08995, 0.09060,&
          0.09123, 0.09184, 0.09248, 0.09310, 0.09372, 0.09434, 0.09496,&
          0.09557, 0.09620, 0.09682, 0.09742, 0.09802, 0.09864, 0.09922,&
          0.09983, 0.10043, 0.10106, 0.10167, 0.10226, 0.10285, 0.10348,&
          0.10412, 0.10464, 0.10519, 0.10581, 0.10645, 0.10700, 0.10754,&
          0.10814, 0.10880, 0.10937, 0.10990, 0.11044, 0.11106, 0.11166,&
          0.11223, 0.11279, 0.11337, 0.11396, 0.11452, 0.11509, 0.11567,&
          0.11624, 0.11680, 0.11737, 0.11794, 0.11851, 0.11907, 0.11965,&
          0.12024, 0.12079, 0.12133, 0.12189, 0.12245, 0.12302, 0.12361,&
          0.12417, 0.12473, 0.12529, 0.12587, 0.12643, 0.12696, 0.12752,&
          0.12806, 0.12862, 0.12920, 0.12979, 0.13030, 0.13084, 0.13139,&
          0.13195, 0.13245, 0.13298, 0.13351, 0.13407, 0.13459, 0.13510,&
          0.13562, 0.13613, 0.13666, 0.13718, 0.13771, 0.13820, 0.13869,&
          0.13920, 0.13971, 0.14025, 0.14076, 0.14127, 0.14177, 0.14224,&
          0.14272, 0.14323, 0.14375, 0.14424, 0.14474, 0.14524, 0.14572,&
          0.14620, 0.14666, 0.14712, 0.14758, 0.14802, 0.14849, 0.14895,&
          0.14939, 0.14982, 0.15026, 0.15067, 0.15109, 0.15154, 0.15195,&
          0.15233, 0.15271, 0.15309, 0.15348, 0.15385, 0.15419, 0.15445,&
          0.15475, 0.15510, 0.15543, 0.15573, 0.15600, 0.15620, 0.15643,&
          0.15668, 0.15695, 0.15714, 0.15732, 0.15752, 0.15771, 0.15784,&
          0.15800, 0.15815, 0.15830, 0.15841, 0.15847, 0.15856, 0.15863,&
          0.15867, 0.15873, 0.15879, 0.15881, 0.15884, 0.15890, 0.15895,&
          0.15892, 0.15889, 0.15893, 0.15895, 0.15890, 0.15887, 0.15885,&
          0.15882, 0.15880, 0.15870, 0.15863, 0.15854, 0.15846, 0.15840,&
          0.15831, 0.15821, 0.15808, 0.15791, 0.15775, 0.15768, 0.15758,&
          0.15736, 0.15714, 0.15699, 0.15682, 0.15662, 0.15637, 0.15620,&
          0.15604, 0.15576, 0.15544, 0.15525, 0.15506, 0.15483, 0.15454,&
          0.15428, 0.15409, 0.15390, 0.15370, 0.15352, 0.15334, 0.15317,&
          0.15308, 0.15303, 0.15292, 0.15287, 0.15298, 0.15305, 0.15307,&
          0.15310, 0.15323, 0.15336, 0.15348, 0.15360, 0.15382, 0.15399,&
          0.15402, 0.15404, 0.15413, 0.15424, 0.15429, 0.15433, 0.15439,&
          0.15448, 0.15445, 0.15436, 0.15436, 0.15439, 0.15434, 0.15422,&
          0.15413, 0.15407, 0.15395, 0.15381, 0.15365, 0.15360, 0.15350,&
          0.15328, 0.15311, 0.15295, 0.15280, 0.15265, 0.15249, 0.15231,&
          0.15215, 0.15202, 0.15190, 0.15172, 0.15157, 0.15143, 0.15134,&
          0.15122, 0.15106, 0.15095, 0.15086, 0.15074, 0.15062, 0.15052,&
          0.15046, 0.15036, 0.15023, 0.15007, 0.14986, 0.14975, 0.14971,&
          0.14957, 0.14938, 0.14920, 0.14907, 0.14889, 0.14858, 0.14836,&
          0.14817, 0.14793, 0.14762, 0.14733, 0.14708, 0.14682, 0.14655,&
          0.14627, 0.14600, 0.14572, 0.14534, 0.14497, 0.14473, 0.14450,&
          0.14414, 0.14375, 0.14343, 0.14312, 0.14276, 0.14237, 0.14204,&
          0.14171, 0.14134, 0.14093, 0.14053, 0.14014, 0.13979, 0.13945,&
          0.13905, 0.13864, 0.13822, 0.13779, 0.13747, 0.13714, 0.13669,&
          0.13618, 0.13582, 0.13551, 0.13508, 0.13462, 0.13426, 0.13396,&
          0.13354, 0.13301, 0.13264, 0.13238, 0.13197, 0.13143, 0.13100,&
          0.13066, 0.13030, 0.12988, 0.12942, 0.12894, 0.12850, 0.12817,&
          0.12771, 0.12710, 0.12662, 0.12625, 0.12588, 0.12548, 0.12504,&
          0.12455, 0.12408, 0.12364, 0.12317, 0.12272, 0.12235, 0.12204,&
          0.12164, 0.12105, 0.12052, 0.12029, 0.12000, 0.11953, 0.11907,&
          0.11878, 0.11843, 0.11793, 0.11749, 0.11717, 0.11678, 0.11631,&
          0.11584, 0.11553, 0.11521, 0.11481, 0.11440, 0.11397, 0.11358,&
          0.11327, 0.11291, 0.11233, 0.11184, 0.11156, 0.11121, 0.11066,&
          0.11014, 0.10976, 0.10938, 0.10894, 0.10851, 0.10800, 0.10761,&
          0.10741, 0.10705, 0.10630, 0.10569, 0.10548, 0.10517, 0.10468,&
          0.10424, 0.10398, 0.10362, 0.10304, 0.10254, 0.10221, 0.10185,&
          0.10143, 0.10101, 0.10053, 0.10008, 0.09982, 0.09953, 0.09905,&
          0.09860, 0.09818, 0.09772, 0.09724, 0.09679, 0.09648, 0.09609,&
          0.09569, 0.09523, 0.09465, 0.09411, 0.09364, 0.09324, 0.09286,&
          0.09242, 0.09186, 0.09147, 0.09113, 0.09068, 0.09011, 0.08962,&
          0.08919, 0.08880, 0.08847, 0.08799, 0.08736, 0.08689, 0.08653,&
          0.08609, 0.08555, 0.08515, 0.08478, 0.08430, 0.08380, 0.08341,&
          0.08304, 0.08256, 0.08209, 0.08151, 0.08085, 0.08060, 0.08057,&
          0.08015, 0.07961, 0.07921, 0.07884, 0.07833, 0.07779, 0.07731,&
          0.07684, 0.07667, 0.07657, 0.07603, 0.07537, 0.07490, 0.07450,&
          0.07437, 0.07418, 0.07366, 0.07319, 0.07283, 0.07240, 0.07195,&
          0.07163, 0.07148, 0.07122, 0.07078, 0.07037, 0.06989, 0.06946,&
          0.06949, 0.06939, 0.06885, 0.06833, 0.06795, 0.06743, 0.06678,&
          0.06648, 0.06672, 0.06651, 0.06573, 0.06551, 0.06590, 0.06577,&
          0.06528, 0.06487, 0.06449, 0.06452, 0.06479, 0.06458, 0.06412,&
          0.06356, 0.06291, 0.06340, 0.06425, 0.06328, 0.06194, 0.06267,&
          0.06364/
              data (phis2full(itmp),itmp=1,2101)/&
          0.00721, 0.00739, 0.00768, 0.00792, 0.00773, 0.00773, 0.00789,&
          0.00828, 0.00839, 0.00850, 0.00863, 0.00863, 0.00863, 0.00864,&
          0.00846, 0.00860, 0.00886, 0.00892, 0.00896, 0.00900, 0.00904,&
          0.00915, 0.00914, 0.00901, 0.00909, 0.00925, 0.00943, 0.00931,&
          0.00936, 0.00944, 0.00945, 0.00964, 0.00976, 0.00974, 0.00980,&
          0.00987, 0.00997, 0.01003, 0.01010, 0.01016, 0.01021, 0.01029,&
          0.01042, 0.01065, 0.01067, 0.01069, 0.01075, 0.01080, 0.01088,&
          0.01093, 0.01099, 0.01104, 0.01111, 0.01117, 0.01128, 0.01133,&
          0.01124, 0.01135, 0.01140, 0.01137, 0.01152, 0.01161, 0.01165,&
          0.01170, 0.01175, 0.01180, 0.01183, 0.01182, 0.01185, 0.01197,&
          0.01197, 0.01205, 0.01220, 0.01214, 0.01218, 0.01228, 0.01235,&
          0.01245, 0.01251, 0.01242, 0.01251, 0.01262, 0.01274, 0.01279,&
          0.01281, 0.01282, 0.01287, 0.01284, 0.01283, 0.01301, 0.01305,&
          0.01308, 0.01319, 0.01327, 0.01333, 0.01339, 0.01340, 0.01346,&
          0.01357, 0.01358, 0.01365, 0.01375, 0.01377, 0.01387, 0.01395,&
          0.01396, 0.01403, 0.01411, 0.01422, 0.01428, 0.01436, 0.01443,&
          0.01448, 0.01454, 0.01461, 0.01470, 0.01477, 0.01480, 0.01485,&
          0.01493, 0.01499, 0.01500, 0.01514, 0.01522, 0.01525, 0.01529,&
          0.01534, 0.01543, 0.01554, 0.01560, 0.01567, 0.01575, 0.01581,&
          0.01586, 0.01590, 0.01596, 0.01607, 0.01617, 0.01628, 0.01630,&
          0.01632, 0.01645, 0.01650, 0.01654, 0.01665, 0.01673, 0.01683,&
          0.01693, 0.01698, 0.01706, 0.01715, 0.01724, 0.01732, 0.01740,&
          0.01746, 0.01755, 0.01765, 0.01771, 0.01783, 0.01793, 0.01799,&
          0.01808, 0.01816, 0.01825, 0.01833, 0.01841, 0.01849, 0.01859,&
          0.01866, 0.01874, 0.01887, 0.01892, 0.01898, 0.01908, 0.01916,&
          0.01924, 0.01930, 0.01940, 0.01949, 0.01955, 0.01964, 0.01970,&
          0.01977, 0.01987, 0.01994, 0.02002, 0.02010, 0.02014, 0.02022,&
          0.02031, 0.02038, 0.02044, 0.02051, 0.02061, 0.02066, 0.02072,&
          0.02079, 0.02084, 0.02090, 0.02098, 0.02103, 0.02110, 0.02118,&
          0.02125, 0.02129, 0.02134, 0.02143, 0.02150, 0.02156, 0.02162,&
          0.02169, 0.02177, 0.02187, 0.02190, 0.02195, 0.02202, 0.02209,&
          0.02216, 0.02222, 0.02226, 0.02233, 0.02239, 0.02243, 0.02248,&
          0.02254, 0.02257, 0.02263, 0.02270, 0.02278, 0.02283, 0.02290,&
          0.02297, 0.02306, 0.02312, 0.02317, 0.02322, 0.02330, 0.02338,&
          0.02345, 0.02351, 0.02357, 0.02363, 0.02369, 0.02373, 0.02378,&
          0.02386, 0.02393, 0.02400, 0.02405, 0.02411, 0.02419, 0.02426,&
          0.02432, 0.02441, 0.02449, 0.02455, 0.02460, 0.02467, 0.02475,&
          0.02482, 0.02489, 0.02495, 0.02502, 0.02510, 0.02518, 0.02521,&
          0.02527, 0.02535, 0.02544, 0.02551, 0.02558, 0.02565, 0.02573,&
          0.02580, 0.02587, 0.02594, 0.02602, 0.02609, 0.02616, 0.02626,&
          0.02633, 0.02639, 0.02646, 0.02655, 0.02661, 0.02667, 0.02677,&
          0.02686, 0.02692, 0.02700, 0.02708, 0.02716, 0.02723, 0.02731,&
          0.02740, 0.02747, 0.02754, 0.02762, 0.02768, 0.02777, 0.02786,&
          0.02793, 0.02798, 0.02806, 0.02816, 0.02822, 0.02830, 0.02841,&
          0.02848, 0.02855, 0.02863, 0.02870, 0.02877, 0.02885, 0.02893,&
          0.02900, 0.02909, 0.02919, 0.02926, 0.02934, 0.02942, 0.02950,&
          0.02958, 0.02967, 0.02976, 0.02982, 0.02989, 0.02999, 0.03007,&
          0.03014, 0.03022, 0.03031, 0.03039, 0.03047, 0.03057, 0.03065,&
          0.03072, 0.03082, 0.03090, 0.03096, 0.03105, 0.03113, 0.03122,&
          0.03130, 0.03139, 0.03146, 0.03153, 0.03164, 0.03171, 0.03179,&
          0.03187, 0.03195, 0.03204, 0.03213, 0.03219, 0.03229, 0.03238,&
          0.03244, 0.03253, 0.03261, 0.03270, 0.03278, 0.03287, 0.03295,&
          0.03304, 0.03313, 0.03320, 0.03328, 0.03336, 0.03345, 0.03355,&
          0.03361, 0.03369, 0.03378, 0.03386, 0.03393, 0.03400, 0.03408,&
          0.03418, 0.03426, 0.03434, 0.03442, 0.03451, 0.03460, 0.03468,&
          0.03474, 0.03483, 0.03491, 0.03500, 0.03507, 0.03515, 0.03523,&
          0.03531, 0.03538, 0.03546, 0.03552, 0.03561, 0.03570, 0.03576,&
          0.03584, 0.03591, 0.03598, 0.03606, 0.03614, 0.03620, 0.03629,&
          0.03636, 0.03643, 0.03651, 0.03658, 0.03665, 0.03673, 0.03678,&
          0.03685, 0.03691, 0.03700, 0.03707, 0.03713, 0.03720, 0.03727,&
          0.03733, 0.03740, 0.03747, 0.03752, 0.03759, 0.03766, 0.03771,&
          0.03779, 0.03785, 0.03791, 0.03797, 0.03803, 0.03809, 0.03816,&
          0.03821, 0.03827, 0.03834, 0.03840, 0.03845, 0.03851, 0.03857,&
          0.03863, 0.03867, 0.03872, 0.03876, 0.03881, 0.03888, 0.03894,&
          0.03898, 0.03901, 0.03907, 0.03913, 0.03916, 0.03923, 0.03928,&
          0.03932, 0.03940, 0.03944, 0.03948, 0.03952, 0.03957, 0.03961,&
          0.03964, 0.03973, 0.03977, 0.03982, 0.03985, 0.03990, 0.03995,&
          0.03998, 0.04004, 0.04009, 0.04013, 0.04016, 0.04021, 0.04027,&
          0.04031, 0.04034, 0.04039, 0.04044, 0.04049, 0.04053, 0.04057,&
          0.04064, 0.04067, 0.04072, 0.04077, 0.04079, 0.04082, 0.04087,&
          0.04093, 0.04097, 0.04102, 0.04107, 0.04115, 0.04117, 0.04120,&
          0.04125, 0.04128, 0.04130, 0.04134, 0.04138, 0.04145, 0.04151,&
          0.04155, 0.04160, 0.04164, 0.04166, 0.04170, 0.04176, 0.04183,&
          0.04192, 0.04193, 0.04199, 0.04204, 0.04206, 0.04210, 0.04216,&
          0.04222, 0.04225, 0.04228, 0.04233, 0.04240, 0.04245, 0.04250,&
          0.04255, 0.04260, 0.04262, 0.04265, 0.04270, 0.04275, 0.04281,&
          0.04287, 0.04295, 0.04298, 0.04302, 0.04307, 0.04314, 0.04316,&
          0.04320, 0.04325, 0.04333, 0.04339, 0.04343, 0.04350, 0.04356,&
          0.04360, 0.04364, 0.04373, 0.04379, 0.04384, 0.04388, 0.04391,&
          0.04395, 0.04403, 0.04412, 0.04417, 0.04420, 0.04421, 0.04432,&
          0.04438, 0.04443, 0.04449, 0.04453, 0.04458, 0.04467, 0.04468,&
          0.04474, 0.04481, 0.04486, 0.04488, 0.04491, 0.04496, 0.04505,&
          0.04506, 0.04509, 0.04514, 0.04518, 0.04522, 0.04526, 0.04529,&
          0.04540, 0.04544, 0.04542, 0.04545, 0.04550, 0.04556, 0.04559,&
          0.04557, 0.04565, 0.04572, 0.04575, 0.04579, 0.04580, 0.04580,&
          0.04581, 0.04598, 0.04601, 0.04597, 0.04613, 0.04615, 0.04560,&
          0.04564, 0.04568, 0.04572, 0.04577, 0.04581, 0.04584, 0.04588,&
          0.04592, 0.04596, 0.04600, 0.04603, 0.04606, 0.04609, 0.04611,&
          0.04614, 0.04617, 0.04618, 0.04621, 0.04626, 0.04630, 0.04631,&
          0.04633, 0.04636, 0.04643, 0.04649, 0.04653, 0.04657, 0.04660,&
          0.04663, 0.04666, 0.04668, 0.04671, 0.04674, 0.04676, 0.04679,&
          0.04681, 0.04682, 0.04688, 0.04692, 0.04696, 0.04700, 0.04702,&
          0.04707, 0.04710, 0.04710, 0.04713, 0.04717, 0.04721, 0.04724,&
          0.04728, 0.04732, 0.04736, 0.04740, 0.04741, 0.04744, 0.04748,&
          0.04753, 0.04756, 0.04758, 0.04762, 0.04765, 0.04767, 0.04770,&
          0.04774, 0.04776, 0.04779, 0.04782, 0.04787, 0.04790, 0.04793,&
          0.04797, 0.04802, 0.04804, 0.04807, 0.04810, 0.04813, 0.04815,&
          0.04819, 0.04823, 0.04827, 0.04828, 0.04830, 0.04833, 0.04836,&
          0.04841, 0.04843, 0.04845, 0.04847, 0.04851, 0.04856, 0.04858,&
          0.04861, 0.04863, 0.04867, 0.04868, 0.04873, 0.04877, 0.04878,&
          0.04880, 0.04883, 0.04886, 0.04891, 0.04895, 0.04897, 0.04898,&
          0.04901, 0.04905, 0.04909, 0.04910, 0.04913, 0.04916, 0.04919,&
          0.04923, 0.04929, 0.04931, 0.04932, 0.04934, 0.04937, 0.04937,&
          0.04938, 0.04942, 0.04947, 0.04952, 0.04956, 0.04960, 0.04964,&
          0.04969, 0.04972, 0.04976, 0.04980, 0.04985, 0.04989, 0.04994,&
          0.04998, 0.05003, 0.05009, 0.05016, 0.05022, 0.05028, 0.05034,&
          0.05040, 0.05044, 0.05049, 0.05055, 0.05062, 0.05068, 0.05073,&
          0.05080, 0.05085, 0.05091, 0.05097, 0.05101, 0.05105, 0.05110,&
          0.05115, 0.05120, 0.05124, 0.05127, 0.05130, 0.05133, 0.05136,&
          0.05139, 0.05143, 0.05147, 0.05151, 0.05153, 0.05154, 0.05157,&
          0.05161, 0.05163, 0.05165, 0.05169, 0.05172, 0.05174, 0.05177,&
          0.05180, 0.05182, 0.05185, 0.05189, 0.05191, 0.05194, 0.05196,&
          0.05200, 0.05204, 0.05207, 0.05210, 0.05213, 0.05217, 0.05220,&
          0.05222, 0.05225, 0.05228, 0.05231, 0.05234, 0.05236, 0.05237,&
          0.05239, 0.05242, 0.05245, 0.05247, 0.05250, 0.05252, 0.05255,&
          0.05257, 0.05260, 0.05263, 0.05264, 0.05265, 0.05268, 0.05270,&
          0.05272, 0.05275, 0.05277, 0.05279, 0.05281, 0.05282, 0.05285,&
          0.05288, 0.05290, 0.05292, 0.05294, 0.05296, 0.05297, 0.05298,&
          0.05301, 0.05304, 0.05306, 0.05307, 0.05308, 0.05310, 0.05312,&
          0.05315, 0.05319, 0.05318, 0.05320, 0.05321, 0.05324, 0.05327,&
          0.05331, 0.05332, 0.05333, 0.05335, 0.05337, 0.05339, 0.05342,&
          0.05344, 0.05345, 0.05348, 0.05349, 0.05350, 0.05351, 0.05352,&
          0.05355, 0.05358, 0.05359, 0.05361, 0.05364, 0.05368, 0.05369,&
          0.05369, 0.05372, 0.05375, 0.05377, 0.05380, 0.05382, 0.05382,&
          0.05384, 0.05386, 0.05389, 0.05393, 0.05396, 0.05399, 0.05401,&
          0.05402, 0.05404, 0.05406, 0.05409, 0.05411, 0.05412, 0.05416,&
          0.05420, 0.05423, 0.05426, 0.05429, 0.05432, 0.05434, 0.05437,&
          0.05442, 0.05447, 0.05453, 0.05456, 0.05461, 0.05464, 0.05467,&
          0.05473, 0.05478, 0.05480, 0.05484, 0.05489, 0.05495, 0.05500,&
          0.05505, 0.05511, 0.05516, 0.05521, 0.05527, 0.05533, 0.05540,&
          0.05546, 0.05553, 0.05558, 0.05560, 0.05566, 0.05574, 0.05581,&
          0.05587, 0.05594, 0.05600, 0.05606, 0.05614, 0.05621, 0.05627,&
          0.05632, 0.05640, 0.05647, 0.05655, 0.05664, 0.05672, 0.05679,&
          0.05687, 0.05696, 0.05705, 0.05714, 0.05723, 0.05730, 0.05738,&
          0.05746, 0.05753, 0.05761, 0.05769, 0.05778, 0.05786, 0.05793,&
          0.05800, 0.05807, 0.05815, 0.05823, 0.05831, 0.05837, 0.05845,&
          0.05851, 0.05856, 0.05862, 0.05870, 0.05878, 0.05886, 0.05894,&
          0.05902, 0.05910, 0.05917, 0.05925, 0.05936, 0.05946, 0.05958,&
          0.05970, 0.05982, 0.05996, 0.06010, 0.06026, 0.06041, 0.06056,&
          0.06075, 0.06094, 0.06112, 0.06130, 0.06155, 0.06180, 0.06207,&
          0.06233, 0.06263, 0.06296, 0.06332, 0.06369, 0.06408, 0.06448,&
          0.06491, 0.06536, 0.06582, 0.06627, 0.06674, 0.06723, 0.06772,&
          0.06822, 0.06871, 0.06919, 0.06968, 0.07012, 0.07057, 0.07101,&
          0.07145, 0.07184, 0.07221, 0.07256, 0.07292, 0.07322, 0.07353,&
          0.07382, 0.07409, 0.07436, 0.07462, 0.07488, 0.07513, 0.07539,&
          0.07565, 0.07592, 0.07618, 0.07644, 0.07671, 0.07697, 0.07725,&
          0.07752, 0.07779, 0.07806, 0.07830, 0.07855, 0.07879, 0.07902,&
          0.07925, 0.07948, 0.07967, 0.07986, 0.08007, 0.08027, 0.08044,&
          0.08061, 0.08075, 0.08088, 0.08103, 0.08117, 0.08131, 0.08145,&
          0.08156, 0.08168, 0.08178, 0.08190, 0.08199, 0.08208, 0.08216,&
          0.08224, 0.08232, 0.08238, 0.08244, 0.08249, 0.08255, 0.08259,&
          0.08261, 0.08262, 0.08264, 0.08266, 0.08266, 0.08266, 0.08266,&
          0.08265, 0.08263, 0.08259, 0.08254, 0.08250, 0.08246, 0.08240,&
          0.08234, 0.08226, 0.08218, 0.08211, 0.08204, 0.08196, 0.08188,&
          0.08178, 0.08166, 0.08157, 0.08148, 0.08138, 0.08127, 0.08116,&
          0.08105, 0.08091, 0.08076, 0.08064, 0.08051, 0.08039, 0.08027,&
          0.08014, 0.08002, 0.07988, 0.07974, 0.07960, 0.07947, 0.07934,&
          0.07922, 0.07908, 0.07892, 0.07878, 0.07864, 0.07850, 0.07835,&
          0.07821, 0.07808, 0.07794, 0.07782, 0.07768, 0.07754, 0.07739,&
          0.07724, 0.07709, 0.07694, 0.07678, 0.07666, 0.07653, 0.07640,&
          0.07627, 0.07612, 0.07599, 0.07585, 0.07571, 0.07558, 0.07546,&
          0.07532, 0.07520, 0.07506, 0.07493, 0.07479, 0.07467, 0.07453,&
          0.07438, 0.07427, 0.07414, 0.07401, 0.07390, 0.07376, 0.07363,&
          0.07351, 0.07340, 0.07328, 0.07317, 0.07305, 0.07295, 0.07284,&
          0.07270, 0.07259, 0.07247, 0.07237, 0.07227, 0.07217, 0.07207,&
          0.07196, 0.07185, 0.07174, 0.07163, 0.07153, 0.07144, 0.07134,&
          0.07126, 0.07116, 0.07106, 0.07098, 0.07089, 0.07081, 0.07072,&
          0.07062, 0.07053, 0.07044, 0.07037, 0.07030, 0.07024, 0.07017,&
          0.07008, 0.07001, 0.06994, 0.06987, 0.06980, 0.06973, 0.06966,&
          0.06959, 0.06953, 0.06948, 0.06942, 0.06937, 0.06933, 0.06927,&
          0.06921, 0.06915, 0.06910, 0.06904, 0.06898, 0.06894, 0.06888,&
          0.06882, 0.06878, 0.06874, 0.06870, 0.06866, 0.06861, 0.06857,&
          0.06855, 0.06852, 0.06847, 0.06843, 0.06840, 0.06835, 0.06832,&
          0.06829, 0.06825, 0.06822, 0.06819, 0.06817, 0.06813, 0.06811,&
          0.06807, 0.06801, 0.06797, 0.06795, 0.06796, 0.06796, 0.06792,&
          0.06788, 0.06786, 0.06783, 0.06779, 0.06774, 0.06773, 0.06771,&
          0.06772, 0.06770, 0.06768, 0.06766, 0.06763, 0.06763, 0.06760,&
          0.06758, 0.06756, 0.06754, 0.06751, 0.06750, 0.06746, 0.06743,&
          0.06741, 0.06741, 0.06743, 0.06746, 0.06744, 0.06743, 0.06741,&
          0.06741, 0.06739, 0.06739, 0.06739, 0.06737, 0.06734, 0.06730,&
          0.06730, 0.06729, 0.06729, 0.06727, 0.06726, 0.06725, 0.06725,&
          0.06726, 0.06725, 0.06723, 0.06724, 0.06726, 0.06725, 0.06724,&
          0.06724, 0.06723, 0.06724, 0.06725, 0.06727, 0.06728, 0.06727,&
          0.06727, 0.06729, 0.06731, 0.06728, 0.06728, 0.06731, 0.06733,&
          0.06734, 0.06735, 0.06735, 0.06737, 0.06740, 0.06743, 0.06745,&
          0.06748, 0.06750, 0.06752, 0.06752, 0.06753, 0.06756, 0.06758,&
          0.06761, 0.06764, 0.06768, 0.06772, 0.06775, 0.06778, 0.06784,&
          0.06790, 0.06791, 0.06794, 0.06798, 0.06800, 0.06802, 0.06804,&
          0.06807, 0.06812, 0.06816, 0.06821, 0.06827, 0.06830, 0.06833,&
          0.06838, 0.06842, 0.06847, 0.06854, 0.06860, 0.06866, 0.06870,&
          0.06874, 0.06881, 0.06889, 0.06895, 0.06899, 0.06907, 0.06916,&
          0.06925, 0.06933, 0.06942, 0.06951, 0.06957, 0.06964, 0.06974,&
          0.06984, 0.06987, 0.06991, 0.07002, 0.07014, 0.07021, 0.07030,&
          0.07038, 0.07045, 0.07055, 0.07064, 0.07076, 0.07087, 0.07095,&
          0.07104, 0.07115, 0.07124, 0.07132, 0.07141, 0.07150, 0.07160,&
          0.07171, 0.07180, 0.07188, 0.07197, 0.07208, 0.07217, 0.07224,&
          0.07234, 0.07242, 0.07249, 0.07254, 0.07261, 0.07270, 0.07275,&
          0.07279, 0.07285, 0.07293, 0.07298, 0.07302, 0.07308, 0.07314,&
          0.07318, 0.07322, 0.07327, 0.07332, 0.07331, 0.07331, 0.07333,&
          0.07336, 0.07337, 0.07337, 0.07338, 0.07340, 0.07342, 0.07345,&
          0.07345, 0.07338, 0.07339, 0.07340, 0.07340, 0.07342, 0.07344,&
          0.07345, 0.07346, 0.07349, 0.07351, 0.07354, 0.07357, 0.07363,&
          0.07366, 0.07368, 0.07368, 0.07370, 0.07375, 0.07378, 0.07378,&
          0.07384, 0.07389, 0.07394, 0.07397, 0.07404, 0.07409, 0.07411,&
          0.07417, 0.07425, 0.07431, 0.07434, 0.07440, 0.07449, 0.07457,&
          0.07466, 0.07475, 0.07486, 0.07497, 0.07508, 0.07522, 0.07536,&
          0.07553, 0.07571, 0.07585, 0.07599, 0.07619, 0.07640, 0.07662,&
          0.07686, 0.07711, 0.07737, 0.07762, 0.07791, 0.07822, 0.07854,&
          0.07889, 0.07924, 0.07959, 0.07996, 0.08036, 0.08076, 0.08123,&
          0.08170, 0.08219, 0.08267, 0.08319, 0.08375, 0.08432, 0.08490,&
          0.08548, 0.08613, 0.08680, 0.08747, 0.08814, 0.08883, 0.08952,&
          0.09020, 0.09085, 0.09147, 0.09209, 0.09270, 0.09325, 0.09379,&
          0.09427, 0.09472, 0.09508, 0.09538, 0.09562, 0.09583, 0.09598,&
          0.09598, 0.09597, 0.09585, 0.09570, 0.09547, 0.09522, 0.09489,&
          0.09450, 0.09411, 0.09370, 0.09326, 0.09282, 0.09238, 0.09198,&
          0.09160, 0.09125, 0.09091, 0.09064, 0.09040, 0.09018, 0.09001,&
          0.08986, 0.08980, 0.08974, 0.08973, 0.08973, 0.08976, 0.08981,&
          0.08989, 0.08997, 0.09006, 0.09018, 0.09031, 0.09045, 0.09059,&
          0.09072, 0.09087, 0.09102, 0.09119, 0.09133, 0.09145, 0.09160,&
          0.09178, 0.09196, 0.09209, 0.09222, 0.09238, 0.09253, 0.09269,&
          0.09284, 0.09300, 0.09316, 0.09331, 0.09344, 0.09358, 0.09374,&
          0.09390, 0.09403, 0.09416, 0.09432, 0.09448, 0.09462, 0.09476,&
          0.09490, 0.09505, 0.09520, 0.09532, 0.09543, 0.09559, 0.09575,&
          0.09586, 0.09598, 0.09610, 0.09621, 0.09635, 0.09647, 0.09656,&
          0.09666, 0.09676, 0.09689, 0.09701, 0.09709, 0.09717, 0.09727,&
          0.09737, 0.09747, 0.09757, 0.09767, 0.09777, 0.09787, 0.09793,&
          0.09801, 0.09809, 0.09818, 0.09829, 0.09839, 0.09846, 0.09855,&
          0.09865, 0.09873, 0.09881, 0.09890, 0.09898, 0.09906, 0.09914,&
          0.09921, 0.09928, 0.09934, 0.09940, 0.09946, 0.09952, 0.09957,&
          0.09962, 0.09967, 0.09971, 0.09976, 0.09978, 0.09982, 0.09986,&
          0.09991, 0.09990, 0.09991, 0.09995, 0.10000, 0.09999, 0.09998,&
          0.09997, 0.09997, 0.09997, 0.09995, 0.09993, 0.09991, 0.09988,&
          0.09986, 0.09983, 0.09979, 0.09975, 0.09971, 0.09966, 0.09962,&
          0.09958, 0.09953, 0.09946, 0.09940, 0.09933, 0.09927, 0.09919,&
          0.09911, 0.09906, 0.09901, 0.09891, 0.09880, 0.09873, 0.09867,&
          0.09857, 0.09845, 0.09835, 0.09825, 0.09816, 0.09807, 0.09797,&
          0.09787, 0.09777, 0.09770, 0.09761, 0.09751, 0.09741, 0.09731,&
          0.09721, 0.09712, 0.09703, 0.09693, 0.09682, 0.09672, 0.09665,&
          0.09657, 0.09648, 0.09639, 0.09628, 0.09618, 0.09609, 0.09600,&
          0.09591, 0.09580, 0.09570, 0.09559, 0.09549, 0.09540, 0.09531,&
          0.09521, 0.09511, 0.09501, 0.09490, 0.09480, 0.09469, 0.09457,&
          0.09445, 0.09435, 0.09425, 0.09414, 0.09403, 0.09393, 0.09384,&
          0.09373, 0.09362, 0.09350, 0.09337, 0.09326, 0.09319, 0.09310,&
          0.09297, 0.09285, 0.09276, 0.09268, 0.09257, 0.09246, 0.09240,&
          0.09233, 0.09223, 0.09212, 0.09204, 0.09197, 0.09188, 0.09179,&
          0.09171, 0.09165, 0.09158, 0.09150, 0.09143, 0.09135, 0.09126,&
          0.09119, 0.09112, 0.09103, 0.09096, 0.09087, 0.09077, 0.09069,&
          0.09062, 0.09054, 0.09044, 0.09034, 0.09023, 0.09014, 0.09007,&
          0.08998, 0.08986, 0.08975, 0.08966, 0.08957, 0.08943, 0.08927,&
          0.08916, 0.08905, 0.08891, 0.08876, 0.08861, 0.08847, 0.08834,&
          0.08820, 0.08804, 0.08787, 0.08771, 0.08756, 0.08739, 0.08722,&
          0.08707, 0.08691, 0.08675, 0.08658, 0.08641, 0.08622, 0.08604,&
          0.08587, 0.08570, 0.08550, 0.08530, 0.08512, 0.08494, 0.08478,&
          0.08464, 0.08446, 0.08428, 0.08411, 0.08396, 0.08378, 0.08360,&
          0.08342, 0.08323, 0.08304, 0.08286, 0.08267, 0.08243, 0.08220,&
          0.08205, 0.08188, 0.08168, 0.08146, 0.08128, 0.08112, 0.08086,&
          0.08060, 0.08046, 0.08036, 0.08015, 0.07993, 0.07976, 0.07962,&
          0.07946, 0.07926, 0.07909, 0.07896, 0.07882, 0.07870, 0.07861,&
          0.07854, 0.07847, 0.07840, 0.07833, 0.07830, 0.07829, 0.07834,&
          0.07837, 0.07842, 0.07846, 0.07851, 0.07857, 0.07861, 0.07866,&
          0.07872, 0.07878, 0.07884, 0.07888, 0.07892, 0.07895, 0.07898,&
          0.07900, 0.07903, 0.07906, 0.07908, 0.07910, 0.07912, 0.07913,&
          0.07914, 0.07914, 0.07914, 0.07912, 0.07912, 0.07912, 0.07911,&
          0.07909, 0.07906, 0.07908, 0.07910, 0.07908, 0.07908, 0.07912,&
          0.07914, 0.07912, 0.07910, 0.07916, 0.07922, 0.07927, 0.07931,&
          0.07935, 0.07940, 0.07947, 0.07955, 0.07962, 0.07969, 0.07977,&
          0.07986, 0.07993, 0.08000, 0.08009, 0.08021, 0.08029, 0.08034,&
          0.08040, 0.08045, 0.08051, 0.08058, 0.08066, 0.08076, 0.08083,&
          0.08089, 0.08097, 0.08106, 0.08113, 0.08112, 0.08112, 0.08117,&
          0.08122, 0.08123, 0.08124, 0.08129, 0.08134, 0.08131, 0.08128,&
          0.08131, 0.08137, 0.08139, 0.08140, 0.08143, 0.08148, 0.08148,&
          0.08147, 0.08154, 0.08165, 0.08165, 0.08164, 0.08170, 0.08176,&
          0.08177, 0.08178, 0.08183, 0.08190, 0.08190, 0.08190, 0.08194,&
          0.08200, 0.08205, 0.08207, 0.08211, 0.08216, 0.08220, 0.08223,&
          0.08228, 0.08235, 0.08239, 0.08243, 0.08249, 0.08254, 0.08257,&
          0.08259, 0.08260, 0.08260, 0.08264, 0.08271, 0.08274, 0.08271,&
          0.08276, 0.08289, 0.08292, 0.08287, 0.08286, 0.08293, 0.08297,&
          0.08300, 0.08301, 0.08301, 0.08306, 0.08319, 0.08323, 0.08315,&
          0.08316, 0.08333, 0.08343, 0.08335, 0.08333, 0.08349, 0.08362,&
          0.08362, 0.08365, 0.08378, 0.08389, 0.08397, 0.08405, 0.08415,&
          0.08426, 0.08429, 0.08432, 0.08442, 0.08452, 0.08455, 0.08457,&
          0.08460, 0.08466, 0.08478, 0.08486, 0.08485, 0.08486, 0.08492,&
          0.08497, 0.08501, 0.08505, 0.08511, 0.08516, 0.08516, 0.08512,&
          0.08508, 0.08510, 0.08522, 0.08529, 0.08523, 0.08522, 0.08534,&
          0.08543, 0.08541, 0.08542, 0.08547, 0.08552, 0.08558, 0.08562,&
          0.08563, 0.08563, 0.08571, 0.08577, 0.08569, 0.08563, 0.08567,&
          0.08568, 0.08569, 0.08572, 0.08574, 0.08574, 0.08570, 0.08566,&
          0.08556, 0.08550, 0.08556, 0.08555, 0.08544, 0.08535, 0.08534,&
          0.08532, 0.08522, 0.08510, 0.08505, 0.08499, 0.08491, 0.08475,&
          0.08455, 0.08450, 0.08462, 0.08458, 0.08438, 0.08427, 0.08423,&
          0.08414, 0.08402, 0.08392, 0.08385, 0.08375, 0.08364, 0.08351,&
          0.08339, 0.08334, 0.08332, 0.08336, 0.08343, 0.08328, 0.08303,&
          0.08297, 0.08295, 0.08287, 0.08278, 0.08271, 0.08265, 0.08262,&
          0.08259, 0.08245, 0.08229, 0.08222, 0.08218, 0.08220, 0.08220,&
          0.08204, 0.08188, 0.08192, 0.08195, 0.08174, 0.08157, 0.08160,&
          0.08158, 0.08151, 0.08145, 0.08131, 0.08119, 0.08134, 0.08140,&
          0.08099, 0.08074, 0.08097, 0.08107, 0.08087, 0.08083, 0.08099,&
          0.08093, 0.08056, 0.08052, 0.08088, 0.08085, 0.08042, 0.08031,&
          0.08043, 0.08053, 0.08062, 0.08043, 0.08011, 0.08006, 0.08010,&
          0.08008, 0.08006, 0.08000, 0.07995, 0.08018, 0.08043, 0.08014,&
          0.07977/
              data (phis3full(itmp),itmp=1,2101)/&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000/
              data (phis4full(itmp),itmp=1,2101)/&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000, 0.00000,&
          0.00000/

contains
subroutine subsetspectra(nbands_to_use,bands_to_use)

	integer nbands_to_use
	integer bands_to_use(nbands_to_use)
        integer i

        nl = nbands_to_use
	call allocatespectra()
	do i=1,nl
		lambda(i) = lambdafull(bands_to_use(i))
                nrefrac(i) = nrefracfull(bands_to_use(i))
                acab(i) = acabfull(bands_to_use(i))
                acar(i) = acarfull(bands_to_use(i))
                acw(i) = acwfull(bands_to_use(i))
                acm(i) = acmfull(bands_to_use(i))
                phis1(i) = phis1full(bands_to_use(i))
                phis2(i) = phis2full(bands_to_use(i))
                phis3(i) = phis3full(bands_to_use(i))
                phis4(i) = phis4full(bands_to_use(i))
	enddo
end subroutine subsetspectra
subroutine allocatespectra
call deallocatespectra()
allocate(lambda(nl))
allocate(nrefrac(nl))
allocate(acab(nl))
allocate(acar(nl))
allocate(acw(nl))
allocate(acm(nl))
allocate(phis1(nl))
allocate(phis2(nl))
allocate(phis3(nl))
allocate(phis4(nl))
end subroutine allocatespectra
subroutine deallocatespectra
if(allocated(lambda))deallocate(lambda)
if(allocated(nrefrac))deallocate(nrefrac)
if(allocated(acab))deallocate(acab)
if(allocated(acar))deallocate(acar)
if(allocated(acw))deallocate(acw)
if(allocated(acm))deallocate(acm)
if(allocated(phis1))deallocate(phis1)
if(allocated(phis2))deallocate(phis2)
if(allocated(phis3))deallocate(phis3)
if(allocated(phis4))deallocate(phis4)
end subroutine deallocatespectra

end module


      END
