app=window.app={config:{},templates:{},utils:{}};(function(app,Backbone){"use strict";app.models={};app.models.Group=Backbone.Model.extend({defaults:{count:0,version:0,tags:[],versions:[],isBookmarked:false,historicalData:[]},updateFrom:function(member){for(var key in member.attributes){if(key=="isResolved"&&this.get("version")>member.get("version")){continue}if(this.get(key)!=member.get(key)){this.set(key,member.get(key))}}}});app.models.User=Backbone.Model.extend({defaults:{}})})(app,Backbone);(function(app){"use strict";app.templates={group:""+'<div class="count" data-count="<%= app.utils.formatNumber(count) %>">'+'<span title="<%= count %>"><%= app.utils.formatNumber(count) %></span>'+"</div>"+'<div class="details">'+'<h3><a href="<%= permalink %>"><%= title %></a></h3>'+'<p class="message">'+"<%= message %>"+"</p>"+'<div class="meta">'+'<span class="last-seen pretty-date" title="<%= lastSeen %>"><%= app.utils.prettyDate(lastSeen) %></span>'+"<% if (timeSpent) { %>"+'<span class="time-spent"><%= Math.round(timeSpent) %>ms</span>'+"<% } %>"+'<span class="tag tag-project"><%= project.name %></span>'+'<span class="tag tag-logger">'+'<a href="<%= loggerUrl %>"><%= logger %></a>'+"</span>"+"<% _.each(versions, function(version){ %> "+'<span class="tag tag-version"><%= version %></span>'+"<% }) %>"+"<% _.each(tags, function(tag){ %> "+'<span class="tag"><%= tag %></span>'+"<% }) %>"+"</div>"+'<span class="sparkline"></span>'+'<ul class="actions">'+"<% if (canResolve) { %>"+"<li>"+'<a href="#" data-action="resolve">'+'<i aria-hidden="true" class="icon-checkmark"></i>'+"</a>"+"</li>"+"<li>"+'<a href="#" data-action="bookmark" class="bookmark<% if (isBookmarked) { %> checked<% } %>" title="Bookmark">'+'<i aria-hidden="true" class="icon-star"></i>'+"</a>"+"</li>"+"<% } %>"+"</ul>"+"</div>"+"</script>"}})(app);(function(app,jQuery,_){"use strict";var $=jQuery;var time_formats=[[60,"just now","just now"],[120,"1 minute ago","1 minute from now"],[3600,"minutes",60],[7200,"1 hour ago","1 hour from now"],[86400,"hours",3600],[172800,"yesterday","tomorrow"],[604800,"days",86400],[1209600,"last week","next week"],[2419200,"weeks",604800],[4838400,"last month","next month"],[29030400,"months",2419200],[58060800,"last year","next year"],[290304e4,"years",29030400],[580608e4,"last century","next century"],[580608e5,"centuries",290304e4]];var number_formats=[[1e9,"b"],[1e6,"m"],[1e3,"k"]];app.utils={getQueryParams:function(){var vars={},href=window.location.href,hashes,hash;if(href.indexOf("?")==-1)return vars;hashes=href.slice(href.indexOf("?")+1,href.indexOf("#")!=-1?href.indexOf("#"):href.length).split("&");$.each(hashes,function(_,chunk){hash=chunk.split("=");if(!hash[0]&&!hash[1])return;vars[hash[0]]=hash[1]?decodeURIComponent(hash[1]).replace(/\+/," "):""});return vars},floatFormat:function(number,places){var multi=Math.pow(10,places);return parseInt(number*multi,10)/multi},formatNumber:function(number){var b,x,y,o,p;number=parseInt(number,10);for(var i=0;b=number_formats[i];i++){x=b[0];y=b[1];o=Math.floor(number/x);p=number%x;if(o>0){if(o/10>1||!p)return""+o+y;return""+this.floatFormat(number/x,1)+y}}return""+number},prettyDate:function(date_str){var time=Date.parse(date_str);var now=new Date;var now_utc=Date.UTC(now.getUTCFullYear(),now.getUTCMonth(),now.getUTCDate(),now.getUTCHours(),now.getUTCMinutes(),now.getUTCSeconds());var token="ago";var seconds=(now_utc-time)/1e3;var list_choice=1;if(seconds<0){seconds=Math.abs(seconds);token="from now";list_choice=2}for(var i=0,format;format=time_formats[i];i++){if(seconds<format[0]){if(typeof format[2]=="string")return format[list_choice];else return Math.floor(seconds/format[2])+" "+format[1]+" "+token}}return time},slugify:function(str){str=str.replace(/^\s+|\s+$/g,"");str=str.toLowerCase();var from="àáäâèéëêìíïîòóöôùúüûñç·/_,:;";var to="aaaaeeeeiiiioooouuuunc------";for(var i=0,l=from.length;i<l;i++){str=str.replace(new RegExp(from.charAt(i),"g"),to.charAt(i))}str=str.replace(/[^a-z0-9\s\-]/g,"").replace(/\s+/g,"-").replace(/-+/g,"-");return str},varToggle:function(link,$elm){var $link=$(link);if(!$link.attr("data-expand-label"))$link.attr("data-expand-label",$link.html());$elm.toggle();if($elm.is(":visible"))$link.html($link.attr("data-collapse-label"));else $link.html($link.attr("data-expand-label"))},getSearchUsersUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/users/search/"},getSearchProjectsUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/projects/search/"},getSearchTagsUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/"+app.config.projectId+"/tags/search/"},makeSearchableInput:function(el,url,callback){$(el).select2({allowClear:true,width:"element",initSelection:function(el,callback){var $el=$(el);callback({id:$el.val(),text:$el.val()})},ajax:{url:url,dataType:"json",data:function(term,page){return{query:term,limit:10}},results:function(data,page){var results=callback(data);return{results:callback(data)}}}})},escape:function(str){return str.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;")},makeSearchableUsersInput:function(el){this.makeSearchableInput(el,this.getSearchUsersUrl(),_.bind(function(data){var results=[];$(data.results).each(_.bind(function(_,val){var label;if(val.first_name){label=this.escape(val.first_name)+" &mdash; "+this.escape(val.username)}else{label=this.escape(val.username)}label+="<br>"+this.escape(val.email);results.push({id:val.username,text:label})},this));if($(results).filter(function(){return this.id.localeCompare(data.query)===0}).length===0){results.push({id:this.escape(data.query),text:this.escape(data.query)})}return results},this))},makeSearchableProjectsInput:function(el){this.makeSearchableInput(el,this.getSearchProjectsUrl(),function(data){var results=[];$(data.results).each(function(_,val){results.push({id:val.slug,text:val.name+"<br>"+val.slug})});return results})},makeSearchableTagsInput:function(el,options){var $el=$(el);$el.select2({multiple:true,tokenSeperators:[","],minimumInputLength:3,allowClear:true,width:"element",initSelection:function(el,callback){var $el=$(el);var values=$el.val().split(",");var results=[];$.each(values,function(_,val){results.push({id:val,text:val})});callback(results)},ajax:{url:this.getSearchTagsUrl(),dataType:"json",data:function(term,page){return{query:term,quietMillis:300,name:$el.data("tag"),limit:10}},results:function(data,page){var results=[];$(data.results).each(function(_,val){results.push({id:val,text:val})});if($(results).filter(function(){return this.id.localeCompare(data.query)===0}).length===0){results.push({id:data.query,text:data.query})}return{results:results}}}})}};$(function(){$(".body select").each(function(){var $this=$(this),options={width:"element",allowClear:false};if($this.attr("data-allowClear")){options.allowClear=$this.attr("data-allowClear")}$this.select2(options)});setInterval(function(){$(".pretty-date").each(function(_,el){var $el=$(el);var title=$el.attr("title");if(title){var date=app.utils.prettyDate(title);if(date){$el.text(date)}}})},5e3)});$.fn.select2.defaults.escapeMarkup=function(s){return s}})(app,jQuery,_);(function(Date,undefined){"use strict";var origParse=Date.parse,numericKeys=[1,4,5,6,7,10,11];Date.parse=function(date){var timestamp,struct,minutesOffset=0;if(struct=/^(\d{4}|[+\-]\d{6})(?:-(\d{2})(?:-(\d{2}))?)?(?:T(\d{2}):(\d{2})(?::(\d{2})(?:\.(\d{3}))?)?(?:(Z)|([+\-])(\d{2})(?::(\d{2}))?)?)?$/.exec(date)){for(var i=0,k;k=numericKeys[i];++i){struct[k]=+struct[k]||0}struct[2]=(+struct[2]||1)-1;struct[3]=+struct[3]||1;if(struct[8]!=="Z"&&struct[9]!==undefined){minutesOffset=struct[10]*60+struct[11];if(struct[9]==="+"){minutesOffset=0-minutesOffset}}timestamp=Date.UTC(struct[1],struct[2],struct[3],struct[4],struct[5]+minutesOffset,struct[6],struct[7])}else{timestamp=origParse?origParse(date):NaN}return timestamp}})(Date);(function(app,Backbone){"use strict";app.ScoredList=Backbone.Collection.extend({comparator:function(member){return-member.get("score")}})})(app,Backbone);(function(app,Backbone,jQuery,_){"use strict";var $=jQuery;app.charts={render:function(el,options){var $el=$("#chart");var url=$el.attr("data-api-url");var title=$(el).attr("data-title");var $spark=$el.find(".sparkline");$spark.height($el.height());$.ajax({url:$el.attr("data-api-url"),type:"get",dataType:"json",data:{days:$el.attr("data-days")||7,gid:$el.attr("data-group")||undefined},success:function(resp){var data=[],maxval=10;$spark.empty();$.each(resp,function(_,val){var date=new Date(val[0]);data.push({y:val[1],label:app.utils.prettyDate(date)});if(val[1]>maxval){maxval=val[1]}});app.charts.createSparkline($spark,data,options)}})},createSparkline:function(el,points,options){var $el=$(el),existing=$el.children(),maxval=10,title,point,pct,child,point_width;if(options===undefined){options={}}for(var i=0;i<points.length;i++){point=points[i];if(typeof point==="number"){point=points[i]={y:point}}if(point.y>maxval){maxval=point.y}}point_width=app.utils.floatFormat(100/points.length,2)+"%";for(i=0;i<points.length;i++){point=points[i];pct=app.utils.floatFormat(point.y/maxval*99,2)+"%";title=point.y+" events";if(point.label){title=title+"<br>("+point.label+")"}if(existing.get(i)===undefined){$('<a style="width:'+point_width+';" rel="tooltip" title="'+title+'"><span style="height:'+pct+'">'+point.y+"</span></a>").tooltip({placement:options.placement||"bottom",html:true,container:"body"}).appendTo($el)}else{$(existing[i]).find("span").css("height",pct).text(point.y).attr("title",point.label||point.y)}}}}})(app,Backbone,jQuery);(function(app,Backbone,jQuery,_){"use strict";var $=jQuery;app.GroupView=Backbone.View.extend({tagName:"li",className:"group",template:_.template(app.templates.group),initialize:function(){_.bindAll(this);this.model.on("change:count",this.updateCount);this.model.on("change:lastSeen",this.updateLastSeen);this.model.on("change:isBookmarked",this.render);this.model.on("change:isResolved",this.updateResolved);this.model.on("change:historicalData",this.renderSparkline)},render:function(){var data=this.model.toJSON();data.loggerUrl=app.config.urlPrefix+"/"+app.config.teamId+"/"+app.config.projectId+"/?logger="+data.logger;this.$el.html(this.template(data));this.$el.attr("data-id",this.model.id);this.$el.addClass(this.getLevelClassName());this.$el.find("a[data-action=resolve]").click(_.bind(function(e){e.preventDefault();if(this.model.get("isResolved")){this.unresolve()}else{this.resolve()}},this));this.$el.find("a[data-action=bookmark]").click(_.bind(function(e){e.preventDefault();this.bookmark()},this));this.renderSparkline();this.updateResolved()},updateResolved:function(){if(this.model.get("isResolved")){this.$el.addClass("resolved")}else{this.$el.removeClass("resolved")}},renderSparkline:function(obj){var data=this.model.get("historicalData");if(!data||!data.length)return;this.$el.addClass("with-sparkline");app.charts.createSparkline(this.$el.find(".sparkline"),data)},resolve:function(){$.ajax({url:this.getResolveUrl(),type:"post",dataType:"json",success:_.bind(function(response){this.model.set("version",response.version);this.model.set("isResolved",true)},this)})},unresolve:function(){$.ajax({url:this.getUnresolveUrl(),type:"post",dataType:"json",success:_.bind(function(response){this.model.set("version",response.version);this.model.set("isResolved",false)},this)})},getResolveUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/"+app.config.projectId+"/group/"+this.model.get("id")+"/set/resolved/"},getUnresolveUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/"+app.config.projectId+"/group/"+this.model.get("id")+"/set/unresolved/"},getBookmarkUrl:function(){return app.config.urlPrefix+"/api/"+app.config.teamId+"/"+app.config.projectId+"/bookmark/"},bookmark:function(){$.ajax({url:this.getBookmarkUrl(),type:"post",dataType:"json",data:{gid:this.model.get("id")},success:_.bind(function(response){this.model.set("version",response.version);this.model.set("isBookmarked",response.isBookmarked)},this)})},getLevelClassName:function(){return"level-"+this.model.get("levelName")},updateLastSeen:function(){this.$el.find(".last-seen").text(app.utils.prettyDate(this.model.get("lastSeen"))).attr("title",this.model.get("lastSeen"))},updateCount:function(){var new_count=app.utils.formatNumber(this.model.get("count"));var counter=this.$el.find(".count");var digit=counter.find("span");if(digit.is(":animated"))return false;if(counter.data("count")==new_count){return false}counter.data("count",new_count);var replacement=$("<span></span>",{css:{top:"-2.1em",opacity:0},text:new_count});digit.before(replacement).animate({top:"2.5em",opacity:0},"fast",function(){digit.remove()});replacement.delay(100).animate({top:0,opacity:1},"fast")}});app.OrderedElementsView=Backbone.View.extend({emptyMessage:'<div class="empty-message"><h2>No events to show.</h2><p>We\'ll notify you if that changes. In the meantime why not take a moment to become more familiar with Sentry.</p><p class="links"><a href="docs/">Installation instructions</a> <a href="settings/">Project settings</a></p></div>',loadingMessage:"<p>Loading...</p>",model:app.models.Group,defaults:{maxItems:50},initialize:function(data){var members=data.members;_.bindAll(this);this.options=$.extend({},this.defaults,this.options,data);this.$wrapper=$("#"+this.id);this.$parent=$("<ul></ul>");this.$empty=$('<li class="empty"></li>');this.$wrapper.html(this.$parent);if(this.options.className)this.$parent.addClass(this.options.className);this.collection=new app.ScoredList;this.collection.on("add",this.renderMemberInContainer);this.collection.on("remove",this.unrenderMember);this.collection.on("reset",this.reSortMembers);delete data.members;this.reset(members)},reset:function(members){this.$parent.empty();this.setEmpty();if(members===undefined){this.$empty.html(this.loadingMessage);this.collection.reset();this.setEmpty();this.loaded=false}else{var _members=[];_.each(members,_.bind(function(m){_members.push(new this.model(m))},this));members=_members;this.$empty.html(this.emptyMessage);this.collection.reset(members);this.loaded=true}},setEmpty:function(){this.$parent.html(this.$empty)},extend:function(data){for(var i=0;i<data.length;i++){this.addMember(data[i])}},addMember:function(member){if(member.get===undefined){member=new this.model(member)}if(!this.hasMember(member)){if(this.collection.models.length>=this.options.maxItems-1)if(member.get("score")<this.collection.last().get("score"))return;while(this.collection.models.length>=this.options.maxItems)this.collection.pop();this.collection.add(member)}else{this.updateMember(member)}},reSortMembers:function(){this.collection.each(_.bind(function(member){this.renderMemberInContainer(member)},this))},updateMember:function(member,options){if(_.isUndefined(options))options={};var existing=this.collection.get(member.id);existing.updateFrom(member);if(options.sort!==false){this.collection.sort()}},hasMember:function(member){return this.collection.get(member.id)?true:false},removeMember:function(member){this.collection.remove(member)},renderMemberInContainer:function(member){var new_pos=this.collection.indexOf(member),$el,$rel;this.$parent.find("li.empty").remove();$el=$("#"+this.id+member.id);if(!$el.length){$el=this.renderMember(member)}else if($el.index()===new_pos){return}if(new_pos===0){this.$parent.prepend($el)}else{$rel=$("#"+this.id+this.collection.at(new_pos).id);if(!$rel.length){this.$parent.append($el)}else if($el.id!==$rel.id){$el.insertBefore($rel)}else{return}}if(this.loaded)$el.css("background-color","#eee").animate({backgroundColor:"#fff"},300)},renderMember:function(member){var view=new app.GroupView({model:member,id:this.id+member.id});view.render();return view.$el},unrenderMember:function(member){$("#"+this.id+member.id).remove();if(!this.$parent.find("li").length)this.setEmpty()}});app.GroupListView=app.OrderedElementsView.extend({defaults:{realtime:false,stream:false,pollUrl:null,pollTime:1e3,tickTime:100},initialize:function(data){if(_.isUndefined(data))data={};data.model=app.models.Group;app.OrderedElementsView.prototype.initialize.call(this,data);this.options=$.extend({},this.defaults,this.options,data);this.queue=new app.ScoredList;this.cursor=null;this.poll();window.setInterval(this.tick,this.options.tickTime)},tick:function(){if(!this.queue.length)return;var item=this.queue.pop();if(this.options.canStream){this.addMember(item)}else if(this.hasMember(item)){this.updateMember(item,{sort:false})}},poll:function(){var data;if(!this.options.realtime||!this.options.pollUrl)return window.setTimeout(this.poll,this.options.pollTime);data=app.utils.getQueryParams();data.cursor=this.cursor||undefined;$.ajax({url:this.options.pollUrl,type:"get",dataType:"json",data:data,success:_.bind(function(groups){var i,data,obj;if(!groups.length)return setTimeout(this.poll,this.options.pollTime*5);this.cursor=groups[groups.length-1].score||undefined;for(i=0;data=groups[i];i+=1){obj=this.queue.get(data.id);if(!_.isUndefined(obj)){obj.set("count",data.count);obj.set("score",data.score);this.queue.sort()}else{this.queue.add(data)}}window.setTimeout(this.poll,this.options.pollTime)},this),error:_.bind(function(){window.setTimeout(this.poll,this.options.pollTime*10)},this)})}});app.UserListView=app.OrderedElementsView.extend({defaults:{},initialize:function(data){if(_.isUndefined(data))data={};data.model=app.User;app.OrderedElementsView.prototype.initialize.call(this,data);this.options=$.extend({},this.defaults,this.options,data)}})})(app,Backbone,jQuery,_);(function(window,app,Backbone,jQuery,_){"use strict";var $=jQuery;var BasePage=Backbone.View.extend({defaults:{canStream:false,realtime:false},initialize:function(data){_.bindAll(this);if(_.isUndefined(data))data={};this.options=$.extend({},this.defaults,this.options,data);this.views={};this.initializeAjaxTabs()},initializeAjaxTabs:function(){$("a[data-toggle=ajtab]").click(_.bind(function(e){var $tab=$(e.target),uri=$tab.attr("data-uri"),view_id=$tab.attr("href").substr(1),view=this.getView(view_id,uri),$cont,$parent;e.preventDefault();if(!uri)return view.reset();$cont=$("#"+view_id);$parent=$cont.parent();$parent.css("opacity",.6);$.ajax({url:uri,dataType:"json",success:function(data){view.reset(data);$parent.css("opacity",1);$tab.tab("show")},error:function(){$cont.html("<p>There was an error fetching data from the server.</p>")}})},this));$("li.active a[data-toggle=ajtab]").click()},makeDefaultView:function(id){return new app.GroupListView({className:"group-list small",id:id,maxItems:5,stream:this.options.stream,realtime:this.options.realtime,model:app.models.Group})},getView:function(id,uri){if(!this.views[id])this.views[id]=this.makeDefaultView(id);var view=this.views[id];view.options.pollUrl=uri;return view}});app.StreamPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);this.group_list=new app.GroupListView({className:"group-list",id:"event_list",members:data.groups,maxItems:50,realtime:$.cookie("pausestream")?false:true,canStream:this.options.canStream,pollUrl:app.config.urlPrefix+"/api/"+app.config.teamId+"/"+app.config.projectId+"/poll/",model:app.models.Group});this.control=$("a[data-action=pause]");this.updateStreamOptions();this.initFilters();this.control.click(_.bind(function(e){e.preventDefault();this.options.realtime=this.group_list.options.realtime=this.control.hasClass("realtime-pause");this.updateStreamOptions()},this));$("#chart").height("50px");app.charts.render("#chart",{placement:"left"})},initFilters:function(){$(".filter").each(_.bind(function(_,el){var $filter=$(el);var $input=$filter.find("input[type=text]");if($input.length>0){$input.select2({initSelection:function(el,callback){var $el=$(el);callback({id:$el.val(),text:$el.val()})},allowClear:true,minimumInputLength:3,ajax:{url:app.utils.getSearchTagsUrl(),dataType:"json",data:function(term,page){return{query:term,quietMillis:300,name:$input.attr("name"),limit:10}},results:function(data,page){var results=[];$(data.results).each(function(_,val){results.push({id:app.utils.escape(val),text:app.utils.escape(val)})});return{results:results}}}})}else{$input=$filter.find("select").select2({allowClear:true})}if($input.length>0){$input.on("change",function(e){var query=app.utils.getQueryParams();query[e.target.name]=e.val;window.location.href="?"+$.param(query)})}},this))},updateStreamOptions:function(){if(this.options.realtime){$.removeCookie("pausestream");this.control.removeClass("realtime-pause");this.control.addClass("realtime-play");this.control.html(this.control.attr("data-pause-label"))}else{$.cookie("pausestream","1",{expires:7});this.control.addClass("realtime-pause");this.control.removeClass("realtime-play");this.control.html(this.control.attr("data-play-label"))}}});app.DashboardPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);$("#chart").height("150px");Sentry.charts.render("#chart")}});app.SelectTeamPage=BasePage.extend({initialize:function(){BasePage.prototype.initialize.call(this);this.refreshSparklines();$(window).on("resize",this.refreshSparklines)},refreshSparklines:function(){$(".chart").each(function(n,el){var $el=$(el);$.ajax({url:$el.attr("data-api-url"),type:"get",dataType:"json",data:{days:1},success:_.bind(function(data){$.plot($el,[{data:data,color:"#ebeff3",shadowSize:0,lines:{lineWidth:2,show:true,fill:true,color:"#f6f8fa"}}],{yaxis:{min:0},grid:{show:false},hoverable:false,legend:{noColumns:5},lines:{show:false}})},this)})})}});app.GroupDetailsPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);this.group_list=new app.GroupListView({className:"group-list",id:"event_list",members:[data.group],model:app.models.Group});$("#chart").height("150px");Sentry.charts.render("#chart");$("#public-status .action").click(function(){var $this=$(this);$.ajax({url:$this.attr("data-api-url"),type:"post",success:function(group){var selector=group.isPublic?"true":"false";var nselector=group.isPublic?"false":"true";$('#public-status span[data-public="'+selector+'"]').show();$('#public-status span[data-public="'+nselector+'"]').hide()},error:function(){window.alert("There was an error changing the public status")}})});var $event_nav=$("#event_nav");if($event_nav.length>0){var $window=$(window);var $nav_links=$event_nav.find("a[href*=#]");var $nav_targets=[];var scroll_offset=$event_nav.offset().top;var event_nav_height;var last_target;$window.resize(function(){event_nav_height=$event_nav.find(".nav").outerHeight();$event_nav.height(event_nav_height+"px")}).resize();$nav_links.click(function(e){var $el=$(this);var target=$(this.hash);$el.parent().addClass("active").siblings().removeClass("active");$("html,body").animate({scrollTop:target.position().top+event_nav_height},"fast");if(history.pushState){history.pushState({},"",this.hash)}e.preventDefault()}).each(function(){if(this.hash.length>1&&$(this.hash).length){$nav_targets.push(this.hash)}});var resizeTimer;$window.scroll(function(){clearTimeout(resizeTimer);resizeTimer=setTimeout(function(){if($window.scrollTop()>scroll_offset){if(!$event_nav.hasClass("fixed")){$event_nav.addClass("fixed")}}else if($event_nav.hasClass("fixed")){$event_nav.removeClass("fixed")}if($nav_targets.length){var from_top=$window.scrollTop()+event_nav_height+20;var cur=$.map($nav_targets,function(hash){if($(hash).offset().top<from_top){return hash}});var target=cur?cur[cur.length-1]:null;if(!target){target=$nav_targets[0]}if(last_target!==target){last_target=target;$nav_links.parent().removeClass("active").end().filter("[href="+target+"]").parent().addClass("active")}}},1)}).scroll()}}});app.WallPage=BasePage.extend({initialize:function(){BasePage.prototype.initialize.call(this,{realtime:true,pollTime:3e3});this.sparkline=$(".chart");this.sparkline.height(this.sparkline.parent().height());this.stats=$("#stats");this.refreshSparkline();this.refreshStats()},makeDefaultView:function(id){return new app.GroupListView({className:"group-list",id:id,maxItems:5,stream:this.options.stream,realtime:this.options.realtime,model:app.models.Group})},refreshSparkline:function(){$.ajax({url:this.sparkline.attr("data-api-url"),type:"get",dataType:"json",data:{days:1,gid:this.sparkline.attr("data-group")||undefined},success:_.bind(function(data){$.plot(this.sparkline,[{data:data,color:"#52566c",shadowSize:0,lines:{lineWidth:2,show:true,fill:true,fillColor:"#232428"}}],{yaxis:{min:0},grid:{show:false},hoverable:false,legend:{noColumns:5},lines:{show:false}})},this)})},refreshStats:function(){$.ajax({url:this.stats.attr("data-uri"),dataType:"json",success:_.bind(function(data){this.stats.find("[data-stat]").each(function(){var $this=$(this);var new_count=data[$this.attr("data-stat")];var counter=$this.find("big");var digit=counter.find("span");if(digit.is(":animated"))return false;if(counter.data("count")==new_count){return false}counter.data("count",new_count);var replacement=$("<span></span>",{css:{top:"-2.1em",opacity:0},text:new_count});digit.before(replacement).animate({top:"2.5em",opacity:0},"fast",function(){digit.remove()});replacement.delay(100).animate({top:0,opacity:1},"fast")});window.setTimeout(this.refreshStats,1e3)},this)})}});app.UserListPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);this.list=new app.UserListView({className:"user-list",id:"user_list",members:data.users})}});app.AddTeamMemberPage=BasePage.extend({});app.AccessGroupMembersPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);app.utils.makeSearchableUsersInput("form input[name=user]")}});app.AccessGroupProjectsPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);app.utils.makeSearchableProjectsInput("form input[name=project]")}});app.TeamDetailsPage=BasePage.extend({initialize:function(data){BasePage.prototype.initialize.call(this,data);app.utils.makeSearchableUsersInput("form input[name=owner]")}});app.ProjectDetailsPage=BasePage.extend({initialize:function initialize(data){BasePage.prototype.initialize.call(this,data);app.utils.makeSearchableUsersInput("form input[name=owner]");$("input[type=range]").each(_.bind(function loop(n,el){var $el=$(el),min=parseInt($el.attr("min"),10),max=parseInt($el.attr("max"),10),step=parseInt($el.attr("step"),10),values=[],$value=$('<span class="value"></span>');var i=min;while(i<=max){values.push(i);if(i<12){i+=1}else if(i<24){i+=3}else if(i<36){i+=6}else if(i<48){i+=12}else{i+=24}}$el.on("slider:ready",_.bind(function sliderready(event,data){$value.appendTo(data.el);$value.html(this.formatHours(data.value))},this)).on("slider:changed",_.bind(function sliderchanged(event,data){$value.html(this.formatHours(data.value))},this)).simpleSlider({range:[min,max],step:step,allowedValues:values,snap:true})},this))},formatHours:function formatHours(val){val=parseInt(val,10);if(val===0){return"Disabled"}else if(val>23&&val%24===0){val=val/24;return val+" day"+(val!=1?"s":"")}return val+" hour"+(val!=1?"s":"")}});app.ProjectNotificationsPage=BasePage.extend({initialize:function initialize(data){BasePage.prototype.initialize.call(this,data);$("input[type=range]").each(_.bind(function loop(n,el){var $el=$(el),min=parseInt($el.attr("min"),10),max=parseInt($el.attr("max"),10),step=parseInt($el.attr("step"),10),$value=$('<span class="value"></span>');$el.on("slider:ready",_.bind(function sliderready(event,data){$value.appendTo(data.el);$value.html(this.formatThreshold(data.value))},this)).on("slider:changed",_.bind(function sliderchanged(event,data){$value.html(this.formatThreshold(data.value))},this)).simpleSlider({range:[min,max],step:step,snap:true})},this));$("#tag_list input").each(function(_,el){$(el).addClass("span6");app.utils.makeSearchableTagsInput(el)})},formatThreshold:function formatThreshold(value){if(!value){return"Disabled"}return value+"%"}});app.NewProjectPage=BasePage.extend({initialize:function(data){this.el=$(data.el);BasePage.prototype.initialize.call(this,data);if(this.options.canSelectTeam&&this.options.canCreateTeam){$("#new_team").hide();$('a[rel="create-new-team"]').click(function(){$("#new_team").show();$("#select_team").hide()});$('a[rel="select-team"]').click(function(){$("#new_team").hide();$("#select_team").show()})}}});Backbone.sync=function(method,model,success,error){success()}})(window,app,Backbone,jQuery,_);
//@ sourceMappingURL=global.min.map.js