''' 
Misc function to help opening files, check directories path
and group the files
'''

import os, sys, gzip
from itertools import izip_longest



def check_dir(directory):
   '''
   Check the given directory and return the whole path
   or set the default to working directory.
   '''
   import os, sys
   if directory == '':
      directory = None
   if directory == None:
      directory = os.getcwd()
   if os.path.isdir(directory):
      directory = os.path.abspath(directory)
   else:
      sys.exit("Not existing directory, please create the directory first")
   return directory

def walklevel(directory, level=1):
   '''

   '''
   import os
   directory = directory.rstrip(os.path.sep)
   assert os.path.isdir(directory)
   num_sep = directory.count(os.path.sep)
   for root, dirs, files in os.walk(directory):
      yield root, dirs, files
      num_sep_this = root.count(os.path.sep)
      if num_sep + level <= num_sep_this:
         del dirs[:]

def xopen(filename, mode='r'):
   '''
   A simple wrapper around the  "open" function, allowing to open
   files that have been compressed with gzip ( recognized by the .gz
   extension), and reads stram from standard output if the file name
   is '-'
   '''
   import sys, gzip
   assert isinstance(filename, basestring)
   if filename == '-':
      return sys.stdin if 'rb' in mode else sys.stdout
   if filename.endswith('.gz'):
      return gzip.open(filename, mode)
   else:
      return open(filename, mode)

def grouper(n, iterable, padvalue=None):
#   '''
#   to be removed and propery implemented in the code
#   grouper(3, 'abcdefg', 'x') -->
#   ('a','b','c'), ('d','e','f'), ('g','x','x')
#   '''
   from itertools import izip_longest
   return izip_longest(*[iter(iterable)]*n, fillvalue=padvalue)


