'''
Created on Dec 9, 2013

@author: scrosby
'''
from sf.RestClient import RestClient
from sf.Session import SoapSession
from userdata.Store import Store
from ui.Login import Factory
import sys

class BaseClient:
    def __init__(self, instance='login.salesforce.com', session_id=None):
        self.store = Store(filename='.chatter_data')
        
        if session_id is None:
            session_id = self.store.__get_local__('session')
        
        counter = 0
        
        while counter < 3:
            if session_id is None:
                if sys.stdin.isatty() and sys.stdout.isatty():
                    login = Factory().get_login('CLI', 'Looks like we need to login...')
                else:
                    login = Factory().get_login('GUI', 'Looks like we need to login...')
                    
                login.add_prompt('user', 'UserName', 'TEXT', self.store.__get_local__('user'))
                login.add_prompt('password', 'Password', 'PASSWORD')
        
                login.display()
                user = login.get_value('user')
                passwd = login.get_value('password')
                
                session = SoapSession(instance)
                try:
                    session.login(user, passwd)
                    session_id = session.get_session_id()
                    self.store.store(session=session_id, user=login.get_value('user'))
                    break
                except Exception as e:
                    print e
            else:
                session = SoapSession(session_id=session_id, instance=instance)
                if not session.is_valid():
                    session_id = None
                else:
                    break
                
            counter += 1
            
        
        self.client = RestClient(instance_url='https://{}'.format(instance), session_id=session_id)
        self.session_id = session_id
        
    def get_current_user(self):
        return self.store.__get_local__('user')