'''
Created on Dec 4, 2013

@author: scrosby
'''
import httplib, re

class SoapSession:
    def __init__(self, instance='login.salesforce.com', session_id=None):
        self.instance = instance
        self.sessionId = session_id
        
    def login(self, user, password, security_token=''):

        headers = {
            'User-Agent'      : 'shawns-client',
            'Accept'          : 'text/html,application/xhtml+xml,application/xml',
            'Accept-Encoding' : 'none',
            'Accept-Charset'  : 'utf-8',
            'Connection'      : 'close',
            'Content-Type'    : 'text/xml; charset=utf-8',
            'SOAPAction'      : '"urn:enterprise.soap.sforce.com/login"'}
        body = '''
            <soap:Envelope xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/" xmlns:tns="urn:enterprise.soap.sforce.com" xmlns:fns="urn:fault.enterprise.soap.sforce.com" xmlns:ens="urn:sobject.enterprise.soap.sforce.com"><soap:Header></soap:Header><soap:Body><tns:login><username>%s</username><password>%s%s</password></tns:login></soap:Body></soap:Envelope>
                ''' % (user, password, security_token)
        conn = httplib.HTTPSConnection(self.instance)
        conn.request('POST', '/services/Soap/c/v29.0', body, headers)
        response = conn.getresponse()
        data = response.read()
        conn.close()
        try:
            regex = re.compile("<sessionId>(.*)</sessionId>", re.MULTILINE)
            match = regex.search(data)
            sessionId = match.group(1)
            self.sessionId = sessionId
        except:
            self.sessionId = None
            raise Exception('Login Failed')
        
    def is_valid(self):
        conn = httplib.HTTPSConnection(self.instance)
        headers = {'Authorization':'Bearer {}'.format(self.sessionId)}
        conn.request('GET', '/services/data/v29.0/chatter/users/me', None, headers)
        response = conn.getresponse()
        conn.close()
        if response.status == 200:
            return True
        else:
            return False
        
    def get_session_id(self):
        return self.sessionId
