from __future__ import unicode_literals
'''
Created on Dec 4, 2013

@author: scrosby
'''
from sf.BaseClient import BaseClient

class Chatter(BaseClient):
    def __init__(self, instance='login.salesforce.com', session_id=None):
        BaseClient.__init__(self, instance=instance, session_id=session_id)

    def get_me(self):
        return self.get_chatter_profile()
    
    def get_chatter_profile(self, obj='me'):
        return self.client.get_chatter_profile(obj)
        
    def get_feed(self, obj=None):
        if obj is None:
            feed = self.client.get_news_feed()
        else:
            feed = self.client.get_object_feed(obj)
            
        for item in feed['items']:
            header = "========================================================="
            print("\n{}\n{}:\n{}".format(header, item['preamble']['text'], header))
            for segment in item['body']['messageSegments']:
                if  segment['type'] == 'Text':
                    print("{}".format(segment['text'].replace('\n',' ')))
    
    def post_chatter_message(self, messageText, obj=None):
        if obj is None:
            return self.client.chatter_post(messageText)
        else:
            return self.client.chatter_on_object(messageText, obj)
        
        