/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  4 13:50:28 EST 2014 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 25 -dif -name hb_25 -include hb.h */

/*
 * This function contains 400 FP additions, 364 FP multiplications,
 * (or, 84 additions, 48 multiplications, 316 fused multiply/add),
 * 176 stack variables, 47 constants, and 100 memory accesses
 */
#include "hb.h"

static void hb_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP921177326, +0.921177326965143320250447435415066029359282231);
     DK(KP833417178, +0.833417178328688677408962550243238843138996060);
     DK(KP541454447, +0.541454447536312777046285590082819509052033189);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP242145790, +0.242145790282157779872542093866183953459003101);
     DK(KP904730450, +0.904730450839922351881287709692877908104763647);
     DK(KP559154169, +0.559154169276087864842202529084232643714075927);
     DK(KP683113946, +0.683113946453479238701949862233725244439656928);
     DK(KP831864738, +0.831864738706457140726048799369896829771167132);
     DK(KP871714437, +0.871714437527667770979999223229522602943903653);
     DK(KP803003575, +0.803003575438660414833440593570376004635464850);
     DK(KP554608978, +0.554608978404018097464974850792216217022558774);
     DK(KP248028675, +0.248028675328619457762448260696444630363259177);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP851038619, +0.851038619207379630836264138867114231259902550);
     DK(KP525970792, +0.525970792408939708442463226536226366643874659);
     DK(KP726211448, +0.726211448929902658173535992263577167607493062);
     DK(KP912018591, +0.912018591466481957908415381764119056233607330);
     DK(KP912575812, +0.912575812670962425556968549836277086778922727);
     DK(KP943557151, +0.943557151597354104399655195398983005179443399);
     DK(KP994076283, +0.994076283785401014123185814696322018529298887);
     DK(KP614372930, +0.614372930789563808870829930444362096004872855);
     DK(KP621716863, +0.621716863012209892444754556304102309693593202);
     DK(KP772036680, +0.772036680810363904029489473607579825330539880);
     DK(KP734762448, +0.734762448793050413546343770063151342619912334);
     DK(KP860541664, +0.860541664367944677098261680920518816412804187);
     DK(KP949179823, +0.949179823508441261575555465843363271711583843);
     DK(KP557913902, +0.557913902031834264187699648465567037992437152);
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP249506682, +0.249506682107067890488084201715862638334226305);
     DK(KP906616052, +0.906616052148196230441134447086066874408359177);
     DK(KP681693190, +0.681693190061530575150324149145440022633095390);
     DK(KP560319534, +0.560319534973832390111614715371676131169633784);
     DK(KP845997307, +0.845997307939530944175097360758058292389769300);
     DK(KP968479752, +0.968479752739016373193524836781420152702090879);
     DK(KP062914667, +0.062914667253649757225485955897349402364686947);
     DK(KP827271945, +0.827271945972475634034355757144307982555673741);
     DK(KP470564281, +0.470564281212251493087595091036643380879947982);
     DK(KP126329378, +0.126329378446108174786050455341811215027378105);
     DK(KP256756360, +0.256756360367726783319498520922669048172391148);
     DK(KP634619297, +0.634619297544148100711287640319130485732531031);
     DK(KP549754652, +0.549754652192770074288023275540779861653779767);
     DK(KP939062505, +0.939062505817492352556001843133229685779824606);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 48); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 48, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T3w, T3P, T2d, T3y, T3x, T3Q;
	       {
		    E T9, T3E, T1F, T3B, T6f, T7d, T5u, T6U, T4k, T2k, T5G, T1G, T19, T1H, T1s;
		    E T1M, T1N, TP, TM, T7i, T77, T5X, T64, T4u, T4D, T3p, T2z, T74, T7h, T63;
		    E T5Q, T4x, T4E, T3q, T2O, T4n, T4G, T3t, T3j, T5F, T70, T7f, T66, T5B, T4q;
		    E T4H, T3s, T34, T5E, T6V;
		    {
			 E T2f, T2e, T6e, T2j, T5t, T6d;
			 {
			      E T1, T1x, T3C, T3D, T8, T2h, T1A, T1D, T2i, T3A, T1E, T3z;
			      T1 = cr[0];
			      T1x = ci[WS(rs, 24)];
			      {
				   E T2, T3, T5, T6;
				   T2 = cr[WS(rs, 5)];
				   T3 = ci[WS(rs, 4)];
				   T5 = cr[WS(rs, 10)];
				   T6 = ci[WS(rs, 9)];
				   {
					E T1y, T4, T7, T1z, T1B, T1C;
					T1y = ci[WS(rs, 19)];
					T3C = T2 - T3;
					T4 = T2 + T3;
					T3D = T5 - T6;
					T7 = T5 + T6;
					T1z = cr[WS(rs, 20)];
					T1B = ci[WS(rs, 14)];
					T1C = cr[WS(rs, 15)];
					T8 = T4 + T7;
					T2f = T4 - T7;
					T2h = T1y + T1z;
					T1A = T1y - T1z;
					T1D = T1B - T1C;
					T2i = T1B + T1C;
				   }
			      }
			      T2e = FNMS(KP250000000, T8, T1);
			      T9 = T1 + T8;
			      T3A = T1A - T1D;
			      T1E = T1A + T1D;
			      T3E = FMA(KP618033988, T3D, T3C);
			      T6e = FNMS(KP618033988, T3C, T3D);
			      T2j = FMA(KP618033988, T2i, T2h);
			      T5t = FNMS(KP618033988, T2h, T2i);
			      T1F = T1x + T1E;
			      T3z = FNMS(KP250000000, T1E, T1x);
			      T6d = FNMS(KP559016994, T3A, T3z);
			      T3B = FMA(KP559016994, T3A, T3z);
			 }
			 {
			      E T2x, T5V, T2m, T2l, Ti, T5w, T3h, T36, TK, T35, T2F, T5L, T2I, Tr, T2H;
			      E T3a, T5z, T3d, T1r, T3c, T2q, T5S, T2t, TZ, T2s, T5O, T2M, T2B, Tt, T18;
			      E T2A, Tx, T2V, T2Y, Tw, T30, T1i, T2X, Ty;
			      {
				   E T1j, T1k, T1p, T39, T1l;
				   {
					E TC, TI, T3g, TD, TE;
					{
					     E Ta, Te, Tf, Tb, Tc, T5s, T2g, T2w, Tg;
					     Ta = cr[WS(rs, 1)];
					     T5s = FNMS(KP559016994, T2f, T2e);
					     T2g = FMA(KP559016994, T2f, T2e);
					     T6f = FNMS(KP951056516, T6e, T6d);
					     T7d = FMA(KP951056516, T6e, T6d);
					     Te = cr[WS(rs, 11)];
					     T5u = FMA(KP951056516, T5t, T5s);
					     T6U = FNMS(KP951056516, T5t, T5s);
					     T4k = FMA(KP951056516, T2j, T2g);
					     T2k = FNMS(KP951056516, T2j, T2g);
					     Tf = ci[WS(rs, 8)];
					     Tb = cr[WS(rs, 6)];
					     Tc = ci[WS(rs, 3)];
					     TC = cr[WS(rs, 3)];
					     T2w = Tf - Te;
					     Tg = Te + Tf;
					     {
						  E T2v, Td, Th, TG, TH;
						  T2v = Tb - Tc;
						  Td = Tb + Tc;
						  TG = ci[WS(rs, 11)];
						  TH = ci[WS(rs, 6)];
						  T2x = FNMS(KP618033988, T2w, T2v);
						  T5V = FMA(KP618033988, T2v, T2w);
						  Th = Td + Tg;
						  T2m = Td - Tg;
						  TI = TG + TH;
						  T3g = TG - TH;
						  T2l = FNMS(KP250000000, Th, Ta);
						  Ti = Ta + Th;
						  TD = cr[WS(rs, 8)];
						  TE = ci[WS(rs, 1)];
					     }
					}
					{
					     E Tj, Tk, Tp, T2E, TJ, Tl;
					     Tj = cr[WS(rs, 4)];
					     {
						  E Tn, To, T3f, TF;
						  Tn = ci[WS(rs, 10)];
						  To = ci[WS(rs, 5)];
						  T3f = TD - TE;
						  TF = TD + TE;
						  Tk = cr[WS(rs, 9)];
						  Tp = Tn + To;
						  T2E = To - Tn;
						  T5w = FNMS(KP618033988, T3f, T3g);
						  T3h = FMA(KP618033988, T3g, T3f);
						  T36 = TI - TF;
						  TJ = TF + TI;
						  Tl = ci[0];
					     }
					     T1j = ci[WS(rs, 21)];
					     TK = TC + TJ;
					     T35 = FNMS(KP250000000, TJ, TC);
					     {
						  E T1n, Tm, T2D, T1o, Tq;
						  T1n = cr[WS(rs, 13)];
						  Tm = Tk + Tl;
						  T2D = Tl - Tk;
						  T1o = cr[WS(rs, 18)];
						  T1k = ci[WS(rs, 16)];
						  T2F = FMA(KP618033988, T2E, T2D);
						  T5L = FNMS(KP618033988, T2D, T2E);
						  T2I = Tm - Tp;
						  Tq = Tm + Tp;
						  T1p = T1n + T1o;
						  T39 = T1o - T1n;
						  Tr = Tj + Tq;
						  T2H = FMS(KP250000000, Tq, Tj);
						  T1l = cr[WS(rs, 23)];
					     }
					}
				   }
				   {
					E T10, T11, T16, T2L, T12;
					{
					     E TR, TS, TX, T2p, T1q, TT;
					     TR = ci[WS(rs, 23)];
					     {
						  E TV, TW, T38, T1m;
						  TV = ci[WS(rs, 13)];
						  TW = cr[WS(rs, 16)];
						  T38 = T1k + T1l;
						  T1m = T1k - T1l;
						  TS = ci[WS(rs, 18)];
						  TX = TV - TW;
						  T2p = TV + TW;
						  T3a = FMA(KP618033988, T39, T38);
						  T5z = FNMS(KP618033988, T38, T39);
						  T3d = T1m + T1p;
						  T1q = T1m - T1p;
						  TT = cr[WS(rs, 21)];
					     }
					     T10 = ci[WS(rs, 20)];
					     T1r = T1j + T1q;
					     T3c = FMS(KP250000000, T1q, T1j);
					     {
						  E T14, TU, T2o, T15, TY;
						  T14 = cr[WS(rs, 14)];
						  TU = TS - TT;
						  T2o = TS + TT;
						  T15 = cr[WS(rs, 19)];
						  T11 = ci[WS(rs, 15)];
						  T2q = FMA(KP618033988, T2p, T2o);
						  T5S = FNMS(KP618033988, T2o, T2p);
						  T2t = TU - TX;
						  TY = TU + TX;
						  T16 = T14 + T15;
						  T2L = T15 - T14;
						  TZ = TR + TY;
						  T2s = FNMS(KP250000000, TY, TR);
						  T12 = cr[WS(rs, 24)];
					     }
					}
					{
					     E T1a, T1e, T1d, T2T, T17, T1f;
					     T1a = ci[WS(rs, 22)];
					     {
						  E T1b, T1c, T2K, T13;
						  T1b = ci[WS(rs, 17)];
						  T1c = cr[WS(rs, 22)];
						  T2K = T11 + T12;
						  T13 = T11 - T12;
						  T1e = ci[WS(rs, 12)];
						  T1d = T1b - T1c;
						  T2T = T1b + T1c;
						  T5O = FNMS(KP618033988, T2K, T2L);
						  T2M = FMA(KP618033988, T2L, T2K);
						  T2B = T13 + T16;
						  T17 = T13 - T16;
						  T1f = cr[WS(rs, 17)];
					     }
					     Tt = cr[WS(rs, 2)];
					     T18 = T10 + T17;
					     T2A = FMS(KP250000000, T17, T10);
					     {
						  E Tu, T1g, T2U, Tv, T1h;
						  Tu = cr[WS(rs, 7)];
						  T1g = T1e - T1f;
						  T2U = T1e + T1f;
						  Tv = ci[WS(rs, 2)];
						  Tx = cr[WS(rs, 12)];
						  T2V = FMA(KP618033988, T2U, T2T);
						  T5G = FNMS(KP618033988, T2T, T2U);
						  T2Y = T1d - T1g;
						  T1h = T1d + T1g;
						  Tw = Tu + Tv;
						  T30 = Tu - Tv;
						  T1i = T1a + T1h;
						  T2X = FMS(KP250000000, T1h, T1a);
						  Ty = ci[WS(rs, 7)];
					     }
					}
				   }
			      }
			      {
				   E T32, T5D, T2R, T2Q, T2u, T2r, T4t;
				   {
					E TA, T31, Tz, TB, Ts;
					T31 = Ty - Tx;
					Tz = Tx + Ty;
					T1G = TZ + T18;
					T19 = TZ - T18;
					T32 = FNMS(KP618033988, T31, T30);
					T5D = FMA(KP618033988, T30, T31);
					TA = Tw + Tz;
					T2R = Tz - Tw;
					T2Q = FNMS(KP250000000, TA, Tt);
					TB = Tt + TA;
					T1H = T1i + T1r;
					T1s = T1i - T1r;
					T1M = Ti - Tr;
					Ts = Ti + Tr;
					{
					     E T2n, T5R, T5U, TL;
					     T2n = FMA(KP559016994, T2m, T2l);
					     T5R = FNMS(KP559016994, T2m, T2l);
					     T5U = FNMS(KP559016994, T2t, T2s);
					     T2u = FMA(KP559016994, T2t, T2s);
					     TL = TB + TK;
					     T1N = TB - TK;
					     {
						  E T5T, T75, T5W, T76;
						  T5T = FMA(KP951056516, T5S, T5R);
						  T75 = FNMS(KP951056516, T5S, T5R);
						  T5W = FMA(KP951056516, T5V, T5U);
						  T76 = FNMS(KP951056516, T5V, T5U);
						  TP = Ts - TL;
						  TM = Ts + TL;
						  T2r = FNMS(KP951056516, T2q, T2n);
						  T4t = FMA(KP951056516, T2q, T2n);
						  T7i = FMA(KP939062505, T75, T76);
						  T77 = FNMS(KP939062505, T76, T75);
						  T5X = FNMS(KP549754652, T5W, T5T);
						  T64 = FMA(KP549754652, T5T, T5W);
					     }
					}
				   }
				   {
					E T2J, T2G, T4v, T5y, T37, T3e, T5v;
					{
					     E T2C, T5K, T5N, T4s, T2y;
					     T2C = FNMS(KP559016994, T2B, T2A);
					     T5K = FMA(KP559016994, T2B, T2A);
					     T5N = FMA(KP559016994, T2I, T2H);
					     T2J = FNMS(KP559016994, T2I, T2H);
					     T4s = FNMS(KP951056516, T2x, T2u);
					     T2y = FMA(KP951056516, T2x, T2u);
					     {
						  E T73, T5M, T72, T5P;
						  T73 = FMA(KP951056516, T5L, T5K);
						  T5M = FNMS(KP951056516, T5L, T5K);
						  T72 = FMA(KP951056516, T5O, T5N);
						  T5P = FNMS(KP951056516, T5O, T5N);
						  T4u = FNMS(KP634619297, T4t, T4s);
						  T4D = FMA(KP634619297, T4s, T4t);
						  T3p = FMA(KP256756360, T2r, T2y);
						  T2z = FNMS(KP256756360, T2y, T2r);
						  T74 = FMA(KP126329378, T73, T72);
						  T7h = FNMS(KP126329378, T72, T73);
						  T63 = FNMS(KP470564281, T5M, T5P);
						  T5Q = FMA(KP470564281, T5P, T5M);
						  T2G = FMA(KP951056516, T2F, T2C);
						  T4v = FNMS(KP951056516, T2F, T2C);
					     }
					     T5y = FMA(KP559016994, T36, T35);
					     T37 = FNMS(KP559016994, T36, T35);
					     T3e = FNMS(KP559016994, T3d, T3c);
					     T5v = FMA(KP559016994, T3d, T3c);
					}
					{
					     E T5x, T6Y, T4w, T2N;
					     T4w = FNMS(KP951056516, T2M, T2J);
					     T2N = FMA(KP951056516, T2M, T2J);
					     {
						  E T4l, T3b, T4m, T3i;
						  T4l = FMA(KP951056516, T3a, T37);
						  T3b = FNMS(KP951056516, T3a, T37);
						  T4m = FMA(KP951056516, T3h, T3e);
						  T3i = FNMS(KP951056516, T3h, T3e);
						  T4x = FNMS(KP827271945, T4w, T4v);
						  T4E = FMA(KP827271945, T4v, T4w);
						  T3q = FMA(KP634619297, T2G, T2N);
						  T2O = FNMS(KP634619297, T2N, T2G);
						  T4n = FNMS(KP126329378, T4m, T4l);
						  T4G = FMA(KP126329378, T4l, T4m);
						  T3t = FNMS(KP939062505, T3b, T3i);
						  T3j = FMA(KP939062505, T3i, T3b);
						  T5x = FMA(KP951056516, T5w, T5v);
						  T6Y = FNMS(KP951056516, T5w, T5v);
					     }
					     {
						  E T2S, T2Z, T5C, T6Z, T5A;
						  T5F = FMA(KP559016994, T2R, T2Q);
						  T2S = FNMS(KP559016994, T2R, T2Q);
						  T2Z = FNMS(KP559016994, T2Y, T2X);
						  T5C = FMA(KP559016994, T2Y, T2X);
						  T6Z = FNMS(KP951056516, T5z, T5y);
						  T5A = FMA(KP951056516, T5z, T5y);
						  {
						       E T4p, T2W, T4o, T33;
						       T4p = FMA(KP951056516, T2V, T2S);
						       T2W = FNMS(KP951056516, T2V, T2S);
						       T4o = FMA(KP951056516, T32, T2Z);
						       T33 = FNMS(KP951056516, T32, T2Z);
						       T70 = FNMS(KP827271945, T6Z, T6Y);
						       T7f = FMA(KP827271945, T6Y, T6Z);
						       T66 = FNMS(KP062914667, T5x, T5A);
						       T5B = FMA(KP062914667, T5A, T5x);
						       T4q = FNMS(KP470564281, T4p, T4o);
						       T4H = FMA(KP470564281, T4o, T4p);
						       T3s = FNMS(KP549754652, T2W, T33);
						       T34 = FMA(KP549754652, T33, T2W);
						       T5E = FNMS(KP951056516, T5D, T5C);
						       T6V = FMA(KP951056516, T5D, T5C);
						  }
					     }
					}
				   }
			      }
			 }
		    }
		    {
			 E T6X, T7e, T6A, T6F, T6C, T6G, T6B;
			 cr[0] = T9 + TM;
			 {
			      E T67, T5I, T25, T22, T1X, T26, T21;
			      {
				   E T1I, T23, T1L, T1Z, T1t, TO, T24, T1O;
				   {
					E T1K, T6W, T5H, T1J;
					T1K = T1G - T1H;
					T1I = T1G + T1H;
					T6W = FNMS(KP951056516, T5G, T5F);
					T5H = FMA(KP951056516, T5G, T5F);
					T1J = FNMS(KP250000000, T1I, T1F);
					T6X = FMA(KP062914667, T6W, T6V);
					T7e = FNMS(KP062914667, T6V, T6W);
					T67 = FNMS(KP634619297, T5E, T5H);
					T5I = FMA(KP634619297, T5H, T5E);
					T23 = FNMS(KP559016994, T1K, T1J);
					T1L = FMA(KP559016994, T1K, T1J);
					T1Z = FNMS(KP618033988, T19, T1s);
					T1t = FMA(KP618033988, T1s, T19);
					TO = FNMS(KP250000000, TM, T9);
					T24 = FNMS(KP618033988, T1M, T1N);
					T1O = FMA(KP618033988, T1N, T1M);
				   }
				   {
					E T2b, T2a, T1Y, TQ, T27;
					ci[0] = T1F + T1I;
					T2b = FMA(KP951056516, T24, T23);
					T25 = FNMS(KP951056516, T24, T23);
					T2a = W[29];
					T1Y = FNMS(KP559016994, TP, TO);
					TQ = FMA(KP559016994, TP, TO);
					T27 = W[28];
					{
					     E T1V, T1P, T20, T1S, T1w, T1v, TN, T1Q;
					     T1V = FNMS(KP951056516, T1O, T1L);
					     T1P = FMA(KP951056516, T1O, T1L);
					     {
						  E T28, T1u, T29, T2c;
						  T20 = FMA(KP951056516, T1Z, T1Y);
						  T28 = FNMS(KP951056516, T1Z, T1Y);
						  T1S = FMA(KP951056516, T1t, TQ);
						  T1u = FNMS(KP951056516, T1t, TQ);
						  T1w = W[9];
						  T29 = T27 * T28;
						  T2c = T2a * T28;
						  TN = W[8];
						  T1Q = T1w * T1u;
						  cr[WS(rs, 15)] = FNMS(T2a, T2b, T29);
						  ci[WS(rs, 15)] = FMA(T27, T2b, T2c);
						  T1v = TN * T1u;
					     }
					     ci[WS(rs, 5)] = FMA(TN, T1P, T1Q);
					     {
						  E T1U, T1R, T1W, T1T;
						  T1U = W[39];
						  cr[WS(rs, 5)] = FNMS(T1w, T1P, T1v);
						  T1R = W[38];
						  T1W = T1U * T1S;
						  T22 = W[19];
						  T1T = T1R * T1S;
						  T1X = W[18];
						  ci[WS(rs, 20)] = FMA(T1R, T1V, T1W);
						  T26 = T22 * T20;
						  cr[WS(rs, 20)] = FNMS(T1U, T1V, T1T);
						  T21 = T1X * T20;
					     }
					}
				   }
			      }
			      {
				   E T6h, T6g, T5Y, T5J, T6z, T69, T6o, T6E;
				   {
					E T6m, T6n, T65, T68;
					T65 = FMA(KP968479752, T64, T63);
					T6h = FNMS(KP968479752, T64, T63);
					ci[WS(rs, 10)] = FMA(T1X, T25, T26);
					T68 = FNMS(KP845997307, T67, T66);
					T6g = FMA(KP845997307, T67, T66);
					cr[WS(rs, 10)] = FNMS(T22, T25, T21);
					T6m = FNMS(KP968479752, T5X, T5Q);
					T5Y = FMA(KP968479752, T5X, T5Q);
					T5J = FMA(KP845997307, T5I, T5B);
					T6n = FNMS(KP845997307, T5I, T5B);
					T6z = FMA(KP560319534, T65, T68);
					T69 = FNMS(KP681693190, T68, T65);
					T6o = FMA(KP681693190, T6n, T6m);
					T6E = FNMS(KP560319534, T6m, T6n);
				   }
				   {
					E T62, T6l, T6I, T6L, T6H, T6K;
					{
					     E T6Q, T6O, T6y, T6D, T6S;
					     {
						  E T6N, T5Z, T61, T6i, T6k;
						  T6N = W[2];
						  T5Z = FMA(KP906616052, T5Y, T5J);
						  T61 = FNMS(KP906616052, T5Y, T5J);
						  T6i = FNMS(KP906616052, T6h, T6g);
						  T6k = FMA(KP906616052, T6h, T6g);
						  T6Q = W[3];
						  {
						       E T60, T6j, T6R, T6P;
						       T60 = FNMS(KP249506682, T5Z, T5u);
						       T6O = FMA(KP998026728, T5Z, T5u);
						       T6j = FNMS(KP249506682, T6i, T6f);
						       T6R = FMA(KP998026728, T6i, T6f);
						       T6y = FMA(KP557913902, T61, T60);
						       T62 = FNMS(KP557913902, T61, T60);
						       T6P = T6N * T6O;
						       T6l = FNMS(KP557913902, T6k, T6j);
						       T6D = FMA(KP557913902, T6k, T6j);
						       T6S = T6N * T6R;
						       cr[WS(rs, 2)] = FNMS(T6Q, T6R, T6P);
						  }
					     }
					     T6A = FNMS(KP949179823, T6z, T6y);
					     T6I = FMA(KP949179823, T6z, T6y);
					     T6L = FNMS(KP949179823, T6E, T6D);
					     T6F = FMA(KP949179823, T6E, T6D);
					     ci[WS(rs, 2)] = FMA(T6Q, T6O, T6S);
					     T6H = W[32];
					     T6K = W[33];
					}
					{
					     E T6a, T6s, T6v, T6p, T6c, T6q, T6b, T6M, T6J, T5r;
					     T6a = FNMS(KP860541664, T69, T62);
					     T6s = FMA(KP860541664, T69, T62);
					     T6v = FMA(KP860541664, T6o, T6l);
					     T6p = FNMS(KP860541664, T6o, T6l);
					     T6M = T6H * T6L;
					     T6J = T6H * T6I;
					     T5r = W[12];
					     T6c = W[13];
					     ci[WS(rs, 17)] = FMA(T6K, T6I, T6M);
					     cr[WS(rs, 17)] = FNMS(T6K, T6L, T6J);
					     T6q = T5r * T6p;
					     T6b = T5r * T6a;
					     {
						  E T6r, T6u, T6w, T6t, T6x;
						  ci[WS(rs, 7)] = FMA(T6c, T6a, T6q);
						  cr[WS(rs, 7)] = FNMS(T6c, T6p, T6b);
						  T6r = W[42];
						  T6u = W[43];
						  T6w = T6r * T6v;
						  T6t = T6r * T6s;
						  T6x = W[22];
						  T6C = W[23];
						  ci[WS(rs, 22)] = FMA(T6u, T6s, T6w);
						  cr[WS(rs, 22)] = FNMS(T6u, T6v, T6t);
						  T6G = T6x * T6F;
						  T6B = T6x * T6A;
					     }
					}
				   }
			      }
			 }
			 {
			      E T7u, T7D, T7n, T7w, T7v, T7E;
			      {
				   E T78, T7t, T7N, T71, T7C, T7S, T7y, T7k;
				   {
					E T7j, T7g, T7A, T7B, T7r, T7s;
					T7r = FNMS(KP734762448, T7i, T7h);
					T7j = FMA(KP734762448, T7i, T7h);
					T7g = FMA(KP772036680, T7f, T7e);
					T7s = FNMS(KP772036680, T7f, T7e);
					ci[WS(rs, 12)] = FMA(T6C, T6A, T6G);
					cr[WS(rs, 12)] = FNMS(T6C, T6F, T6B);
					T7A = FNMS(KP734762448, T77, T74);
					T78 = FMA(KP734762448, T77, T74);
					T7t = FNMS(KP621716863, T7s, T7r);
					T7N = FMA(KP614372930, T7r, T7s);
					T71 = FMA(KP772036680, T70, T6X);
					T7B = FNMS(KP772036680, T70, T6X);
					T7C = FNMS(KP621716863, T7B, T7A);
					T7S = FMA(KP614372930, T7A, T7B);
					T7y = FNMS(KP994076283, T7j, T7g);
					T7k = FMA(KP994076283, T7j, T7g);
				   }
				   {
					E T7c, T6T, T7x, T7l, T79, T7p;
					T7c = W[5];
					T6T = W[4];
					T7x = FNMS(KP249506682, T7k, T7d);
					T7l = FMA(KP998026728, T7k, T7d);
					T79 = FMA(KP994076283, T78, T71);
					T7p = FNMS(KP994076283, T78, T71);
					{
					     E T7z, T7Y, T7Z, T7T, T7q, T7O, T7X, T7L, T7Q, T7P, T7U;
					     {
						  E T7V, T80, T7b, T7m, T7W;
						  {
						       E T7R, T7o, T7a, T7M;
						       T7V = W[34];
						       T7R = FMA(KP557913902, T7y, T7x);
						       T7z = FNMS(KP557913902, T7y, T7x);
						       T7Y = W[35];
						       T7o = FNMS(KP249506682, T79, T6U);
						       T7a = FMA(KP998026728, T79, T6U);
						       T7Z = FMA(KP949179823, T7S, T7R);
						       T7T = FNMS(KP949179823, T7S, T7R);
						       T7M = FMA(KP557913902, T7p, T7o);
						       T7q = FNMS(KP557913902, T7p, T7o);
						       T7b = T6T * T7a;
						       T7m = T7c * T7a;
						       T7W = FNMS(KP949179823, T7N, T7M);
						       T7O = FMA(KP949179823, T7N, T7M);
						  }
						  cr[WS(rs, 3)] = FNMS(T7c, T7l, T7b);
						  ci[WS(rs, 3)] = FMA(T6T, T7l, T7m);
						  T80 = T7Y * T7W;
						  T7X = T7V * T7W;
						  T7L = W[24];
						  T7Q = W[25];
						  ci[WS(rs, 18)] = FMA(T7V, T7Z, T80);
					     }
					     cr[WS(rs, 18)] = FNMS(T7Y, T7Z, T7X);
					     T7P = T7L * T7O;
					     T7U = T7Q * T7O;
					     {
						  E T7J, T7F, T7I, T7H, T7K, T7G;
						  T7u = FMA(KP943557151, T7t, T7q);
						  T7G = FNMS(KP943557151, T7t, T7q);
						  cr[WS(rs, 13)] = FNMS(T7Q, T7T, T7P);
						  ci[WS(rs, 13)] = FMA(T7L, T7T, T7U);
						  T7J = FMA(KP943557151, T7C, T7z);
						  T7D = FNMS(KP943557151, T7C, T7z);
						  T7F = W[44];
						  T7I = W[45];
						  T7n = W[14];
						  T7H = T7F * T7G;
						  T7K = T7I * T7G;
						  T7w = W[15];
						  T7v = T7n * T7u;
						  cr[WS(rs, 23)] = FNMS(T7I, T7J, T7H);
						  ci[WS(rs, 23)] = FMA(T7F, T7J, T7K);
					     }
					}
				   }
			      }
			      T7E = T7w * T7u;
			      cr[WS(rs, 8)] = FNMS(T7w, T7D, T7v);
			      {
				   E T3F, T4K, T4X, T4j, T4M, T4L, T4Y;
				   {
					E T4P, T4O, T4y, T4r, T4J, T57, T4N, T5c, T4W;
					{
					     E T4U, T4V, T4F, T4I;
					     T4F = FNMS(KP912575812, T4E, T4D);
					     T4P = FMA(KP912575812, T4E, T4D);
					     T4O = FMA(KP912018591, T4H, T4G);
					     T4I = FNMS(KP912018591, T4H, T4G);
					     ci[WS(rs, 8)] = FMA(T7n, T7D, T7E);
					     T4y = FMA(KP912575812, T4x, T4u);
					     T4U = FNMS(KP912575812, T4x, T4u);
					     T4V = FMA(KP912018591, T4q, T4n);
					     T4r = FNMS(KP912018591, T4q, T4n);
					     T4J = FNMS(KP726211448, T4I, T4F);
					     T57 = FMA(KP525970792, T4F, T4I);
					     T3F = FMA(KP951056516, T3E, T3B);
					     T4N = FNMS(KP951056516, T3E, T3B);
					     T5c = FMA(KP525970792, T4U, T4V);
					     T4W = FNMS(KP726211448, T4V, T4U);
					}
					{
					     E T5o, T4S, T4B, T5l, T5p, T4R, T4A, T5m, T4Q, T4z;
					     T5o = W[7];
					     T4Q = FMA(KP851038619, T4P, T4O);
					     T4S = FNMS(KP851038619, T4P, T4O);
					     T4z = FMA(KP851038619, T4y, T4r);
					     T4B = FNMS(KP851038619, T4y, T4r);
					     T5l = W[6];
					     T5p = FMA(KP992114701, T4Q, T4N);
					     T4R = FNMS(KP248028675, T4Q, T4N);
					     T4A = FMA(KP248028675, T4z, T4k);
					     T5m = FNMS(KP992114701, T4z, T4k);
					     {
						  E T4T, T4C, T5d, T58, T55, T5a, T59, T5e;
						  {
						       E T5f, T5j, T5i, T5h, T5k, T5g;
						       T5f = W[36];
						       {
							    E T5b, T56, T5n, T5q;
							    T4T = FNMS(KP554608978, T4S, T4R);
							    T5b = FMA(KP554608978, T4S, T4R);
							    T56 = FNMS(KP554608978, T4B, T4A);
							    T4C = FMA(KP554608978, T4B, T4A);
							    T5n = T5l * T5m;
							    T5q = T5o * T5m;
							    T5j = FMA(KP943557151, T5c, T5b);
							    T5d = FNMS(KP943557151, T5c, T5b);
							    T5g = FMA(KP943557151, T57, T56);
							    T58 = FNMS(KP943557151, T57, T56);
							    cr[WS(rs, 4)] = FNMS(T5o, T5p, T5n);
							    ci[WS(rs, 4)] = FMA(T5l, T5p, T5q);
						       }
						       T5i = W[37];
						       T5h = T5f * T5g;
						       T55 = W[26];
						       T5k = T5i * T5g;
						       T5a = W[27];
						       cr[WS(rs, 19)] = FNMS(T5i, T5j, T5h);
						       T59 = T55 * T58;
						       ci[WS(rs, 19)] = FMA(T5f, T5j, T5k);
						  }
						  T5e = T5a * T58;
						  {
						       E T53, T4Z, T52, T51, T54, T50;
						       cr[WS(rs, 14)] = FNMS(T5a, T5d, T59);
						       T4K = FNMS(KP803003575, T4J, T4C);
						       T50 = FMA(KP803003575, T4J, T4C);
						       ci[WS(rs, 14)] = FMA(T55, T5d, T5e);
						       T4X = FNMS(KP803003575, T4W, T4T);
						       T53 = FMA(KP803003575, T4W, T4T);
						       T4Z = W[46];
						       T52 = W[47];
						       T4j = W[16];
						       T51 = T4Z * T50;
						       T54 = T52 * T50;
						       T4M = W[17];
						       T4L = T4j * T4K;
						       cr[WS(rs, 24)] = FNMS(T52, T53, T51);
						       ci[WS(rs, 24)] = FMA(T4Z, T53, T54);
						  }
					     }
					}
				   }
				   T4Y = T4M * T4K;
				   cr[WS(rs, 9)] = FNMS(T4M, T4X, T4L);
				   {
					E T3G, T3H, T2P, T3k, T3Z, T3v, T3O, T44;
					{
					     E T3M, T3N, T3r, T3u;
					     T3G = FNMS(KP871714437, T3q, T3p);
					     T3r = FMA(KP871714437, T3q, T3p);
					     T3u = FNMS(KP831864738, T3t, T3s);
					     T3H = FMA(KP831864738, T3t, T3s);
					     ci[WS(rs, 9)] = FMA(T4j, T4X, T4Y);
					     T3M = FNMS(KP871714437, T2O, T2z);
					     T2P = FMA(KP871714437, T2O, T2z);
					     T3k = FMA(KP831864738, T3j, T34);
					     T3N = FNMS(KP831864738, T3j, T34);
					     T3Z = FMA(KP683113946, T3r, T3u);
					     T3v = FNMS(KP559154169, T3u, T3r);
					     T3O = FMA(KP559154169, T3N, T3M);
					     T44 = FNMS(KP683113946, T3M, T3N);
					}
					{
					     E T4g, T3K, T3n, T4d, T3J, T4h, T4e, T3m, T3I, T3l;
					     T4g = W[1];
					     T3K = FMA(KP904730450, T3H, T3G);
					     T3I = FNMS(KP904730450, T3H, T3G);
					     T3n = FNMS(KP904730450, T3k, T2P);
					     T3l = FMA(KP904730450, T3k, T2P);
					     T4d = W[0];
					     T3J = FNMS(KP242145790, T3I, T3F);
					     T4h = FMA(KP968583161, T3I, T3F);
					     T4e = FMA(KP968583161, T3l, T2k);
					     T3m = FNMS(KP242145790, T3l, T2k);
					     {
						  E T3L, T3o, T45, T40, T3X, T42, T41, T46;
						  {
						       E T47, T4b, T4a, T49, T4c, T48;
						       T47 = W[30];
						       {
							    E T43, T3Y, T4f, T4i;
							    T43 = FNMS(KP541454447, T3K, T3J);
							    T3L = FMA(KP541454447, T3K, T3J);
							    T3o = FMA(KP541454447, T3n, T3m);
							    T3Y = FNMS(KP541454447, T3n, T3m);
							    T4f = T4d * T4e;
							    T4i = T4g * T4e;
							    T45 = FNMS(KP833417178, T44, T43);
							    T4b = FMA(KP833417178, T44, T43);
							    T40 = FNMS(KP833417178, T3Z, T3Y);
							    T48 = FMA(KP833417178, T3Z, T3Y);
							    cr[WS(rs, 1)] = FNMS(T4g, T4h, T4f);
							    ci[WS(rs, 1)] = FMA(T4d, T4h, T4i);
						       }
						       T4a = W[31];
						       T49 = T47 * T48;
						       T3X = W[20];
						       T4c = T4a * T48;
						       T42 = W[21];
						       cr[WS(rs, 16)] = FNMS(T4a, T4b, T49);
						       T41 = T3X * T40;
						       ci[WS(rs, 16)] = FMA(T47, T4b, T4c);
						  }
						  T46 = T42 * T40;
						  {
						       E T3V, T3R, T3U, T3T, T3W, T3S;
						       cr[WS(rs, 11)] = FNMS(T42, T45, T41);
						       T3S = FMA(KP921177326, T3v, T3o);
						       T3w = FNMS(KP921177326, T3v, T3o);
						       ci[WS(rs, 11)] = FMA(T3X, T45, T46);
						       T3V = FNMS(KP921177326, T3O, T3L);
						       T3P = FMA(KP921177326, T3O, T3L);
						       T3R = W[40];
						       T3U = W[41];
						       T2d = W[10];
						       T3T = T3R * T3S;
						       T3W = T3U * T3S;
						       T3y = W[11];
						       T3x = T2d * T3w;
						       cr[WS(rs, 21)] = FNMS(T3U, T3V, T3T);
						       ci[WS(rs, 21)] = FMA(T3R, T3V, T3W);
						  }
					     }
					}
				   }
			      }
			 }
		    }
	       }
	       cr[WS(rs, 6)] = FNMS(T3y, T3P, T3x);
	       T3Q = T3y * T3w;
	       ci[WS(rs, 6)] = FMA(T2d, T3P, T3Q);
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 25},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hb_25", twinstr, &GENUS, {84, 48, 316, 0} };

void X(codelet_hb_25) (planner *p) {
     X(khc2hc_register) (p, hb_25, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc.native -compact -variables 4 -pipeline-latency 4 -sign 1 -n 25 -dif -name hb_25 -include hb.h */

/*
 * This function contains 400 FP additions, 280 FP multiplications,
 * (or, 260 additions, 140 multiplications, 140 fused multiply/add),
 * 107 stack variables, 20 constants, and 100 memory accesses
 */
#include "hb.h"

static void hb_25(R *cr, R *ci, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP998026728, +0.998026728428271561952336806863450553336905220);
     DK(KP062790519, +0.062790519529313376076178224565631133122484832);
     DK(KP992114701, +0.992114701314477831049793042785778521453036709);
     DK(KP125333233, +0.125333233564304245373118759816508793942918247);
     DK(KP425779291, +0.425779291565072648862502445744251703979973042);
     DK(KP904827052, +0.904827052466019527713668647932697593970413911);
     DK(KP248689887, +0.248689887164854788242283746006447968417567406);
     DK(KP968583161, +0.968583161128631119490168375464735813836012403);
     DK(KP770513242, +0.770513242775789230803009636396177847271667672);
     DK(KP637423989, +0.637423989748689710176712811676016195434917298);
     DK(KP844327925, +0.844327925502015078548558063966681505381659241);
     DK(KP535826794, +0.535826794978996618271308767867639978063575346);
     DK(KP684547105, +0.684547105928688673732283357621209269889519233);
     DK(KP728968627, +0.728968627421411523146730319055259111372571664);
     DK(KP481753674, +0.481753674101715274987191502872129653528542010);
     DK(KP876306680, +0.876306680043863587308115903922062583399064238);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 48); m < me; m = m + 1, cr = cr + ms, ci = ci - ms, W = W + 48, MAKE_VOLATILE_STRIDE(50, rs)) {
	       E T9, T5Q, T3y, T39, T5v, Ti, Tr, Ts, TZ, T18, T1z, T2k, T4l, T3h, T44;
	       E T5d, T6C, T5C, T6o, T56, T6B, T5B, T6l, T2z, T4m, T3i, T47, T1K, T5w, T3c;
	       E T3B, T5R, TB, TK, TL, T1i, T1r, T1A, T2P, T4o, T3k, T4b, T5s, T6F, T5F;
	       E T6v, T5l, T6E, T5E, T6s, T34, T4p, T3l, T4e;
	       {
		    E T1, T4, T7, T8, T3x, T3w, T37, T38;
		    T1 = cr[0];
		    {
			 E T2, T3, T5, T6;
			 T2 = cr[WS(rs, 5)];
			 T3 = ci[WS(rs, 4)];
			 T4 = T2 + T3;
			 T5 = cr[WS(rs, 10)];
			 T6 = ci[WS(rs, 9)];
			 T7 = T5 + T6;
			 T8 = T4 + T7;
			 T3x = T5 - T6;
			 T3w = T2 - T3;
		    }
		    T9 = T1 + T8;
		    T5Q = FMA(KP951056516, T3w, KP587785252 * T3x);
		    T3y = FNMS(KP951056516, T3x, KP587785252 * T3w);
		    T37 = FNMS(KP250000000, T8, T1);
		    T38 = KP559016994 * (T4 - T7);
		    T39 = T37 - T38;
		    T5v = T38 + T37;
	       }
	       {
		    E Ta, T27, T53, T2f, Th, T26, T10, T2p, T58, T2x, T17, T2o, Tj, T2n, T5a;
		    E T2t, Tq, T2s, TR, T2b, T51, T2h, TY, T2g;
		    {
			 E Tg, T2e, Td, T2d;
			 Ta = cr[WS(rs, 1)];
			 {
			      E Te, Tf, Tb, Tc;
			      Te = cr[WS(rs, 11)];
			      Tf = ci[WS(rs, 8)];
			      Tg = Te + Tf;
			      T2e = Te - Tf;
			      Tb = cr[WS(rs, 6)];
			      Tc = ci[WS(rs, 3)];
			      Td = Tb + Tc;
			      T2d = Tb - Tc;
			 }
			 T27 = KP559016994 * (Td - Tg);
			 T53 = FMA(KP951056516, T2d, KP587785252 * T2e);
			 T2f = FNMS(KP951056516, T2e, KP587785252 * T2d);
			 Th = Td + Tg;
			 T26 = FNMS(KP250000000, Th, Ta);
		    }
		    {
			 E T16, T2w, T13, T2v;
			 T10 = ci[WS(rs, 20)];
			 {
			      E T14, T15, T11, T12;
			      T14 = cr[WS(rs, 14)];
			      T15 = cr[WS(rs, 19)];
			      T16 = T14 + T15;
			      T2w = T15 - T14;
			      T11 = ci[WS(rs, 15)];
			      T12 = cr[WS(rs, 24)];
			      T13 = T11 - T12;
			      T2v = T11 + T12;
			 }
			 T2p = KP559016994 * (T13 + T16);
			 T58 = FMA(KP951056516, T2v, KP587785252 * T2w);
			 T2x = FNMS(KP951056516, T2w, KP587785252 * T2v);
			 T17 = T13 - T16;
			 T2o = FNMS(KP250000000, T17, T10);
		    }
		    {
			 E Tp, T2m, Tm, T2l;
			 Tj = cr[WS(rs, 4)];
			 {
			      E Tn, To, Tk, Tl;
			      Tn = ci[WS(rs, 10)];
			      To = ci[WS(rs, 5)];
			      Tp = Tn + To;
			      T2m = Tn - To;
			      Tk = cr[WS(rs, 9)];
			      Tl = ci[0];
			      Tm = Tk + Tl;
			      T2l = Tk - Tl;
			 }
			 T2n = FNMS(KP951056516, T2m, KP587785252 * T2l);
			 T5a = FMA(KP951056516, T2l, KP587785252 * T2m);
			 T2t = KP559016994 * (Tm - Tp);
			 Tq = Tm + Tp;
			 T2s = FNMS(KP250000000, Tq, Tj);
		    }
		    {
			 E TX, T2a, TU, T29;
			 TR = ci[WS(rs, 23)];
			 {
			      E TV, TW, TS, TT;
			      TV = ci[WS(rs, 13)];
			      TW = cr[WS(rs, 16)];
			      TX = TV - TW;
			      T2a = TV + TW;
			      TS = ci[WS(rs, 18)];
			      TT = cr[WS(rs, 21)];
			      TU = TS - TT;
			      T29 = TS + TT;
			 }
			 T2b = FNMS(KP951056516, T2a, KP587785252 * T29);
			 T51 = FMA(KP951056516, T29, KP587785252 * T2a);
			 T2h = KP559016994 * (TU - TX);
			 TY = TU + TX;
			 T2g = FNMS(KP250000000, TY, TR);
		    }
		    Ti = Ta + Th;
		    Tr = Tj + Tq;
		    Ts = Ti + Tr;
		    TZ = TR + TY;
		    T18 = T10 + T17;
		    T1z = TZ + T18;
		    {
			 E T2c, T42, T2j, T43, T28, T2i;
			 T28 = T26 - T27;
			 T2c = T28 - T2b;
			 T42 = T28 + T2b;
			 T2i = T2g - T2h;
			 T2j = T2f + T2i;
			 T43 = T2i - T2f;
			 T2k = FNMS(KP481753674, T2j, KP876306680 * T2c);
			 T4l = FMA(KP728968627, T43, KP684547105 * T42);
			 T3h = FMA(KP876306680, T2j, KP481753674 * T2c);
			 T44 = FNMS(KP684547105, T43, KP728968627 * T42);
		    }
		    {
			 E T59, T6n, T5c, T6m, T57, T5b;
			 T57 = T2t + T2s;
			 T59 = T57 - T58;
			 T6n = T57 + T58;
			 T5b = T2o + T2p;
			 T5c = T5a + T5b;
			 T6m = T5b - T5a;
			 T5d = FNMS(KP844327925, T5c, KP535826794 * T59);
			 T6C = FMA(KP637423989, T6m, KP770513242 * T6n);
			 T5C = FMA(KP535826794, T5c, KP844327925 * T59);
			 T6o = FNMS(KP637423989, T6n, KP770513242 * T6m);
		    }
		    {
			 E T52, T6j, T55, T6k, T50, T54;
			 T50 = T27 + T26;
			 T52 = T50 - T51;
			 T6j = T50 + T51;
			 T54 = T2h + T2g;
			 T55 = T53 + T54;
			 T6k = T54 - T53;
			 T56 = FNMS(KP248689887, T55, KP968583161 * T52);
			 T6B = FMA(KP535826794, T6k, KP844327925 * T6j);
			 T5B = FMA(KP968583161, T55, KP248689887 * T52);
			 T6l = FNMS(KP844327925, T6k, KP535826794 * T6j);
		    }
		    {
			 E T2r, T45, T2y, T46, T2q, T2u;
			 T2q = T2o - T2p;
			 T2r = T2n + T2q;
			 T45 = T2q - T2n;
			 T2u = T2s - T2t;
			 T2y = T2u - T2x;
			 T46 = T2u + T2x;
			 T2z = FMA(KP904827052, T2r, KP425779291 * T2y);
			 T4m = FNMS(KP992114701, T45, KP125333233 * T46);
			 T3i = FNMS(KP425779291, T2r, KP904827052 * T2y);
			 T47 = FMA(KP125333233, T45, KP992114701 * T46);
		    }
	       }
	       {
		    E T1C, T1F, T1I, T1J, T3b, T3a, T3z, T3A;
		    T1C = ci[WS(rs, 24)];
		    {
			 E T1D, T1E, T1G, T1H;
			 T1D = ci[WS(rs, 19)];
			 T1E = cr[WS(rs, 20)];
			 T1F = T1D - T1E;
			 T1G = ci[WS(rs, 14)];
			 T1H = cr[WS(rs, 15)];
			 T1I = T1G - T1H;
			 T1J = T1F + T1I;
			 T3b = T1G + T1H;
			 T3a = T1D + T1E;
		    }
		    T1K = T1C + T1J;
		    T5w = FMA(KP951056516, T3a, KP587785252 * T3b);
		    T3c = FNMS(KP951056516, T3b, KP587785252 * T3a);
		    T3z = FNMS(KP250000000, T1J, T1C);
		    T3A = KP559016994 * (T1F - T1I);
		    T3B = T3z - T3A;
		    T5R = T3A + T3z;
	       }
	       {
		    E Tt, T2C, T5i, T2K, TA, T2B, T1a, T2G, T5g, T2M, T1h, T2L, TC, T2R, T5p;
		    E T2Z, TJ, T2Q, T1j, T2V, T5n, T31, T1q, T30;
		    {
			 E Tw, T2I, Tz, T2J;
			 Tt = cr[WS(rs, 2)];
			 {
			      E Tu, Tv, Tx, Ty;
			      Tu = cr[WS(rs, 7)];
			      Tv = ci[WS(rs, 2)];
			      Tw = Tu + Tv;
			      T2I = Tu - Tv;
			      Tx = cr[WS(rs, 12)];
			      Ty = ci[WS(rs, 7)];
			      Tz = Tx + Ty;
			      T2J = Tx - Ty;
			 }
			 T2C = KP559016994 * (Tw - Tz);
			 T5i = FMA(KP951056516, T2I, KP587785252 * T2J);
			 T2K = FNMS(KP951056516, T2J, KP587785252 * T2I);
			 TA = Tw + Tz;
			 T2B = FNMS(KP250000000, TA, Tt);
		    }
		    {
			 E T1d, T2E, T1g, T2F;
			 T1a = ci[WS(rs, 22)];
			 {
			      E T1b, T1c, T1e, T1f;
			      T1b = ci[WS(rs, 17)];
			      T1c = cr[WS(rs, 22)];
			      T1d = T1b - T1c;
			      T2E = T1b + T1c;
			      T1e = ci[WS(rs, 12)];
			      T1f = cr[WS(rs, 17)];
			      T1g = T1e - T1f;
			      T2F = T1e + T1f;
			 }
			 T2G = FNMS(KP951056516, T2F, KP587785252 * T2E);
			 T5g = FMA(KP951056516, T2E, KP587785252 * T2F);
			 T2M = KP559016994 * (T1d - T1g);
			 T1h = T1d + T1g;
			 T2L = FNMS(KP250000000, T1h, T1a);
		    }
		    {
			 E TI, T2Y, TF, T2X;
			 TC = cr[WS(rs, 3)];
			 {
			      E TG, TH, TD, TE;
			      TG = ci[WS(rs, 11)];
			      TH = ci[WS(rs, 6)];
			      TI = TG + TH;
			      T2Y = TG - TH;
			      TD = cr[WS(rs, 8)];
			      TE = ci[WS(rs, 1)];
			      TF = TD + TE;
			      T2X = TD - TE;
			 }
			 T2R = KP559016994 * (TF - TI);
			 T5p = FMA(KP951056516, T2X, KP587785252 * T2Y);
			 T2Z = FNMS(KP951056516, T2Y, KP587785252 * T2X);
			 TJ = TF + TI;
			 T2Q = FNMS(KP250000000, TJ, TC);
		    }
		    {
			 E T1p, T2U, T1m, T2T;
			 T1j = ci[WS(rs, 21)];
			 {
			      E T1n, T1o, T1k, T1l;
			      T1n = cr[WS(rs, 13)];
			      T1o = cr[WS(rs, 18)];
			      T1p = T1n + T1o;
			      T2U = T1o - T1n;
			      T1k = ci[WS(rs, 16)];
			      T1l = cr[WS(rs, 23)];
			      T1m = T1k - T1l;
			      T2T = T1k + T1l;
			 }
			 T2V = FNMS(KP951056516, T2U, KP587785252 * T2T);
			 T5n = FMA(KP951056516, T2T, KP587785252 * T2U);
			 T31 = KP559016994 * (T1m + T1p);
			 T1q = T1m - T1p;
			 T30 = FNMS(KP250000000, T1q, T1j);
		    }
		    TB = Tt + TA;
		    TK = TC + TJ;
		    TL = TB + TK;
		    T1i = T1a + T1h;
		    T1r = T1j + T1q;
		    T1A = T1i + T1r;
		    {
			 E T2H, T49, T2O, T4a, T2D, T2N;
			 T2D = T2B - T2C;
			 T2H = T2D - T2G;
			 T49 = T2D + T2G;
			 T2N = T2L - T2M;
			 T2O = T2K + T2N;
			 T4a = T2N - T2K;
			 T2P = FNMS(KP844327925, T2O, KP535826794 * T2H);
			 T4o = FMA(KP062790519, T4a, KP998026728 * T49);
			 T3k = FMA(KP535826794, T2O, KP844327925 * T2H);
			 T4b = FNMS(KP998026728, T4a, KP062790519 * T49);
		    }
		    {
			 E T5o, T6u, T5r, T6t, T5m, T5q;
			 T5m = T2R + T2Q;
			 T5o = T5m - T5n;
			 T6u = T5m + T5n;
			 T5q = T30 + T31;
			 T5r = T5p + T5q;
			 T6t = T5q - T5p;
			 T5s = FNMS(KP684547105, T5r, KP728968627 * T5o);
			 T6F = FNMS(KP992114701, T6t, KP125333233 * T6u);
			 T5F = FMA(KP728968627, T5r, KP684547105 * T5o);
			 T6v = FMA(KP125333233, T6t, KP992114701 * T6u);
		    }
		    {
			 E T5h, T6r, T5k, T6q, T5f, T5j;
			 T5f = T2C + T2B;
			 T5h = T5f - T5g;
			 T6r = T5f + T5g;
			 T5j = T2M + T2L;
			 T5k = T5i + T5j;
			 T6q = T5j - T5i;
			 T5l = FNMS(KP481753674, T5k, KP876306680 * T5h);
			 T6E = FNMS(KP425779291, T6q, KP904827052 * T6r);
			 T5E = FMA(KP876306680, T5k, KP481753674 * T5h);
			 T6s = FMA(KP904827052, T6q, KP425779291 * T6r);
		    }
		    {
			 E T2W, T4d, T33, T4c, T2S, T32;
			 T2S = T2Q - T2R;
			 T2W = T2S - T2V;
			 T4d = T2S + T2V;
			 T32 = T30 - T31;
			 T33 = T2Z + T32;
			 T4c = T32 - T2Z;
			 T34 = FNMS(KP998026728, T33, KP062790519 * T2W);
			 T4p = FNMS(KP637423989, T4c, KP770513242 * T4d);
			 T3l = FMA(KP062790519, T33, KP998026728 * T2W);
			 T4e = FMA(KP770513242, T4c, KP637423989 * T4d);
		    }
	       }
	       {
		    E TM, TQ, T1U, T1L, T1N, T1Z, T1t, T1V, T1y, T1Y;
		    {
			 E TO, TP, T1B, T1M;
			 TO = KP559016994 * (Ts - TL);
			 TM = Ts + TL;
			 TP = FNMS(KP250000000, TM, T9);
			 TQ = TO + TP;
			 T1U = TP - TO;
			 T1B = KP559016994 * (T1z - T1A);
			 T1L = T1z + T1A;
			 T1M = FNMS(KP250000000, T1L, T1K);
			 T1N = T1B + T1M;
			 T1Z = T1M - T1B;
		    }
		    {
			 E T19, T1s, T1w, T1x;
			 T19 = TZ - T18;
			 T1s = T1i - T1r;
			 T1t = FMA(KP951056516, T19, KP587785252 * T1s);
			 T1V = FNMS(KP951056516, T1s, KP587785252 * T19);
			 T1w = Ti - Tr;
			 T1x = TB - TK;
			 T1y = FMA(KP951056516, T1w, KP587785252 * T1x);
			 T1Y = FNMS(KP951056516, T1x, KP587785252 * T1w);
		    }
		    cr[0] = T9 + TM;
		    ci[0] = T1K + T1L;
		    {
			 E T1u, T1O, TN, T1v;
			 T1u = TQ - T1t;
			 T1O = T1y + T1N;
			 TN = W[8];
			 T1v = W[9];
			 cr[WS(rs, 5)] = FNMS(T1v, T1O, TN * T1u);
			 ci[WS(rs, 5)] = FMA(T1v, T1u, TN * T1O);
		    }
		    {
			 E T22, T24, T21, T23;
			 T22 = T1U + T1V;
			 T24 = T1Z - T1Y;
			 T21 = W[28];
			 T23 = W[29];
			 cr[WS(rs, 15)] = FNMS(T23, T24, T21 * T22);
			 ci[WS(rs, 15)] = FMA(T23, T22, T21 * T24);
		    }
		    {
			 E T1W, T20, T1T, T1X;
			 T1W = T1U - T1V;
			 T20 = T1Y + T1Z;
			 T1T = W[18];
			 T1X = W[19];
			 cr[WS(rs, 10)] = FNMS(T1X, T20, T1T * T1W);
			 ci[WS(rs, 10)] = FMA(T1X, T1W, T1T * T20);
		    }
		    {
			 E T1Q, T1S, T1P, T1R;
			 T1Q = TQ + T1t;
			 T1S = T1N - T1y;
			 T1P = W[38];
			 T1R = W[39];
			 cr[WS(rs, 20)] = FNMS(T1R, T1S, T1P * T1Q);
			 ci[WS(rs, 20)] = FMA(T1R, T1Q, T1P * T1S);
		    }
	       }
	       {
		    E T6H, T71, T6M, T74, T6i, T6x, T6y, T6z, T6Q, T6R, T6P, T6S;
		    {
			 E T6D, T6G, T6K, T6L;
			 T6D = T6B + T6C;
			 T6G = T6E - T6F;
			 T6H = FMA(KP951056516, T6D, KP587785252 * T6G);
			 T71 = FNMS(KP951056516, T6G, KP587785252 * T6D);
			 T6K = T6l - T6o;
			 T6L = T6v - T6s;
			 T6M = FMA(KP951056516, T6K, KP587785252 * T6L);
			 T74 = FNMS(KP951056516, T6L, KP587785252 * T6K);
		    }
		    {
			 E T6p, T6w, T6N, T6O;
			 T6i = T5v + T5w;
			 T6p = T6l + T6o;
			 T6w = T6s + T6v;
			 T6x = T6p - T6w;
			 T6y = FNMS(KP250000000, T6x, T6i);
			 T6z = KP559016994 * (T6p + T6w);
			 T6Q = T5R - T5Q;
			 T6N = T6B - T6C;
			 T6O = T6E + T6F;
			 T6R = T6N + T6O;
			 T6P = KP559016994 * (T6N - T6O);
			 T6S = FNMS(KP250000000, T6R, T6Q);
		    }
		    {
			 E T7c, T7e, T7b, T7d;
			 T7c = T6i + T6x;
			 T7e = T6Q + T6R;
			 T7b = W[6];
			 T7d = W[7];
			 cr[WS(rs, 4)] = FNMS(T7d, T7e, T7b * T7c);
			 ci[WS(rs, 4)] = FMA(T7d, T7c, T7b * T7e);
		    }
		    {
			 E T72, T78, T76, T7a, T70, T75;
			 T70 = T6y - T6z;
			 T72 = T70 - T71;
			 T78 = T70 + T71;
			 T75 = T6S - T6P;
			 T76 = T74 + T75;
			 T7a = T75 - T74;
			 {
			      E T6Z, T73, T77, T79;
			      T6Z = W[26];
			      T73 = W[27];
			      cr[WS(rs, 14)] = FNMS(T73, T76, T6Z * T72);
			      ci[WS(rs, 14)] = FMA(T73, T72, T6Z * T76);
			      T77 = W[36];
			      T79 = W[37];
			      cr[WS(rs, 19)] = FNMS(T79, T7a, T77 * T78);
			      ci[WS(rs, 19)] = FMA(T79, T78, T77 * T7a);
			 }
		    }
		    {
			 E T6I, T6W, T6U, T6Y, T6A, T6T;
			 T6A = T6y + T6z;
			 T6I = T6A - T6H;
			 T6W = T6A + T6H;
			 T6T = T6P + T6S;
			 T6U = T6M + T6T;
			 T6Y = T6T - T6M;
			 {
			      E T6h, T6J, T6V, T6X;
			      T6h = W[16];
			      T6J = W[17];
			      cr[WS(rs, 9)] = FNMS(T6J, T6U, T6h * T6I);
			      ci[WS(rs, 9)] = FMA(T6J, T6I, T6h * T6U);
			      T6V = W[46];
			      T6X = W[47];
			      cr[WS(rs, 24)] = FNMS(T6X, T6Y, T6V * T6W);
			      ci[WS(rs, 24)] = FMA(T6X, T6W, T6V * T6Y);
			 }
		    }
	       }
	       {
		    E T3n, T3N, T3s, T3Q, T3d, T3e, T36, T3f, T3C, T3D, T3v, T3E;
		    {
			 E T3j, T3m, T3q, T3r;
			 T3j = T3h - T3i;
			 T3m = T3k - T3l;
			 T3n = FMA(KP951056516, T3j, KP587785252 * T3m);
			 T3N = FNMS(KP951056516, T3m, KP587785252 * T3j);
			 T3q = T2k + T2z;
			 T3r = T2P - T34;
			 T3s = FMA(KP951056516, T3q, KP587785252 * T3r);
			 T3Q = FNMS(KP951056516, T3r, KP587785252 * T3q);
		    }
		    {
			 E T2A, T35, T3t, T3u;
			 T3d = T39 - T3c;
			 T2A = T2k - T2z;
			 T35 = T2P + T34;
			 T3e = T2A + T35;
			 T36 = KP559016994 * (T2A - T35);
			 T3f = FNMS(KP250000000, T3e, T3d);
			 T3C = T3y + T3B;
			 T3t = T3h + T3i;
			 T3u = T3k + T3l;
			 T3D = T3t + T3u;
			 T3v = KP559016994 * (T3t - T3u);
			 T3E = FNMS(KP250000000, T3D, T3C);
		    }
		    {
			 E T3Y, T40, T3X, T3Z;
			 T3Y = T3d + T3e;
			 T40 = T3C + T3D;
			 T3X = W[2];
			 T3Z = W[3];
			 cr[WS(rs, 2)] = FNMS(T3Z, T40, T3X * T3Y);
			 ci[WS(rs, 2)] = FMA(T3Z, T3Y, T3X * T40);
		    }
		    {
			 E T3O, T3U, T3S, T3W, T3M, T3R;
			 T3M = T3f - T36;
			 T3O = T3M - T3N;
			 T3U = T3M + T3N;
			 T3R = T3E - T3v;
			 T3S = T3Q + T3R;
			 T3W = T3R - T3Q;
			 {
			      E T3L, T3P, T3T, T3V;
			      T3L = W[22];
			      T3P = W[23];
			      cr[WS(rs, 12)] = FNMS(T3P, T3S, T3L * T3O);
			      ci[WS(rs, 12)] = FMA(T3P, T3O, T3L * T3S);
			      T3T = W[32];
			      T3V = W[33];
			      cr[WS(rs, 17)] = FNMS(T3V, T3W, T3T * T3U);
			      ci[WS(rs, 17)] = FMA(T3V, T3U, T3T * T3W);
			 }
		    }
		    {
			 E T3o, T3I, T3G, T3K, T3g, T3F;
			 T3g = T36 + T3f;
			 T3o = T3g - T3n;
			 T3I = T3g + T3n;
			 T3F = T3v + T3E;
			 T3G = T3s + T3F;
			 T3K = T3F - T3s;
			 {
			      E T25, T3p, T3H, T3J;
			      T25 = W[12];
			      T3p = W[13];
			      cr[WS(rs, 7)] = FNMS(T3p, T3G, T25 * T3o);
			      ci[WS(rs, 7)] = FMA(T3p, T3o, T25 * T3G);
			      T3H = W[42];
			      T3J = W[43];
			      cr[WS(rs, 22)] = FNMS(T3J, T3K, T3H * T3I);
			      ci[WS(rs, 22)] = FMA(T3J, T3I, T3H * T3K);
			 }
		    }
	       }
	       {
		    E T4r, T4L, T4w, T4O, T4h, T4i, T4g, T4j, T4A, T4B, T4z, T4C;
		    {
			 E T4n, T4q, T4u, T4v;
			 T4n = T4l - T4m;
			 T4q = T4o - T4p;
			 T4r = FMA(KP951056516, T4n, KP587785252 * T4q);
			 T4L = FNMS(KP951056516, T4q, KP587785252 * T4n);
			 T4u = T44 + T47;
			 T4v = T4b + T4e;
			 T4w = FMA(KP951056516, T4u, KP587785252 * T4v);
			 T4O = FNMS(KP951056516, T4v, KP587785252 * T4u);
		    }
		    {
			 E T48, T4f, T4x, T4y;
			 T4h = T39 + T3c;
			 T48 = T44 - T47;
			 T4f = T4b - T4e;
			 T4i = T48 + T4f;
			 T4g = KP559016994 * (T48 - T4f);
			 T4j = FNMS(KP250000000, T4i, T4h);
			 T4A = T3B - T3y;
			 T4x = T4l + T4m;
			 T4y = T4o + T4p;
			 T4B = T4x + T4y;
			 T4z = KP559016994 * (T4x - T4y);
			 T4C = FNMS(KP250000000, T4B, T4A);
		    }
		    {
			 E T4W, T4Y, T4V, T4X;
			 T4W = T4h + T4i;
			 T4Y = T4A + T4B;
			 T4V = W[4];
			 T4X = W[5];
			 cr[WS(rs, 3)] = FNMS(T4X, T4Y, T4V * T4W);
			 ci[WS(rs, 3)] = FMA(T4X, T4W, T4V * T4Y);
		    }
		    {
			 E T4M, T4S, T4Q, T4U, T4K, T4P;
			 T4K = T4j - T4g;
			 T4M = T4K - T4L;
			 T4S = T4K + T4L;
			 T4P = T4C - T4z;
			 T4Q = T4O + T4P;
			 T4U = T4P - T4O;
			 {
			      E T4J, T4N, T4R, T4T;
			      T4J = W[24];
			      T4N = W[25];
			      cr[WS(rs, 13)] = FNMS(T4N, T4Q, T4J * T4M);
			      ci[WS(rs, 13)] = FMA(T4N, T4M, T4J * T4Q);
			      T4R = W[34];
			      T4T = W[35];
			      cr[WS(rs, 18)] = FNMS(T4T, T4U, T4R * T4S);
			      ci[WS(rs, 18)] = FMA(T4T, T4S, T4R * T4U);
			 }
		    }
		    {
			 E T4s, T4G, T4E, T4I, T4k, T4D;
			 T4k = T4g + T4j;
			 T4s = T4k - T4r;
			 T4G = T4k + T4r;
			 T4D = T4z + T4C;
			 T4E = T4w + T4D;
			 T4I = T4D - T4w;
			 {
			      E T41, T4t, T4F, T4H;
			      T41 = W[14];
			      T4t = W[15];
			      cr[WS(rs, 8)] = FNMS(T4t, T4E, T41 * T4s);
			      ci[WS(rs, 8)] = FMA(T4t, T4s, T41 * T4E);
			      T4F = W[44];
			      T4H = W[45];
			      cr[WS(rs, 23)] = FNMS(T4H, T4I, T4F * T4G);
			      ci[WS(rs, 23)] = FMA(T4H, T4G, T4F * T4I);
			 }
		    }
	       }
	       {
		    E T5H, T63, T5M, T66, T5x, T5y, T5u, T5z, T5S, T5T, T5P, T5U;
		    {
			 E T5D, T5G, T5K, T5L;
			 T5D = T5B - T5C;
			 T5G = T5E - T5F;
			 T5H = FMA(KP951056516, T5D, KP587785252 * T5G);
			 T63 = FNMS(KP951056516, T5G, KP587785252 * T5D);
			 T5K = T56 - T5d;
			 T5L = T5l - T5s;
			 T5M = FMA(KP951056516, T5K, KP587785252 * T5L);
			 T66 = FNMS(KP951056516, T5L, KP587785252 * T5K);
		    }
		    {
			 E T5e, T5t, T5N, T5O;
			 T5x = T5v - T5w;
			 T5e = T56 + T5d;
			 T5t = T5l + T5s;
			 T5y = T5e + T5t;
			 T5u = KP559016994 * (T5e - T5t);
			 T5z = FNMS(KP250000000, T5y, T5x);
			 T5S = T5Q + T5R;
			 T5N = T5B + T5C;
			 T5O = T5E + T5F;
			 T5T = T5N + T5O;
			 T5P = KP559016994 * (T5N - T5O);
			 T5U = FNMS(KP250000000, T5T, T5S);
		    }
		    {
			 E T6e, T6g, T6d, T6f;
			 T6e = T5x + T5y;
			 T6g = T5S + T5T;
			 T6d = W[0];
			 T6f = W[1];
			 cr[WS(rs, 1)] = FNMS(T6f, T6g, T6d * T6e);
			 ci[WS(rs, 1)] = FMA(T6f, T6e, T6d * T6g);
		    }
		    {
			 E T64, T6a, T68, T6c, T62, T67;
			 T62 = T5z - T5u;
			 T64 = T62 - T63;
			 T6a = T62 + T63;
			 T67 = T5U - T5P;
			 T68 = T66 + T67;
			 T6c = T67 - T66;
			 {
			      E T61, T65, T69, T6b;
			      T61 = W[20];
			      T65 = W[21];
			      cr[WS(rs, 11)] = FNMS(T65, T68, T61 * T64);
			      ci[WS(rs, 11)] = FMA(T65, T64, T61 * T68);
			      T69 = W[30];
			      T6b = W[31];
			      cr[WS(rs, 16)] = FNMS(T6b, T6c, T69 * T6a);
			      ci[WS(rs, 16)] = FMA(T6b, T6a, T69 * T6c);
			 }
		    }
		    {
			 E T5I, T5Y, T5W, T60, T5A, T5V;
			 T5A = T5u + T5z;
			 T5I = T5A - T5H;
			 T5Y = T5A + T5H;
			 T5V = T5P + T5U;
			 T5W = T5M + T5V;
			 T60 = T5V - T5M;
			 {
			      E T4Z, T5J, T5X, T5Z;
			      T4Z = W[10];
			      T5J = W[11];
			      cr[WS(rs, 6)] = FNMS(T5J, T5W, T4Z * T5I);
			      ci[WS(rs, 6)] = FMA(T5J, T5I, T4Z * T5W);
			      T5X = W[40];
			      T5Z = W[41];
			      cr[WS(rs, 21)] = FNMS(T5Z, T60, T5X * T5Y);
			      ci[WS(rs, 21)] = FMA(T5Z, T5Y, T5X * T60);
			 }
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 25},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 25, "hb_25", twinstr, &GENUS, {260, 140, 140, 0} };

void X(codelet_hb_25) (planner *p) {
     X(khc2hc_register) (p, hb_25, &desc);
}
#endif				/* HAVE_FMA */
