// Generated by CoffeeScript 1.3.3

(function(jQuery) {
  var createSvgWrapper, svgWrapper, svg_tag_names, tag_name, wrap_map, _i, _len;
  createSvgWrapper = function(svg_tag_name) {
    var key, obj, val, _fn, _ref;
    obj = {
      _svgEl: null
    };
    _ref = $("<svg><" + svg_tag_name + "/></svg>").find("" + svg_tag_name)[0];
    _fn = function(key) {
      if ((val != null) && (val.baseVal != null)) {
        return Object.defineProperty(obj, key, {
          get: function() {
            return this._svgEl[key].baseVal;
          },
          set: function(value) {
            return this._svgEl[key].baseVal = value;
          }
        });
      } else {
        return Object.defineProperty(obj, key, {
          get: function() {
            return this._svgEl[key];
          },
          set: function(value) {
            return this._svgEl[key] = value;
          }
        });
      }
    };
    for (key in _ref) {
      val = _ref[key];
      _fn(key);
    }
    return obj;
  };
  svg_tag_names = ['rect', 'circle', 'ellipse', 'line', 'polygon', 'polyline'];
  wrap_map = {};
  for (_i = 0, _len = svg_tag_names.length; _i < _len; _i++) {
    tag_name = svg_tag_names[_i];
    wrap_map[tag_name] = createSvgWrapper(tag_name);
  }
  svgWrapper = function(el) {
    this._svgEl = el;
    this.__proto__ = wrap_map[el.tagName];
    return this;
  };
  return jQuery.fn.wrapSvg = function() {
    return this.map(function(i, el) {
      if (el.namespaceURI === "http://www.w3.org/2000/svg" && (!("_svgEl" in el))) {
        return new svgWrapper(el);
      } else {
        return el;
      }
    });
  };
})(window.jQuery);

/* http://keith-wood.name/svg.html
   jQuery DOM compatibility for jQuery SVG v1.4.5.
   Written by Keith Wood (kbwood{at}iinet.com.au) April 2009.
   Dual licensed under the GPL (http://dev.jquery.com/browser/trunk/jquery/GPL-LICENSE.txt) and 
   MIT (http://dev.jquery.com/browser/trunk/jquery/MIT-LICENSE.txt) licenses. 
   Please attribute the author if you use it. */

(function($) { // Hide scope, no $ conflict

/* Support adding class names to SVG nodes. */
$.fn.addClass = function(origAddClass) {
    return function(classNames) {
        classNames = classNames || '';
        return this.each(function() {
            if (isSVGElem(this)) {
                var node = this;
                $.each(classNames.split(/\s+/), function(i, className) {
                    var classes = (node.className ? node.className.baseVal : node.getAttribute('class'));
                    if ($.inArray(className, classes.split(/\s+/)) == -1) {
                        classes += (classes ? ' ' : '') + className;
                        (node.className ? node.className.baseVal = classes :
                            node.setAttribute('class',  classes));
                    }
                });
            }
            else {
                origAddClass.apply($(this), [classNames]);
            }
        });
    };
}($.fn.addClass);

/* Support removing class names from SVG nodes. */
$.fn.removeClass = function(origRemoveClass) {
    return function(classNames) {
        classNames = classNames || '';
        return this.each(function() {
            if (isSVGElem(this)) {
                var node = this;
                $.each(classNames.split(/\s+/), function(i, className) {
                    var classes = (node.className ? node.className.baseVal : node.getAttribute('class'));
                    classes = $.grep(classes.split(/\s+/), function(n, i) { return n != className; }).
                        join(' ');
                    (node.className ? node.className.baseVal = classes :
                        node.setAttribute('class', classes));
                });
            }
            else {
                origRemoveClass.apply($(this), [classNames]);
            }
        });
    };
}($.fn.removeClass);

function isSVGElem(el) {
  return (el.namespaceURI === "http://www.w3.org/2000/svg" && (!("_svgEl" in el)))
}

})(window.jQuery);
