"""
simple-django-oauth
-------------------

Adds OAuth support to Django.

History
```````

This work is fully based on the implemented of Flask-OAuth by Armin Ronacher.
It's adapted to work with Django (especially Django's HttpRequests) by Vincent
Driessen.

Links
`````

* `original documentation <http://packages.python.org/Flask-OAuth>`_
"""
from setuptools import setup


setup(
    name='simple-django-oauth',
    version='0.1.1',
    url='http://github.com/nvie/simple-django-oauth',
    license='BSD',
    author='Vincent Driessen',
    author_email='vincent@3rdcloud.com',
    description='Adds OAuth support to Django',
    long_description=__doc__,
    py_modules=['simple_django_oauth'],
    zip_safe=False,
    platforms='any',
    install_requires=[
        'Werkzeug',
        'oauth2'
    ],
    classifiers=[
        'Development Status :: 4 - Beta',
        'Environment :: Web Environment',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License',
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
        'Topic :: Software Development :: Libraries :: Python Modules'
    ]
)
