# -*- coding: utf-8 -*-
import os
from setuptools import setup, find_packages

def read(fname):
    try:
        return open(os.path.join(os.path.dirname(__file__), fname)).read()
    except IOError:
        return ''

setup(
    name="simple_api",
    version=__import__('simple_api').__version__,
    description=read('DESCRIPTION'),
    license="The MIT License (MIT)",
    keywords="django, api, simple_api",

    author="Alexander Yudkin",
    author_email="san4ezy@gmail.com",

    maintainer='Alexander Yudkin',
    maintainer_email='san4ezy@gmail.com',

    url="http://yudkin.com.ua",
    classifiers=[
        'Intended Audience :: Developers',
        'License :: OSI Approved :: MIT License',
        'Framework :: Django',
        'Environment :: Web Environment',
        'Operating System :: OS Independent',
        'Programming Language :: Python',        
        'Programming Language :: Python :: 2.6',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
    # packages=find_packages(exclude=['example', 'example.*']),
    # install_requires=[],
    # include_package_data=True,
    # zip_safe=False,
    # long_description=read('README'),
    # entry_points={
    #     'redsolutioncms': ['myapp = myapp.redsolution_setup', ],
    # }
)