#!/usr/bin/env python
# -*- Mode: python; tab-width: 4; indent-tabs-mode: nil; coding: utf-8 -*-

from setuptools import setup, find_packages

__version__ = '0.2.2'

setup(
    name='simpledropbox',
    version=__version__,
    description=u"Small python library to interact with dropbox through its public web interface.",
    long_description=u"""\
Upload, delete, get, rename, move, ... files in a dropbox.com account directly from python.

The latest version is available in a `Mercurial repository`_.

.. _Mercurial repository: http://bitbucket.org/greyw/simpledropbox/

""",
    author=u'Serge Émond',
    author_email='greyl@greyworld.net',
    url='http://greyworld.net/en/projects/simpledropbox/',
    license='Apache License 2.0',
    classifiers = [
        'Development Status :: 3 - Alpha',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        # 'Topic :: Communications :: File Sharing',
    ],
    install_requires=[
        "BeautifulSoup>=3.0.0.0",
        "pytz",
        # "timelib",
        "poster>=0.6.0",
    ],
    packages=find_packages(),
    zip_safe=False,
    test_suite='nose.collector',
)
