#!/usr/bin/env python
# -*- Mode: python; tab-width: 4; indent-tabs-mode: nil; coding: utf-8 -*-
"""
untitled.py

..
    :copyright: 2010 Serge Émond
    :license: not specified

"""

__all__ = ['SdObject', 'SdDirectory', 'SdFile']

import datetime
import re

# dropbox requires names without: \ / : ? * < > " |
_re_validate_path = re.compile(ur'[\:?*<>"|]', re.U)

class SdObject(object):
    """docstring for SdObject"""
    
    _elements = ('path', )
    
    def __init__(self):
        super(SdObject, self).__init__()
    
    def __iter__(self):
        self._i = 0
        return self
    
    def next(self):
        if len(self._elements) <= self._i:
            raise StopIteration
        n = self._elements[self._i]
        self._i = self._i + 1
        return n, getattr(self, n)
    
    def iteritems(self):
        return self.__iter__()
    
    def keys(self):
        return self._elements
    
    def values(self):
        return [v for k, v in self.iteritems()]
    
    def __repr__(self):
        items = ["%s=%r" % (k, v) for k, v in self.iteritems()]
        return "%s.%s(%s)" % (
            self.__class__.__module__,
            self.__class__.__name__,
            ','.join(items)
        )
    
    def __getitem__(self, key):
        try:
            return getattr(self, key)
        except AttributeError, e:
            raise IndexError(e)
    
    # def __getattr__(self, name):
    #     return self.__dict__[name]
    
    def __setitem__(self, key, value):
        try:
            return setattr(self, key, value)
        except AttributeError, e:
            raise IndexError(e)
    
    def __setattr__(self, name, value):
        if name[0] == '_':
            self.__dict__[name] = value
            return
        
        # Path always exists
        if name == 'path':
            if isinstance(value, type(None)):
                self.__dict__[name] = None
                return
            
            if isinstance(value, str):
                try:
                    value = value.decode('utf-8')
                except UnicodeDecodeError:
                    value = unicode(value)
            
            if not isinstance(value, unicode):
                value = unicode(value)
            
            if len(value) < 1:
                value = u'/'
            elif value[0] != u'/':
                value = u'/' + value
            
            if _re_validate_path.search(value):
                raise ValueError("Path name must not contain \\, :, ?, *, <, > \" or |")
        
        if name not in self._elements:
            raise AttributeError("Invalid name %r" % name)
        self.__dict__[name] = value
    
    def __delitem__(self, key):
        raise IndexError("Invalid key %r" % key)
    
    def __contains__(self, item):
        return item in self._elements and getattr(self, item, 'None') is not None
    
    def __unicode__(self):
        return unicode(self.path)
    
    def __str__(self):
        return self.__unicode__().encode('utf-8')
    

class SdDirectory(SdObject):
    
    _elements = ('path', )
    
    def __init__(self, **kwargs):
        super(SdDirectory, self).__init__()
        
        for k in self._elements:
            setattr(self, k, kwargs[k] if k in kwargs else None)
    

class SdFile(SdObject):
    
    _elements = ('path', 'get_url', 'size', 'modified', 'etag')
    
    def __init__(self, **kwargs):
        super(SdFile, self).__init__()
        
        for k in self._elements:
            setattr(self, k, kwargs[k] if k in kwargs else None)
    
    def __setattr__(self, name, value):
        if name == 'modified':
            if not isinstance(value, (datetime.datetime, type(None))):
                raise TypeError("'modified' must be datetime.datetime")
        SdObject.__setattr__(self, name, value)
    

