#python-encoding: UTF-8

sentences = \
{
    '人は贔屓扱いされることを欲さない．': \
    {
    },
    '人間は哺乳類の一種である．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 である ．",
        'untokenize':       "人間は哺乳類の一種である．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6 7"),
    },
    '人間は哺乳類の一種であった．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 であった ．",
        'untokenize':       "人間は哺乳類の一種であった．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6〜た 7"),
    },
    '人間は哺乳類の一種ではあります．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 ではあります ．",
        'untokenize':       "人間は哺乳類の一種ではあります．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ます ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6〜ます 7"),
    },
    '人間は哺乳類の一種じゃあります．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 じゃ ある ．",
        'tokenize':         "人間 は 哺乳類 の 一種 じゃ あります ．",
        'untokenize':       "人間は哺乳類の一種じゃあります．",
        'lemma_split':      ("人間 哺乳類 一種 ある", "1 は 2 の 3 じゃ 4〜ます ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 じゃ ある ．", "1 2 3 4 5 6 7〜ます 8"),
    },
    '人間は哺乳類の一種じゃない．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 じゃない ．",
        'untokenize':       "人間は哺乳類の一種じゃない．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ない ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6 7"),
    },
    '人間は哺乳類の一種じゃなかった．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 じゃなかった ．",
        'untokenize':       "人間は哺乳類の一種じゃなかった．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ない〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜た 7"),
    },
    '人間は哺乳類の一種じゃありません．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 じゃありません ．",
        'untokenize':       "人間は哺乳類の一種じゃありません．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ます〜ない ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜ます 7"),
    },
    '人間は哺乳類の一種じゃありませんでした．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 じゃありませんでした ．",
        'untokenize':       "人間は哺乳類の一種じゃありませんでした．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ます〜ない〜です〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜ます〜です〜た 7"),
    },
    '人間は哺乳類の一種ではありません．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 ではありません ．",
        'untokenize':       "人間は哺乳類の一種ではありません．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ます〜ない ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜ます 7"),
    },
    '人間は哺乳類の一種ではありませんでした．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 ではありませんでした ．",
        'untokenize':       "人間は哺乳類の一種ではありませんでした．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ます〜ない〜です〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜ます〜です〜た 7"),
    },
    '人間は哺乳類の一種ではない．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 ではない ．",
        'untokenize':       "人間は哺乳類の一種ではない．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ない ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6 7"),
    },
    '人間は哺乳類の一種ではなかった．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である〜ない ．",
        'tokenize':         "人間 は 哺乳類 の 一種 ではなかった ．",
        'untokenize':       "人間は哺乳類の一種ではなかった．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜ない〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である〜ない ．", "1 2 3 4 5 6〜た 7"),
    },
    '人間は哺乳類の一種です．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 です ．",
        'untokenize':       "人間は哺乳類の一種です．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6 7"),
    },
    '人間は哺乳類の一種でした．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 でした ．",
        'untokenize':       "人間は哺乳類の一種でした．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6〜た 7"),
    },
    '人間は哺乳類の一種だ．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 だ ．",
        'untokenize':       "人間は哺乳類の一種だ．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6 7"),
    },
    '人間は哺乳類の一種だった．': \
    {
        'normalize':        "人間 は 哺乳類 の 一種 である ．",
        'tokenize':         "人間 は 哺乳類 の 一種 だった ．",
        'untokenize':       "人間は哺乳類の一種だった．",
        'lemma_split':      ("人間 哺乳類 一種", "1 は 2 の 3 である〜た ．"),
        'lemma_split_keep': ("人間 は 哺乳類 の 一種 である ．", "1 2 3 4 5 6〜た 7"),
    },
    'あなたが会議の際にすることの一つは資料を配布するである．': \
    {
        'normalize':        "あなた が 会議 の 際 に する こと の 一つ は 資料 を 配布する である ．",
        'tokenize':         "あなた が 会議 の 際 に する こと の 一つ は 資料 を 配布する である ．",
        'untokenize':       "あなたが会議の際にすることの一つは資料を配布するである．",
        'lemma_split':      ("あなた 会議 際 する 一つ 資料 配布する", "1 が 2 の 3 に 4 こと の 5 は 6 を 7 である ．"),
        'lemma_split_keep': ("あなた が 会議 の 際 に する こと の 一つ は 資料 を 配布する である ．", "1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16"),
    },
    'とうもろこしは地面でなくても育つことができる．': \
    {
        'normalize':        "とうもろこし は 地面 である〜ない ても 育つ こと が できる ．",
        'tokenize':         "とうもろこし は 地面 でなく ても 育つ こと が できる ．",
        'untokenize':       "とうもろこしは地面でなくても育つことができる．",
        'lemma_split':      ("とうもろこし 地面 育つ できる", "1 は 2 である〜ない ても 3 こと が 4 ．"),
        'lemma_split_keep': ("とうもろこし は 地面 である〜ない ても 育つ こと が できる ．", "1 2 3 4 5 6 7 8 9 10"),
    },
    'ラケットはテニスをするために利用することができる．': \
    {
        'normalize':        "ラケット は テニス を する ため に 利用する こと が できる ．",
        'tokenize':         "ラケット は テニス を する ため に 利用する こと が できる ．",
        'untokenize':       "ラケットはテニスをするために利用することができる．",
        'lemma_split':      ("ラケット テニス する ため 利用する できる", "1 は 2 を 3 4 に 5 こと が 6 ．"),
        'lemma_split_keep': ("ラケット は テニス を する ため に 利用する こと が できる ．", "1 2 3 4 5 6 7 8 9 10 11 12"),
    },
    'あなたは食事中に気持ち悪くなることがある．': \
    {
        'normalize':        "あなた は 食事中 に 気持ち 悪くなる こと が ある ．",
        'tokenize':         "あなた は 食事中 に 気持ち 悪くなる こと が ある ．",
        'untokenize':       "あなたは食事中に気持ち悪くなることがある．",
        'lemma_split':      ("あなた 食事中 気持ち 悪くなる ある", "1 は 2 に 3 4 こと が 5 ．"),
        'lemma_split_keep': ("あなた は 食事中 に 気持ち 悪くなる こと が ある ．", "1 2 3 4 5 6 7 8 9 10"),
    },
    '幼児は感じやすいという特徴がある．': \
    {
        'normalize':        "幼児 は 感じる やすい という 特徴 が ある ．",
        'tokenize':         "幼児 は 感じ やすい という 特徴 が ある ．",
        'untokenize':       "幼児は感じやすいという特徴がある．",
        'lemma_split':      ("幼児 感じる やすい 特徴 ある", "1 は 2 3 という 4 が 5 ．"),
        'lemma_split_keep': ("幼児 は 感じる やすい という 特徴 が ある ．", "1 2 3 4 5 6 7 8 9"),
    },
    '晴天はあなたが布団を干すことをやる気にさせる．': \
    {
        'normalize':        "晴天 は あなた が 布団 を 干す こと を やる気 に する ．",
        'tokenize':         "晴天 は あなた が 布団 を 干す こと を やる気 に させる ．",
        'untokenize':       "晴天はあなたが布団を干すことをやる気にさせる．",
        'lemma_split':      ("晴天 あなた 布団 干す やる気 する", "1 は 2 が 3 を 4 こと を 5 に 6〜せる ．"),
        'lemma_split_keep': ("晴天 は あなた が 布団 を 干す こと を やる気 に する ．", "1 2 3 4 5 6 7 8 9 10 11 12〜せる 13"),
    },
    '押し入れに行くと保管物を見ることができる．': \
    {
        'normalize':        "押し入れ に 行く と 保管物 を 見る こと が できる ．",
        'tokenize':         "押し入れ に 行く と 保管物 を 見る こと が できる ．",
        'untokenize':       "押し入れに行くと保管物を見ることができる．",
        'lemma_split':      ("押し入れ 行く 保管物 見る できる", "1 に 2 と 3 を 4 こと が 5 ．"),
        'lemma_split_keep': ("押し入れ に 行く と 保管物 を 見る こと が できる ．", "1 2 3 4 5 6 7 8 9 10 11"),
    },
    'コップは歯ブラシを立てるために利用することができる．': \
    {
        'normalize':        "コップ は 歯ブラシ を 立てる ため に 利用する こと が できる ．",
        'tokenize':         "コップ は 歯ブラシ を 立てる ため に 利用する こと が できる ．",
        'untokenize':       "コップは歯ブラシを立てるために利用することができる．",
        'lemma_split':      ("コップ 歯ブラシ 立てる ため 利用する できる", "1 は 2 を 3 4 に 5 こと が 6 ．"),
        'lemma_split_keep': ("コップ は 歯ブラシ を 立てる ため に 利用する こと が できる ．", "1 2 3 4 5 6 7 8 9 10 11 12"),
    },
    '学生は落第を欲さない．': \
    {
        'normalize':        "学生 は 落第 を 欲する〜ない ．",
        'tokenize':         "学生 は 落第 を 欲さない ．",
        'untokenize':       "学生は落第を欲さない．",
        'lemma_split':      ("学生 落第 欲する〜ない", "1 は 2 を 3 ．"),
        'lemma_split_keep': ("学生 は 落第 を 欲する〜ない ．", "1 2 3 4 5 6"),
    },
    '私はよく出来ません。': \
    {
        'normalize':        "私 は よく 出来る〜ない 。",
        'tokenize':         "私 は よく 出来ません 。",
        'untokenize':       "私はよく出来ません。",
        'lemma_split':      ("私 出来る〜ない", "1 は よく 2〜ます 。"),
        'lemma_split_keep': ("私 は よく 出来る〜ない 。", "1 2 3 4〜ます 5"),
    },
    '私は歌う小鳥です。': \
    {
        'normalize':        "私 は 歌う 小鳥 である 。",
        'tokenize':         "私 は 歌う 小鳥 です 。",
        'untokenize':       "私は歌う小鳥です。",
        'lemma_split':      ("私 歌う 小鳥", "1 は 2 3 である 。"),
        'lemma_split_keep': ("私 は 歌う 小鳥 である 。", "1 2 3 4 5 6"),
    },
    '食べたくはないではない': \
    {
        'tokenize':         "食べたく は ない ではない",
        'normalize':        "食べる〜たい は ない である〜ない",
        'untokenize':       "食べたくはないではない",
        'lemma_split':      ("食べる〜たい ない", "1 は 2 である〜ない"),
        'lemma_split_keep': ("食べる〜たい は ない である〜ない", "1 2 3 4"),
    },
    '明日学校へ行けますか？': \
    {
        'tokenize':         "明日 学校 へ 行けます か ？",
        'normalize':        "明日 学校 へ 行ける か ？",
    },
    '明日学校へ行けるぞ!': \
    {
        'tokenize':         "明日 学校 へ 行ける ぞ ！",
        'normalize':        "明日 学校 へ 行ける ぞ ！",
    },
    '日本語が喋られますか?': \
    {
        'tokenize':         "日本語 が 喋られます か ？",
        'normalize':        "日本語 が 喋る か ？",
    },
    'こんな声で話せる': \
    {
        'tokenize':         "こんな 声 で 話せる",
        'normalize':        "こんな 声 で 話せる",
    },
    'あなたのことが好き。': \
    {
        'tokenize':         "あなた の こと が 好き 。",
        'normalize':        "あなた の こと が 好き 。",
        'lemma_split':      ("あなた 好き", "1 の こと が 2 。"),
        'lemma_split_keep': ("あなた の こと が 好き 。", "1 2 3 4 5 6"),
    },
    'あなたの事が好き。': \
    {
        'tokenize':         "あなた の 事 が 好き 。",
        'normalize':        "あなた の 事 が 好き 。",
        'lemma_split':      ("あなた 好き", "1 の 事 が 2 。"),
        'lemma_split_keep': ("あなた の 事 が 好き 。", "1 2 3 4 5 6"),
    },
    '色んなことが好き。': \
    {
        'tokenize':         "色んな こと が 好き 。",
        'normalize':        "色んな こと が 好き 。",
        'lemma_split':      ("色んな 好き", "1 こと が 2 。"),
        'lemma_split_keep': ("色んな こと が 好き 。", "1 2 3 4 5"),
    },
    'ことが好き。': \
    {
        'tokenize':         "こと が 好き 。",
        'normalize':        "こと が 好き 。",
        'lemma_split':      ("好き", "こと が 1 。"),
        'lemma_split_keep': ("こと が 好き 。", "1 2 3 4"),
    },
    '事が好き。': \
    {
        'tokenize':         "事 が 好き 。",
        'normalize':        "事 が 好き 。",
        'lemma_split':      ("事 好き", "1 が 2 。"),
        'lemma_split_keep': ("事 が 好き 。", "1 2 3 4"),
    },
    'ものが好き。': \
    {
        'tokenize':         "もの が 好き 。",
        'normalize':        "もの が 好き 。",
        'lemma_split':      ("好き", "もの が 1 。"),
        'lemma_split_keep': ("もの が 好き 。", "1 2 3 4"),
    },
    '物が好き。': \
    {
        'tokenize':         "物 が 好き 。",
        'normalize':        "物 が 好き 。",
        'lemma_split':      ("物 好き", "1 が 2 。"),
        'lemma_split_keep': ("物 が 好き 。", "1 2 3 4"),
    },
    '赤ちゃんが泣くものです。': \
    {
        'tokenize':         "赤ちゃん が 泣く もの です 。",
        'normalize':        "赤ちゃん が 泣く もの である 。",
        'lemma_split':      ("赤ちゃん 泣く", "1 が 2 もの である 。"),
        'lemma_split_keep': ("赤ちゃん が 泣く もの である 。", "1 2 3 4 5 6"),
    },
    '赤ちゃんが泣くですもの。': \
    {
        'tokenize':         "赤ちゃん が 泣く です もの 。",
        'normalize':        "赤ちゃん が 泣く である もの 。",
        'lemma_split':      ("赤ちゃん 泣く", "1 が 2 である もの 。"),
        'lemma_split_keep': ("赤ちゃん が 泣く である もの 。", "1 2 3 4 5 6"),
    },
}

words = \
{
    'apple': \
    {
        'normalize':  "apple",
        'word_split': ("apple", ""),
        'is_stopword': False,
    },
    '、': \
    {
        'normalize':  "、",
        'word_split': ("、", ""),
        'is_stopword': True,
    },
    '。': \
    {
        'normalize':  "。",
        'word_split': ("。", ""),
        'is_stopword': True,
    },
    '「': \
    {
        'normalize':  "「",
        'word_split': ("「", ""),
        'is_stopword': True,
    },
    'ある': \
    {
        'normalize':  "ある",
        'word_split': ("ある", ""),
        'is_stopword': False,
    },
    'お客様': \
    {
        'normalize':  "お客様",
        'word_split': ("お客様", ""),
        'is_stopword': False,
    },
    'だ': \
    {
        'normalize':  "だ",
        'word_split': ("だ", ""),
        'is_stopword': False,
    },
    'の': \
    {
        'normalize':  "の",
        'word_split': ("の", ""),
        'is_stopword': True,
    },
    'は': \
    {
        'normalize':  "は",
        'word_split': ("は", ""),
        'is_stopword': True,
    },
    'アメリカ': \
    {
        'normalize':  "アメリカ",
        'word_split': ("アメリカ", ""),
        'is_stopword': False,
    },
    '１月': \
    {
        'normalize':  "１月",
        'word_split': ("１月", ""),
        'is_stopword': False,
    },
    '赤い': \
    {
        'normalize':  "赤い",
        'word_split': ("赤い", ""),
        'is_stopword': False,
    },
    '素敵': \
    {
        'normalize':  "素敵",
        'word_split': ("素敵", ""),
        'is_stopword': False,
    },
    '素敵な': \
    {
        'normalize':  "素敵",
        'word_split': ("素敵", ""),
        'is_stopword': False,
    },
    'お知らせします': \
    {
        'normalize':  "お知らせする",
        'word_split': ("お知らせする", "〜ます"),
        'is_stopword': False,
    },
    '赤くなっ': # This one is wierd #
    {
        'normalize':  "赤くなる",
        'word_split': ("赤くなる", ""),
        'is_stopword': False,
    },
    '赤くなった': \
    {
        'normalize':  "赤くなる",
        'word_split': ("赤くなる", "〜た"),
        'is_stopword': False,
    },
    'ならない': \
    {
        'normalize':  "なる〜ない",
        'word_split': ("なる〜ない", ""),
        'is_stopword': False,
    },
    'ならなかった': \
    {
        'normalize':  "なる〜ない",
        'word_split': ("なる〜ない", "〜た"),
        'is_stopword': False,
    },
    'かみ': \
    {
        'normalize':  "かむ",
        'word_split': ("かむ", ""),
        'is_stopword': False,
    },
    'さけた': \
    {
        'normalize':  "さける",
        'word_split': ("さける", "〜た"),
        'is_stopword': False,
    },
    '面白く': \
    {
        'normalize':  "面白い",
        'word_split': ("面白い", ""),
        'is_stopword': False,
    },
    'やすくならなけれ': \
    {
        'normalize':  "やすくなる〜ない",
        'word_split': ("やすくなる〜ない", ""),
        'is_stopword': False,
    },
    'あ': \
    {
        'normalize': "あ",
        'is_stopword': False,
    },
    '1': \
    {
        'normalize': "１",
        'is_stopword': False,
    },
    '３': \
    {
        'normalize': "３",
        'is_stopword': False,
    },
    'は': \
    {
        'normalize': "は",
        'is_stopword': True,
    },
    'ば': \
    {
        'normalize': "ば",
        'word_split': ("ば", ""),
        'is_stopword': False,
    },
    '一種': \
    {
        'normalize': "一種",
        'word_split': ("一種", ""),
        'is_stopword': False,
    },
}

