# -*- coding: utf-8 -*-
#
#  setup.py
#  simplestats
# 
#  Created by Lars Yencken on 10-04-2009.
#  Copyright 2009 Lars Yencken. All rights reserved.
#

from setuptools import setup

VERSION = '0.1.0'

f = open('src/__version__.py', 'w')
f.write('# Autogenerated by setup.py\n')
f.write('version = "%s"\n' % VERSION)
f.close()

setup(
        name='simplestats',
        description="Simple statistics modules for data analysis.",
        long_description = """
        Provides basic statistics calcuations, frequency distributions, data
        approximation methods, and others.
        """,
        url="http://bitbucket.org/lars512/simplestats/",
        version=VERSION,
        author="Lars Yencken",
        author_email="lljy@csse.unimelb.edu.au",
        license="BSD",

        package_dir={'simplestats': 'src'},
        packages=['simplestats'],
    )
