#!/usr/bin/env python
'''
# simplevector

## Introduction

This library serves as a collection of useful objects and utility functions to 
facilitate vector math.

This library is not designed to be performant, but is instead designed to be 
pragmatic and easily used. I initially created this project because I noticed
that I was accumulating a variety of vector-related code to help me work through
some math problems, and wanted a way to keep them bundled and easily reusable.
'''

from __future__ import absolute_import, division

__all__ = ['Vector', 'Vector2d', 'offsets']

from simplevector.vector3d import Vector
from simplevector.vector2d import Vector2d, Polar2d
import simplevector.offsets as offsets