from __future__ import absolute_import, division
import random

from simplevector import Vector

def test_cross_product():
    a = Vector(3, -3, 1)
    b = Vector(4, 9, 2)
    ans = Vector(-15, -2, 39)
    assert a.cross(b) == ans
    
def test_magnitude():
    r = random.Random(0) # seed is 0
    for i in range(100):
        v = get_rand_vector(r)
        assert abs(v) == v.magnitude
        
def test_division():
    v = Vector(1, 2, 3)
    a = v.__div__(2)
    b = v.__truediv__(2)
    assert a == b
    
def test_dot_product():
    r = random.Random(0) # seed is 0
    for i in range(100):
        v1 = get_rand_vector(r)
        v2 = get_rand_vector(r)
        assert v1 * v2 == v2 * v1 == v1.dot(v2) == v2.dot(v1)
        
def test_scalar_product():
    r = random.Random(0) # seed is 0
    for i in range(100):
        v = get_rand_vector(r)
        x = r.randint(-10000, 10000)
        assert v * x == x * v
        
def get_rand_vector(r, x_range=(-10000,10000), y_range=(-10000,10000), z_range=(-10000,10000)):
    x = r.randint(*x_range)
    y = r.randint(*y_range)
    z = r.randint(*z_range)
    return Vector(x, y, z)