#!/usr/bin/env python

from __future__ import absolute_import, division
import math

import simplevector

class Vector2d(simplevector.Vector):
    def __init__(self, x, y):
        super(Vector2d, self).__init__(x, y, 0)
        
    @property
    def angle(self):
        return math.atan2(self.y, self.x)
        
    @angle.setter
    def angle(self, theta):
        self.x = math.cos(theta) * self._cached_magnitude
        self.y = math.sin(theta) * self._cached_magnitude
        
class Polar2d(Vector2d):
    def __init__(self, theta, magnitude):
        x = math.cos(theta) * magnitude
        y = math.sin(theta) * magnitude
        super(Polar2d, self).__init__(x, y)