#!/usr/bin/env python2.7
# -*- coding: utf-8 -*-

# sipcentric/__init__.py
# Python client library for the Sipcentric API
# Copyright (c) 2013 Sipcentric Ltd. Licensed under the MIT license: http://www.opensource.org/licenses/mit-license.php

import requests, json, math

api = 'http://pbx.sipcentric.com/api/v1/' # Sipcentric API V1

class sms(object):

  def __init__(self, username, password):
    self.username = username
    self.password = password

  def credit(self):
    uri = "customers/me/creditstatus"
    request = requests.get(api + uri, auth=requests.auth.HTTPBasicAuth(self.username, self.password))
    if request.status_code == 200:
      response = request.json()
      credit = float(response['creditRemaining'])
      messages = math.trunc(credit / 0.10)
      return {'credit':credit,'messages':messages}
    else:
      return {'error':request.status_code}

  def originators(self):
    items = {}
    originators = []

    uri = "customers/me/outgoingcallerids"
    request = requests.get(api + uri, auth=requests.auth.HTTPBasicAuth(self.username, self.password))
    if request.status_code == 200:
      response = request.json()
      if response['totalItems'] > 0:
        for i in response['items']:
          if i['allowSms'] == True:
            originators.append(i['number'])

    uri = "customers/me/phonenumbers"
    request = requests.get(api + uri, auth=requests.auth.HTTPBasicAuth(self.username, self.password))
    if request.status_code == 200:
      response = request.json()
      if response['totalItems'] > 0:
        for i in response['items']:
          if 'smsEnabled' in i and i['smsEnabled'] == True:
            originators.append(i['number'])
    items['originators'] = originators
    return items

  def send(self, originator, recipient, message):
    uri = "customers/me/sms"

    headers = {'content-type': 'application/json'}
    content = {'type': 'smsmessage', 'to': recipient, 'from': originator, 'body': message}

    request = requests.post(api + uri, auth=requests.auth.HTTPBasicAuth(self.username, self.password), data=json.dumps(content), headers=headers)
    if request.status_code == 201:
      response = request.json()
      return {'state':response['sendStatus'],'cost':response['cost']}
    else:
      return {'error':request.status_code}

# End of file
