import os
import sipconfig

# The name of the SIP build file generated by SIP and used by the build
# system.
build_file = "ftgl.sbf"

# Get the SIP configuration information.
config = sipconfig.Configuration()

# Run SIP to generate the code.
os.system(" ".join([config.sip_bin, "-c", ".", "-b", build_file, 
                    "ftgl.sip"]))

# Create the Makefile.
makefile = sipconfig.SIPModuleMakefile(config, build_file)

# Add the library we are wrapping.  The name doesn't include any platform
# specific prefixes or extensions (e.g. the "lib" prefix on UNIX, or the
# ".dll" extension on Windows).
makefile.extra_libs = ["ftgl"]


makefile.extra_lflags = [
    # this should be set to where libftgl lies
    "-L/usr/local/lib"
]

makefile.extra_include_dirs = [
    # this should be set to where your FTGL header directory lies
    "/usr/local/include", 
    # this should be set to where your freetype header directory lies
    "/usr/local/include/freetype2"]

# Generate the Makefile itself.
makefile.generate()
