import yaml
import os
import os.path as path

replace_map = {
    'UID': os.getuid(),
    'GID': os.getgid(),
    'HOME': os.getenv('HOME'),
}

def transform_comment(config, find):
    for directive in config.find_recursive(**find):
        directive.comment()

def tranform_append(config, find, item):
    item = dict(item)
    if 'args' in item:
        item['args'] = item['args'] % replace_map

    for directive in config.find_recursive(**find):
        directive.append_nonblock(**item)

def transform_replace_inargs(config, find, replace):
    replace = replace % replace_map

    for directive in config.find_recursive():
        if directive.args is not None:
            directive.args = directive.args.replace(find, replace)

def transform_replace_item(config, find, replace):
    for directive in config.find_recursive(**find):
        for key,value in replace.iteritems():
            if key in ['args']:
                value = value % replace_map

            setattr(directive, key, value)

action_map = {
    'append': tranform_append,
    'comment': transform_comment,
    'replace item': transform_replace_item,
    'replace in args': transform_replace_inargs,
}

class Action(object):
    def __init__(self, func, config):
        self._func = func
        self._config = config

    @classmethod
    def yaml_constructor(cls, loader, node):
        type,config = loader.construct_pairs(node, deep=True).pop()
        
        return cls(action_map[type], config)
    
    def __unicode__(self):
        return u'<Action %s(%s)>' % (unicode(self._func.func_name),
                                     unicode(self._config))

    def __repr__(self):
        return unicode(self)

    def __call__(self, config):
        return self._func(config, **self._config)


def transform_config(config):
    yaml.add_path_resolver('!action', [None], dict)
    yaml.add_constructor('!action', Action.yaml_constructor)

    for tfile in [path.join(os.getenv('HOME'),
                            '.siteadm/transforms.yaml'),
                  '/etc/siteadm/transforms.yaml']:
        if not path.exists(tfile):
            continue

        for action in yaml.load(file(tfile)):
            action(config)
