#! /usr/bin/python
# -*- encoding: utf-8 -*-

template_starter = """\
#! %(python_executable)s
# -*- encoding: utf-8 -*-

# do not edit this file. configuration should be done in config.py

from os.path import dirname
import sys
sys.path += dirname(__file__)

from werkzeug.serving import run_simple
from skarabaeus_server import make_application

import config

application = make_application(config.main)

if __name__ == '__main__':
    run_simple(application=application, hostname='', port=%(standalone_port)s)
"""

template_config = """\
# -*- encoding: utf-8

mb = 1024 ** 2
    
main = {
    # where to store the session data of the users.
    'session_secret' : '%(session_secret)s',
    
    'filedb' : {
        # use the filesystem for storage
        'plugin' : 'skarabaeus_server.plugins.fsfiledb.FsFileDb',
        
        # save uploaded files here
        'storage_path' : '%(storage_path)s',    
    },
    
    'userdb' : {
        # use this file for listing users
        'plugin' : 'skarabaeus_server.plugins.dictuserdb.DictUserDb',
        
        # any user may upload files up to 5 megabytes. this may be overridden
        # in the user's settings.
        'default_max_file_size' : 10 * mb,
        
        # before an upload, skarabäus clears files, so that the total size of
        # the uploading user's files is below 1 gigabyte.
        'default_max_total_size' : 1024 * mb,
        
        # list your users here
        'users' : {
                    
            # 'joe_malik' : {
            #     'password' : "there's no enemy",
            #     'max_total_size' : 23 * mb,                
            #     'max_file_size' : 5 * mb,
            # },
            
            
            # 'harry_coin' : {
            #     'password' : "there's no friend",
            # },        
            
            # this is the user anyone not logged in is treated as.
            # DO NOT DELETE!
            # if you dont want anonymous file upload, set 'max_file_size' to 0
            'anonymous' : {
                'password' : '',
                'max_total_size' : 23 * mb,                
                'max_file_size' : 5 * mb,                
            },
            
        },
        
    },
} # no trailing comma!
"""

import optparse
import os
import os.path
import random
import sys
import stat

def main():
    parser = optparse.OptionParser(usage="%prog TARGET")
    #parser.add_option()
    options, args = parser.parse_args()
    
    if len(args) != 1:
        parser.error('please give a target')
        
    target, = args
    
    if not os.path.isdir(target):
        os.makedirs(target)
        
    
    files = [
        ('starter.py', template_starter, 0770),
        ('config.py', template_config, 0660),    
    ]
    
    template_vars = {
        'session_secret' : random.randint(0, 10 ** 20),
        'standalone_port' : 23235,
        'storage_path' : '/tmp',
        'python_executable' : sys.executable,
    }    
    
    mask = os.umask(0777)

    for filename, template, mode in files:
        fullfilename = os.path.join(target, filename)
        fp = open(fullfilename, 'wb')
        try:
            fp.write(template % template_vars)
        finally:
            fp.close()
        os.chmod(fullfilename, mode)
        
    os.umask(mask)


if __name__ == '__main__':
    main()
